/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.ima;

import android.content.Context;
import com.akamai.amp.ads.ima.GoogleAdsInfo;
import com.akamai.amp.ads.ima.IMAAdsHandler;
import com.akamai.amp.id3.ID3TagData;
import com.akamai.amp.id3.ID3TagEventListener;
import com.akamai.amp.utils.LogManager;
import com.google.ads.interactivemedia.v3.api.Ad;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.BaseManager;
import com.google.ads.interactivemedia.v3.api.CuePoint;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.StreamManager;
import com.google.ads.interactivemedia.v3.api.StreamRequest;
import com.google.ads.interactivemedia.v3.api.player.VideoStreamPlayer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ServerSideAdsHandler
extends IMAAdsHandler {
    private static final String TAG = ServerSideAdsHandler.class.getSimpleName();
    protected List<VideoStreamPlayer.VideoStreamPlayerCallback> mPlayerCallbacks;
    private StreamManager streamManager;

    public ServerSideAdsHandler(Context context, String fallbackURL, boolean disableAdsCountdown, ImaSdkSettings imaSdkSettings) {
        super(context, fallbackURL, disableAdsCountdown, imaSdkSettings);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mPlayerCallbacks = new CopyOnWriteArrayList<VideoStreamPlayer.VideoStreamPlayerCallback>();
        this.createServerSideAdsLoader();
    }

    public boolean isClientSideAds() {
        return false;
    }

    public boolean isServerSideAds() {
        return true;
    }

    @Override
    protected BaseManager getManager(AdsManagerLoadedEvent event) {
        this.streamManager = event.getStreamManager();
        return this.streamManager;
    }

    @Override
    public void onResume(boolean shouldResume) {
        if (this.mVideoPlayerView == null) {
            return;
        }
        this.mVideoPlayerView.doOnResumeParent();
        if (shouldResume) {
            this.mVideoPlayerView.resume();
        }
    }

    @Override
    public void onPause() {
        if (this.mVideoPlayerView == null) {
            return;
        }
        this.mVideoPlayerView.pause();
        this.mVideoPlayerView.doOnPauseParent();
    }

    @Override
    public BaseManager getManager() {
        return this.streamManager;
    }

    @Override
    public void playWithServerAds() {
        StreamRequest streamRequest = this.buildStreamRequest();
        this.mAdsLoader.requestStream(streamRequest);
    }

    public void playWithServerAds(String vodContentSourceId, String videoId) {
        this.setVodVideoID(videoId);
        this.setVodContentSourceId(vodContentSourceId);
        StreamRequest streamRequest = this.buildStreamRequest();
        this.mAdsLoader.requestStream(streamRequest);
    }

    public void playWithServerAds(String liveAssetID) {
        this.setLiveAssetKey(liveAssetID);
        this.mAdsLoader.requestStream(this.buildStreamRequest());
    }

    public void setAdsUrl(String adsUrl) {
        this.reportInvalid(TAG, "setAdsUrl(String adsUrl)");
    }

    @Override
    protected void doOnAdLoaded(Ad ad) {
        GoogleAdsInfo adsInfo = this.convert(ad);
        this.onLoaded(adsInfo);
    }

    @Override
    protected void doOnAdStarted(String adId) {
    }

    @Override
    protected void startOnLoaded() {
    }

    public int getContentPosition(int contentPosition) {
        return (int)this.getAccurateContentTime(contentPosition);
    }

    public int getStreamPosition(int streamPosition) {
        return (int)this.getAccurateStreamTime(streamPosition);
    }

    public int getContentDuration(int contentDuration) {
        return (int)this.getAccurateContentTime(contentDuration);
    }

    private long getAccurateContentTime(int contentDuration) {
        if (this.streamManager != null && this.mVideoPlayerView != null) {
            return (long)this.streamManager.getContentTimeForStreamTime((double)contentDuration);
        }
        return contentDuration;
    }

    private long getAccurateStreamTime(int streamDuration) {
        if (this.streamManager != null && this.mVideoPlayerView != null) {
            return (long)this.streamManager.getStreamTimeForContentTime((double)streamDuration);
        }
        return streamDuration;
    }

    @Override
    public void pauseAd() {
    }

    @Override
    public void resumeAd() {
    }

    public void doProxyInit() {
    }

    public void doSessionInit() {
    }

    public void doProxyInit(int debugFlags) {
    }

    public void doSessionInit(int debugFlags) {
    }

    @Override
    protected void onSeekingStarted() {
        long currentTime = this.mVideoPlayerView.getCurrentStreamPosition();
        double timeToSeek = currentTime;
        if (this.mAdsManager != null && !this.missedCuePoint) {
            CuePoint cuePoint = this.streamManager.getPreviousCuePointForStreamTime((double)currentTime);
            double bookMarkStreamTime = this.streamManager.getStreamTimeForContentTime(this.mBookMarkContentTime);
            if (cuePoint != null && !cuePoint.isPlayed() && cuePoint.getEndTime() > bookMarkStreamTime) {
                this.mSnapBackTime = timeToSeek > cuePoint.getEndTime() ? timeToSeek : cuePoint.getEndTime();
                timeToSeek = cuePoint.getStartTime() * 1000.0;
                this.missedCuePoint = true;
                this.mVideoPlayerView.seek(Math.round(timeToSeek));
            }
        }
    }

    @Override
    protected void extractMetadata() {
        if (this.isServerSideAds()) {
            ID3TagEventListener metadataListener = new ID3TagEventListener(){

                public boolean onFoundID3TagData(ID3TagData data) {
                    for (VideoStreamPlayer.VideoStreamPlayerCallback callback : ServerSideAdsHandler.this.mPlayerCallbacks) {
                        String text = data.getText();
                        callback.onUserTextReceived(text);
                        LogManager.log((String)"AMP", (String)("AMP/IMAAdsPlugin: Tag:" + text));
                    }
                    return false;
                }
            };
            if (this.mVideoPlayerView == null) {
                return;
            }
            this.mVideoPlayerView.addId3TagsEventListener(metadataListener);
        }
    }

    @Override
    protected void doOnAdBreakEnded() {
        if (this.mBookMarkContentTime > 0.0 && this.streamManager != null) {
            double streamTime = this.streamManager.getStreamTimeForContentTime(this.mBookMarkContentTime);
            this.mVideoPlayerView.seek((int)Math.round(streamTime));
        }
    }

    @Override
    protected void handlePlaybackFinishedEvent(boolean isEndOfVideo) {
        if (isEndOfVideo) {
            this.onContentComplete();
            this.showProgressBar(false);
        }
    }

    @Override
    protected void addVideoStreamPlayerCallback(VideoStreamPlayer.VideoStreamPlayerCallback videoStreamPlayerCallback) {
        this.mPlayerCallbacks.add(videoStreamPlayerCallback);
    }

    @Override
    protected void removeVideoStreamPlayerCallback(VideoStreamPlayer.VideoStreamPlayerCallback videoStreamPlayerCallback) {
        this.mPlayerCallbacks.remove(videoStreamPlayerCallback);
    }

    @Override
    protected void onContentComplete() {
        if (this.mPlayerCallbacks == null || this.mPlayerCallbacks.isEmpty()) {
            return;
        }
        for (VideoStreamPlayer.VideoStreamPlayerCallback callback : this.mPlayerCallbacks) {
            callback.onContentComplete();
        }
    }

    @Override
    public AdDisplayContainer getAdDisplayContainer() {
        return null;
    }
}

