/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.ima;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.akamai.amp.ads.AdPosition;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.ima.AmpDAIManager;
import com.akamai.amp.ads.ima.AmpIMAManager;
import com.akamai.amp.ads.ima.GoogleAdsInfo;
import com.akamai.amp.ads.ima.IMAAdsPlugin;
import com.akamai.amp.ads.ima.IPlayheadUpdate;
import com.akamai.amp.ads.ima.ImaSDK.AdsPlayerHolder;
import com.akamai.amp.ads.ima.ImaSDK.AdsVideoView;
import com.akamai.amp.ads.ima.ImaSDK.CompanionAd;
import com.akamai.amp.ads.ima.adprogress.AdProgressChecker;
import com.akamai.amp.ads.ima.adprogress.AdProgressData;
import com.akamai.amp.config.Config;
import com.akamai.amp.config.data.IMAData;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.Listeners;
import com.akamai.amp.media.VideoPlayerContainer;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.networking.IAutoRecoveryCallback;
import com.akamai.amp.parser.feed.FeedParser;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import com.google.ads.interactivemedia.v3.api.Ad;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdPodInfo;
import com.google.ads.interactivemedia.v3.api.AdProgressInfo;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRenderingSettings;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.BaseManager;
import com.google.ads.interactivemedia.v3.api.CompanionAdSlot;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.StreamDisplayContainer;
import com.google.ads.interactivemedia.v3.api.StreamRequest;
import com.google.ads.interactivemedia.v3.api.player.ContentProgressProvider;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import com.google.ads.interactivemedia.v3.api.player.VideoStreamPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class IMAAdsHandler
implements AmpIMAManager,
AmpDAIManager,
IMAAdsPlugin.IMAVideoBasedPlugin {
    private static final String TAG = IMAAdsHandler.class.getName();
    public static final String VERSION = "9.10.7";
    private static final int DEFAULT_TIMEOUT = 8000;
    private static final int DEFAULT_VAST_TIMEOUT = 5000;
    private static final String VOD = "VOD";
    private static final String LIVE = "LIVE";
    private final int ADS_TIMEOUT = 10000;
    private boolean autoPlayHandled = true;
    private Context context;
    private VideoPlayerContainer mVideoPlayerContainer;
    protected VideoPlayerView mVideoPlayerView;
    private FrameLayout adsMainFrame;
    protected ImaSdkFactory mImaSdkFactory = null;
    protected ImaSdkSettings mImaSdkSettings = null;
    protected AdsLoader mAdsLoader = null;
    protected BaseManager mAdsManager = null;
    protected AdsPlayerHolder mAdsPlayerHolder = null;
    protected AdDisplayContainer mAdsContainer = null;
    private ContentProgressProvider mContentProgressProvider;
    private StreamDisplayContainer mDisplayContainer;
    private ArrayList<CompanionAdSlot> companionAdSlots;
    private boolean disableAdsCountdown;
    private boolean enablePreoloading = false;
    private boolean playBackFinished = false;
    private boolean mAdsLoaded = false;
    private boolean mAdsInterrupted = false;
    protected boolean mIsAdStarted = false;
    private boolean mIsAdPlaying = false;
    private boolean mResumeVideoAutomatically = true;
    private boolean isAdRequested = false;
    protected boolean isIMADataSetManually = false;
    protected boolean missedCuePoint = false;
    private int adsOrigin;
    private String streamRequestType;
    private int bitrate = -1;
    private boolean disableAdsUI = false;
    private int videoTimeout = 8000;
    private int vastTimeout = 5000;
    private String[] mimeType;
    private static boolean allowIMAInit = true;
    protected double mBookMarkContentTime;
    protected double mSnapBackTime;
    private Listeners<IAdsComponentListener> mListeners = new Listeners();
    private boolean adsEnabled = true;
    protected String tagURL;
    private String liveAssetKey;
    private String vodContentSourceId;
    private String vodVideoId;
    private String manifestSuffix;
    private Map<String, String> adParameters = new HashMap<String, String>();
    private String fallbackURL;
    private LogManager.Logs adLogs;
    private Ad latestAd = null;
    private final AdProgressChecker adProgressChecker = new AdProgressChecker(this);
    private AdErrorEvent.AdErrorListener adErrorListener = new AdErrorEvent.AdErrorListener(){

        public void onAdError(AdErrorEvent arg0) {
            String error = arg0.getError().toString();
            IMAAdsHandler.this.doOnAdError(error, true);
        }
    };
    private IPlayheadUpdate iPlayheadUpdate = new IPlayheadUpdate(){

        @Override
        public void onPlayheadUpdate(int seconds) {
            for (IAdsComponentListener listener : IMAAdsHandler.this.getListeners()) {
                listener.onAdsPlayheadUpdate(seconds);
            }
        }
    };
    private AdsVideoView.TrackingVideoCallback trackingVideoCallback = new AdsVideoView.TrackingVideoCallback(){

        @Override
        public void onComplete() {
            LogManager.log((String)"Url Options", (String)"AdEvent On Complete");
        }

        @Override
        public void onVideoPrepared() {
            IMAAdsHandler.this.mIsAdStarted = true;
            IMAAdsHandler.this.mIsAdPlaying = true;
            IMAAdsHandler.this.mAdsLoaded = true;
            IMAAdsHandler.this.showProgressBar(false);
            IMAAdsHandler.this.mAdsPlayerHolder.resizeVideo();
            GoogleAdsInfo adsInfo = IMAAdsHandler.this.convert(IMAAdsHandler.this.latestAd);
            if (adsInfo.adPosition == AdPosition.PREROLL && !IMAAdsHandler.this.autoPlayHandled) {
                IMAAdsHandler.this.pauseAd();
            }
        }

        @Override
        public void onVideoError() {
            IMAAdsHandler.this.resumeContentVideo();
        }
    };
    private IPlayerEventsListener iPlayerEventsListener = new IPlayerEventsListener(){

        public boolean onPlayerEvent(int iInEventType) {
            if (IMAAdsHandler.this.adsEnabled && 22 == iInEventType && !IMAAdsHandler.this.mVideoPlayerView.isResumingAfterActivityResume() && IMAAdsHandler.this.tagURL != null && IMAAdsHandler.this.tagURL.length() > 0 && IMAAdsHandler.this.mVideoPlayerView.getCurrentStreamPosition() == 0) {
                if (!IMAAdsHandler.this.mVideoPlayerView.isAutoPlayOn()) {
                    IMAAdsHandler.this.autoPlayHandled = false;
                }
                IMAAdsHandler.this.requestAd();
                return false;
            }
            if (IMAAdsHandler.this.adsEnabled && 15 == iInEventType && !IMAAdsHandler.this.mVideoPlayerView.isResumingAfterActivityResume() && !IMAAdsHandler.this.autoPlayHandled && IMAAdsHandler.this.latestAd != null) {
                GoogleAdsInfo adsInfo = IMAAdsHandler.this.convert(IMAAdsHandler.this.latestAd);
                for (IAdsComponentListener listener : IMAAdsHandler.this.getListeners()) {
                    listener.onAdsStarted((AdsInfo)adsInfo);
                }
                IMAAdsHandler.this.doOnAdStarted(adsInfo.adId);
                IMAAdsHandler.this.resumeAd();
                IMAAdsHandler.this.autoPlayHandled = true;
                return false;
            }
            if (IMAAdsHandler.this.adsEnabled && 3 == iInEventType && !IMAAdsHandler.this.mVideoPlayerView.isResumingAfterActivityResume()) {
                IMAAdsHandler.this.playBackFinished = false;
                if (IMAAdsHandler.this.isAdRequested) {
                    IMAAdsHandler.this.isAdRequested = false;
                    IMAAdsHandler.this.onContentPauseRequested();
                }
                return false;
            }
            if (2 == iInEventType) {
                IMAAdsHandler.this.playBackFinished = true;
                IMAAdsHandler.this.handlePlaybackFinishedEvent(IMAAdsHandler.this.mVideoPlayerView.getStreamDuration() > 0 && IMAAdsHandler.this.mVideoPlayerView.getStreamDuration() <= IMAAdsHandler.this.mVideoPlayerView.getCurrentStreamPosition() + 2);
            } else if (19 == iInEventType) {
                IMAAdsHandler.this.onSeekingStarted();
            } else if (11 == iInEventType) {
                IMAAdsHandler.this.missedCuePoint = false;
            } else {
                if (17 == iInEventType) {
                    IMAAdsHandler.this.pauseAd();
                    return false;
                }
                if (18 == iInEventType) {
                    IMAAdsHandler.this.resumeAd();
                    return false;
                }
                if (23 == iInEventType) {
                    IMAAdsHandler.this.doManagerDestroy();
                    return false;
                }
                if (4 == iInEventType) {
                    IMAAdsHandler.this.isAdRequested = false;
                    return false;
                }
            }
            return true;
        }

        public boolean onPlayerExtendedEvent(int iInEventType, int arg1, int arg2) {
            return true;
        }
    };
    private AdEvent.AdEventListener adEventListener = new AdEvent.AdEventListener(){

        public void onAdEvent(AdEvent event) {
            if (IMAAdsHandler.this.mAdsInterrupted) {
                return;
            }
            IMAAdsHandler.this.timeOutHandler.removeMessages(0);
            IMAAdsHandler.this.mAdsLoaded = true;
            AdEvent.AdEventType adEventType = event.getType();
            Ad ad = event.getAd();
            LogManager.log((String)TAG, (String)("onAdEvent: " + adEventType + " / " + IMAAdsHandler.this.adToString(ad) + " / AdData: " + event.getAdData()));
            switch (adEventType) {
                case TAPPED: {
                    IMAAdsHandler.this.onTapped();
                    break;
                }
                case LOADED: {
                    IMAAdsHandler.this.latestAd = ad;
                    IMAAdsHandler.this.doOnAdLoaded(ad);
                    break;
                }
                case CONTENT_PAUSE_REQUESTED: {
                    IMAAdsHandler.this.onContentPauseRequested();
                    break;
                }
                case CONTENT_RESUME_REQUESTED: {
                    IMAAdsHandler.this.onContentResumeRequested();
                    break;
                }
                case STARTED: {
                    if (IMAAdsHandler.this.isClientSideAds()) {
                        IMAAdsHandler.this.checkFirstAdsStart(event);
                    }
                    IMAAdsHandler.this.onStarted(ad);
                    break;
                }
                case AD_BREAK_STARTED: {
                    IMAAdsHandler.this.onAdBreakStart();
                    break;
                }
                case AD_BREAK_ENDED: {
                    IMAAdsHandler.this.onAllAdsCompleted();
                    IMAAdsHandler.this.onAdBreakEnd();
                    break;
                }
                case SKIPPED: {
                    IMAAdsHandler.this.onSkipped();
                }
                case COMPLETED: {
                    IMAAdsHandler.this.log("AMP/IMAAdsPlugin: Fourth quartile finished");
                    IMAAdsHandler.this.onCompleted();
                    if (!IMAAdsHandler.this.isClientSideAds()) break;
                    IMAAdsHandler.this.checkAllAdsCompleted(event);
                    break;
                }
                case ALL_ADS_COMPLETED: {
                    break;
                }
                case PAUSED: {
                    IMAAdsHandler.this.onPaused();
                    break;
                }
                case RESUMED: {
                    IMAAdsHandler.this.onResumed();
                    break;
                }
                case FIRST_QUARTILE: {
                    IMAAdsHandler.this.log("AMP/IMAAdsPlugin: First quartile finished");
                    IMAAdsHandler.this.onFirstQuartile();
                    break;
                }
                case MIDPOINT: {
                    IMAAdsHandler.this.log("AMP/IMAAdsPlugin: midpoint (Second Quartile finished)");
                    IMAAdsHandler.this.onMidpoint();
                    break;
                }
                case THIRD_QUARTILE: {
                    IMAAdsHandler.this.log("AMP/IMAAdsPlugin: Third quartile finished");
                    IMAAdsHandler.this.onThirdQuartile();
                    break;
                }
                case LOG: {
                    Map adData = event.getAdData();
                    String errorMessage = IMAAdsHandler.this.buildErrorMessage(adData);
                    IMAAdsHandler.this.doOnAdError(errorMessage, false);
                    break;
                }
                case AD_PROGRESS: {
                    String adId = ad == null ? "NULL AD " : ad.getAdId();
                    String progressMessage = IMAAdsHandler.this.onAdProgress(adId);
                    IMAAdsHandler.this.log(progressMessage);
                    break;
                }
                default: {
                    IMAAdsHandler.this.log("AMP/IMAAdsPlugin: " + adEventType);
                }
            }
        }
    };
    private AdsLoader.AdsLoadedListener adsLoadedListener = new AdsLoader.AdsLoadedListener(){

        public void onAdsManagerLoaded(AdsManagerLoadedEvent event) {
            LogManager.log((String)TAG, (String)"onAdsManagerLoaded");
            IMAAdsHandler.this.mAdsManager = IMAAdsHandler.this.getManager(event);
            IMAAdsHandler.this.mAdsManager.addAdErrorListener(IMAAdsHandler.this.adErrorListener);
            IMAAdsHandler.this.mAdsManager.addAdEventListener(IMAAdsHandler.this.adEventListener);
            AdsRenderingSettings rendering = IMAAdsHandler.this.mImaSdkFactory.createAdsRenderingSettings();
            rendering.setMimeTypes(Arrays.asList(IMAAdsHandler.this.getAdsMimeType()));
            if (IMAAdsHandler.this.videoTimeout != 8000) {
                rendering.setLoadVideoTimeout(IMAAdsHandler.this.videoTimeout);
            }
            rendering.setBitrateKbps(IMAAdsHandler.this.bitrate);
            rendering.setDisableUi(IMAAdsHandler.this.disableAdsUI);
            if (IMAAdsHandler.this.enablePreoloading) {
                rendering.setEnablePreloading(true);
            }
            if (IMAAdsHandler.this.disableAdsCountdown) {
                HashSet set = new HashSet();
                Set builtIn = Collections.synchronizedSet(set);
                rendering.setUiElements(builtIn);
            }
            IMAAdsHandler.this.mAdsManager.init(rendering);
            IMAAdsHandler.this.onAdsInitialized();
        }
    };
    private IAutoRecoveryCallback iAutoRecoveryCallback = new IAutoRecoveryCallback(){

        public void onAutoRecoveryTriggered() {
            LogManager.log((String)TAG, (String)"AutoRecovery triggered");
            allowIMAInit = false;
        }
    };
    private Handler timeOutHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (!IMAAdsHandler.this.mAdsLoaded) {
                LogManager.log((String)"Url Options", (String)"AdEvent - Timeout - Starting video playback");
                IMAAdsHandler.this.mAdsInterrupted = true;
                IMAAdsHandler.this.mAdsPlayerHolder.stop();
                if (!IMAAdsHandler.this.mVideoPlayerView.isPlaying() && IMAAdsHandler.this.mVideoPlayerView.isPaused()) {
                    IMAAdsHandler.this.resumeContentVideo();
                }
            }
            super.handleMessage(msg);
        }
    };

    @Override
    public void forceError() {
        String error = this.adProgressChecker.getErrorMessage();
        this.doOnAdError(error, true);
    }

    private String onAdProgress(String adId) {
        String progressMessage = "AMP/IMAAdsPlugin: Ad progress";
        if (this.mAdsManager == null) {
            return progressMessage;
        }
        AdProgressInfo adProgressInfo = this.mAdsManager.getAdProgressInfo();
        if (adProgressInfo == null) {
            return progressMessage;
        }
        double currentTime = adProgressInfo.getCurrentTime();
        double duration = adProgressInfo.getDuration();
        String timeMessage = " " + currentTime + " of " + duration;
        progressMessage = progressMessage + timeMessage;
        LogManager.log((String)TAG, (String)("AD_PROGRESS: AD ID: " + adId + timeMessage));
        this.adProgressChecker.checkAdProgress(new AdProgressData(adId, currentTime, duration));
        return progressMessage;
    }

    public IMAAdsHandler(Context context, String fallbackURL, boolean disableAdsCountdown, ImaSdkSettings imaSdkSettings) {
        this.context = context;
        this.fallbackURL = fallbackURL;
        this.disableAdsCountdown = disableAdsCountdown;
        this.mImaSdkSettings = imaSdkSettings;
        LogManager.log((String)TAG, (String)("IMAAdsHandler created with context " + context + " and fallbackURL " + fallbackURL + " and ImaSdkSettings " + imaSdkSettings));
        this.initialize();
    }

    public IMAAdsHandler(Context context, boolean disableAdsCountdown, ImaSdkSettings imaSdkSettings) {
        this.context = context;
        this.disableAdsCountdown = disableAdsCountdown;
        this.mImaSdkSettings = imaSdkSettings;
        LogManager.log((String)TAG, (String)("IMAAdsHandler created with context " + context + " and fallbackURL " + this.fallbackURL + " and ImaSdkSettings " + imaSdkSettings));
        this.initialize();
    }

    protected abstract void onContentComplete();

    protected abstract void handlePlaybackFinishedEvent(boolean var1);

    protected abstract void onSeekingStarted();

    protected abstract BaseManager getManager(AdsManagerLoadedEvent var1);

    protected abstract void doOnAdLoaded(Ad var1);

    protected abstract void doOnAdStarted(String var1);

    protected abstract void doOnAdBreakEnded();

    protected abstract void startOnLoaded();

    @Override
    public abstract void onResume(boolean var1);

    @Override
    public abstract void onPause();

    public String getExternalLibVersion() {
        return "17.1.2";
    }

    @Override
    public IAutoRecoveryCallback getAutoRecoveryCallback() {
        return this.iAutoRecoveryCallback;
    }

    public void setURLSuffix(String manifestSuffix) {
        this.manifestSuffix = (String)Utils.requireNonNull((Object)manifestSuffix);
        LogManager.log((String)TAG, (String)("setURLSuffix " + manifestSuffix));
    }

    @Override
    public void setAdTagParameters(Map<String, String> adParameters) {
        this.adParameters = adParameters;
        LogManager.log((String)TAG, (String)("setAdTagParameters " + adParameters));
    }

    @Override
    public Map<String, String> getAdTagParemeters() {
        return this.adParameters;
    }

    @Override
    public void setLog(LogManager.Logs logger) {
        this.adLogs = logger;
    }

    @Override
    public void log(String entry) {
        if (this.adLogs != null) {
            this.adLogs.log(entry);
        }
    }

    @Override
    public ContentProgressProvider getContentProgressProvider() {
        return this.mContentProgressProvider;
    }

    public void setVideoPlayerContainer(VideoPlayerContainer videoPlayerContainer) {
        this.mVideoPlayerContainer = (VideoPlayerContainer)Utils.requireNonNull((Object)videoPlayerContainer);
    }

    public void setVideoPlayerView(VideoPlayerView videoPlayerView) {
        if (allowIMAInit) {
            this.mVideoPlayerView = videoPlayerView;
            if (this.mVideoPlayerView != null) {
                this.mVideoPlayerView.addEventsListener(this.iPlayerEventsListener);
                this.addEventsListener(this.mVideoPlayerView.getAdsComponentListener());
            }
            if (!this.isIMADataSetManually) {
                this.loadIMADataFromConfig();
            }
            this.hideAdsContainer();
            this.extractMetadata();
            this.attachToVideoPlayerContainer();
        }
    }

    public void addEventsListener(IAdsComponentListener listener) {
        if (listener == null) {
            LogManager.error((String)TAG, (String)"NULL IAdsComponentListener sent to AdsComponent.addEventsListener()");
        } else if (!this.getListeners().contains((Object)listener)) {
            this.getListeners().add((Object)listener);
        }
    }

    @Override
    public void clearEventsListener() {
        this.mListeners.clear();
    }

    @Override
    public void setResumeVideoAutomatically(boolean value) {
        this.mResumeVideoAutomatically = value;
    }

    @Override
    public void setBookMarkTime(double bookMarkTime) {
        this.mBookMarkContentTime = bookMarkTime;
    }

    @Override
    public Ad getLatestAd() {
        return this.latestAd;
    }

    @Override
    public boolean isAdPlaying() {
        return this.mIsAdPlaying;
    }

    @Override
    public boolean isAdStarted() {
        return this.mIsAdStarted;
    }

    @Override
    public void setAdsEnabled(boolean value) {
        this.adsEnabled = value;
    }

    public void onDestroy() {
        allowIMAInit = true;
        this.doManagerDestroy();
    }

    public boolean getPlayButtonVisibilityOnAds() {
        return true;
    }

    public boolean canPreparePlayback() {
        return true;
    }

    public boolean isPluginActive() {
        return this.mIsAdStarted;
    }

    public boolean isPluginPlaying() {
        return this.mIsAdPlaying;
    }

    public void pausePluginContent() {
        this.pauseAd();
    }

    public void resumePluginContent() {
        this.resumeAd();
    }

    @Override
    public String[] getAdsMimeType() {
        if (this.mimeType == null) {
            this.mimeType = new String[]{"video/mp4"};
        }
        return this.mimeType;
    }

    @Override
    public void setAdsMimeType(String[] mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public void setBitrateKbps(int bitrate) {
        this.bitrate = bitrate;
    }

    @Override
    public void setLoadVideoTimeout(int timeoutInMillis) {
        this.videoTimeout = timeoutInMillis;
    }

    @Override
    public void enableAdsUI() {
        this.disableAdsUI = false;
    }

    @Override
    public void disableAdsUI() {
        this.disableAdsUI = true;
    }

    @Override
    public boolean isAdsCountdownEnabled() {
        return !this.disableAdsCountdown;
    }

    @Override
    public boolean isAdPreloadingEnabled() {
        return this.enablePreoloading;
    }

    @Override
    public void enableAdPreloading() {
        this.enablePreoloading = true;
    }

    @Override
    public void disableAdPreloading() {
        this.enablePreoloading = false;
    }

    @Override
    public void setCompanionAds(ArrayList<CompanionAd> companionAds) {
        this.companionAdSlots = new ArrayList();
        for (CompanionAd companionAd : companionAds) {
            CompanionAdSlot companionAdSlot = this.mImaSdkFactory.createCompanionAdSlot();
            companionAdSlot.setContainer(companionAd.getCompanionContainer());
            companionAdSlot.setSize(companionAd.getCompanionWidth(), companionAd.getCompanionHeight());
            this.companionAdSlots.add(companionAdSlot);
        }
    }

    @Override
    public void setVastTimeout(int timeoutInMillis) {
        this.vastTimeout = timeoutInMillis;
    }

    protected void createClientSideAdsLoader() {
        this.mAdsLoader = this.mImaSdkFactory.createAdsLoader(this.context, this.getImaSdkSettings(), this.mAdsContainer);
        this.mAdsLoader.addAdErrorListener(this.adErrorListener);
        this.mAdsLoader.addAdsLoadedListener(this.adsLoadedListener);
    }

    protected void createServerSideAdsLoader() {
        this.mAdsLoader = this.mImaSdkFactory.createAdsLoader(this.context, this.getImaSdkSettings(), this.mDisplayContainer);
        this.mAdsLoader.addAdErrorListener(this.adErrorListener);
        this.mAdsLoader.addAdsLoadedListener(this.adsLoadedListener);
    }

    protected void setLiveAssetKey(String liveAssetKey) {
        this.liveAssetKey = (String)Utils.requireNonNull((Object)liveAssetKey);
        this.streamRequestType = LIVE;
        LogManager.log((String)TAG, (String)("setLiveAssetKey " + liveAssetKey));
    }

    protected void setVodContentSourceId(String vodContentSourceId) {
        this.vodContentSourceId = (String)Utils.requireNonNull((Object)vodContentSourceId);
        this.streamRequestType = VOD;
        LogManager.log((String)TAG, (String)("setVodContentSourceId " + vodContentSourceId));
    }

    protected void setVodVideoID(String vodVideoID) {
        this.vodVideoId = (String)Utils.requireNonNull((Object)vodVideoID);
        this.streamRequestType = VOD;
        LogManager.log((String)TAG, (String)("setVodVideoID " + this.vodVideoId));
    }

    private void doOnAdError(String error, boolean isFatal) {
        this.mIsAdStarted = false;
        LogManager.error((String)TAG, (String)("AdEvent-Error: " + error));
        if (isFatal) {
            this.hideAdsContainer();
        }
        if (this.isClientSideAds() && this.mVideoPlayerView != null) {
            this.mVideoPlayerView.setAdPlaying(false);
        }
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsError(error);
        }
        if (this.isServerSideAds() && this.fallbackURL != null) {
            this.mVideoPlayerContainer.prepareResource(this.fallbackURL);
            this.log("AMP/IMAAdsPlugin: FALLBACK URL LOADED:" + this.fallbackURL);
            Log.e((String)TAG, (String)("DAI fallback URL loaded: " + this.fallbackURL));
        } else if (isFatal) {
            LogManager.error((String)TAG, (String)("doOnAdError() -> " + error));
            this.resumeContentVideo();
        }
    }

    private ImaSdkSettings getImaSdkSettings() {
        if (this.mImaSdkSettings == null) {
            this.mImaSdkSettings = this.mImaSdkFactory.createImaSdkSettings();
        }
        return this.mImaSdkSettings;
    }

    protected void initialize() {
        Utils.checkModuleVersion((String)TAG, (String)VERSION);
        this.mImaSdkFactory = ImaSdkFactory.getInstance();
        this.adsMainFrame = new FrameLayout(this.context);
        this.mAdsPlayerHolder = new AdsPlayerHolder(this.context);
        this.mAdsPlayerHolder.setCompletionCallback(this.trackingVideoCallback);
        this.mAdsPlayerHolder.setPlayheadUpdateMember(this.iPlayheadUpdate);
        this.mContentProgressProvider = this.buildContentProgressProvider();
        VideoStreamPlayer videoStreamPlayer = this.createVideoStreamPlayer();
        if (this.disableAdsCountdown) {
            ViewGroup viewHolder = new ViewGroup(this.context){

                protected void onLayout(boolean b, int i, int i1, int i2, int i3) {
                }
            };
            this.mDisplayContainer = ImaSdkFactory.createStreamDisplayContainer((ViewGroup)viewHolder, (VideoStreamPlayer)videoStreamPlayer);
        } else {
            this.mDisplayContainer = ImaSdkFactory.createStreamDisplayContainer((ViewGroup)this.adsMainFrame, (VideoStreamPlayer)videoStreamPlayer);
        }
    }

    private ContentProgressProvider buildContentProgressProvider() {
        return new ContentProgressProvider(){

            public VideoProgressUpdate getContentProgress() {
                boolean timeNotReady;
                boolean bl = timeNotReady = IMAAdsHandler.this.mVideoPlayerView == null || IMAAdsHandler.this.mVideoPlayerView.getStreamDuration() <= 0;
                if (timeNotReady) {
                    return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
                }
                long timePosition = IMAAdsHandler.this.mVideoPlayerView.getCurrentPositionPeriodInMillis() < 0L ? 0L : IMAAdsHandler.this.mVideoPlayerView.getCurrentPositionPeriodInMillis();
                return new VideoProgressUpdate(timePosition, (long)(IMAAdsHandler.this.mVideoPlayerView.getStreamDuration() * 1000));
            }
        };
    }

    protected void extractMetadata() {
    }

    protected void addVideoStreamPlayerCallback(VideoStreamPlayer.VideoStreamPlayerCallback videoStreamPlayerCallback) {
    }

    protected void removeVideoStreamPlayerCallback(VideoStreamPlayer.VideoStreamPlayerCallback videoStreamPlayerCallback) {
    }

    protected StreamRequest buildStreamRequest() {
        StreamRequest request = LIVE.equals(this.streamRequestType) ? this.mImaSdkFactory.createLiveStreamRequest(this.liveAssetKey, null) : this.mImaSdkFactory.createVodStreamRequest(this.vodContentSourceId, this.vodVideoId, null);
        request.setManifestSuffix(this.manifestSuffix);
        request.setAdTagParameters(this.adParameters);
        return request;
    }

    private VideoStreamPlayer createVideoStreamPlayer() {
        VideoStreamPlayer player = new VideoStreamPlayer(){

            public int getVolume() {
                return Utils.getDeviceVolume((Context)IMAAdsHandler.this.context);
            }

            public void pause() {
                IMAAdsHandler.this.pauseContentVideo();
            }

            public void resume() {
                IMAAdsHandler.this.resumeContentVideo();
            }

            public void loadUrl(String url, List subtitles) {
                url = Uri.decode((String)url);
                IMAAdsHandler.this.mVideoPlayerContainer.prepareResource(url);
                IMAAdsHandler.this.log("AMP/IMAAdsPlugin: URL LOADED:" + url);
            }

            public void addCallback(VideoStreamPlayer.VideoStreamPlayerCallback videoStreamPlayerCallback) {
                IMAAdsHandler.this.addVideoStreamPlayerCallback(videoStreamPlayerCallback);
            }

            public void removeCallback(VideoStreamPlayer.VideoStreamPlayerCallback videoStreamPlayerCallback) {
                IMAAdsHandler.this.removeVideoStreamPlayerCallback(videoStreamPlayerCallback);
            }

            public void onAdBreakStarted() {
                IMAAdsHandler.this.onAdBreakStart();
                LogManager.log((String)TAG, (String)"IMAAdsPlugin AD BREAK STARTED");
            }

            public void onAdBreakEnded() {
                IMAAdsHandler.this.onAdBreakEnd();
                if (IMAAdsHandler.this.mSnapBackTime > 0.0) {
                    LogManager.log((String)"IMAAdsPlugin", (String)("seeking " + IMAAdsHandler.this.mSnapBackTime));
                    IMAAdsHandler.this.mVideoPlayerView.seek((int)Math.round(IMAAdsHandler.this.mSnapBackTime));
                }
                IMAAdsHandler.this.mSnapBackTime = 0.0;
                IMAAdsHandler.this.doOnAdBreakEnded();
                LogManager.log((String)"AMP", (String)"AMP/IMAAdsPlugin: Ads break ended");
            }

            public VideoProgressUpdate getContentProgress() {
                if (IMAAdsHandler.this.mVideoPlayerView != null) {
                    return new VideoProgressUpdate(IMAAdsHandler.this.mVideoPlayerView.getCurrentPositionPeriodInMillis(), (long)(IMAAdsHandler.this.mVideoPlayerView.getStreamDuration() * 1000));
                }
                return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
            }

            public void seek(long var1) {
            }

            public void onAdPeriodStarted() {
            }

            public void onAdPeriodEnded() {
            }
        };
        return player;
    }

    private void requestAd() {
        LogManager.log((String)TAG, (String)"requestAd");
        this.mAdsLoaded = false;
        this.mAdsInterrupted = false;
        this.isAdRequested = true;
        this.onContentComplete();
        AdsRequest adsRequest = this.buildAdsRequest();
        LogManager.log((String)TAG, (String)this.adsRequestToString(adsRequest));
        this.mAdsLoader.requestAds(adsRequest);
        this.timeOutHandler.sendEmptyMessageDelayed(0, 10000L);
    }

    private String adsRequestToString(AdsRequest adsRequest) {
        if (adsRequest == null) {
            return "AdsRequest is NULL";
        }
        String request = "AdsRequest: " + adsRequest.getAdTagUrl() + " / Params: " + adsRequest.getExtraParameters() + " / Response: " + adsRequest.getAdsResponse();
        return request;
    }

    private AdsRequest buildAdsRequest() {
        if (this.mAdsContainer != null && this.companionAdSlots != null && !this.companionAdSlots.isEmpty()) {
            this.mAdsContainer.setCompanionSlots(this.companionAdSlots);
        }
        AdsRequest request = this.mImaSdkFactory.createAdsRequest();
        request.setVastLoadTimeout((float)this.vastTimeout);
        if (this.tagURL != null && this.tagURL.length() > 0) {
            String sDecodedAdsUrl = this.evaluateUrl(this.tagURL);
            sDecodedAdsUrl = sDecodedAdsUrl.replace(" ", "%20");
            request.setAdTagUrl(sDecodedAdsUrl);
        }
        request.setContentProgressProvider(this.mContentProgressProvider);
        return request;
    }

    public void resumeContentVideo() {
        this.isAdRequested = false;
        if (this.mResumeVideoAutomatically && this.mVideoPlayerView != null && !this.playBackFinished) {
            this.mVideoPlayerView.signalLogicalResume();
            this.mVideoPlayerView.resume();
        }
        this.hideAdsContainer();
    }

    public void pauseContentVideo() {
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.signalLogicalPause();
            this.mVideoPlayerView.pause();
        }
    }

    private void showAdsContainer() {
        if (this.isClientSideAds()) {
            this.mAdsPlayerHolder.showVideoAdsLayer();
            this.adsMainFrame.setBackgroundColor(-16777216);
        }
    }

    private void hideAdsContainer() {
        if (this.isClientSideAds()) {
            this.mAdsPlayerHolder.hideVideoAdsLayer();
            this.adsMainFrame.setBackgroundColor(0);
        }
    }

    private void attachToVideoPlayerContainer() {
        Utils.tryRemoveFromParent((View)this.adsMainFrame);
        if (this.mVideoPlayerContainer == null) {
            return;
        }
        FrameLayout.LayoutParams lParams = new FrameLayout.LayoutParams(-1, -1);
        lParams.gravity = 17;
        this.mVideoPlayerContainer.addView((View)this.adsMainFrame, Utils.getNextIndex((ViewGroup)this.mVideoPlayerContainer), (ViewGroup.LayoutParams)lParams);
        this.mVideoPlayerContainer.requestLayout();
        this.mVideoPlayerContainer.forceLayout();
        if (this.isClientSideAds() && this.mAdsPlayerHolder != null) {
            Utils.tryRemoveFromParent((View)this.mAdsPlayerHolder);
            this.adsMainFrame.addView((View)this.mAdsPlayerHolder);
        }
    }

    private void loadIMADataFromConfig() {
        Config c = Config.getConfig();
        if (!c.configLoaded) {
            return;
        }
        IMAData imaData = c.imaData;
        if (imaData == null) {
            return;
        }
        this.tagURL = imaData.getAdTagUrl();
        this.adsEnabled = imaData.getAdsEnabled();
    }

    private void hideVideoPlayerLayer() {
        this.adsMainFrame.setVisibility(0);
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.setVisibility(8);
            this.mVideoPlayerContainer.requestLayout();
            this.mVideoPlayerView.requestLayout();
            this.mVideoPlayerContainer.forceLayout();
        }
    }

    private void showVideoPlayerLayer() {
        this.adsMainFrame.setVisibility(8);
        if (this.mVideoPlayerView != null) {
            this.mVideoPlayerView.setVisibility(0);
            this.mVideoPlayerView.setFullScreenMode(this.mVideoPlayerView.getFullScreenMode());
            this.mVideoPlayerContainer.requestLayout();
            this.mVideoPlayerView.requestLayout();
            this.mVideoPlayerContainer.forceLayout();
        }
    }

    protected void showProgressBar(boolean show) {
        View progressBar;
        if (this.mVideoPlayerView != null && (progressBar = this.mVideoPlayerView.getProgressBarControl()) != null) {
            if (show) {
                progressBar.setVisibility(0);
            } else {
                progressBar.setVisibility(8);
            }
        }
    }

    private String adToString(Ad ad) {
        if (ad == null) {
            return "Ad is NULL";
        }
        String s = "Ad: " + ad.getAdId() + " / " + ad.getContentType() + " / " + ad.getDescription() + " / " + ad.getSurveyUrl() + " / " + ad.getTitle() + " / " + ad.getAdPodInfo();
        return s;
    }

    private String buildErrorMessage(Map<String, String> adData) {
        String type = this.getParam(adData, "type");
        String errorCode = this.getParam(adData, "errorCode");
        String errorMessage = this.getParam(adData, "errorMessage");
        String result = IMAAdsHandler.class.getName() + " ERROR " + type + " (" + errorCode + "): " + errorMessage;
        return result;
    }

    private String getParam(Map<String, String> adData, String type) {
        String s = adData.get(type);
        if (s == null) {
            return "";
        }
        return s;
    }

    private void checkAllAdsCompleted(AdEvent event) {
        int totalAds;
        Ad ad = event.getAd();
        if (ad == null) {
            return;
        }
        AdPodInfo adPodInfo = ad.getAdPodInfo();
        if (adPodInfo == null) {
            return;
        }
        int adPosition = adPodInfo.getAdPosition();
        if (adPosition == (totalAds = adPodInfo.getTotalAds())) {
            this.onAllAdsCompleted();
            this.onAdBreakEnd();
        } else {
            this.onEnded();
        }
    }

    private void checkFirstAdsStart(AdEvent event) {
        Ad ad = event.getAd();
        if (ad == null) {
            return;
        }
        AdPodInfo adPodInfo = ad.getAdPodInfo();
        if (adPodInfo == null) {
            return;
        }
        int adPosition = adPodInfo.getAdPosition();
        if (adPosition == 1) {
            this.onAdBreakStart();
        }
    }

    private void onSkipped() {
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdSkipped();
        }
    }

    private void onThirdQuartile() {
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsTrackProgress(2);
        }
    }

    private void onMidpoint() {
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsTrackProgress(1);
        }
    }

    private void onFirstQuartile() {
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsTrackProgress(0);
        }
    }

    private void onResumed() {
        this.mIsAdPlaying = true;
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsResumed();
        }
    }

    private void onPaused() {
        this.mIsAdPlaying = false;
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsPaused();
        }
    }

    private void onAllAdsCompleted() {
        if (this.isClientSideAds()) {
            this.mVideoPlayerView.setAdPlaying(false);
        }
        this.isAdRequested = false;
        this.mIsAdStarted = false;
        this.mIsAdPlaying = false;
        this.onEnded();
    }

    private void onCompleted() {
        this.latestAd = null;
        this.mIsAdStarted = false;
        this.mIsAdPlaying = false;
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsTrackProgress(3);
        }
    }

    private void onEnded() {
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsEnded();
        }
    }

    private void onOtherAdEvent() {
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdEvent();
        }
    }

    private void onAdBreakStart() {
        LogManager.log((String)TAG, (String)"onAdBreakStart()");
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdBreakStarted();
        }
    }

    private void onAdBreakEnd() {
        LogManager.log((String)TAG, (String)"onAdBreakEnd()");
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdBreakEnded();
        }
    }

    private void onStarted(Ad ad) {
        if (this.isClientSideAds()) {
            this.mVideoPlayerView.setAdPlaying(true);
        }
        if (ad == null) {
            LogManager.log((String)TAG, (String)"onStarted with a NULL ad, so this *might* be an AdBreakStart instead");
        } else {
            LogManager.log((String)TAG, (String)("onStarted: " + ad.getAdId() + " and title: " + ad.getTitle()));
        }
        this.latestAd = ad;
        this.mIsAdStarted = true;
        this.mIsAdPlaying = true;
        this.mVideoPlayerContainer.removePoster();
        GoogleAdsInfo adsInfo = this.convert(this.latestAd);
        LogManager.log((String)TAG, (String)("onStarted: GoogleAdsInfo " + (Object)((Object)adsInfo)));
        if (this.autoPlayHandled) {
            for (IAdsComponentListener listener : this.getListeners()) {
                listener.onAdsStarted((AdsInfo)adsInfo);
            }
            this.doOnAdStarted(adsInfo.adId);
        }
        this.showProgressBar(false);
    }

    protected GoogleAdsInfo convert(Ad ad) {
        if (ad == null) {
            return null;
        }
        IMAData imaData = new IMAData();
        GoogleAdsInfo result = new GoogleAdsInfo(imaData, ad);
        result.adId = ad.getAdId();
        result.name = ad.getTitle();
        result.lengthInSeconds = (int)ad.getDuration();
        AdPodInfo adPodInfo = ad.getAdPodInfo();
        if (adPodInfo != null) {
            result.adPosition = this.convert(adPodInfo);
            result.adBreakTotal = adPodInfo.getTotalAds();
            result.positionInAdBreak = adPodInfo.getAdPosition();
            result.adPodMaxDuration = adPodInfo.getMaxDuration();
        }
        return result;
    }

    private AdPosition convert(AdPodInfo adPodInfo) {
        if (adPodInfo == null) {
            return AdPosition.PREROLL;
        }
        int adPosition = adPodInfo.getPodIndex();
        if (adPosition == -1) {
            return AdPosition.POSTROLL;
        }
        if (adPosition >= 1) {
            return AdPosition.MIDROLL;
        }
        return AdPosition.PREROLL;
    }

    private void onContentResumeRequested() {
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onResumeContentRequested();
        }
        this.resumeContentVideo();
    }

    private void onContentPauseRequested() {
        this.pauseContentVideo();
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onPauseContentRequested();
        }
    }

    protected void onLoaded(GoogleAdsInfo adsInfo) {
        this.showAdsContainer();
        this.startOnLoaded();
        AdsCount adsCount = new AdsCount((AdsInfo)adsInfo);
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsLoaded(adsCount);
        }
    }

    private void onTapped() {
        LogManager.log((String)TAG, (String)"TAPPED");
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsTapped();
        }
    }

    private void doManagerDestroy() {
        LogManager.log((String)TAG, (String)"onDestroy");
        this.resetContainerFrame();
        this.releaseStreamManager();
        this.releaseAdsManager();
    }

    private void resetContainerFrame() {
        if (this.mVideoPlayerContainer != null) {
            this.mVideoPlayerContainer.removeAllViews();
        }
    }

    private void releaseAdsManager() {
        if (this.mAdsManager != null) {
            this.mAdsManager.destroy();
            this.mAdsManager = null;
            this.hideAdsContainer();
        }
    }

    private void releaseStreamManager() {
        if (this.mAdsManager != null) {
            this.mAdsManager.destroy();
        }
        this.mAdsManager = null;
    }

    private void onAdsInitialized() {
        for (IAdsComponentListener listener : this.getListeners()) {
            listener.onAdsInitialized();
        }
    }

    private String evaluateUrl(String sUrl) {
        Pattern p = Pattern.compile("(\\#\\{)([a-zA-Z0-9_()\\.]+)(\\})");
        Matcher m = p.matcher(sUrl);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String param = this.evaluateExpression(m.group(2));
            m.appendReplacement(result, param);
        }
        m.appendTail(result);
        return result.toString();
    }

    private String evaluateExpression(String sExpr) {
        MediaResource mediaResource;
        String sRes = "";
        String tempExpr = sExpr;
        boolean bEncoded = false;
        if (tempExpr.indexOf("encodeURIComponent(") >= 0) {
            tempExpr = tempExpr.replace("encodeURIComponent(", "");
            tempExpr = tempExpr.replace(")", "");
            bEncoded = true;
        }
        if (tempExpr.equals("now")) {
            Date oDate = new Date();
            sRes = String.valueOf(oDate.getTime());
        } else if (tempExpr.startsWith("media.") && (mediaResource = this.mVideoPlayerView.getMediaResource()) != null) {
            if (tempExpr.startsWith("media.title")) {
                sRes = mediaResource.getTitle();
            } else if (tempExpr.startsWith("player.mode")) {
                sRes = "Android SDK";
            } else if (tempExpr.startsWith("player.version")) {
                sRes = "Akamai Android SDK 9.10.7 player";
            } else if (tempExpr.startsWith("app.name")) {
                sRes = Utils.getApplicationName((Context)this.context);
            } else {
                sRes = FeedParser.getStringPropertyByPath((String)tempExpr, (MediaResource)mediaResource);
                if (sRes != null && sRes.length() == 0) {
                    sRes = "-";
                }
            }
        }
        if (sRes == null) {
            sRes = tempExpr;
        }
        sRes = Uri.encode((String)sRes);
        if (bEncoded) {
            sRes = sRes.replace("%", "%25");
        }
        return sRes;
    }

    private Listeners<IAdsComponentListener> getListeners() {
        this.mListeners.remove(null);
        return this.mListeners;
    }

    protected void reportInvalid(String tag, String methodName) {
        LogManager.error((String)tag, (String)(methodName + " is not valid for " + tag));
    }

    @Override
    public AdProgressChecker getAdProgressChecker() {
        return this.adProgressChecker;
    }
}

