/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.ads;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.source.ads.AdPlaybackState;
import com.akamai.amp.exoplayer2.source.ads.AdsMediaSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface AdsLoader {
    public void setPlayer(@Nullable Player var1);

    public void release();

    public void setSupportedContentTypes(int ... var1);

    public void setAdTagDataSpec(DataSpec var1);

    public void start(EventListener var1, AdViewProvider var2);

    public void stop();

    public void handlePrepareComplete(int var1, int var2);

    public void handlePrepareError(int var1, int var2, IOException var3);

    public static final class OverlayInfo {
        public static final int PURPOSE_CONTROLS = 0;
        public static final int PURPOSE_CLOSE_AD = 1;
        public static final int PURPOSE_OTHER = 2;
        public static final int PURPOSE_NOT_VISIBLE = 3;
        public final View view;
        public final int purpose;
        @Nullable
        public final String reasonDetail;

        public OverlayInfo(View view, int purpose) {
            this(view, purpose, null);
        }

        public OverlayInfo(View view, int purpose, @Nullable String detailedReason) {
            this.view = view;
            this.purpose = purpose;
            this.reasonDetail = detailedReason;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Purpose {
        }
    }

    public static interface AdViewProvider {
        @Nullable
        public ViewGroup getAdViewGroup();

        @Deprecated
        default public View[] getAdOverlayViews() {
            return new View[0];
        }

        default public List<OverlayInfo> getAdOverlayInfos() {
            ImmutableList.Builder listBuilder = new ImmutableList.Builder();
            for (View view : this.getAdOverlayViews()) {
                listBuilder.add((Object)new OverlayInfo(view, 0));
            }
            return listBuilder.build();
        }
    }

    public static interface EventListener {
        default public void onAdPlaybackState(AdPlaybackState adPlaybackState) {
        }

        default public void onAdLoadError(AdsMediaSource.AdLoadException error, DataSpec dataSpec) {
        }

        default public void onAdClicked() {
        }

        default public void onAdTapped() {
        }
    }
}

