/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.simple;

import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

class TaskScheduler {
    private static final long TICK_INTERVAL = 250L;
    private ArrayList<Task> _tasks;
    private Logger _logger;
    private String _logTag;
    private Timer _timer;
    private Object _lock;

    public TaskScheduler(Logger logger) {
        if (logger == null) {
            throw new Error("Reference to the logger cannot be NULL.");
        }
        this._logger = logger;
        this._logTag = this.getClass().getSimpleName();
        this._tasks = new ArrayList();
        this._lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object scheduleTask(ICallback taskFn, long timeAfter) {
        this._logger.info(this._logTag, "#scheduleTask()");
        long execTime = this._getCurrentTimeInMS() + timeAfter - 1L;
        Task task = new Task(taskFn, execTime);
        Object object = this._lock;
        synchronized (object) {
            this._tasks.add(task);
            if (this._tasks.size() == 1) {
                this._startTimer();
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(Object task) {
        this._logger.info(this._logTag, "#cancelTask()");
        Object object = this._lock;
        synchronized (object) {
            this._tasks.remove(task);
            if (this._tasks.size() == 0) {
                this._stopTimer();
            }
        }
    }

    public void pauseTask(Object task) {
        this._logger.info(this._logTag, "#pauseTask()");
    }

    public void resumeTask(Object task) {
        this._logger.info(this._logTag, "#resumeTask()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTasks() {
        Object object = this._lock;
        synchronized (object) {
            this._stopTimer();
            this._tasks = new ArrayList();
        }
    }

    long _getCurrentTimeInMS() {
        return new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTasksAtTime(long time) {
        ArrayList<Task> runTasks = new ArrayList<Task>();
        Iterator iterator = this._lock;
        synchronized (iterator) {
            int i = 0;
            while (i < this._tasks.size()) {
                Task task = this._tasks.get(i);
                if (time >= task.getExecTime()) {
                    runTasks.add(task);
                    this._tasks.remove(i);
                    continue;
                }
                ++i;
            }
            if (this._tasks.size() == 0) {
                this._stopTimer();
            }
        }
        for (Task task : runTasks) {
            task.getTaskFn().call(null);
        }
    }

    private TimerTask _onTickTask() {
        return new TimerTask(){

            public void run() {
                long now = TaskScheduler.this._getCurrentTimeInMS();
                TaskScheduler.this.runTasksAtTime(now);
            }
        };
    }

    private void _startTimer() {
        this._logger.info(this._logTag, "#startTimer()");
        this._timer = new Timer();
        this._timer.schedule(this._onTickTask(), 250L, 250L);
    }

    private void _stopTimer() {
        if (this._timer != null) {
            this._logger.info(this._logTag, "#stopTimer()");
            this._timer.cancel();
            this._timer = null;
        }
    }

    private class Task {
        private ICallback _taskFn;
        private long _execTime;

        Task(ICallback taskFn, long execTime) {
            this._taskFn = taskFn;
            this._execTime = execTime;
        }

        ICallback getTaskFn() {
            return this._taskFn;
        }

        long getExecTime() {
            return this._execTime;
        }
    }
}

