/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.simple;

import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.Logger;
import com.adobe.primetime.core.plugin.IPlugin;
import com.adobe.primetime.va.ErrorInfo;
import com.adobe.primetime.va.Heartbeat;
import com.adobe.primetime.va.HeartbeatConfig;
import com.adobe.primetime.va.HeartbeatDelegate;
import com.adobe.primetime.va.Version;
import com.adobe.primetime.va.plugins.aa.AdobeAnalyticsPlugin;
import com.adobe.primetime.va.plugins.aa.AdobeAnalyticsPluginConfig;
import com.adobe.primetime.va.plugins.aa.AdobeAnalyticsPluginDelegate;
import com.adobe.primetime.va.plugins.ah.AdobeHeartbeatPlugin;
import com.adobe.primetime.va.plugins.ah.AdobeHeartbeatPluginConfig;
import com.adobe.primetime.va.plugins.ah.AdobeHeartbeatPluginDelegate;
import com.adobe.primetime.va.plugins.videoplayer.AdBreakInfo;
import com.adobe.primetime.va.plugins.videoplayer.AdInfo;
import com.adobe.primetime.va.plugins.videoplayer.ChapterInfo;
import com.adobe.primetime.va.plugins.videoplayer.QoSInfo;
import com.adobe.primetime.va.plugins.videoplayer.VideoInfo;
import com.adobe.primetime.va.plugins.videoplayer.VideoPlayerPlugin;
import com.adobe.primetime.va.plugins.videoplayer.VideoPlayerPluginConfig;
import com.adobe.primetime.va.plugins.videoplayer.VideoPlayerPluginDelegate;
import com.adobe.primetime.va.simple.IPredicate;
import com.adobe.primetime.va.simple.MediaHeartbeatConfig;
import com.adobe.primetime.va.simple.MediaObject;
import com.adobe.primetime.va.simple.Predicate;
import com.adobe.primetime.va.simple.RuleEngine;
import com.adobe.primetime.va.simple.RuleEngineContext;
import com.adobe.primetime.va.simple.TaskScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaHeartbeat {
    private final Object _lock;
    private MediaHeartbeatDelegate _delegate;
    private MediaHeartbeatConfig _config;
    private HashMap<State, Boolean> _mediaState;
    private String _logTag;
    private Logger _logger;
    private VideoInfo _videoInfo;
    private AdBreakInfo _adBreakInfo;
    private AdInfo _adInfo;
    private ChapterInfo _chapterInfo;
    private AdobeAnalyticsPlugin _aaPlugin;
    private AdobeHeartbeatPlugin _ahPlugin;
    private VideoPlayerPlugin _playerPlugin;
    private Heartbeat _heartbeat;
    private Boolean _debugLogging = false;
    private boolean _mediaHeartbeatDisabled;
    private RuleEngine _ruleEngine;
    private TaskScheduler _taskScheduler;
    private MediaObject _currentMediaObject;
    private MediaObject _currentAdObject;
    private MediaObject _currentAdBreakObject;
    private MediaObject _currentChapterObject;
    private boolean _prerollWaitEnabled;
    private long _prerollWaitTime;
    private boolean _playReceived;
    private boolean _playUnhandledFromPrerollWaitTime;
    private Object _playTaskHandle;
    private boolean _playAfterAdStart;
    private String KEY_MEDIA_OBJECT = "key_media_object";
    private String KEY_ADBREAK_OBJECT = "key_adbreak_object";
    private String KEY_AD_OBJECT = "key_ad_object";
    private String KEY_CHAPTER_OBJECT = "key_chapter_object";
    private String KEY_TIMED_METADATA_OBJECT = "key_timed_metadata_object";
    private String KEY_CUSTOM_METADATA = "key_custom_metadata";
    private String KEY_ERROR_ID = "key_error_id";
    private String MEDIAINFO_KEY_TIMEDMETADATA = "timedMetadata";
    private IPredicate _isTrackingDisabled = new IPredicate(){

        public boolean call(Object data) {
            return MediaHeartbeat.this._mediaHeartbeatDisabled;
        }
    };
    private IPredicate _isInSession = new IPredicate(){

        public boolean call(Object data) {
            return MediaHeartbeat.this._isInState(State.Session);
        }
    };
    private IPredicate _isInMedia = new IPredicate(){

        public boolean call(Object param) {
            return MediaHeartbeat.this._isInState(State.Media);
        }
    };
    private IPredicate _isInAd = new IPredicate(){

        public boolean call(Object param) {
            return MediaHeartbeat.this._isInState(State.Ad);
        }
    };
    private IPredicate _isInAdBreak = new IPredicate(){

        public boolean call(Object param) {
            return MediaHeartbeat.this._isInState(State.AdBreak);
        }
    };
    private IPredicate _isInChapter = new IPredicate(){

        public boolean call(Object param) {
            return MediaHeartbeat.this._isInState(State.Chapter);
        }
    };
    private IPredicate _isInPlay = new IPredicate(){

        public boolean call(Object param) {
            return MediaHeartbeat.this._isInState(State.PlayPause);
        }
    };
    private IPredicate _isInPause = new IPredicate(){

        public boolean call(Object param) {
            return !MediaHeartbeat.this._isInState(State.PlayPause);
        }
    };
    private IPredicate _isInBuffer = new IPredicate(){

        public boolean call(Object param) {
            return MediaHeartbeat.this._isInState(State.Buffer);
        }
    };
    private IPredicate _isInSeek = new IPredicate(){

        public boolean call(Object param) {
            return MediaHeartbeat.this._isInState(State.Seek);
        }
    };
    private IPredicate _isValidMediaObject = new IPredicate(){

        public boolean call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            if (reContext.getData(MediaHeartbeat.this.KEY_MEDIA_OBJECT) instanceof MediaObject) {
                MediaObject mediaObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_MEDIA_OBJECT);
                if (mediaObject.getValue("resumed") != null && !(mediaObject.getValue("resumed") instanceof Boolean)) {
                    MediaHeartbeat.this._logger.warn(MediaHeartbeat.this._logTag, "Ignoring value set for MediaResumed in MediaObject as we expect a valid Boolean value");
                }
                if (mediaObject.getValue("preroll_tracking_waiting_time") != null && !(mediaObject.getValue("preroll_tracking_waiting_time") instanceof Long)) {
                    MediaHeartbeat.this._logger.warn(MediaHeartbeat.this._logTag, "Ignoring value set for PrerollTrackingWaitingTime in MediaObject as we expect a valid Long value");
                }
                if (mediaObject.getValue("media_standard_content_metadata") != null && !(mediaObject.getValue("media_standard_content_metadata") instanceof HashMap)) {
                    MediaHeartbeat.this._logger.warn(MediaHeartbeat.this._logTag, "Ignoring value set for StandardMediaMetadata in MediaObject as we expect a valid HashMap instance");
                }
                return true;
            }
            return false;
        }
    };
    private IPredicate _isValidAdBreakObject = new IPredicate(){

        public boolean call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            return reContext.getData(MediaHeartbeat.this.KEY_ADBREAK_OBJECT) instanceof MediaObject;
        }
    };
    private IPredicate _isDifferentAdBreakObject = new IPredicate(){

        public boolean call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaObject adBreakObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_ADBREAK_OBJECT);
            return MediaHeartbeat.this._currentAdBreakObject == null || !MediaHeartbeat.this._currentAdBreakObject.isEqual(adBreakObject);
        }
    };
    private IPredicate _isValidAdObject = new IPredicate(){

        public boolean call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            if (reContext.getData(MediaHeartbeat.this.KEY_AD_OBJECT) instanceof MediaObject) {
                MediaObject adObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_AD_OBJECT);
                if (adObject.getValue("granular_ad_tracking") != null && !(adObject.getValue("granular_ad_tracking") instanceof Boolean)) {
                    MediaHeartbeat.this._logger.warn(MediaHeartbeat.this._logTag, "Ignoring value set for GranularAdTracking in AdObject as we expect a valid Boolean value");
                }
                if (adObject.getValue("media_standard_ad_metadata") != null && !(adObject.getValue("media_standard_ad_metadata") instanceof HashMap)) {
                    MediaHeartbeat.this._logger.warn(MediaHeartbeat.this._logTag, "Ignoring value set for StandardAdMetadata in MediaObject as we expect a valid HashMap instance");
                }
                return true;
            }
            return false;
        }
    };
    private IPredicate _isDifferentAdObject = new IPredicate(){

        public boolean call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaObject adObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_AD_OBJECT);
            return MediaHeartbeat.this._currentAdObject == null || !MediaHeartbeat.this._currentAdObject.isEqual(adObject);
        }
    };
    private IPredicate _isValidChapterObject = new IPredicate(){

        public boolean call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            return reContext.getData(MediaHeartbeat.this.KEY_CHAPTER_OBJECT) instanceof MediaObject;
        }
    };
    private IPredicate _isDifferentChapterObject = new IPredicate(){

        public boolean call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaObject chapterObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_CHAPTER_OBJECT);
            return MediaHeartbeat.this._currentChapterObject == null || !MediaHeartbeat.this._currentChapterObject.isEqual(chapterObject);
        }
    };
    private IPredicate _isValidTimedMetadataObject = new IPredicate(){

        public boolean call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            if (reContext.getData(MediaHeartbeat.this.KEY_TIMED_METADATA_OBJECT) instanceof MediaObject) {
                MediaObject timedMetadataObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_TIMED_METADATA_OBJECT);
                return timedMetadataObject.getValue(MediaHeartbeat.this.MEDIAINFO_KEY_TIMEDMETADATA) instanceof String;
            }
            return false;
        }
    };
    private IPredicate _shouldAllowPlayerStateChange = new IPredicate(){

        public boolean call(Object param) {
            return !MediaHeartbeat.this._isInState(State.AdBreak) || MediaHeartbeat.this._isInState(State.Ad);
        }
    };
    private ICallback _cleanContextData = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            if (reContext.getData(MediaHeartbeat.this.KEY_CUSTOM_METADATA) != null && reContext.getData(MediaHeartbeat.this.KEY_CUSTOM_METADATA) instanceof HashMap) {
                MediaHeartbeat.this._cleanMap((HashMap)reContext.getData(MediaHeartbeat.this.KEY_CUSTOM_METADATA));
            }
            return null;
        }
    };
    private ICallback _deferredTrackPlay = new ICallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call(Object param) {
            Object object = MediaHeartbeat.this._lock;
            synchronized (object) {
                if (!MediaHeartbeat.this._prerollWaitEnabled) {
                    return null;
                }
                MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Executing deferred API:trackPlay.");
                MediaHeartbeat.this._prerollWaitEnabled = false;
                MediaHeartbeat.this._playTaskHandle = null;
                MediaHeartbeat.this._processRule(3, RuleEngine.createContext());
            }
            return null;
        }
    };
    private ICallback _cmdEnterAction = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            int ruleName = reContext.getRuleName();
            if (MediaHeartbeat.this._prerollWaitEnabled) {
                if (!MediaHeartbeat.this._playReceived) {
                    switch (ruleName) {
                        case 3: {
                            MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Deferring API:trackPlay for " + MediaHeartbeat.this._prerollWaitTime + " ms.");
                            MediaHeartbeat.this._playReceived = true;
                            MediaHeartbeat.this._playUnhandledFromPrerollWaitTime = true;
                            MediaHeartbeat.this._playTaskHandle = MediaHeartbeat.this._taskScheduler.scheduleTask(MediaHeartbeat.this._deferredTrackPlay, MediaHeartbeat.this._prerollWaitTime);
                            reContext.stopProcessingAction();
                            break;
                        }
                        case 4: {
                            MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Received trackPause before first trackPlay.");
                            MediaHeartbeat.this._prerollWaitEnabled = false;
                            break;
                        }
                        case 6: {
                            MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Received trackEvent(AdBreakStart) before first trackPlay.");
                            MediaHeartbeat.this._prerollWaitEnabled = false;
                        }
                    }
                } else {
                    switch (ruleName) {
                        case 14: 
                        case 16: {
                            MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Cancelling scheduled API:trackPlay because of SeekStart/BufferStart event");
                            MediaHeartbeat.this._taskScheduler.cancelTask(MediaHeartbeat.this._playTaskHandle);
                            MediaHeartbeat.this._playTaskHandle = null;
                            break;
                        }
                        case 15: 
                        case 17: {
                            MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Rescheduled API:trackPlay after SeekComplete/BufferComplete event");
                            MediaHeartbeat.this._playTaskHandle = MediaHeartbeat.this._taskScheduler.scheduleTask(MediaHeartbeat.this._deferredTrackPlay, MediaHeartbeat.this._prerollWaitTime);
                            break;
                        }
                        case 3: {
                            MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Dropping API:trackPlay as we already have a API:trackPlay scheduled.");
                            reContext.stopProcessingAction();
                            break;
                        }
                        case 4: {
                            MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Cancelling scheduled API:trackPlay because of API:trackPause call.");
                            MediaHeartbeat.this._taskScheduler.cancelTask(MediaHeartbeat.this._playTaskHandle);
                            MediaHeartbeat.this._playTaskHandle = null;
                            MediaHeartbeat.this._prerollWaitEnabled = false;
                            break;
                        }
                        case 6: {
                            MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Received API:trackEvent(AdBreakStart) within " + MediaHeartbeat.this._prerollWaitTime + " ms after API:trackPlay. We will track this as preroll AdBreak.");
                            MediaHeartbeat.this._taskScheduler.cancelTask(MediaHeartbeat.this._playTaskHandle);
                            MediaHeartbeat.this._playTaskHandle = null;
                            MediaHeartbeat.this._prerollWaitEnabled = false;
                            MediaHeartbeat.this._playAfterAdStart = true;
                        }
                    }
                }
            }
            return null;
        }
    };
    private ICallback _cmdExitAction = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            int ruleName = reContext.getRuleName();
            if (MediaHeartbeat.this._playAfterAdStart) {
                if (ruleName == 8) {
                    MediaHeartbeat.this._cmdPlay.call(reContext);
                    MediaHeartbeat.this._playAfterAdStart = false;
                } else if (ruleName == 7) {
                    MediaHeartbeat.this._playAfterAdStart = false;
                }
            }
            if (ruleName == 8 && !MediaHeartbeat.this._isInState(State.FPlayPause)) {
                MediaHeartbeat.this._cmdPlay.call(reContext);
            }
            if (!(MediaHeartbeat.this._prerollWaitEnabled || !MediaHeartbeat.this._playUnhandledFromPrerollWaitTime || ruleName != 17 && ruleName != 15 && ruleName != 7 || MediaHeartbeat.this._isInState(State.FPlayPause) || MediaHeartbeat.this._isInState(State.Buffer) || MediaHeartbeat.this._isInState(State.Seek))) {
                MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "Executing pending API:trackPlay. This case most likely happens tracking Preroll AdBreak without any Ads.");
                MediaHeartbeat.this._cmdPlay.call(reContext);
            }
            return null;
        }
    };
    private ICallback _cmdConfigure = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaHeartbeat.this._resetStates();
            ArrayList plugins = new ArrayList();
            MediaHeartbeat.this.configureAdobeAnalyticsPlugin(plugins);
            String mcOrgId = null;
            if (MediaHeartbeat.this._aaPlugin != null && MediaHeartbeat.this._aaPlugin.getMobileServices() != null) {
                mcOrgId = MediaHeartbeat.this._aaPlugin.getMobileServices().getMarketingCloudOrgID();
            }
            if (mcOrgId == null || mcOrgId.length() == 0) {
                MediaHeartbeat.this._logger.error(MediaHeartbeat.this._logTag, "Marketing Cloud Organization ID is not defined in the json config");
                MediaHeartbeat.this._resetStates();
                reContext.stopProcessingAction();
                return null;
            }
            MediaHeartbeat.this.configureVideoPlayerPlugin(plugins);
            MediaHeartbeat.this.configureAdobeHeartbeatPlugin(plugins, mcOrgId);
            MediaHeartbeat.this.configureOtherPlugins(plugins);
            MediaHeartbeat.this.configureHeartbeat(plugins);
            return null;
        }
    };
    private ICallback _cmdSessionStart = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaObject mediaObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_MEDIA_OBJECT);
            MediaHeartbeat.this._currentMediaObject = mediaObject;
            MediaHeartbeat.this._videoInfo = mediaObject.createVideoInfo();
            String string = ((MediaHeartbeat)MediaHeartbeat.this)._videoInfo.playerName = ((MediaHeartbeat)MediaHeartbeat.this)._config.playerName != null ? ((MediaHeartbeat)MediaHeartbeat.this)._config.playerName : "";
            if (mediaObject.getValue("resumed") != null && mediaObject.getValue("resumed") instanceof Boolean) {
                ((MediaHeartbeat)MediaHeartbeat.this)._videoInfo.resumed = (Boolean)mediaObject.getValue("resumed");
            }
            if (mediaObject.getValue("preroll_tracking_waiting_time") != null && mediaObject.getValue("preroll_tracking_waiting_time") instanceof Long) {
                MediaHeartbeat.this._prerollWaitTime = (Long)mediaObject.getValue("preroll_tracking_waiting_time");
                if (MediaHeartbeat.this._prerollWaitTime <= 0L) {
                    MediaHeartbeat.this._prerollWaitEnabled = false;
                }
            }
            Object mediaMetadata = reContext.getData(MediaHeartbeat.this.KEY_CUSTOM_METADATA);
            Object standardMetadata = mediaObject.getValue("media_standard_content_metadata");
            HashMap metadata = MediaHeartbeat.this._prepareMetadata(standardMetadata, mediaMetadata);
            metadata.put(MediaHeartbeat.AdobeMediaTypeContextDataKey, ((MediaHeartbeat)MediaHeartbeat.this)._videoInfo.mediaType);
            MediaHeartbeat.this._aaPlugin.setVideoMetadata(metadata);
            MediaHeartbeat.this._playerPlugin.trackVideoLoad();
            MediaHeartbeat.this._playerPlugin.trackSessionStart();
            MediaHeartbeat.this._setState(State.Session, true);
            MediaHeartbeat.this._setState(State.Media, true);
            return null;
        }
    };
    private ICallback _cmdVideoEnd = new ICallback(){

        public Object call(Object param) {
            boolean complete;
            RuleEngineContext reContext = (RuleEngineContext)param;
            boolean bl = complete = reContext.getRuleName() == 2;
            if (MediaHeartbeat.this._isInState(State.Media)) {
                MediaHeartbeat.this._playerPlugin.trackComplete(new CompleteCallback(MediaHeartbeat.this._heartbeat, MediaHeartbeat.this._playerPlugin), complete);
            }
            MediaHeartbeat.this._setState(State.Media, false);
            return null;
        }
    };
    private ICallback _cmdHandleMediaComplete = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            if (!MediaHeartbeat.this._isInMedia.call(reContext)) {
                MediaHeartbeat.this._logger.info(MediaHeartbeat.this._logTag, "API:trackComplete has already cleaned up Heartbeat instance.");
                MediaHeartbeat.this._cmdSessionEnd.call(reContext);
                reContext.stopProcessingAction();
            }
            return null;
        }
    };
    private ICallback _cmdSessionEnd = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._resetStates();
            return null;
        }
    };
    private ICallback _cmdDisableTracking = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._logger.error(MediaHeartbeat.this._logTag, "#_cmdDisableTracking: ADBMediaHeartbeat Tracking Disabled Remotely.");
            MediaHeartbeat.this._mediaHeartbeatDisabled = true;
            return null;
        }
    };
    private ICallback _cmdBufferStart = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._playerPlugin.trackBufferStart();
            MediaHeartbeat.this._setState(State.Buffer, true);
            return null;
        }
    };
    private ICallback _cmdBufferComplete = new ICallback(){

        public Object call(Object param) {
            if (MediaHeartbeat.this._isInState(State.Buffer)) {
                MediaHeartbeat.this._playerPlugin.trackBufferComplete();
            }
            MediaHeartbeat.this._setState(State.Buffer, false);
            return null;
        }
    };
    private ICallback _cmdSeekStart = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._playerPlugin.trackSeekStart();
            MediaHeartbeat.this._setState(State.Seek, true);
            return null;
        }
    };
    private ICallback _cmdSeekComplete = new ICallback(){

        public Object call(Object param) {
            if (MediaHeartbeat.this._isInState(State.Seek)) {
                MediaHeartbeat.this._playerPlugin.trackSeekComplete();
            }
            MediaHeartbeat.this._setState(State.Seek, false);
            return null;
        }
    };
    private ICallback _cmdPlay = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._playerPlugin.trackPlay();
            MediaHeartbeat.this._setState(State.PlayPause, true);
            MediaHeartbeat.this._setState(State.FPlayPause, true);
            MediaHeartbeat.this._playUnhandledFromPrerollWaitTime = false;
            return null;
        }
    };
    private ICallback _cmdPause = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._playerPlugin.trackPause();
            MediaHeartbeat.this._setState(State.PlayPause, false);
            MediaHeartbeat.this._setState(State.FPlayPause, true);
            return null;
        }
    };
    private ICallback _cmdAdBreakStart = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaObject adBreakObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_ADBREAK_OBJECT);
            MediaHeartbeat.this._currentAdBreakObject = adBreakObject;
            MediaHeartbeat.this._adBreakInfo = adBreakObject.createAdBreakInfo();
            ((MediaHeartbeat)MediaHeartbeat.this)._adBreakInfo.playerName = ((MediaHeartbeat)MediaHeartbeat.this)._config.playerName != null ? ((MediaHeartbeat)MediaHeartbeat.this)._config.playerName : "";
            MediaHeartbeat.this._playerPlugin.trackAdBreakStart();
            MediaHeartbeat.this._setState(State.AdBreak, true);
            return null;
        }
    };
    private ICallback _cmdAdBreakComplete = new ICallback(){

        public Object call(Object data) {
            MediaHeartbeat.this._currentAdBreakObject = null;
            MediaHeartbeat.this._adBreakInfo = null;
            if (MediaHeartbeat.this._isInState(State.AdBreak)) {
                MediaHeartbeat.this._playerPlugin.trackAdBreakComplete();
            }
            MediaHeartbeat.this._setState(State.AdBreak, false);
            return null;
        }
    };
    private ICallback _cmdAdStart = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaObject adObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_AD_OBJECT);
            MediaHeartbeat.this._currentAdObject = adObject;
            MediaHeartbeat.this._adInfo = adObject.createAdInfo();
            if (adObject.getValue("granular_ad_tracking") != null && adObject.getValue("granular_ad_tracking") instanceof Boolean) {
                ((MediaHeartbeat)MediaHeartbeat.this)._adInfo.granularTracking = (Boolean)adObject.getValue("granular_ad_tracking");
            }
            Object adMetadata = reContext.getData(MediaHeartbeat.this.KEY_CUSTOM_METADATA);
            Object standardMetadata = adObject.getValue("media_standard_ad_metadata");
            HashMap metadata = MediaHeartbeat.this._prepareMetadata(standardMetadata, adMetadata);
            metadata.remove(MediaHeartbeat.AdobeMediaTypeContextDataKey);
            MediaHeartbeat.this._aaPlugin.setAdMetadata(metadata);
            MediaHeartbeat.this._playerPlugin.trackAdStart();
            MediaHeartbeat.this._setState(State.Ad, true);
            return null;
        }
    };
    private ICallback _cmdAdComplete = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._currentAdObject = null;
            MediaHeartbeat.this._adInfo = null;
            if (MediaHeartbeat.this._isInState(State.Ad)) {
                MediaHeartbeat.this._playerPlugin.trackAdComplete();
            }
            MediaHeartbeat.this._setState(State.Ad, false);
            return null;
        }
    };
    private ICallback _cmdAdSkip = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._currentAdObject = null;
            MediaHeartbeat.this._adInfo = null;
            if (MediaHeartbeat.this._isInState(State.Ad)) {
                MediaHeartbeat.this._playerPlugin.trackAdSkip();
            }
            MediaHeartbeat.this._setState(State.Ad, false);
            return null;
        }
    };
    private ICallback _cmdChapterStart = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaObject chapterObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_CHAPTER_OBJECT);
            MediaHeartbeat.this._currentChapterObject = chapterObject;
            MediaHeartbeat.this._chapterInfo = chapterObject.createChapterInfo();
            Object chapterMetadata = reContext.getData(MediaHeartbeat.this.KEY_CUSTOM_METADATA);
            HashMap metadata = MediaHeartbeat.this._prepareMetadata(null, chapterMetadata);
            metadata.remove(MediaHeartbeat.AdobeMediaTypeContextDataKey);
            MediaHeartbeat.this._aaPlugin.setChapterMetadata(metadata);
            MediaHeartbeat.this._playerPlugin.trackChapterStart();
            MediaHeartbeat.this._setState(State.Chapter, true);
            return null;
        }
    };
    private ICallback _cmdChapterComplete = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._currentChapterObject = null;
            MediaHeartbeat.this._chapterInfo = null;
            if (MediaHeartbeat.this._isInState(State.Chapter)) {
                MediaHeartbeat.this._playerPlugin.trackChapterComplete();
            }
            MediaHeartbeat.this._setState(State.Chapter, false);
            return null;
        }
    };
    private ICallback _cmdChapterSkip = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._currentChapterObject = null;
            MediaHeartbeat.this._chapterInfo = null;
            if (MediaHeartbeat.this._isInState(State.Chapter)) {
                MediaHeartbeat.this._playerPlugin.trackChapterSkip();
            }
            MediaHeartbeat.this._setState(State.Chapter, false);
            return null;
        }
    };
    private ICallback _cmdError = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            String errorId = (String)reContext.getData(MediaHeartbeat.this.KEY_ERROR_ID);
            if (errorId == null || errorId == "") {
                errorId = "unknown_error_id";
            }
            MediaHeartbeat.this._playerPlugin.trackVideoPlayerError(errorId);
            return null;
        }
    };
    private ICallback _cmdBitrate = new ICallback(){

        public Object call(Object param) {
            MediaHeartbeat.this._playerPlugin.trackBitrateChange();
            return null;
        }
    };
    private ICallback _cmdTimedMetadataUpdate = new ICallback(){

        public Object call(Object param) {
            RuleEngineContext reContext = (RuleEngineContext)param;
            MediaObject timedMetadataObject = (MediaObject)reContext.getData(MediaHeartbeat.this.KEY_TIMED_METADATA_OBJECT);
            String timedMetadata = timedMetadataObject.createTimedMetadata();
            MediaHeartbeat.this._playerPlugin.trackTimedMetadata(timedMetadata);
            return null;
        }
    };
    private static final String AdobeMediaHeartbeatPrimetimeTVSDKVersionKey = "a.__pttvsdkVersion";
    private static final String AdobeMediaTypeContextDataKey = "a.media.streamType";
    private static final long CONST_PREROLL_WAIT_TIME = 250L;

    public static MediaObject createMediaObject(String name, String mediaId, Double length, String streamType) {
        return MediaObject.mediaInfoForVideo(name, mediaId, length, streamType, MediaType.Video);
    }

    public static MediaObject createMediaObject(String name, String mediaId, Double length, String streamType, MediaType mediaType) {
        return MediaObject.mediaInfoForVideo(name, mediaId, length, streamType, mediaType);
    }

    public static MediaObject createAdBreakObject(String name, Long position, Double startTime) {
        return MediaObject.mediaInfoForAdBreak(name, position, startTime);
    }

    public static MediaObject createAdObject(String name, String adId, Long position, Double length) {
        return MediaObject.mediaInfoForAd(name, adId, position, length);
    }

    public static MediaObject createChapterObject(String name, Long position, Double length, Double startTime) {
        return MediaObject.mediaInfoForChapter(name, position, length, startTime);
    }

    public static MediaObject createQoSObject(Long bitrate, Double startupTime, Double fps, Long droppedFrames) {
        return MediaObject.mediaInfoForQoS(bitrate, startupTime, fps, droppedFrames);
    }

    public static MediaObject createTimedMetadataObject(String metadata) {
        return MediaObject.mediaInfoForTimedMetadata(metadata);
    }

    public MediaHeartbeat(MediaHeartbeatDelegate delegate, MediaHeartbeatConfig config) {
        if (delegate == null) {
            throw new Error("MediaHeartbeatDelegate cannot be NULL");
        }
        if (config == null) {
            throw new Error("MediaHeartbeatConfig cannot be NULL");
        }
        this._delegate = delegate;
        this._config = config;
        this._lock = new Object();
        this._logger = new Logger();
        this._logTag = this.getClass().getSimpleName();
        this._debugLogging = config.debugLogging;
        if (this._debugLogging.booleanValue()) {
            this._logger.enable();
        } else {
            this._logger.disable();
        }
        this._ruleEngine = new RuleEngine(this._logger);
        this._taskScheduler = new TaskScheduler(this._logger);
        this._resetStates();
        this._setupRules();
    }

    public static String version() {
        return Version.getVersion();
    }

    public void trackSessionStart(MediaObject mediaInfo, Map<String, String> contextData) {
        this._logger.debug(this._logTag, "#trackSessionStart");
        HashMap<String, String> videoContextData = null;
        if (contextData != null && contextData instanceof HashMap) {
            videoContextData = new HashMap<String, String>(contextData);
        }
        RuleEngineContext reContext = RuleEngine.createContext();
        reContext.setData(this.KEY_MEDIA_OBJECT, mediaInfo);
        reContext.setData(this.KEY_CUSTOM_METADATA, videoContextData);
        this._processRule(0, reContext);
    }

    public void trackPlay() {
        this._logger.debug(this._logTag, "#trackPlay");
        RuleEngineContext reContext = RuleEngine.createContext();
        this._processRule(3, reContext);
    }

    public void trackPause() {
        this._logger.debug(this._logTag, "#trackPause");
        RuleEngineContext reContext = RuleEngine.createContext();
        this._processRule(4, reContext);
    }

    public void trackComplete() {
        this._logger.debug(this._logTag, "#trackComplete");
        RuleEngineContext reContext = RuleEngine.createContext();
        this._processRule(2, reContext);
    }

    public void trackSessionEnd() {
        this._logger.debug(this._logTag, "#trackSessionEnd");
        RuleEngineContext reContext = RuleEngine.createContext();
        this._processRule(1, reContext);
    }

    public void trackError(String errorId) {
        this._logger.debug(this._logTag, "#trackError");
        RuleEngineContext reContext = RuleEngine.createContext();
        reContext.setData(this.KEY_ERROR_ID, errorId);
        this._processRule(5, reContext);
    }

    public void trackEvent(Event event, MediaObject info, Map<String, String> contextData) {
        int ruleName;
        this._logger.info(this._logTag, "#::trackEvent() - " + (Object)((Object)event));
        RuleEngineContext reContext = RuleEngine.createContext();
        HashMap<String, String> contextMetadata = null;
        if (contextData != null && contextData instanceof HashMap) {
            contextMetadata = new HashMap<String, String>(contextData);
        }
        switch (event) {
            case AdBreakStart: {
                reContext.setData(this.KEY_ADBREAK_OBJECT, info);
                reContext.setData(this.KEY_CUSTOM_METADATA, contextMetadata);
                ruleName = 6;
                break;
            }
            case AdBreakComplete: {
                ruleName = 7;
                break;
            }
            case AdStart: {
                reContext.setData(this.KEY_AD_OBJECT, info);
                reContext.setData(this.KEY_CUSTOM_METADATA, contextMetadata);
                ruleName = 8;
                break;
            }
            case AdComplete: {
                ruleName = 9;
                break;
            }
            case AdSkip: {
                ruleName = 10;
                break;
            }
            case SeekStart: {
                ruleName = 14;
                break;
            }
            case SeekComplete: {
                ruleName = 15;
                break;
            }
            case ChapterStart: {
                reContext.setData(this.KEY_CHAPTER_OBJECT, info);
                reContext.setData(this.KEY_CUSTOM_METADATA, contextMetadata);
                ruleName = 11;
                break;
            }
            case ChapterComplete: {
                ruleName = 12;
                break;
            }
            case ChapterSkip: {
                ruleName = 13;
                break;
            }
            case BufferStart: {
                ruleName = 16;
                break;
            }
            case BufferComplete: {
                ruleName = 17;
                break;
            }
            case BitrateChange: {
                ruleName = 18;
                break;
            }
            case TimedMetadataUpdate: {
                ruleName = 19;
                reContext.setData(this.KEY_TIMED_METADATA_OBJECT, info);
                break;
            }
            default: {
                this._logger.error(this._logTag, "Incorrect event name.");
                return;
            }
        }
        this._processRule(ruleName, reContext);
    }

    MediaObject getCurrentMediaObject() {
        return this._currentMediaObject;
    }

    MediaObject getCurrentAdObject() {
        return this._currentAdObject;
    }

    MediaObject getCurrentAdBreakObject() {
        return this._currentAdBreakObject;
    }

    MediaObject getCurrentChapterObject() {
        return this._currentChapterObject;
    }

    private void _resetStates() {
        this._taskScheduler.clearTasks();
        this._mediaState = new HashMap();
        this._videoInfo = null;
        this._adBreakInfo = null;
        this._adInfo = null;
        this._chapterInfo = null;
        this._currentMediaObject = null;
        this._currentAdObject = null;
        this._currentAdBreakObject = null;
        this._currentChapterObject = null;
        this._prerollWaitEnabled = true;
        this._prerollWaitTime = 250L;
        this._playReceived = false;
        this._playUnhandledFromPrerollWaitTime = false;
        this._playTaskHandle = null;
        this._playAfterAdStart = false;
        this._aaPlugin = null;
        this._playerPlugin = null;
        this._ahPlugin = null;
        this._heartbeat = null;
    }

    private void _cleanMap(HashMap map) {
        ArrayList keysToRemove = new ArrayList();
        for (Object key : map.keySet()) {
            if (key instanceof String && !((String)key).isEmpty() && map.get(key) instanceof String) continue;
            keysToRemove.add(key);
        }
        for (Object key : keysToRemove) {
            map.remove(key);
        }
    }

    private HashMap<String, String> _prepareMetadata(Object standardMetadata, Object customMetadata) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (customMetadata != null && customMetadata instanceof HashMap) {
            ret.putAll((Map)customMetadata);
        }
        if (standardMetadata != null && standardMetadata instanceof HashMap) {
            this._cleanMap((HashMap)standardMetadata);
            ret.putAll((Map)standardMetadata);
        }
        return ret;
    }

    private void _setState(State state, boolean value) {
        this._mediaState.put(state, value);
    }

    private boolean _isInState(State state) {
        if (this._mediaState.get((Object)state) != null) {
            return this._mediaState.get((Object)state);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _processRule(int ruleName, RuleEngineContext reContext) {
        Object object = this._lock;
        synchronized (object) {
            return this._ruleEngine.processRule(ruleName, reContext);
        }
    }

    private void _setupRules() {
        this._ruleEngine.registerEnterExitAction(this._cmdEnterAction, this._cmdExitAction);
        ArrayList<Predicate> sessionStartPredicateList = new ArrayList<Predicate>();
        sessionStartPredicateList.add(RuleEngine.createPredicate(this._isTrackingDisabled, false, "MediaHeartbeat tracking is disabled for this publisher. Please contact Adobe Representative to enable tracking."));
        sessionStartPredicateList.add(RuleEngine.createPredicate(this._isInSession, false, "MediaHeartbeat is already in tracking session, call trackSessionEnd to end current tracking session."));
        sessionStartPredicateList.add(RuleEngine.createPredicate(this._isValidMediaObject, true, "VideoInfo passed into trackSessionStart is invalid."));
        ArrayList<ICallback> sessionStartActionList = new ArrayList<ICallback>();
        sessionStartActionList.add(this._cmdConfigure);
        sessionStartActionList.add(this._cleanContextData);
        sessionStartActionList.add(this._cmdSessionStart);
        this._ruleEngine.registerRule(0, "API:trackSessionStart", sessionStartPredicateList, sessionStartActionList);
        ArrayList<Predicate> sessionEndPredicateList = new ArrayList<Predicate>();
        sessionEndPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        ArrayList<ICallback> sessionEndActionList = new ArrayList<ICallback>();
        sessionEndActionList.add(this._cmdHandleMediaComplete);
        sessionEndActionList.add(this._cmdAdSkip);
        sessionEndActionList.add(this._cmdAdBreakComplete);
        sessionEndActionList.add(this._cmdChapterSkip);
        sessionEndActionList.add(this._cmdVideoEnd);
        sessionEndActionList.add(this._cmdSessionEnd);
        this._ruleEngine.registerRule(1, "API:trackSessionEnd", sessionEndPredicateList, sessionEndActionList);
        ArrayList<Predicate> videoCompletePredicateList = new ArrayList<Predicate>();
        videoCompletePredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        videoCompletePredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        ArrayList<ICallback> videoCompleteActionList = new ArrayList<ICallback>();
        videoCompleteActionList.add(this._cmdAdSkip);
        videoCompleteActionList.add(this._cmdAdBreakComplete);
        videoCompleteActionList.add(this._cmdChapterSkip);
        videoCompleteActionList.add(this._cmdVideoEnd);
        this._ruleEngine.registerRule(2, "API:trackComplete", videoCompletePredicateList, videoCompleteActionList);
        ArrayList<Predicate> disableTrackingPredicateList = new ArrayList<Predicate>();
        disableTrackingPredicateList.add(RuleEngine.createPredicate(this._isTrackingDisabled, false, "MediaHeartbeat tracking is disabled for this publisher. Please contact Adobe Representative to enable tracking."));
        ArrayList<ICallback> disableTrackingActionList = new ArrayList<ICallback>();
        disableTrackingActionList.add(this._cmdDisableTracking);
        this._ruleEngine.registerRule(20, "DisableTracking", disableTrackingPredicateList, disableTrackingActionList);
        ArrayList<Predicate> errorPredicateList = new ArrayList<Predicate>();
        errorPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        errorPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        ArrayList<ICallback> errorActionList = new ArrayList<ICallback>();
        errorActionList.add(this._cmdError);
        this._ruleEngine.registerRule(5, "API:trackError", errorPredicateList, errorActionList);
        ArrayList<Predicate> playPredicateList = new ArrayList<Predicate>();
        playPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        playPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        playPredicateList.add(RuleEngine.createPredicate(this._shouldAllowPlayerStateChange, true, "MediaHeartbeat is tracking an AdBreak but not tracking any Ad and will drop any calls to track player state (Play, Pause, Buffer or Seek) in this state."));
        ArrayList<ICallback> playActionList = new ArrayList<ICallback>();
        playActionList.add(this._cmdSeekComplete);
        playActionList.add(this._cmdBufferComplete);
        playActionList.add(this._cmdPlay);
        this._ruleEngine.registerRule(3, "API:trackPlay", playPredicateList, playActionList);
        ArrayList<Predicate> pausePredicateList = new ArrayList<Predicate>();
        pausePredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        pausePredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        pausePredicateList.add(RuleEngine.createPredicate(this._shouldAllowPlayerStateChange, true, "MediaHeartbeat is tracking an AdBreak but not tracking any Ad and will drop any calls to track player state (Play, Pause, Buffer or Seek) in this state."));
        pausePredicateList.add(RuleEngine.createPredicate(this._isInBuffer, false, "MediaHeartbeat is already tracking buffer events. We got a duplicate call to trackEvent(MediaHeartbeat.Event.BufferStart)."));
        pausePredicateList.add(RuleEngine.createPredicate(this._isInSeek, false, "MediaHeartbeat is already tracking seek events. We got a duplicate call to trackEvent(MediaHeartbeat.Event.SeekStart)."));
        ArrayList<ICallback> pauseActionList = new ArrayList<ICallback>();
        pauseActionList.add(this._cmdPause);
        this._ruleEngine.registerRule(4, "API:trackPause", pausePredicateList, pauseActionList);
        ArrayList<Predicate> bufferStartPredicateList = new ArrayList<Predicate>();
        bufferStartPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        bufferStartPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        bufferStartPredicateList.add(RuleEngine.createPredicate(this._shouldAllowPlayerStateChange, true, "MediaHeartbeat is tracking an AdBreak but not tracking any Ad and will drop any calls to track player state (Play, Pause, Buffer or Seek) in this state."));
        bufferStartPredicateList.add(RuleEngine.createPredicate(this._isInBuffer, false, "MediaHeartbeat is already tracking buffer events. We got a duplicate call to trackEvent(MediaHeartbeat.Event.BufferStart)."));
        bufferStartPredicateList.add(RuleEngine.createPredicate(this._isInSeek, false, "MediaHeartbeat is already tracking seek events. We got a duplicate call to trackEvent(MediaHeartbeat.Event.SeekStart)."));
        ArrayList<ICallback> bufferStartActionList = new ArrayList<ICallback>();
        bufferStartActionList.add(this._cmdBufferStart);
        this._ruleEngine.registerRule(16, "API:trackEvent(BufferStart)", bufferStartPredicateList, bufferStartActionList);
        ArrayList<Predicate> bufferCompletePredicateList = new ArrayList<Predicate>();
        bufferCompletePredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        bufferCompletePredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        bufferCompletePredicateList.add(RuleEngine.createPredicate(this._shouldAllowPlayerStateChange, true, "MediaHeartbeat is tracking an AdBreak but not tracking any Ad and will drop any calls to track player state (Play, Pause, Buffer or Seek) in this state."));
        bufferCompletePredicateList.add(RuleEngine.createPredicate(this._isInBuffer, true, "MediaHeartbeat is currently not tracking buffer events, call trackEvent(MediaHeartbeat.Event.BufferStart) before BufferComplete."));
        ArrayList<ICallback> bufferCompleteActionList = new ArrayList<ICallback>();
        bufferCompleteActionList.add(this._cmdBufferComplete);
        this._ruleEngine.registerRule(17, "API:trackEvent(BufferComplete)", bufferCompletePredicateList, bufferCompleteActionList);
        ArrayList<Predicate> seekStartPredicateList = new ArrayList<Predicate>();
        seekStartPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        seekStartPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        seekStartPredicateList.add(RuleEngine.createPredicate(this._shouldAllowPlayerStateChange, true, "MediaHeartbeat is tracking an AdBreak but not tracking any Ad and will drop any calls to track player state (Play, Pause, Buffer or Seek) in this state."));
        seekStartPredicateList.add(RuleEngine.createPredicate(this._isInSeek, false, "MediaHeartbeat is already tracking seek events. We got a duplicate call to trackEvent(MediaHeartbeat.Event.SeekStart)."));
        seekStartPredicateList.add(RuleEngine.createPredicate(this._isInBuffer, false, "MediaHeartbeat is already tracking buffer events. We got a duplicate call to trackEvent(MediaHeartbeat.Event.BufferStart)."));
        ArrayList<ICallback> seekStartActionList = new ArrayList<ICallback>();
        seekStartActionList.add(this._cmdSeekStart);
        this._ruleEngine.registerRule(14, "API:trackEvent(SeekStart)", seekStartPredicateList, seekStartActionList);
        ArrayList<Predicate> seekCompletePredicateList = new ArrayList<Predicate>();
        seekCompletePredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        seekCompletePredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        seekCompletePredicateList.add(RuleEngine.createPredicate(this._shouldAllowPlayerStateChange, true, "MediaHeartbeat is tracking an AdBreak but not tracking any Ad and will drop any calls to track player state (Play, Pause, Buffer or Seek) in this state."));
        seekCompletePredicateList.add(RuleEngine.createPredicate(this._isInSeek, true, "MediaHeartbeat is currently not tracking seek events, call trackEvent(MediaHeartbeat.Event.SeekStart) before SeekComplete."));
        ArrayList<ICallback> seekCompleteActionList = new ArrayList<ICallback>();
        seekCompleteActionList.add(this._cmdSeekComplete);
        this._ruleEngine.registerRule(15, "API:trackEvent(SeekComplete)", seekCompletePredicateList, seekCompleteActionList);
        ArrayList<Predicate> adBreakStartPredicateList = new ArrayList<Predicate>();
        adBreakStartPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        adBreakStartPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        adBreakStartPredicateList.add(RuleEngine.createPredicate(this._isValidAdBreakObject, true, "AdBreakInfo passed into trackEvent(MediaHeartbeat.Event.AdBreakStart) is invalid."));
        adBreakStartPredicateList.add(RuleEngine.createPredicate(this._isDifferentAdBreakObject, true, "MediaHeartbeat is currently tracking the AdBreak passed into trackEvent(MediaHeartbeat.Event.AdBreakStart)."));
        ArrayList<ICallback> adBreakStartActionList = new ArrayList<ICallback>();
        adBreakStartActionList.add(this._cmdAdSkip);
        adBreakStartActionList.add(this._cmdAdBreakComplete);
        adBreakStartActionList.add(this._cmdAdBreakStart);
        this._ruleEngine.registerRule(6, "API:trackEvent(AdBreakStart)", adBreakStartPredicateList, adBreakStartActionList);
        ArrayList<Predicate> adBreakCompletePredicateList = new ArrayList<Predicate>();
        adBreakCompletePredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        adBreakCompletePredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        adBreakCompletePredicateList.add(RuleEngine.createPredicate(this._isInAdBreak, true, "MediaHeartbeat is currently not tracking any AdBreak, call trackEvent(MediaHeartbeat.Event.AdBreakStart) to begin tracking AdBreak"));
        ArrayList<ICallback> adBreakCompleteActionList = new ArrayList<ICallback>();
        adBreakCompleteActionList.add(this._cmdAdSkip);
        adBreakCompleteActionList.add(this._cmdAdBreakComplete);
        this._ruleEngine.registerRule(7, "API:trackEvent(AdBreakComplete)", adBreakCompletePredicateList, adBreakCompleteActionList);
        ArrayList<Predicate> adStartPredicateList = new ArrayList<Predicate>();
        adStartPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        adStartPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        adStartPredicateList.add(RuleEngine.createPredicate(this._isInAdBreak, true, "MediaHeartbeat is currently not tracking any AdBreak, call trackEvent(MediaHeartbeat.Event.AdBreakStart) to begin tracking AdBreak"));
        adStartPredicateList.add(RuleEngine.createPredicate(this._isValidAdObject, true, "AdInfo passed into trackEvent(MediaHeartbeat.Event.AdStart) is invalid."));
        adStartPredicateList.add(RuleEngine.createPredicate(this._isDifferentAdObject, true, "MediaHeartbeat is currently tracking the AdBreak passed into trackEvent(MediaHeartbeat.Event.AdStart)."));
        ArrayList<ICallback> adStartActionList = new ArrayList<ICallback>();
        adStartActionList.add(this._cmdAdSkip);
        adStartActionList.add(this._cleanContextData);
        adStartActionList.add(this._cmdAdStart);
        this._ruleEngine.registerRule(8, "API:trackEvent(AdStart)", adStartPredicateList, adStartActionList);
        ArrayList<Predicate> adCompletePredicateList = new ArrayList<Predicate>();
        adCompletePredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        adCompletePredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        adCompletePredicateList.add(RuleEngine.createPredicate(this._isInAdBreak, true, "MediaHeartbeat is currently not tracking any AdBreak, call trackEvent(MediaHeartbeat.Event.AdBreakStart) to begin tracking AdBreak"));
        adCompletePredicateList.add(RuleEngine.createPredicate(this._isInAd, true, "MediaHeartbeat is currently not tracking any Ad, call trackEvent(MediaHeartbeat.Event.AdStart) to begin tracking Ad"));
        ArrayList<ICallback> adCompleteActionList = new ArrayList<ICallback>();
        adCompleteActionList.add(this._cmdAdComplete);
        this._ruleEngine.registerRule(9, "API:trackEvent(AdComplete)", adCompletePredicateList, adCompleteActionList);
        ArrayList<Predicate> adSkipPredicateList = new ArrayList<Predicate>();
        adSkipPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        adSkipPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        adSkipPredicateList.add(RuleEngine.createPredicate(this._isInAdBreak, true, "MediaHeartbeat is currently not tracking any AdBreak, call trackEvent(MediaHeartbeat.Event.AdBreakStart) to begin tracking AdBreak"));
        adSkipPredicateList.add(RuleEngine.createPredicate(this._isInAd, true, "MediaHeartbeat is currently not tracking any Ad, call trackEvent(MediaHeartbeat.Event.AdStart) to begin tracking Ad"));
        ArrayList<ICallback> adSkipActionList = new ArrayList<ICallback>();
        adSkipActionList.add(this._cmdAdSkip);
        this._ruleEngine.registerRule(10, "API:trackEvent(AdSkip)", adSkipPredicateList, adSkipActionList);
        ArrayList<Predicate> ChapterStartPredicateList = new ArrayList<Predicate>();
        ChapterStartPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        ChapterStartPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        ChapterStartPredicateList.add(RuleEngine.createPredicate(this._isValidChapterObject, true, "ChapterInfo passed into trackEvent(MediaHeartbeat.Event.ChapterStart) is invalid."));
        ChapterStartPredicateList.add(RuleEngine.createPredicate(this._isDifferentChapterObject, true, "MediaHeartbeat is currently tracking the Chapter passed into trackEvent(MediaHeartbeat.Event.ChapterStart)."));
        ArrayList<ICallback> chapterStartActionList = new ArrayList<ICallback>();
        chapterStartActionList.add(this._cmdChapterSkip);
        chapterStartActionList.add(this._cleanContextData);
        chapterStartActionList.add(this._cmdChapterStart);
        this._ruleEngine.registerRule(11, "API:trackEvent(ChapterStart)", ChapterStartPredicateList, chapterStartActionList);
        ArrayList<Predicate> ChapterCompletePredicateList = new ArrayList<Predicate>();
        ChapterCompletePredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        ChapterCompletePredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        ChapterCompletePredicateList.add(RuleEngine.createPredicate(this._isInChapter, true, "MediaHeartbeat is currently not tracking any Chapter, call trackEvent(MediaHeartbeat.Event.ChapterStart) to begin tracking Chapter"));
        ArrayList<ICallback> ChapterCompleteActionList = new ArrayList<ICallback>();
        ChapterCompleteActionList.add(this._cmdChapterComplete);
        this._ruleEngine.registerRule(12, "API:trackEvent(ChapterComplete)", ChapterCompletePredicateList, ChapterCompleteActionList);
        ArrayList<Predicate> chapterSkipPredicateList = new ArrayList<Predicate>();
        chapterSkipPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        chapterSkipPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        chapterSkipPredicateList.add(RuleEngine.createPredicate(this._isInChapter, true, "MediaHeartbeat is currently not tracking any Chapter, call trackEvent(MediaHeartbeat.Event.ChapterStart) to begin tracking Chapter"));
        ArrayList<ICallback> chapterSkipActionList = new ArrayList<ICallback>();
        chapterSkipActionList.add(this._cmdChapterSkip);
        this._ruleEngine.registerRule(13, "API:trackEvent(ChapterSkip)", chapterSkipPredicateList, chapterSkipActionList);
        ArrayList<Predicate> bitratePredicateList = new ArrayList<Predicate>();
        bitratePredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        bitratePredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        ArrayList<ICallback> bitrateActionList = new ArrayList<ICallback>();
        bitrateActionList.add(this._cmdBitrate);
        this._ruleEngine.registerRule(18, "API:trackEvent(BitrateChange)", bitratePredicateList, bitrateActionList);
        ArrayList<Predicate> timedMetadataPredicateList = new ArrayList<Predicate>();
        timedMetadataPredicateList.add(RuleEngine.createPredicate(this._isInSession, true, "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session."));
        timedMetadataPredicateList.add(RuleEngine.createPredicate(this._isInMedia, true, "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session."));
        timedMetadataPredicateList.add(RuleEngine.createPredicate(this._isValidTimedMetadataObject, true, "TimedMetadata passed into trackEvent(MediaHeartbeat.Event.TimedMetadataUpdate) is invalid."));
        ArrayList<ICallback> timedMetadataActionList = new ArrayList<ICallback>();
        timedMetadataActionList.add(this._cmdTimedMetadataUpdate);
        this._ruleEngine.registerRule(19, "API:trackEvent(TimedMetadataUpdate)", timedMetadataPredicateList, timedMetadataActionList);
    }

    private void configureAdobeAnalyticsPlugin(ArrayList<IPlugin> plugins) {
        AdobeMediaAnalyticsPluginDelegate aaPluginDelegate = new AdobeMediaAnalyticsPluginDelegate();
        aaPluginDelegate.setHeartbeat(this);
        AdobeAnalyticsPluginConfig aaPluginConfig = new AdobeAnalyticsPluginConfig();
        aaPluginConfig.channel = this._config.channel;
        aaPluginConfig.debugLogging = this._config.debugLogging;
        this._aaPlugin = new AdobeAnalyticsPlugin(aaPluginDelegate);
        this._aaPlugin.configure(aaPluginConfig);
        plugins.add(this._aaPlugin);
    }

    private void configureAdobeHeartbeatPlugin(ArrayList<IPlugin> plugins, String publisher) {
        AdobeMediaHeartbeatPluginDelegate hbPluginDelegate = new AdobeMediaHeartbeatPluginDelegate();
        hbPluginDelegate.setHeartbeat(this);
        AdobeHeartbeatPluginConfig ahPluginConfig = new AdobeHeartbeatPluginConfig(this._config.trackingServer, publisher);
        ahPluginConfig.debugLogging = this._config.debugLogging;
        ahPluginConfig.ssl = this._config.ssl;
        ahPluginConfig.sdk = this._config.appVersion != null ? this._config.appVersion : "";
        ahPluginConfig.ovp = this._config.ovp != null ? this._config.ovp : "";
        String tvsdkVersion = this.primetimeTVSDKVersion();
        if (tvsdkVersion != null && tvsdkVersion.length() > 0) {
            ahPluginConfig.__isPrimetime = true;
            ahPluginConfig.__psdkVersion = tvsdkVersion;
        }
        this._ahPlugin = new AdobeHeartbeatPlugin(hbPluginDelegate);
        this._ahPlugin.configure(ahPluginConfig);
        plugins.add(this._ahPlugin);
    }

    private void configureVideoPlayerPlugin(ArrayList<IPlugin> plugins) {
        AdobeMediaHeartbeatVideoPluginDelegate vpPluginDelegate = new AdobeMediaHeartbeatVideoPluginDelegate();
        vpPluginDelegate.setHeartbeat(this);
        VideoPlayerPluginConfig playerPluginConfig = new VideoPlayerPluginConfig();
        playerPluginConfig.debugLogging = this._config.debugLogging;
        this._playerPlugin = new VideoPlayerPlugin(vpPluginDelegate);
        this._playerPlugin.configure(playerPluginConfig);
        plugins.add(this._playerPlugin);
    }

    private void configureOtherPlugins(ArrayList<IPlugin> plugins) {
    }

    private void configureHeartbeat(ArrayList<IPlugin> plugins) {
        AdobeMediaHeartbeatDelegate hbDelegate = new AdobeMediaHeartbeatDelegate();
        hbDelegate.setHeartbeat(this);
        HeartbeatConfig hbConfig = new HeartbeatConfig();
        hbConfig.debugLogging = this._config.debugLogging;
        this._heartbeat = new Heartbeat(hbDelegate, plugins);
        this._heartbeat.configure(hbConfig);
    }

    private String primetimeTVSDKVersion() {
        if (this._currentMediaObject != null) {
            return this._currentMediaObject.getValue(AdobeMediaHeartbeatPrimetimeTVSDKVersionKey) != null ? this._currentMediaObject.getValue(AdobeMediaHeartbeatPrimetimeTVSDKVersionKey).toString() : null;
        }
        return null;
    }

    private void onDelegateError(ErrorInfo errorInfo) {
        if (this._debugLogging.booleanValue()) {
            this._logger.error(errorInfo.getMessage(), "ADBMediaHeartbeat Delegate Error: " + errorInfo.getDetails());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableHBTracking() {
        Object object = this._lock;
        synchronized (object) {
            RuleEngineContext reContext = RuleEngine.createContext();
            this._processRule(20, reContext);
            this._processRule(1, reContext);
        }
    }

    class ErrorMessage {
        static final String ErrNotInSession = "MediaHeartbeat is not in tracking session, call trackSessionStart to begin tracking session.";
        static final String ErrInSession = "MediaHeartbeat is already in tracking session, call trackSessionEnd to end current tracking session.";
        static final String ErrTrackingDisabled = "MediaHeartbeat tracking is disabled for this publisher. Please contact Adobe Representative to enable tracking.";
        static final String ErrNotInMedia = "MediaHeartbeat has completed tracking session, call trackSessionStart to begin a new tracking session.";
        static final String ErrInBuffer = "MediaHeartbeat is already tracking buffer events. We got a duplicate call to trackEvent(MediaHeartbeat.Event.BufferStart).";
        static final String ErrNotInBuffer = "MediaHeartbeat is currently not tracking buffer events, call trackEvent(MediaHeartbeat.Event.BufferStart) before BufferComplete.";
        static final String ErrInSeek = "MediaHeartbeat is already tracking seek events. We got a duplicate call to trackEvent(MediaHeartbeat.Event.SeekStart).";
        static final String ErrNotInSeek = "MediaHeartbeat is currently not tracking seek events, call trackEvent(MediaHeartbeat.Event.SeekStart) before SeekComplete.";
        static final String ErrNotInAdBreak = "MediaHeartbeat is currently not tracking any AdBreak, call trackEvent(MediaHeartbeat.Event.AdBreakStart) to begin tracking AdBreak";
        static final String ErrNotInAd = "MediaHeartbeat is currently not tracking any Ad, call trackEvent(MediaHeartbeat.Event.AdStart) to begin tracking Ad";
        static final String ErrNotInChapter = "MediaHeartbeat is currently not tracking any Chapter, call trackEvent(MediaHeartbeat.Event.ChapterStart) to begin tracking Chapter";
        static final String ErrInvalidMediaObject = "VideoInfo passed into trackSessionStart is invalid.";
        static final String ErrInvalidAdBreakObject = "AdBreakInfo passed into trackEvent(MediaHeartbeat.Event.AdBreakStart) is invalid.";
        static final String ErrDuplicateAdBreakObject = "MediaHeartbeat is currently tracking the AdBreak passed into trackEvent(MediaHeartbeat.Event.AdBreakStart).";
        static final String ErrInvalidAdObject = "AdInfo passed into trackEvent(MediaHeartbeat.Event.AdStart) is invalid.";
        static final String ErrDuplicateAdObject = "MediaHeartbeat is currently tracking the AdBreak passed into trackEvent(MediaHeartbeat.Event.AdStart).";
        static final String ErrInvalidChapterObject = "ChapterInfo passed into trackEvent(MediaHeartbeat.Event.ChapterStart) is invalid.";
        static final String ErrDuplicateChapterObject = "MediaHeartbeat is currently tracking the Chapter passed into trackEvent(MediaHeartbeat.Event.ChapterStart).";
        static final String ErrInvalidTimedMetadataObject = "TimedMetadata passed into trackEvent(MediaHeartbeat.Event.TimedMetadataUpdate) is invalid.";
        static final String ErrInvalidPlayerState = "MediaHeartbeat is tracking an AdBreak but not tracking any Ad and will drop any calls to track player state (Play, Pause, Buffer or Seek) in this state.";

        ErrorMessage() {
        }
    }

    private class Rule {
        static final int SessionStart = 0;
        static final int SessionEnd = 1;
        static final int VideoComplete = 2;
        static final int Play = 3;
        static final int Pause = 4;
        static final int Error = 5;
        static final int AdBreakStart = 6;
        static final int AdBreakComplete = 7;
        static final int AdStart = 8;
        static final int AdComplete = 9;
        static final int AdSkip = 10;
        static final int ChapterStart = 11;
        static final int ChapterComplete = 12;
        static final int ChapterSkip = 13;
        static final int SeekStart = 14;
        static final int SeekComplete = 15;
        static final int BufferStart = 16;
        static final int BufferComplete = 17;
        static final int BitrateChange = 18;
        static final int TimedMetadataUpdate = 19;
        static final int DisableTracking = 20;

        private Rule() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Session,
        Media,
        AdBreak,
        Ad,
        Chapter,
        PlayPause,
        Buffer,
        Seek,
        FPlayPause;

    }

    private class CompleteCallback
    implements ICallback {
        Heartbeat heartbeat;
        VideoPlayerPlugin playerPlugin;

        CompleteCallback(Heartbeat heartbeat, VideoPlayerPlugin playerPlugin) {
            this.heartbeat = heartbeat;
            this.playerPlugin = playerPlugin;
        }

        public Object call(Object param) {
            this.playerPlugin.trackVideoUnload();
            this.playerPlugin = null;
            this.heartbeat.destroy();
            this.heartbeat = null;
            return null;
        }
    }

    private class AdobeMediaHeartbeatVideoPluginDelegate
    extends VideoPlayerPluginDelegate {
        MediaHeartbeat _heartbeat;

        private AdobeMediaHeartbeatVideoPluginDelegate() {
        }

        public void setHeartbeat(MediaHeartbeat heartbeat) {
            this._heartbeat = heartbeat;
        }

        public VideoInfo getVideoInfo() {
            if (MediaHeartbeat.this._videoInfo != null && MediaHeartbeat.this._delegate != null) {
                ((MediaHeartbeat)MediaHeartbeat.this)._videoInfo.playhead = MediaHeartbeat.this._delegate.getCurrentPlaybackTime();
            }
            return MediaHeartbeat.this._videoInfo;
        }

        public AdBreakInfo getAdBreakInfo() {
            return MediaHeartbeat.this._adBreakInfo;
        }

        public AdInfo getAdInfo() {
            return MediaHeartbeat.this._adInfo;
        }

        public ChapterInfo getChapterInfo() {
            return MediaHeartbeat.this._chapterInfo;
        }

        public QoSInfo getQoSInfo() {
            if (MediaHeartbeat.this._delegate != null && MediaHeartbeat.this._delegate.getQoSObject() != null) {
                return MediaHeartbeat.this._delegate.getQoSObject().createQoSInfo();
            }
            return null;
        }
    }

    private class AdobeMediaHeartbeatDelegate
    extends HeartbeatDelegate {
        MediaHeartbeat _heartbeat;

        private AdobeMediaHeartbeatDelegate() {
        }

        public void setHeartbeat(MediaHeartbeat heartbeat) {
            this._heartbeat = heartbeat;
        }

        public void onError(ErrorInfo errorInfo) {
            this._heartbeat.onDelegateError(errorInfo);
        }
    }

    private class AdobeMediaHeartbeatPluginDelegate
    extends AdobeHeartbeatPluginDelegate {
        MediaHeartbeat _heartbeat;

        private AdobeMediaHeartbeatPluginDelegate() {
        }

        public void setHeartbeat(MediaHeartbeat heartbeat) {
            this._heartbeat = heartbeat;
        }

        public void onError(ErrorInfo errorInfo) {
            this._heartbeat.onDelegateError(errorInfo);
        }

        public void onTrackingDisabled() {
            this._heartbeat.disableHBTracking();
        }
    }

    private class AdobeMediaAnalyticsPluginDelegate
    extends AdobeAnalyticsPluginDelegate {
        MediaHeartbeat _heartbeat;

        private AdobeMediaAnalyticsPluginDelegate() {
        }

        public void setHeartbeat(MediaHeartbeat heartbeat) {
            this._heartbeat = heartbeat;
        }

        public void onError(ErrorInfo errorInfo) {
            this._heartbeat.onDelegateError(errorInfo);
        }
    }

    public static final class AdMetadataKeys {
        public static final String ADVERTISER = "a.media.ad.advertiser";
        public static final String CAMPAIGN_ID = "a.media.ad.campaign";
        public static final String CREATIVE_ID = "a.media.ad.creative";
        public static final String PLACEMENT_ID = "a.media.ad.placement";
        public static final String SITE_ID = "a.media.ad.site";
        public static final String CREATIVE_URL = "a.media.ad.creativeURL";
    }

    public static final class AudioMetadataKeys {
        public static final String ARTIST = "a.media.artist";
        public static final String ALBUM = "a.media.album";
        public static final String LABEL = "a.media.label";
        public static final String AUTHOR = "a.media.author";
        public static final String STATION = "a.media.station";
        public static final String PUBLISHER = "a.media.publisher";
    }

    public static final class VideoMetadataKeys {
        public static final String SHOW = "a.media.show";
        public static final String SEASON = "a.media.season";
        public static final String EPISODE = "a.media.episode";
        public static final String ASSET_ID = "a.media.asset";
        public static final String GENRE = "a.media.genre";
        public static final String FIRST_AIR_DATE = "a.media.airDate";
        public static final String FIRST_DIGITAL_DATE = "a.media.digitalDate";
        public static final String RATING = "a.media.rating";
        public static final String ORIGINATOR = "a.media.originator";
        public static final String NETWORK = "a.media.network";
        public static final String SHOW_TYPE = "a.media.type";
        public static final String AD_LOAD = "a.media.adLoad";
        public static final String MVPD = "a.media.pass.mvpd";
        public static final String AUTHORIZED = "a.media.pass.auth";
        public static final String DAY_PART = "a.media.dayPart";
        public static final String FEED = "a.media.feed";
        public static final String STREAM_FORMAT = "a.media.format";
    }

    public static final class MediaObjectKey {
        public static final String StandardVideoMetadata = "media_standard_content_metadata";
        public static final String StandardMediaMetadata = "media_standard_content_metadata";
        public static final String StandardAdMetadata = "media_standard_ad_metadata";
        public static final String VideoResumed = "resumed";
        public static final String MediaResumed = "resumed";
        private static final String GranularAdTracking = "granular_ad_tracking";
        public static final String PrerollTrackingWaitingTime = "preroll_tracking_waiting_time";
    }

    public static final class StreamType {
        public static final String VOD = "vod";
        public static final String LIVE = "live";
        public static final String LINEAR = "linear";
        public static final String PODCAST = "podcast";
        public static final String AUDIOBOOK = "audiobook";
        public static final String AOD = "aod";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MediaType {
        Video,
        Audio;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        AdBreakStart,
        AdBreakComplete,
        AdStart,
        AdComplete,
        AdSkip,
        ChapterStart,
        ChapterComplete,
        ChapterSkip,
        SeekStart,
        SeekComplete,
        BufferStart,
        BufferComplete,
        BitrateChange,
        TimedMetadataUpdate;

    }

    public static interface MediaHeartbeatDelegate {
        public MediaObject getQoSObject();

        public Double getCurrentPlaybackTime();
    }
}

