/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.ah.engine.model.serialization;

import com.adobe.primetime.core.ILogger;
import com.adobe.primetime.va.plugins.ah.engine.model.dao.Dao;
import com.adobe.primetime.va.plugins.ah.engine.model.report.Report;
import com.adobe.primetime.va.plugins.ah.engine.model.serialization.BaseSerializer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStringSerializer
extends BaseSerializer {
    private static final String DATA_TYPE_LONG = "l";
    private static final String DATA_TYPE_SHORT = "h";
    private static final String DATA_TYPE_STRING = "s";

    public QueryStringSerializer(ILogger logger) {
        super(logger);
    }

    public HashMap<String, Object> serializeReport(Report report) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (report.getAdobeAnalyticsData() != null) {
            result.add(this.serializeDao(report.getAdobeAnalyticsData()));
        }
        if (report.getUserData() != null) {
            result.add(this.serializeDao(report.getUserData()));
        }
        if (report.getAAMData() != null) {
            result.add(this.serializeDao(report.getAAMData()));
        }
        if (report.getCUserData() != null) {
            result.add(this.serializeDao(report.getCUserData()));
        }
        if (report.getServiceProviderData() != null) {
            result.add(this.serializeDao(report.getServiceProviderData()));
        }
        if (report.getSessionData() != null) {
            result.add(this.serializeDao(report.getSessionData()));
        }
        if (report.getEventData() != null) {
            result.add(this.serializeDao(report.getEventData()));
        }
        if (report.getAssetData() != null) {
            result.add(this.serializeDao(report.getAssetData()));
        }
        if (report.getStreamData() != null) {
            result.add(this.serializeDao(report.getStreamData()));
        }
        if (report.getQosData() != null) {
            result.add(this.serializeDao(report.getQosData()));
        }
        if (report.getMeta() != null) {
            HashMap map = (HashMap)report.getMeta();
            result.add(this.serializeMap((Map)map));
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < result.size(); ++i) {
            if (i == result.size() - 1) {
                out.append((String)result.get(i));
                continue;
            }
            out.append((String)result.get(i)).append("&");
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("serializedOutput", out);
        retVal.put("callback", report.getCallback());
        return retVal;
    }

    @Override
    String serializeDao(Dao dao) {
        StringBuilder out = new StringBuilder();
        ArrayList<String> result = this._processDao(dao);
        for (int i = 0; i < result.size(); ++i) {
            if (i == result.size() - 1) {
                out.append(result.get(i));
                continue;
            }
            out.append(result.get(i)).append("&");
        }
        return out.toString();
    }

    @Override
    String serializeMap(Map<String, Object> mapObject) {
        StringBuilder out = new StringBuilder();
        for (String key : mapObject.keySet()) {
            try {
                out.append("s:meta:" + URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode((String)mapObject.get(key), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                this._logger.warn(this._logTag, "#serializeMap() - Unable to serialize string: " + e.getMessage());
            }
            out.append("&");
        }
        return this._removeLastCharacter(out.toString());
    }

    @Override
    protected Object serializeDouble(String key, Double number, String realm, Object hint) {
        if (number != null) {
            return "l:" + realm + ":" + key + "=" + number.longValue();
        }
        return null;
    }

    @Override
    protected Object serializeLong(String key, Long number, String realm, Object hint) {
        String type = DATA_TYPE_LONG;
        if (number != null) {
            if (hint != null && hint instanceof Dao.Hint && hint == Dao.Hint.SHORT) {
                type = DATA_TYPE_SHORT;
            }
            return type + ":" + realm + ":" + key + "=" + number;
        }
        return null;
    }

    @Override
    protected Object serializeInteger(String key, Integer number, String realm, Object hint) {
        if (number != null) {
            return "l:" + realm + ":" + key + "=" + number;
        }
        return null;
    }

    @Override
    protected Object serializeBooleanToLong(String key, Boolean value, String realm, Object hint) {
        if (value != null) {
            String type = DATA_TYPE_LONG;
            long number = 0L;
            if (value.booleanValue()) {
                number = 1L;
            }
            if (hint != null && hint instanceof Dao.Hint && hint == Dao.Hint.SHORT) {
                type = DATA_TYPE_SHORT;
            }
            return type + ":" + realm + ":" + key + "=" + number;
        }
        return null;
    }

    @Override
    protected Object serializeString(String key, String string, String realm, Object hint) {
        if (string != null && !string.equals("")) {
            try {
                return "s:" + realm + ":" + key + "=" + URLEncoder.encode(string, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                this._logger.warn(this._logTag, "serializeString() - Unable to serialize string: " + e.getMessage());
            }
        }
        return null;
    }

    private String _removeLastCharacter(String string) {
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

