/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.primetime.va.plugins.aa;

import com.adobe.mobile.MobileServicesFactory;
import com.adobe.primetime.core.ICallback;
import com.adobe.primetime.core.Trigger;
import com.adobe.primetime.core.plugin.BasePlugin;
import com.adobe.primetime.core.plugin.IPluginConfig;
import com.adobe.primetime.core.plugin.ParamMapping;
import com.adobe.primetime.core.plugin.PluginManager;
import com.adobe.primetime.core.radio.Command;
import com.adobe.primetime.core.radio.CommandQueue;
import com.adobe.primetime.utils.MD5;
import com.adobe.primetime.va.ErrorInfo;
import com.adobe.primetime.va.plugins.aa.AdobeAnalyticsPluginConfig;
import com.adobe.primetime.va.plugins.aa.AdobeAnalyticsPluginDelegate;
import com.adobe.primetime.va.plugins.aa.IAdobeMobileServices;
import com.adobe.primetime.va.plugins.aa.InputDataValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdobeAnalyticsPlugin
extends BasePlugin {
    private static final String ADOBE_ANALYTICS_PLUGIN = "adobe-analytics";
    private static final String PLAYER_PLUGIN = "player";
    private static final String ADOBE_HEARTBEAT_PLUGIN = "adobe-heartbeat";
    private static final String ADOBE_NIELSEN_PLUGIN = "adobe-nielsen";
    private static final String VIDEO_INFO = "video_info";
    private static final String AD_BREAK_INFO = "ad_break_info";
    private static final String AD_INFO = "ad_info";
    private static final String CHANNEL = "channel";
    private static final String IS_PRIMETIME = "is_primetime";
    private static final String DPID = "userId.id";
    private static final String DPUUID = "puuid.id";
    private static final String AUDIENCEMANAGER_BLOB = "blob";
    private static final String AUDIENCEMANAGER_LOCATION_HINT = "loc_hint";
    private static final String RSID = "rsid";
    private static final String TRACKING_SERVER = "tracking_server";
    private static final String OPT_OUT = "opt_out";
    private static final String USE_SSL = "ssl";
    private static final String VISITOR_ID = "vid";
    private static final String ANALYTICS_VISITOR_ID = "aid";
    private static final String MARKETING_CLOUD_VISITOR_ID = "mid";
    private static final String MARKETING_CLOUD_ORG_ID = "mcorgid";
    private static final String META = "meta";
    private static final String SC_CONTENT_TYPE_VIDEO = "video";
    private static final String SC_CONTENT_TYPE_VIDEOAD = "videoAd";
    private static final String SC_CONTENT_TYPE_AUDIO = "audio";
    private static final String SC_CONTENT_TYPE_AUDIOAD = "audioAd";
    private static final String SC_START = "ms_s";
    private static final String SC_START_PRIMETIME = "msp_s";
    private static final String SC_START_AD = "msa_s";
    private static final String SC_START_AD_PRIMETIME = "mspa_s";
    private static final String AA_START = "aa_start";
    private static final String AA_AD_START = "sc_ad_start";
    private static final String VIDEO_LOAD = "video_load";
    private static final String VIDEO_START = "video_start";
    private static final String AD_START = "ad_start";
    private Map<String, String> _videoMetadata;
    private Map<String, String> _adMetadata;
    private Map<String, String> _chapterMetadata;
    private InputDataValidator _inputDataValidator;
    private CommandQueue _workQueue;
    private AdobeAnalyticsPluginDelegate _delegate;
    private ErrorInfo _errorInfo;
    private AdobeAnalyticsPluginConfig _config;
    private IAdobeMobileServices _mobileServices;
    private ArrayList<String> _customMetadataKeys;
    private final ICallback _cmdVideoLoad = new ICallback(){

        public Object call(Object data) {
            AdobeAnalyticsPlugin.this._errorInfo = null;
            return null;
        }
    };
    private final ICallback _cmdVideoStart = new ICallback(){

        public Object call(Object data) {
            AdobeAnalyticsPlugin.this._logger.debug(AdobeAnalyticsPlugin.this._logTag, "#_cmdVideoStart()");
            if (!AdobeAnalyticsPlugin.this._canProcess()) {
                return null;
            }
            AdobeAnalyticsPlugin.this._workQueue.addCommand(new Command(AdobeAnalyticsPlugin.this._executeOpen, data));
            return null;
        }
    };
    private final ICallback _cmdAdStart = new ICallback(){

        public Object call(Object data) {
            AdobeAnalyticsPlugin.this._logger.debug(AdobeAnalyticsPlugin.this._logTag, "#_cmdAdStart()");
            if (!AdobeAnalyticsPlugin.this._canProcess()) {
                return null;
            }
            AdobeAnalyticsPlugin.this._workQueue.addCommand(new Command(AdobeAnalyticsPlugin.this._executeOpenAd, data));
            return null;
        }
    };
    private final ICallback _cmdHeartbeatPluginError = new ICallback(){

        public Object call(Object data) {
            if (AdobeAnalyticsPlugin.this._errorInfo != null) {
                return null;
            }
            AdobeAnalyticsPlugin.this._errorInfo = new ErrorInfo("Internal error", "HeartbeatPlugin is in ERROR state.");
            AdobeAnalyticsPlugin.this._trigger("error", AdobeAnalyticsPlugin.this._errorInfo);
            if (AdobeAnalyticsPlugin.this._delegate != null) {
                AdobeAnalyticsPlugin.this._delegate.onError(AdobeAnalyticsPlugin.this._errorInfo);
            }
            return null;
        }
    };
    private final ICallback _executeOpen = new ICallback(){

        public Object call(Object param) {
            HashMap metaNielsenObject;
            HashMap data = (HashMap)param;
            AdobeAnalyticsPlugin.this._logger.debug(AdobeAnalyticsPlugin.this._logTag, "#_executeOpen(id=" + data.get("videoId") + ", videoName=" + data.get("videoName") + ", streamType=" + data.get("streamType") + ", mediaType=" + data.get("mediaType") + ", length=" + data.get("videoLength") + ", playerName=" + data.get("playerName") + ", channel=" + data.get(AdobeAnalyticsPlugin.CHANNEL) + ", isPrimetime=" + data.get("isPrimetime") + ", sessionId=" + data.get("sessionId") + ")");
            if (!AdobeAnalyticsPlugin.this._canProcess()) {
                return null;
            }
            if (!AdobeAnalyticsPlugin.this._inputDataValidator.validateFields(data, new String[]{"videoId", "mediaType", "streamType", "videoLength", "playerName"})) {
                return null;
            }
            HashMap metaVideo = (HashMap)data.get("metaVideo");
            HashMap<String, Object> contextData = new HashMap<String, Object>();
            if (metaVideo != null) {
                for (Object key : metaVideo.keySet()) {
                    contextData.put((String)key, metaVideo.get(key));
                    AdobeAnalyticsPlugin.this._customMetadataKeys.add(key);
                }
            }
            if ((metaNielsenObject = (HashMap)data.get("metaNielsen")) != null) {
                for (String key : metaNielsenObject.keySet()) {
                    contextData.put(key, metaNielsenObject.get(key));
                    AdobeAnalyticsPlugin.this._customMetadataKeys.add(key);
                }
            }
            contextData.put("a.contentType", data.get("streamType"));
            contextData.put("a.media.name", data.get("videoId"));
            contextData.put("a.media.friendlyName", data.get("videoName") != null ? data.get("videoName") : "");
            contextData.put("a.media.length", data.get("videoLength") == null ? "0.0" : Long.valueOf(((Double)data.get("videoLength")).longValue()));
            contextData.put("a.media.playerName", data.get("playerName"));
            contextData.put("a.media.channel", data.get(AdobeAnalyticsPlugin.CHANNEL) != null ? data.get(AdobeAnalyticsPlugin.CHANNEL) : "");
            contextData.put("a.media.view", String.valueOf(true));
            contextData.put("a.media.vsid", data.get("sessionId") != null ? data.get("sessionId") : "");
            String mediaType = (String)data.get("mediaType");
            if (mediaType.equals(AdobeAnalyticsPlugin.SC_CONTENT_TYPE_AUDIO)) {
                contextData.put("&&pev3", AdobeAnalyticsPlugin.SC_CONTENT_TYPE_AUDIO);
                contextData.put("&&ms_a", "1");
            } else {
                contextData.put("&&pev3", AdobeAnalyticsPlugin.SC_CONTENT_TYPE_VIDEO);
            }
            contextData.put("&&pe", (Boolean)data.get("isPrimetime") != false ? AdobeAnalyticsPlugin.SC_START_PRIMETIME : AdobeAnalyticsPlugin.SC_START);
            contextData.put("&&cid.userId.id", data.get("dpid"));
            contextData.put("&&cid.puuid.id", data.get("dpuuid"));
            if (!AdobeAnalyticsPlugin.this._mobileServices.isOptedOut()) {
                AdobeAnalyticsPlugin.this._mobileServices.trackAction(null, contextData);
            }
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            AdobeAnalyticsPlugin.this._trigger(AdobeAnalyticsPlugin.AA_START, data);
            return null;
        }
    };
    private final ICallback _executeOpenAd = new ICallback(){

        public Object call(Object param) {
            HashMap metaNielsenObject;
            HashMap data = (HashMap)param;
            String podId = MD5.hash((String)data.get("videoId")) + "_" + data.get("podPosition");
            AdobeAnalyticsPlugin.this._logger.debug(AdobeAnalyticsPlugin.this._logTag, "#_executeOpenAd(id=" + data.get("adId") + ", length=" + data.get("adLength") + ", streamType=" + data.get("streamType") + ", mediaType=" + data.get("mediaType") + ", podPlayerName=" + data.get("podPlayerName") + ", parentId=" + data.get("videoId") + ", podId=" + podId + ", parentPodPosition=" + data.get("adPosition") + ", podSecond=" + data.get("podSecond") + ")");
            if (!AdobeAnalyticsPlugin.this._canProcess()) {
                return null;
            }
            if (!AdobeAnalyticsPlugin.this._inputDataValidator.validateFields(data, new String[]{"videoId", "mediaType", "streamType", "playerName", "adId", "adLength", "podPlayerName", "adPosition"})) {
                return null;
            }
            data.put("podSecond", !(data.get("podSecond") instanceof Double) ? data.get("playhead") : data.get("podSecond"));
            HashMap metaVideo = (HashMap)data.get("metaVideo");
            HashMap metaAd = (HashMap)data.get("metaAd");
            HashMap<String, Object> contextData = new HashMap<String, Object>();
            if (metaVideo != null) {
                for (Object key : metaVideo.keySet()) {
                    contextData.put((String)key, metaVideo.get(key));
                    AdobeAnalyticsPlugin.this._customMetadataKeys.add(key);
                }
            }
            if (metaAd != null) {
                for (Object key : metaAd.keySet()) {
                    contextData.put((String)key, metaAd.get(key));
                    AdobeAnalyticsPlugin.this._customMetadataKeys.add(key);
                }
            }
            if ((metaNielsenObject = (HashMap)data.get("metaNielsen")) != null) {
                for (String key : metaNielsenObject.keySet()) {
                    contextData.put(key, metaNielsenObject.get(key));
                    AdobeAnalyticsPlugin.this._customMetadataKeys.add(key);
                }
            }
            contextData.put("a.contentType", data.get("streamType"));
            contextData.put("a.media.name", data.get("videoId"));
            contextData.put("a.media.playerName", data.get("playerName"));
            contextData.put("a.media.channel", data.get(AdobeAnalyticsPlugin.CHANNEL) != null ? data.get(AdobeAnalyticsPlugin.CHANNEL) : "");
            contextData.put("a.media.friendlyName", data.get("videoName") != null ? data.get("videoName") : "");
            contextData.put("a.media.length", data.get("videoLength") == null ? "0.0" : Long.valueOf(((Double)data.get("videoLength")).longValue()));
            contextData.put("a.media.vsid", data.get("sessionId") != null ? data.get("sessionId") : "");
            contextData.put("a.media.ad.name", data.get("adId"));
            contextData.put("a.media.ad.friendlyName", data.get("adName") != null ? data.get("adName") : "");
            contextData.put("a.media.ad.podFriendlyName", data.get("podName") != null ? data.get("podName") : "");
            contextData.put("a.media.ad.length", ((Double)data.get("adLength")).longValue() == 0L ? "0.0" : Long.valueOf(((Double)data.get("adLength")).longValue()));
            contextData.put("a.media.ad.playerName", data.get("podPlayerName"));
            contextData.put("a.media.ad.pod", podId);
            contextData.put("a.media.ad.podPosition", data.get("adPosition") == null ? "0.0" : (Long)data.get("adPosition"));
            contextData.put("a.media.ad.podSecond", ((Double)data.get("podSecond")).longValue() == 0L ? "0.0" : Long.valueOf(((Double)data.get("podSecond")).longValue()));
            contextData.put("a.media.ad.view", String.valueOf(true));
            String mediaType = (String)data.get("mediaType");
            if (mediaType.equals(AdobeAnalyticsPlugin.SC_CONTENT_TYPE_AUDIO)) {
                contextData.put("&&pev3", AdobeAnalyticsPlugin.SC_CONTENT_TYPE_AUDIOAD);
                contextData.put("&&ms_a", "1");
            } else {
                contextData.put("&&pev3", AdobeAnalyticsPlugin.SC_CONTENT_TYPE_VIDEOAD);
            }
            contextData.put("&&pe", (Boolean)data.get("isPrimetime") != false ? AdobeAnalyticsPlugin.SC_START_AD_PRIMETIME : AdobeAnalyticsPlugin.SC_START_AD);
            contextData.put("&&cid.userId.id", data.get("dpid"));
            contextData.put("&&cid.puuid.id", data.get("dpuuid"));
            if (!AdobeAnalyticsPlugin.this._mobileServices.isOptedOut()) {
                AdobeAnalyticsPlugin.this._mobileServices.trackAction(null, contextData);
            }
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            AdobeAnalyticsPlugin.this._trigger(AdobeAnalyticsPlugin.AA_AD_START, data);
            return null;
        }
    };
    private final ICallback _onInvalidInputData = new ICallback(){

        public Object call(Object param) {
            AdobeAnalyticsPlugin.this._errorInfo = (ErrorInfo)param;
            AdobeAnalyticsPlugin.this._logger.error(AdobeAnalyticsPlugin.this._logTag, AdobeAnalyticsPlugin.this._errorInfo.getMessage() + " | " + AdobeAnalyticsPlugin.this._errorInfo.getDetails());
            AdobeAnalyticsPlugin.this._trigger("error", param);
            if (AdobeAnalyticsPlugin.this._delegate != null) {
                AdobeAnalyticsPlugin.this._delegate.onError(AdobeAnalyticsPlugin.this._errorInfo);
            }
            return null;
        }
    };

    public AdobeAnalyticsPlugin(AdobeAnalyticsPluginDelegate delegate) {
        super(ADOBE_ANALYTICS_PLUGIN);
        this._delegate = delegate;
        this._customMetadataKeys = new ArrayList();
        this._videoMetadata = new HashMap<String, String>();
        this._adMetadata = new HashMap<String, String>();
        this._chapterMetadata = new HashMap<String, String>();
        this._errorInfo = null;
        this._workQueue = new CommandQueue();
        this._inputDataValidator = new InputDataValidator(this._onInvalidInputData);
        this._mobileServices = MobileServicesFactory.getMobileService();
        this._setupDataResolver();
    }

    public void setVideoMetadata(Map<String, String> videoMetadata) {
        this._videoMetadata = videoMetadata;
    }

    public void setAdMetadata(Map<String, String> adMetadata) {
        this._adMetadata = adMetadata;
    }

    public void setChapterMetadata(Map<String, String> chapterMetadata) {
        this._chapterMetadata = chapterMetadata;
    }

    @Override
    public void configure(IPluginConfig pluginConfig) {
        if (pluginConfig == null) {
            throw new Error("Reference to the configuration data cannot be NULL.");
        }
        if (!AdobeAnalyticsPluginConfig.class.isInstance(pluginConfig)) {
            throw new Error("Expected config data to be instance of AdobeAnalyticsPluginConfig");
        }
        this._config = (AdobeAnalyticsPluginConfig)pluginConfig;
        if (this._config.debugLogging) {
            this._logger.enable();
        } else {
            this._logger.disable();
        }
        this._logger.debug(this._logTag, "#configure({trackingServer=" + this._config.debugLogging + ", channel=" + this._config.channel + ", ssl=" + this._mobileServices.getUseSSL() + "})");
    }

    @Override
    public void bootstrap(PluginManager pluginManager) {
        super.bootstrap(pluginManager);
        this._registerCommands();
        this._registerBehaviours();
    }

    @Override
    public void setup() {
        super.setup();
    }

    public IAdobeMobileServices getMobileServices() {
        return this._mobileServices;
    }

    @Override
    protected void _teardown() {
        this._logger.debug(this._logTag, "#_teardown()");
        this._workQueue.destroy();
    }

    @Override
    protected boolean _canProcess() {
        if (this._errorInfo != null) {
            this._logger.error(this._logTag, "#_canProcess() > In ERROR state.");
            return false;
        }
        return super._canProcess();
    }

    private void _setupDataResolver() {
        final HashMap<String, ICallback> fnMap = new HashMap<String, ICallback>();
        fnMap.put(RSID, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getReportSuiteIDs();
            }
        });
        fnMap.put(TRACKING_SERVER, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getSCTrackingServer();
            }
        });
        fnMap.put(USE_SSL, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getUseSSL();
            }
        });
        fnMap.put(VISITOR_ID, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getVisitorID();
            }
        });
        fnMap.put(ANALYTICS_VISITOR_ID, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getAnalyticsVisitorID();
            }
        });
        fnMap.put(MARKETING_CLOUD_VISITOR_ID, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getMarketingCloudVisitorID();
            }
        });
        fnMap.put(AUDIENCEMANAGER_BLOB, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getAnalyticsParameterBlob();
            }
        });
        fnMap.put(AUDIENCEMANAGER_LOCATION_HINT, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getAnalyticsParameterLocationHint();
            }
        });
        fnMap.put(DPID, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getDpid();
            }
        });
        fnMap.put(DPUUID, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.getDpuuid();
            }
        });
        fnMap.put(OPT_OUT, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._mobileServices.isOptedOut();
            }
        });
        fnMap.put(CHANNEL, new ICallback(){

            public Object call(Object param) {
                return AdobeAnalyticsPlugin.this._config != null ? ((AdobeAnalyticsPlugin)AdobeAnalyticsPlugin.this)._config.channel : null;
            }
        });
        fnMap.put(META, new ICallback(){

            public Object call(Object param) {
                String key = (String)param;
                String[] tokens = key.split("\\.");
                if (tokens.length < 2) {
                    return null;
                }
                Domain domain = Domain.valueOf(tokens[0]);
                String keyVal = key.substring(key.indexOf(".") + 1);
                if (domain != null) {
                    switch (domain) {
                        case video: {
                            if (keyVal.equals("*")) {
                                return AdobeAnalyticsPlugin.this._videoMetadata;
                            }
                            return AdobeAnalyticsPlugin.this._videoMetadata != null && AdobeAnalyticsPlugin.this._videoMetadata.containsKey(keyVal) ? (String)AdobeAnalyticsPlugin.this._videoMetadata.get(keyVal) : null;
                        }
                        case ad: {
                            if (keyVal.equals("*")) {
                                return AdobeAnalyticsPlugin.this._adMetadata;
                            }
                            return AdobeAnalyticsPlugin.this._adMetadata.get(keyVal);
                        }
                        case chapter: {
                            if (keyVal.equals("*")) {
                                return AdobeAnalyticsPlugin.this._chapterMetadata;
                            }
                            return AdobeAnalyticsPlugin.this._chapterMetadata != null && AdobeAnalyticsPlugin.this._chapterMetadata.containsKey(keyVal) ? (String)AdobeAnalyticsPlugin.this._chapterMetadata.get(keyVal) : null;
                        }
                    }
                    return null;
                }
                return null;
            }
        });
        this._dataResolver = new ICallback(){

            public Object call(Object param) {
                ArrayList keys = (ArrayList)param;
                if (keys == null || keys.size() == 0) {
                    return null;
                }
                HashMap<String, Object> _result = new HashMap<String, Object>();
                for (String key : keys) {
                    if (key.startsWith("meta.")) {
                        String[] tokens = key.split("meta\\.");
                        _result.put(key, ((ICallback)fnMap.get(AdobeAnalyticsPlugin.META)).call(tokens[1]));
                        continue;
                    }
                    _result.put(key, fnMap.containsKey(key) ? ((ICallback)fnMap.get(key)).call(this) : null);
                }
                return _result;
            }
        };
    }

    private void _registerCommands() {
        this._pluginManager.comply(this, "handleVideoLoad", this._cmdVideoLoad);
        this._pluginManager.comply(this, "handleVideoStart", this._cmdVideoStart);
        this._pluginManager.comply(this, "handleAdStart", this._cmdAdStart);
        this._pluginManager.comply(this, "handleHeartbeatPluginError", this._cmdHeartbeatPluginError);
    }

    private void _registerBehaviours() {
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_LOAD), this, "handleVideoLoad", null);
        ArrayList<ParamMapping> videoStart = new ArrayList<ParamMapping>();
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.id", "videoId"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.name", "videoName"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.length", "videoLength"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playerName", "playerName"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.streamType", "streamType"));
        videoStart.add(new ParamMapping(PLAYER_PLUGIN, "video.mediaType", "mediaType"));
        videoStart.add(new ParamMapping(ADOBE_HEARTBEAT_PLUGIN, IS_PRIMETIME, "isPrimetime"));
        videoStart.add(new ParamMapping(ADOBE_HEARTBEAT_PLUGIN, "session_id", "sessionId"));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, CHANNEL, CHANNEL));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, DPID, "dpid"));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, DPUUID, "dpuuid"));
        videoStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "meta.video.*", "metaVideo"));
        videoStart.add(new ParamMapping(ADOBE_NIELSEN_PLUGIN, META, "metaNielsen"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, VIDEO_START), this, "handleVideoStart", videoStart);
        ArrayList<ParamMapping> adStart = new ArrayList<ParamMapping>();
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "video.id", "videoId"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "video.streamType", "streamType"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "video.mediaType", "mediaType"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playhead", "playhead"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "video.playerName", "playerName"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "video.name", "videoName"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "video.length", "videoLength"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.id", "adId"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.length", "adLength"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.position", "adPosition"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "ad.name", "adName"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "pod.name", "podName"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "pod.position", "podPosition"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "pod.startTime", "podSecond"));
        adStart.add(new ParamMapping(PLAYER_PLUGIN, "pod.playerName", "podPlayerName"));
        adStart.add(new ParamMapping(ADOBE_HEARTBEAT_PLUGIN, IS_PRIMETIME, "isPrimetime"));
        adStart.add(new ParamMapping(ADOBE_HEARTBEAT_PLUGIN, "session_id", "sessionId"));
        adStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, CHANNEL, CHANNEL));
        adStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, DPID, "dpid"));
        adStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, DPUUID, "dpuuid"));
        adStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "meta.video.*", "metaVideo"));
        adStart.add(new ParamMapping(ADOBE_ANALYTICS_PLUGIN, "meta.ad.*", "metaAd"));
        adStart.add(new ParamMapping(ADOBE_NIELSEN_PLUGIN, META, "metaNielsen"));
        this._pluginManager.registerBehaviour(new Trigger(PLAYER_PLUGIN, AD_START), this, "handleAdStart", adStart);
        this._pluginManager.registerBehaviour(new Trigger(ADOBE_HEARTBEAT_PLUGIN, "error"), this, "handleHeartbeatPluginError", null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Domain {
        video,
        ad,
        chapter;

    }
}

