/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import com.akamai.amp.ads.AdsCount;
import com.akamai.amp.ads.AdsInfo;
import com.akamai.amp.ads.AlternativeTimelineListener;
import com.akamai.amp.ads.IAdsComponentListener;
import com.akamai.amp.ads.TimelineData;
import com.akamai.amp.config.Config;
import com.akamai.amp.downloader.DownloadRequestProvider;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.ampcustom.AmpBasePlayer;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.text.Cue;
import com.akamai.amp.exoplayer2.upstream.BandwidthMeter;
import com.akamai.amp.id3.ID3TagEventListener;
import com.akamai.amp.license.manager.AES256LicenseDecryption;
import com.akamai.amp.license.manager.AMPLicenseManager;
import com.akamai.amp.license.manager.RSALicenseDecryption;
import com.akamai.amp.mae.LmsManager;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.ISegmentInfoListener;
import com.akamai.amp.media.Listeners;
import com.akamai.amp.media.audio.AudioFocusManager;
import com.akamai.amp.media.elements.MediaResource;
import com.akamai.amp.media.elements.QualityLevel;
import com.akamai.amp.media.errors.IErrorBeacon;
import com.akamai.amp.media.errors.IErrorsReporter;
import com.akamai.amp.media.exowrapper2.SideloadedCaptionsData;
import com.akamai.amp.media.mute.IMuteable;
import com.akamai.amp.media.mute.MuteHelper;
import com.akamai.amp.tracker.AMPTracker;
import com.akamai.amp.tracker.AkamaiEvent;
import com.akamai.amp.utils.AbortListener;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class VideoPlayerView
extends GLSurfaceView
implements IMuteable {
    private static final String TAG = "VideoPlayerView";
    @Deprecated
    public static final String VERSION = "9.10.7";
    public static final int FULLSCREEN_MODE_NONE = 1;
    @Deprecated
    public static final int FULLSCREEN_MODE_KEEP_ASPECT_RATIO = 2;
    public static final int FULLSCREEN_MODE_TOTAL = 3;
    public static final int FULLSCREEN_MODE_KEEP_ASPECT_RATIO_FIT_SCREEN = 2;
    public static final int FULLSCREEN_MODE_KEEP_ASPECT_RATIO_FILL_SCREEN = 5;
    public static final int NETSESSION_MODE_DISABLED = 0;
    public static final int NETSESSION_MODE_ALLOWED = 1;
    public static final int NETSESSION_MODE_REQUIRED = 2;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_NETWORK_UNAVAILABLE = 1;
    public static final int ERROR_NETWORK_RESOURCE_DONT_EXIST = 2;
    public static final int ERROR_NETWORK_SECURITY_ISSUE = 3;
    public static final int ERROR_FORMAT_UNKNOWN = 4;
    public static final int ERROR_RESOURCES_ISSUE = 5;
    public static final int ERROR_TS_SEGMENT_INVALID = 6;
    public static final int EXO2_ERROR_BASE = 7;
    public static final int QUALITY_LEVEL_ABR = -1;
    public static final String PROTOCOL_HLS = "HLS";
    public static final String PROTOCOL_SS = "Smooth";
    public static final String PROTOCOL_DASH = "MPEG-DASH";
    public static final String PROTOCOL_PMD = "PMD";
    public static final String PROTOCOL_UNKNOWN = "Unknown";
    public static final int BITRATE_NOT_REPORTED = -1;
    public static final int FPS_NOT_REPORTED = -1;
    public static final int BANDWIDTH_NOT_REPORTED = -1;
    protected MediaResource mMediaResource;
    protected Player.EventListener exoEventsListener;
    protected boolean abortPlayback;
    protected boolean shouldAutoPlay = true;
    protected int repeatMode = 0;
    protected AbortListener abortListener;
    protected int mFullscreenMode = 2;
    protected View mProgressBar = null;
    protected boolean mLoadWasInterruptedByPlugin = false;
    protected boolean mNeedToRestorePlayingVideo = false;
    protected boolean mResumingAfterActivityResume = false;
    protected boolean mAutomaticResume = false;
    protected boolean shouldUnMuteAfterDucking = true;
    protected boolean lostFullAudioFocus = false;
    protected int mLastPlayingPosition = -1;
    protected RSALicenseDecryption mRSALicenseDecryption;
    protected AES256LicenseDecryption aes256LicenseDecryption;
    protected String mLicense = "";
    protected Context bindingContextForReceivers;
    protected int mDropFramesCount = 0;
    protected int mVideoWidth = 0;
    protected int mVideoHeight = 0;
    protected int scaledWidth = 0;
    protected int scaledHeight = 0;
    protected int rawWidth = 0;
    protected int rawHeight = 0;
    protected int mVideoContainerWidth = 0;
    protected int mVideoContainerHei = 0;
    protected int mLastReportedBandwidth = -1;
    protected int mLastErrorCode = 0;
    protected int mLastHttpErrorCode = 0;
    protected Exception mLastException = IErrorsReporter.NO_EXCEPTION;
    protected boolean isDVREnabled = false;
    protected boolean reactToAudioFocusInTheBackground = false;
    protected TimelineData timelineData;
    protected AMPTracker ampTracker;
    protected Boolean mDebuggingActive = false;
    protected String mDebugUrl;
    private Listeners<IPlayerEventsListener> mListeners = new Listeners();
    private ArrayList<ISegmentInfoListener> mSegmentInfoListeners = new ArrayList();
    private LogManager.Logs logger;
    private String mServerIp = "";
    private int mServerPort = 80;
    private Surface surface;
    private Listeners<View.OnTouchListener> onTouchListeners = new Listeners();
    private IErrorBeacon errorBeacon;
    private boolean isInBackground = false;
    private AudioFocusManager audioFocusManager;
    private BecomingNoisyReceiver myNoisyAudioStreamReceiver;
    private IntentFilter intentFilter;
    private boolean isAdPlaying;
    private AdsCount adsCount;
    private AdsInfo latestAdInfo;
    private final IAdsComponentListener iAdsComponentListener = new IAdsComponentListener(){

        @Override
        public void onListenerRegistered() {
            VideoPlayerView.this.adsCount = null;
            VideoPlayerView.this.latestAdInfo = null;
        }

        @Override
        public void onAdsLoaded(AdsCount param) {
            VideoPlayerView.this.adsCount = param;
        }

        public void onAdsStarted(AdsInfo ad) {
            VideoPlayerView.this.latestAdInfo = ad;
            VideoPlayerView.this.requestAudioFocus();
        }

        @Override
        public void onAdsEnded() {
            VideoPlayerView.this.stopAudioFocus();
        }

        @Override
        public void onAdsPaused() {
            VideoPlayerView.this.stopAudioFocus();
        }

        @Override
        public void onAdsResumed() {
            VideoPlayerView.this.requestAudioFocus();
        }

        @Override
        public void onAdBreakEnded() {
            LogManager.log(VideoPlayerView.TAG, "onAdsEnded() ");
            if (VideoPlayerView.this.latestAdInfo == null) {
                return;
            }
            if (VideoPlayerView.this.latestAdInfo.isLastPostroll()) {
                VideoPlayerView.this.fireEvent(28);
                LogManager.log(VideoPlayerView.TAG, "onAdBreakEnded() fired PLAYER_EVENT_TYPE_ALL_PLAYBACK_COMPLETED");
            }
            VideoPlayerView.this.latestAdInfo = null;
        }

        @Override
        public void onAdsInitialized() {
        }

        @Override
        public void onAdRequest() {
        }

        @Override
        public void onAllPostrollsEnded() {
        }

        @Override
        public void onAdBreakStarted() {
        }

        @Override
        public void onAdsTrackProgress(int progress) {
        }

        @Override
        public void onAdsPlayheadUpdate(int seconds) {
        }

        @Override
        public void onAdsError(String reason) {
        }

        @Override
        public void onPauseContentRequested() {
        }

        @Override
        public void onResumeContentRequested() {
        }

        @Override
        public void onAdsTapped() {
        }

        @Override
        public void onAdSkipped() {
        }

        @Override
        public void onAdEvent() {
        }

        @Override
        public void onAdBufferingStarted() {
        }

        @Override
        public void onAdBufferingEnded() {
        }
    };
    private Handler mUIEventsHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 14: {
                    if (VideoPlayerView.this.mLoadWasInterruptedByPlugin) break;
                    VideoPlayerView.this.changeProgressBarVisibility(true);
                    break;
                }
                case 5: {
                    VideoPlayerView.this.changeProgressBarVisibility(true);
                    break;
                }
                case 4: 
                case 6: {
                    VideoPlayerView.this.changeProgressBarVisibility(false);
                    break;
                }
                case 3: {
                    VideoPlayerView.this.ampTracker.trackEvent(AkamaiEvent.READY);
                    VideoPlayerView.this.changeProgressBarVisibility(false);
                    break;
                }
                case 2: {
                    VideoPlayerView.this.stopAudioFocus();
                    VideoPlayerView.this.fireAllPlaybackCompleteIfNoPostrolls();
                    break;
                }
                case 22: {
                    if (AMPLicenseManager.licenseTypeSelected == AMPLicenseManager.LICENSE_TYPE.AES256) {
                        VideoPlayerView.this.ampTracker.setLicenseData(AMPLicenseManager.getInstance().getApiKey(), VideoPlayerView.this.getContext().getPackageName(), 0L);
                    } else {
                        String packageName = VideoPlayerView.this.mRSALicenseDecryption.getLicensePackageName();
                        long daysUntilExpiration = VideoPlayerView.this.mRSALicenseDecryption.getDaysUntilExpiration();
                        VideoPlayerView.this.ampTracker.setLicenseData(VideoPlayerView.this.mLicense, packageName, daysUntilExpiration);
                    }
                    VideoPlayerView.this.ampTracker.trackEvent(AkamaiEvent.CREATE);
                }
            }
            super.handleMessage(msg);
        }
    };

    public VideoPlayerView(Context context, RSALicenseDecryption RSALicenseDecryptor) {
        super(context);
        this.setOnTouchListener((v, event) -> {
            this.performClick();
            return this.fireMotionEvent(v, event);
        });
        this.mRSALicenseDecryption = RSALicenseDecryptor;
        AMPLicenseManager.getInstance().setLicenseValidationListener(() -> {
            if (!this.shouldAllowPlayback()) {
                this.stop();
                this.onDestroy();
                LogManager.error("Api Key", "License validation result => Playback Blocked!");
            }
        });
        this.ampTracker = new AMPTracker(context);
        this.initialize(context);
    }

    public IErrorBeacon getErrorBeacon() {
        return this.errorBeacon;
    }

    public void setErrorBeacon(IErrorBeacon errorBeacon) {
        this.errorBeacon = errorBeacon;
    }

    public void setBindingContextForReceivers(Context bindingContextForReceivers) {
        this.bindingContextForReceivers = bindingContextForReceivers;
    }

    public void setLogger(LogManager.Logs logger) {
        this.logger = logger;
    }

    public void log(String entry) {
        if (this.logger != null) {
            this.logger.log(entry);
        }
    }

    public IAdsComponentListener getAdsComponentListener() {
        return this.iAdsComponentListener;
    }

    public void sendAbortRequest(boolean abortPlayback, AbortListener abortListener) {
        this.setAbortPlayback(abortPlayback);
        this.setAbortListener(abortListener);
    }

    protected void setExoEventsListener(Player.EventListener exoEventsListener) {
        this.exoEventsListener = exoEventsListener;
    }

    private void setAbortListener(AbortListener abortListener) {
        this.abortListener = abortListener;
    }

    public boolean isAdPlaying() {
        return this.isAdPlaying;
    }

    public void setAdPlaying(boolean adPlaying) {
        this.isAdPlaying = adPlaying;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void setTimelineListener(AlternativeTimelineListener alternativeTimelineListener) {
        this.timelineData.setTimelineListener(alternativeTimelineListener);
    }

    public void useContentTimeline(boolean useContentTimeline) {
        this.timelineData.setUseContentData(useContentTimeline);
    }

    public void play(MediaResource media) {
        this.play(media, -1, -1);
    }

    public void play(MediaResource media, int position, int duration) {
        this.doPlay(media);
    }

    public void play(MediaResource media, int position) {
        this.doPlay(media);
    }

    public void playAudio(MediaResource media) {
        this.playAudio(media, -1, -1);
    }

    public void playAudio(MediaResource media, int position, int duration) {
        this.doPlay(media);
    }

    public void playAudio(MediaResource media, int position) {
        this.doPlay(media);
    }

    public abstract TrackGroupArray getAvailableAudioTracks();

    public abstract void switchAudioTrack(int var1);

    public abstract int getCurrentAudioTrackIndex();

    public void stop() {
        this.stopAudioFocus();
        if (LmsManager.getManager().isMulticastEnabled()) {
            LmsManager.getManager().stopMulticast();
        }
    }

    public abstract void pause();

    public void resumeAndRequestAudioFocus() {
        this.requestAudioFocus();
        this.resume();
    }

    public void pauseAndReleaseAudioFocus() {
        this.stopAudioFocus();
        this.pause();
    }

    public abstract void resume();

    public void signalLogicalPause() {
    }

    public void signalLogicalResume() {
    }

    public abstract void seek(int var1);

    public abstract void seek(long var1);

    public abstract void seekToLive();

    public abstract void switchBitrateUp() throws Exception;

    public abstract void switchBitrateDown() throws Exception;

    public abstract void setMaxBitrate(int var1);

    @Deprecated
    public abstract void setBitrateToPlay(int var1) throws Exception;

    @Deprecated
    public abstract void setStartingBitrateIndex(int var1);

    public abstract int getBitratesCount();

    public abstract int getBitrateByIndex(int var1);

    public abstract int getIndexByBitrate(int var1);

    public Boolean isBitrateSupported(int iBitrateIndex) {
        return true;
    }

    public abstract boolean isPlaying();

    public abstract boolean isPaused();

    public abstract boolean isError();

    public abstract boolean isFinished();

    public abstract boolean isSeeking();

    public abstract boolean isAudioOnly();

    public boolean isFullScreen() {
        return this.mFullscreenMode != 1;
    }

    public abstract boolean isLive();

    public boolean isPlaybackProcessInterrupted() {
        return this.mLoadWasInterruptedByPlugin;
    }

    public boolean isResumingAfterActivityResume() {
        return this.mResumingAfterActivityResume;
    }

    @Deprecated
    public int getTimePosition() {
        return this.getCurrentStreamPosition();
    }

    public abstract int getCurrentStreamPosition();

    public abstract long getCurrentPositionPeriodInMillis();

    public int getCurrentTimelinePosition() {
        int position = this.getCurrentStreamPosition();
        int result = this.timelineData.getTimelinePosition(position);
        return result;
    }

    public int getTimelineStreamPosition(int atContentPosition) {
        int result = this.timelineData.getStreamPosition(atContentPosition);
        return result;
    }

    @Deprecated
    public long getTimePositionMS() {
        return this.getCurrentStreamPositionMS();
    }

    public abstract long getCurrentStreamPositionMS();

    public int getCurrentTimelinePositionMS() {
        return this.timelineData.getTimelinePosition(this.getCurrentTimelinePosition()) * 1000;
    }

    public abstract Date getCurrentStreamPositionAsDate();

    public abstract int getPositionInDVR();

    public abstract long getDVRLength();

    public long getLastPTS() {
        return 0L;
    }

    public void setAdjustTimestamps(boolean adjust) {
    }

    public void setDisableDynamicAudioFeature(boolean disable) {
    }

    public void setDropWrongTimestampPacketsMode(int mode) {
    }

    public void onDestroy() {
        Config.getConfig().clearConfig();
        this.fireEvent(23);
        this.mListeners.clear();
        this.onTouchListeners.clear();
    }

    public boolean isInBackground() {
        return this.isInBackground;
    }

    public void onResume() {
        this.doOnResumeParent();
    }

    public void onPause() {
        this.doOnPauseParent();
    }

    public void doOnPauseParent() {
        this.isInBackground = true;
        this.stopAudioFocus();
        this.fireEvent(17);
    }

    public void doOnResumeParent() {
        this.isInBackground = false;
        this.fireEvent(18);
        this.requestAudioFocus();
        MuteHelper.setCurrentMuteState(this);
    }

    public abstract String getStreamsInfo();

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    @Deprecated
    public int getDuration() {
        return this.getStreamDuration();
    }

    public abstract int getStreamDuration();

    public int getTimelineDuration() {
        return this.timelineData.getTimelinePosition(this.getStreamDuration());
    }

    public long getCurrentBitrate() {
        return -1L;
    }

    public abstract void setFullScreenMode(int var1);

    @Deprecated
    public abstract void setFullScreen(boolean var1);

    public int getFullScreenMode() {
        return this.mFullscreenMode;
    }

    public abstract int getBufferingPercentage();

    public void setRebufferingMode(int iInMode) {
    }

    public void setRebufferingSize(int iInRebufferSize) {
    }

    public void addOnTouchListener(View.OnTouchListener listener) {
        if (listener == null) {
            LogManager.error(TAG, "OnTouchListener Error: Listener cannot be null");
        } else {
            boolean isAlreadyContained = this.onTouchListeners.contains(listener);
            if (isAlreadyContained) {
                LogManager.error(TAG, "OnTouchListener Error: listener was already added " + listener);
            } else {
                this.onTouchListeners.add(listener);
                LogManager.log(TAG, "OnTouchListener added: " + listener);
            }
        }
    }

    public void addEventsListener(IPlayerEventsListener listener) {
        if (listener == null) {
            LogManager.error(TAG, "IPlayerEventsListener Error: Listener cannot be null");
        } else {
            boolean isAlreadyContained = this.mListeners.contains(listener);
            if (isAlreadyContained) {
                LogManager.error(TAG, "IPlayerEventsListener Error: listener was already added " + listener);
            } else {
                this.mListeners.add(listener);
                LogManager.log(TAG, "IPlayerEventsListener added: " + listener);
            }
        }
    }

    public void removeOnTouchListener(View.OnTouchListener listener) {
        this.onTouchListeners.remove(listener);
    }

    public void removeEventsListener(IPlayerEventsListener listener) {
        this.mListeners.remove(listener);
    }

    public void setSegmentInfoListener(ISegmentInfoListener segInfoListener) {
        this.mSegmentInfoListeners.add(segInfoListener);
    }

    public void removeSegmentInfoListener(ISegmentInfoListener segInfoListener) {
        this.mSegmentInfoListeners.remove(segInfoListener);
    }

    public abstract int getBitratesSwitchesUp();

    public abstract int getBitratesSwitchesDown();

    public abstract int getRebuffers();

    public abstract double getRebufferingTime();

    public float getFPS() {
        return -1.0f;
    }

    @Deprecated
    public float getAvgFPS() {
        return this.getFPS();
    }

    @Deprecated
    public float getEncodedFPS() {
        return this.getFPS();
    }

    public String getProtocol() {
        return PROTOCOL_UNKNOWN;
    }

    public final String getServerIp() {
        return this.mServerIp;
    }

    public final int getServerPort() {
        return this.mServerPort;
    }

    public final int getLastHttpErrorCode() {
        return this.mLastHttpErrorCode;
    }

    public final Exception getLastException() {
        return this.mLastException;
    }

    public int getLastMeasuredBandwidth() {
        return this.mLastReportedBandwidth;
    }

    public void setDropFrames(boolean value) {
    }

    public void setVideoQuality(int iInQuality) {
    }

    public void setAvoidAudioOnlyStreams(boolean bInValue) {
    }

    public void setUseBufferingWhenStarting(boolean value) {
    }

    public void setHLSStartingAlgorithm(int mode) {
    }

    public final void setLogEnabled(boolean value) {
        LogManager.setLogEnabled(value);
    }

    public void setUseMultiThread(boolean value) {
    }

    @Deprecated
    public abstract void setManualSwitching(boolean var1);

    public void setAvoidIncompatibleVideoProfiles(boolean bInValue) {
    }

    public void setAvoidIncompatibleVideoResolutions(boolean bInValue) {
    }

    public void setAutoResume(boolean enable) {
        this.mAutomaticResume = enable;
    }

    public abstract long getBytesLoaded();

    @Deprecated
    public String about() {
        return "Android AMP SDK - v9.10.7";
    }

    public final void setProgressBarControl(View progressBar) {
        this.mProgressBar = progressBar;
    }

    public final View getProgressBarControl() {
        return this.mProgressBar;
    }

    public final void setDebugUrl(String value) {
        this.mDebugUrl = value;
    }

    public final void setDebugingActive(Boolean value) {
        this.mDebuggingActive = value;
    }

    public final void setLicense(String license) {
        if (license != null) {
            this.mLicense = license;
            AMPLicenseManager.licenseTypeSelected = AMPLicenseManager.LICENSE_TYPE.RSA;
        }
    }

    public final ArrayList<String> getLicensePackageNames() {
        if (AMPLicenseManager.licenseTypeSelected == AMPLicenseManager.LICENSE_TYPE.AES256) {
            return AMPLicenseManager.getInstance().getAes256LicenseDecryption().getLicense().packageNames;
        }
        return new ArrayList<String>();
    }

    public final String getLicensePackageName() {
        return this.mRSALicenseDecryption.getLicensePackageName();
    }

    public final Date getLicenseExpirationDate() {
        if (AMPLicenseManager.licenseTypeSelected == AMPLicenseManager.LICENSE_TYPE.AES256) {
            return AMPLicenseManager.getInstance().getAes256LicenseDecryption().getLicense().expirationDate;
        }
        return this.mRSALicenseDecryption.getLicenseExpirationDate();
    }

    public String getVersionDescription() {
        return "Java Lib Version: 9.10.7";
    }

    public void setDefaultAudioConfig(int sample_rate, int channels) {
    }

    public final String getStreamUrl() {
        if (this.mMediaResource != null) {
            return this.mMediaResource.getResourceUrl();
        }
        return "";
    }

    public final MediaResource getMediaResource() {
        return this.mMediaResource;
    }

    public final int getLastErrorCode() {
        return this.mLastErrorCode;
    }

    public final int[] getLocationOnScreen() {
        try {
            int[] videoLocation = new int[2];
            super.getLocationOnScreen(videoLocation);
            return videoLocation;
        }
        catch (Exception ex) {
            return new int[]{0, 0};
        }
    }

    public void clearRenderBuffer() {
    }

    public final void onSegmentProgress(String segmentUrl, int segmentOffset) {
        this.fireExtendedEvent(2, segmentUrl, segmentOffset);
    }

    public String getCurrentSegmentUrl() {
        return null;
    }

    public void setForceFormatChange(boolean value) {
    }

    public void setHardwareSeekingProtection(boolean value) {
    }

    public void setAkamaiAlgorithmValue(int bitrate) {
    }

    public abstract void setNetSessionMode(int var1);

    public void setForceOMXdecoding(boolean value) {
    }

    public boolean isMuted() {
        return MuteHelper.isMuted();
    }

    @Override
    public void mute() {
        MuteHelper.mute(this);
    }

    @Override
    public void unmute() {
        MuteHelper.unmute(this);
    }

    @Override
    public void setVolume(float volume) {
        MuteHelper.setVolume(this, volume);
    }

    public void setMuteState(boolean isMuted) {
        MuteHelper.setMuteState(this, isMuted);
    }

    public void playMuted(MediaResource resource) {
        this.play(resource);
        this.mute();
    }

    public void playMuted(MediaResource resource, int startPosition) {
        this.play(resource, startPosition, -1);
        this.mute();
    }

    public void playMuted(MediaResource resource, int startPosition, int duration) {
        this.play(resource, startPosition, duration);
        this.mute();
    }

    public void safeRun(Runnable runnable) {
    }

    public Looper getCurrentLooper() {
        return null;
    }

    public final boolean fireEvent(int iEventType) {
        this.mUIEventsHandler.sendEmptyMessage(iEventType);
        boolean bRes = true;
        for (IPlayerEventsListener l : this.mListeners) {
            boolean b = l.onPlayerEvent(iEventType);
            bRes = bRes && b;
        }
        this.handleBecomeNoisyReceiver(iEventType);
        this.validateTriggeringErrorBeacon(iEventType);
        return bRes;
    }

    public boolean fireMotionEvent(View v, MotionEvent e) {
        for (View.OnTouchListener l : this.onTouchListeners) {
            l.onTouch(v, e);
        }
        return true;
    }

    public boolean isCurrentBitrateNotReported() {
        long currentBitrate = this.getCurrentBitrate();
        boolean result = -1L == currentBitrate;
        return result;
    }

    public abstract void setVideoBufferSize(int var1);

    public long getPlayheadPosition() {
        if (this.isLive()) {
            long currentUtcSeconds = System.currentTimeMillis() / 1000L;
            return currentUtcSeconds;
        }
        int playbackSeconds = this.getCurrentStreamPosition();
        return playbackSeconds;
    }

    public int getDropFramesCount() {
        return this.mDropFramesCount;
    }

    public void enableDVRfeatures(boolean enabled) {
        this.isDVREnabled = enabled;
    }

    public Map<String, List<String>> getResponseHeader() {
        return null;
    }

    public CaptioningManager getCaptioningManager() {
        return (CaptioningManager)this.getContext().getSystemService("captioning");
    }

    public void setReactToAudioFocusInTheBackground(boolean reactToAudioFocusInTheBackground) {
        this.reactToAudioFocusInTheBackground = reactToAudioFocusInTheBackground;
    }

    public HashMap<Integer, Integer> getAvailableBitrates() {
        return new HashMap<Integer, Integer>();
    }

    public abstract List<QualityLevel> getQualityLevels();

    public abstract void setQualityLevel(int var1);

    public int getSelectedQualityLevelIndex() {
        LogManager.error(TAG, "Quality levels are not available");
        return -1;
    }

    public QualityLevel getSelectedQualityLevel() {
        LogManager.error(TAG, "Quality levels are not available");
        return null;
    }

    public AudioManager.OnAudioFocusChangeListener getAudioFocusListener() {
        return focusChange -> {
            if (!this.isAdPlaying && this.reactToAudioFocus()) {
                switch (focusChange) {
                    case -3: {
                        LogManager.log(TAG, "Audio focus loss transient can duck");
                        if (!this.isMuted()) {
                            this.setVolume(MuteHelper.DUCK_VOLUME);
                            this.shouldUnMuteAfterDucking = true;
                            break;
                        }
                        this.shouldUnMuteAfterDucking = false;
                        break;
                    }
                    case 3: {
                        LogManager.log(TAG, "Audio focus gain transient may duck");
                        break;
                    }
                    case -2: {
                        LogManager.log(TAG, "Audio focus loss transient");
                        if (Utils.isFireTV(this.getContext())) {
                            this.mute();
                        } else {
                            this.pause();
                        }
                        this.lostFullAudioFocus = true;
                        break;
                    }
                    case 1: {
                        LogManager.log(TAG, "Audio focus gain");
                        if (this.isPaused() && this.lostFullAudioFocus) {
                            this.resume();
                            this.lostFullAudioFocus = false;
                        }
                        if (!this.shouldUnMuteAfterDucking) break;
                        this.unmute();
                        break;
                    }
                    case -1: {
                        LogManager.log(TAG, "Audio focus loss");
                        this.stopAudioFocus();
                        this.lostFullAudioFocus = true;
                        if (this.isPaused()) break;
                        this.pause();
                    }
                }
            }
        };
    }

    public void setMediaResource(MediaResource mediaResource) {
        this.mMediaResource = mediaResource;
    }

    public void setDownloadRequestProvider(DownloadRequestProvider p) {
    }

    public float getPlaybackRate() {
        return 1.0f;
    }

    public void setPlaybackRate(float rate, float pitch) {
    }

    public AmpBasePlayer getAmpBasePlayer() {
        return null;
    }

    public void setBandwidthMeter(BandwidthMeter bandwidthMeter) {
    }

    public long getBufferAvailable() {
        return 0L;
    }

    public long getLatency() {
        return 0L;
    }

    public boolean isBuffering() {
        return false;
    }

    public int getStreamType() {
        return 3;
    }

    public void loadExternalVTTResources(SideloadedCaptionsData ... c) {
    }

    public abstract long toUTC(int var1);

    public abstract long fromUTC(int var1);

    public void addId3TagsEventListener(ID3TagEventListener listener) {
    }

    public void removeId3TagsEventListener(ID3TagEventListener listener) {
    }

    public void setThumbnails(String vttURL, String basePath) {
    }

    public void setThumbnails(String vttURL) {
    }

    public void shouldAutoPlay(boolean autoPlay) {
        this.shouldAutoPlay = autoPlay;
    }

    public boolean isAutoPlayOn() {
        return this.shouldAutoPlay;
    }

    public void setRepeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
    }

    public String getThumbnailsBasePath() {
        return null;
    }

    public boolean areThumbnailsEnabled() {
        return false;
    }

    public List<Cue> getThumbnailByPosition(long positionInSeconds) {
        return null;
    }

    private boolean reactToAudioFocus() {
        if (this.reactToAudioFocusInTheBackground) {
            return true;
        }
        return !this.isInBackground;
    }

    private void requestAudioFocus() {
        if (!this.audioFocusManager.isAudioFocusRequested()) {
            this.audioFocusManager.requestAudioFocus(this.getAudioFocusListener());
        }
    }

    private void stopAudioFocus() {
        this.audioFocusManager.abandonAudioFocus();
    }

    private boolean isAudioFocusGained() {
        return this.audioFocusManager.isAudioFocusGranted();
    }

    protected void abortPlayback() {
        LogManager.log(TAG, "Playback aborted!");
        this.setAbortPlayback(false);
        this.abortListener.abortActionCompleted();
        this.stop();
        this.onDestroy();
    }

    private void handleBecomeNoisyReceiver(int e) {
        switch (e) {
            case 22: {
                if (this.myNoisyAudioStreamReceiver != null) break;
                this.intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
                this.myNoisyAudioStreamReceiver = new BecomingNoisyReceiver();
                if (this.bindingContextForReceivers == null) {
                    this.bindingContextForReceivers = this.getContext();
                }
                this.bindingContextForReceivers.registerReceiver((BroadcastReceiver)this.myNoisyAudioStreamReceiver, this.intentFilter);
                break;
            }
            case 21: {
                if (this.myNoisyAudioStreamReceiver == null) break;
                if (this.bindingContextForReceivers == null) {
                    this.bindingContextForReceivers = this.getContext();
                }
                this.bindingContextForReceivers.unregisterReceiver((BroadcastReceiver)this.myNoisyAudioStreamReceiver);
                this.myNoisyAudioStreamReceiver = null;
            }
        }
    }

    private void fireAllPlaybackCompleteIfNoPostrolls() {
        boolean sessionHasPostrolls;
        LogManager.log(TAG, "fireAllPlaybackCompleteIfNoPostrolls() ");
        boolean bl = sessionHasPostrolls = this.adsCount != null && this.adsCount.hasPostrolls();
        if (!sessionHasPostrolls) {
            this.fireEvent(28);
            LogManager.log(TAG, "fireAllPlaybackCompleteIfNoPostrolls() fired PLAYER_EVENT_TYPE_ALL_PLAYBACK_COMPLETED");
        }
    }

    private void setAbortPlayback(boolean abortPlayback) {
        this.abortPlayback = abortPlayback;
    }

    protected void initialize(Context context) {
        this.audioFocusManager = new AudioFocusManager(context);
        this.timelineData = new TimelineData();
    }

    private void doPlay(MediaResource media) {
        this.mLastException = IErrorsReporter.NO_EXCEPTION;
        this.mMediaResource = media;
        this.requestAudioFocus();
        if (this.mDebuggingActive.booleanValue()) {
            Utils.resetLog();
        }
        this.unmute();
    }

    protected boolean shouldAllowPlayback() {
        if (AMPLicenseManager.licenseTypeSelected == AMPLicenseManager.LICENSE_TYPE.NONE) {
            String message = "No valid license was found, playback is not allowed";
            LogManager.error("AMPLicense", message);
            return false;
        }
        return this.checkAES256License() || this.checkRSALicense();
    }

    private boolean checkRSALicense() {
        if (!this.mRSALicenseDecryption.isLicenseValid(this.mLicense)) {
            int cause = this.mRSALicenseDecryption.getCause();
            return 0 == cause;
        }
        return true;
    }

    private boolean checkAES256License() {
        if (AMPLicenseManager.getInstance().isLicenseRetrieved()) {
            return AMPLicenseManager.getInstance().isLicenseValid(this.getContext());
        }
        return AMPLicenseManager.getInstance().isLicenseRequested();
    }

    private void validateTriggeringErrorBeacon(int iEventType) {
        if (this.errorBeacon == null) {
            return;
        }
        if (4 == iEventType) {
            this.errorBeacon.onErrorTriggered();
        } else if (20 == iEventType) {
            this.errorBeacon.onPlaybackBackNormal();
        }
    }

    private void changeProgressBarVisibility(boolean setVisible) {
        if (this.mProgressBar == null) {
            return;
        }
        if (setVisible) {
            this.fireEvent(29);
            this.mProgressBar.setVisibility(0);
        } else {
            this.fireEvent(30);
            this.mProgressBar.setVisibility(4);
        }
    }

    protected final boolean fireExtendedEvent(int iEventType, int arg1, int arg2) {
        boolean bRes = true;
        for (IPlayerEventsListener listener : this.mListeners) {
            if (listener == null) continue;
            bRes = bRes && listener.onPlayerExtendedEvent(iEventType, arg1, arg2);
        }
        return bRes;
    }

    protected boolean fireExtendedEvent(int iEventType, String url, byte[] data) {
        boolean bRes = true;
        for (int i = 0; i < this.mSegmentInfoListeners.size(); ++i) {
            bRes = bRes && this.mSegmentInfoListeners.get(i).onPlayerExtendedEvent(iEventType, url, data);
        }
        return bRes;
    }

    protected boolean fireExtendedEvent(int iEventType, String url, int offset) {
        boolean bRes = true;
        for (int i = 0; i < this.mSegmentInfoListeners.size(); ++i) {
            bRes = bRes && this.mSegmentInfoListeners.get(i).onPlayerExtendedEvent(iEventType, url, offset);
        }
        return bRes;
    }

    protected void loadServerParameters() {
        new Thread(){

            @Override
            public void run() {
                try {
                    URL url = new URL(VideoPlayerView.this.mMediaResource.getResourceUrl());
                    String host = url.getHost();
                    InetAddress address = InetAddress.getByName(host);
                    VideoPlayerView.this.mServerIp = address.getHostAddress();
                    VideoPlayerView.this.mServerPort = url.getPort();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected final void postDebugData() {
        Thread t = new Thread(){

            @Override
            public void run() {
                String sDeviceId = Utils.getDeviceId(VideoPlayerView.this.getContext());
                String sInfo = String.format("Id: %s\r\nDevice: %s\r\nModel: %s\r\nAndroid Os: %s\r\nCpu Abi: %s\r\nScreen: %dx%d\r\nAvg FPS: %d\r\nUrl: %s\r\nStreams:\r\n%s\r\nError: %d", sDeviceId, Build.DEVICE, Build.MODEL, Build.VERSION.RELEASE, Build.CPU_ABI, VideoPlayerView.this.getWidth(), VideoPlayerView.this.getHeight(), Float.valueOf(VideoPlayerView.this.getAvgFPS()), VideoPlayerView.this.mMediaResource != null ? VideoPlayerView.this.mMediaResource.getResourceUrl() : "", VideoPlayerView.this.getStreamsInfo(), VideoPlayerView.this.getLastHttpErrorCode());
                LogManager.log("Android Player Report", sInfo);
                if (VideoPlayerView.this.mDebugUrl == null) {
                    return;
                }
                try {
                    String lineEnd = "\r\n";
                    String twoHyphens = "--";
                    String boundary = "*****";
                    String sUrl = VideoPlayerView.this.mDebugUrl;
                    sUrl = sUrl.replace("%DEVICE", sDeviceId);
                    sUrl = sUrl.replace("%TIME", System.currentTimeMillis() + "");
                    sUrl = sUrl.replace("%ERRORCODE", VideoPlayerView.this.getLastHttpErrorCode() + "");
                    URL url = new URL(sUrl);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    connection.setUseCaches(false);
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Connection", "Keep-Alive");
                    connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                    DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
                    outputStream.writeBytes(twoHyphens + boundary + lineEnd);
                    outputStream.writeBytes(lineEnd);
                    outputStream.writeBytes(sInfo);
                    outputStream.writeBytes(lineEnd);
                    outputStream.writeBytes("\n\n\n********* LOG **********\n");
                    outputStream.writeBytes(Utils.getLogLines());
                    outputStream.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
                    outputStream.flush();
                    LogManager.log("Android Player Report", connection.getResponseMessage());
                    LogManager.log("Android Player Report", "" + connection.getResponseCode());
                    outputStream.close();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private class BecomingNoisyReceiver
    extends BroadcastReceiver {
        private BecomingNoisyReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.media.AUDIO_BECOMING_NOISY".equals(intent.getAction())) {
                VideoPlayerView.this.pause();
            }
        }
    }
}

