/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ui;

import android.util.Log;
import com.akamai.amp.ui.UIEventsListener;
import com.akamai.amp.utils.LogManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class UIController {
    private final String TAG = this.getClass().getSimpleName();
    private List<UIEventsListener> uiEventsListeners = new CopyOnWriteArrayList<UIEventsListener>();

    public void addEventsListener(UIEventsListener listener) {
        if (listener != null) {
            boolean isAlreadyContained = this.uiEventsListeners.contains(listener);
            if (isAlreadyContained) {
                LogManager.log(this.TAG, "UIEventsListener is already added " + listener);
            } else {
                this.uiEventsListeners.add(listener);
            }
        } else {
            Log.e((String)this.TAG, (String)"UIEventsListener Error: Listener cannot be null");
        }
    }

    public void removeEventsListener(UIEventsListener listener) {
        this.uiEventsListeners.remove(listener);
    }

    public void onScrubbingEnded() {
        for (UIEventsListener l : this.uiEventsListeners) {
            l.onScrubbingEnded();
        }
    }

    public void clearListeners() {
        this.uiEventsListeners.clear();
    }
}

