/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.text.webvtt;

import android.text.TextUtils;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class WebvttCssStyle {
    public static final int UNSPECIFIED = -1;
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_BOLD_ITALIC = 3;
    public static final int FONT_SIZE_UNIT_PIXEL = 1;
    public static final int FONT_SIZE_UNIT_EM = 2;
    public static final int FONT_SIZE_UNIT_PERCENT = 3;
    private static final int OFF = 0;
    private static final int ON = 1;
    private String targetId = "";
    private String targetTag = "";
    private Set<String> targetClasses = Collections.emptySet();
    private String targetVoice = "";
    @Nullable
    private String fontFamily = null;
    @ColorInt
    private int fontColor;
    private boolean hasFontColor = false;
    private int backgroundColor;
    private boolean hasBackgroundColor = false;
    private int linethrough = -1;
    private int underline = -1;
    private int bold = -1;
    private int italic = -1;
    private int fontSizeUnit = -1;
    private float fontSize;
    private int rubyPosition = -1;
    private boolean combineUpright = false;

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setTargetTagName(String targetTag) {
        this.targetTag = targetTag;
    }

    public void setTargetClasses(String[] targetClasses) {
        this.targetClasses = new HashSet<String>(Arrays.asList(targetClasses));
    }

    public void setTargetVoice(String targetVoice) {
        this.targetVoice = targetVoice;
    }

    public int getSpecificityScore(@Nullable String id, @Nullable String tag, Set<String> classes, @Nullable String voice) {
        if (this.targetId.isEmpty() && this.targetTag.isEmpty() && this.targetClasses.isEmpty() && this.targetVoice.isEmpty()) {
            return TextUtils.isEmpty((CharSequence)tag) ? 1 : 0;
        }
        int score = 0;
        score = WebvttCssStyle.updateScoreForMatch(score, this.targetId, id, 0x40000000);
        score = WebvttCssStyle.updateScoreForMatch(score, this.targetTag, tag, 2);
        if ((score = WebvttCssStyle.updateScoreForMatch(score, this.targetVoice, voice, 4)) == -1 || !classes.containsAll(this.targetClasses)) {
            return 0;
        }
        return score += this.targetClasses.size() * 4;
    }

    public int getStyle() {
        if (this.bold == -1 && this.italic == -1) {
            return -1;
        }
        return (this.bold == 1 ? 1 : 0) | (this.italic == 1 ? 2 : 0);
    }

    public boolean isLinethrough() {
        return this.linethrough == 1;
    }

    public WebvttCssStyle setLinethrough(boolean linethrough) {
        this.linethrough = linethrough ? 1 : 0;
        return this;
    }

    public boolean isUnderline() {
        return this.underline == 1;
    }

    public WebvttCssStyle setUnderline(boolean underline) {
        this.underline = underline ? 1 : 0;
        return this;
    }

    public WebvttCssStyle setBold(boolean bold) {
        this.bold = bold ? 1 : 0;
        return this;
    }

    public WebvttCssStyle setItalic(boolean italic) {
        this.italic = italic ? 1 : 0;
        return this;
    }

    @Nullable
    public String getFontFamily() {
        return this.fontFamily;
    }

    public WebvttCssStyle setFontFamily(@Nullable String fontFamily) {
        this.fontFamily = Util.toLowerInvariant(fontFamily);
        return this;
    }

    public int getFontColor() {
        if (!this.hasFontColor) {
            throw new IllegalStateException("Font color not defined");
        }
        return this.fontColor;
    }

    public WebvttCssStyle setFontColor(int color) {
        this.fontColor = color;
        this.hasFontColor = true;
        return this;
    }

    public boolean hasFontColor() {
        return this.hasFontColor;
    }

    public int getBackgroundColor() {
        if (!this.hasBackgroundColor) {
            throw new IllegalStateException("Background color not defined.");
        }
        return this.backgroundColor;
    }

    public WebvttCssStyle setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.hasBackgroundColor = true;
        return this;
    }

    public boolean hasBackgroundColor() {
        return this.hasBackgroundColor;
    }

    public WebvttCssStyle setFontSize(float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public WebvttCssStyle setFontSizeUnit(short unit) {
        this.fontSizeUnit = unit;
        return this;
    }

    public int getFontSizeUnit() {
        return this.fontSizeUnit;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public WebvttCssStyle setRubyPosition(int rubyPosition) {
        this.rubyPosition = rubyPosition;
        return this;
    }

    public int getRubyPosition() {
        return this.rubyPosition;
    }

    public WebvttCssStyle setCombineUpright(boolean enabled) {
        this.combineUpright = enabled;
        return this;
    }

    public boolean getCombineUpright() {
        return this.combineUpright;
    }

    private static int updateScoreForMatch(int currentScore, String target, @Nullable String actual, int score) {
        if (target.isEmpty() || currentScore == -1) {
            return currentScore;
        }
        return target.equals(actual) ? currentScore + score : -1;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface OptionalBoolean {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FontSizeUnit {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StyleFlags {
    }
}

