/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.ima;

import android.content.Context;
import android.view.ViewGroup;
import com.akamai.amp.ads.ima.GoogleAdsInfo;
import com.akamai.amp.ads.ima.IMAAdsHandler;
import com.akamai.amp.utils.LogManager;
import com.akamai.amp.utils.Utils;
import com.google.ads.interactivemedia.v3.api.Ad;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.BaseManager;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;
import com.google.ads.interactivemedia.v3.api.ImaSdkSettings;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import java.util.HashSet;
import java.util.Set;

public class ClientSideAdsHandler
extends IMAAdsHandler {
    private static final String TAG = ClientSideAdsHandler.class.getSimpleName();
    AdsManager adsManager;
    private static Set<String> startedAdIds = new HashSet<String>();

    public ClientSideAdsHandler(Context context, boolean disableAdsCountdown, ImaSdkSettings imaSdkSettings) {
        super(context, disableAdsCountdown, imaSdkSettings);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mAdsContainer = ImaSdkFactory.createAdDisplayContainer((ViewGroup)this.mAdsPlayerHolder.getUiContainer(), (VideoAdPlayer)this.mAdsPlayerHolder);
        this.createClientSideAdsLoader();
    }

    public boolean isClientSideAds() {
        return true;
    }

    public boolean isServerSideAds() {
        return false;
    }

    @Override
    protected BaseManager getManager(AdsManagerLoadedEvent event) {
        this.adsManager = event.getAdsManager();
        return this.adsManager;
    }

    @Override
    public void onResume(boolean shouldResume) {
        if (this.mVideoPlayerView == null) {
            return;
        }
        this.mVideoPlayerView.onResume();
    }

    @Override
    public void onPause() {
        if (this.mVideoPlayerView == null) {
            return;
        }
        this.mVideoPlayerView.onPause();
    }

    @Override
    public BaseManager getManager() {
        return this.adsManager;
    }

    public void setAdsUrl(String adsUrl) {
        this.tagURL = (String)Utils.requireNonNull((Object)adsUrl);
        this.isIMADataSetManually = true;
        startedAdIds.clear();
    }

    @Override
    protected void doOnAdLoaded(Ad ad) {
        if (this.checkRepetition(ad)) {
            return;
        }
        GoogleAdsInfo adsInfo = this.convert(ad);
        if (adsInfo.isPreroll()) {
            this.pauseContentVideo();
        }
        this.onLoaded(adsInfo);
    }

    private boolean checkRepetition(Ad ad) {
        String adId;
        boolean hasAlreadyPlayed;
        GoogleAdsInfo adsInfo;
        if (this.isClientSideAds() && this.mAdsManager != null && (adsInfo = this.convert(ad)) != null && (hasAlreadyPlayed = startedAdIds.contains(adId = adsInfo.adId))) {
            LogManager.log((String)TAG, (String)("SKIPPING -> " + (Object)((Object)adsInfo)));
            this.adsManager.skip();
            if (adsInfo.isLastInAdBreak()) {
                this.resumeContentVideo();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doOnAdStarted(String adId) {
        startedAdIds.add(adId);
        if (this.mVideoPlayerView != null && this.mVideoPlayerView.isPlaying()) {
            this.pauseContentVideo();
        }
    }

    @Override
    protected void startOnLoaded() {
        if (this.adsManager != null) {
            this.adsManager.start();
        }
    }

    @Override
    public void playWithServerAds() {
        this.reportInvalid(TAG, "playWithServerAds()");
    }

    public void playWithServerAds(String assetKey) {
        this.reportInvalid(TAG, "playWithServerAds(String assetKey)");
    }

    public void playWithServerAds(String vodContentSourceId, String videoId) {
        this.reportInvalid(TAG, "playWithServerAds(String vodContentSourceId, String videoId)");
    }

    public int getContentPosition(int contentPosition) {
        return contentPosition;
    }

    public int getStreamPosition(int streamPosition) {
        return streamPosition;
    }

    public int getContentDuration(int contentDuration) {
        return contentDuration;
    }

    @Override
    public void pauseAd() {
        LogManager.log((String)TAG, (String)"pauseAd");
        if (this.mIsAdStarted && this.adsManager != null) {
            this.mAdsPlayerHolder.pauseContent();
            this.adsManager.pause();
        }
    }

    @Override
    public void resumeAd() {
        LogManager.log((String)TAG, (String)"resumeAd");
        if (this.mIsAdStarted && this.adsManager != null) {
            this.mAdsPlayerHolder.resumeContent();
            this.adsManager.resume();
        }
    }

    @Override
    protected void handlePlaybackFinishedEvent(boolean isEndOfVideo) {
        if (isEndOfVideo) {
            this.onContentComplete();
            this.showProgressBar(false);
        }
    }

    @Override
    protected void onContentComplete() {
        if (this.mAdsPlayerHolder == null) {
            return;
        }
        this.mAdsPlayerHolder.onContentComplete();
    }

    @Override
    protected void onSeekingStarted() {
    }

    @Override
    protected void doOnAdBreakEnded() {
    }

    public void doProxyInit() {
    }

    public void doSessionInit() {
    }

    public void doProxyInit(int debugFlags) {
    }

    public void doSessionInit(int debugFlags) {
    }

    @Override
    public AdDisplayContainer getAdDisplayContainer() {
        return this.mAdsContainer;
    }
}

