/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import com.adobe.mobile.AnalyticsWorker;
import com.adobe.mobile.ContextData;
import com.adobe.mobile.Lifecycle;
import com.adobe.mobile.Messages;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.VisitorIDService;
import com.adobe.mobile.WearableFunctionBridge;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class RequestBuilder {
    private static final String VAR_ESCAPE_PREFIX = "&&";
    private static final String PRIVACY_MODE_KEY = "a.privacy.mode";
    private static final String CUSTOMER_PERSPECTIVE_VAR = "cp";
    private static final String APP_STATE_FOREGROUND = "foreground";
    private static final String APP_STATE_BACKGROUND = "background";

    RequestBuilder() {
    }

    protected static void buildAndSendRequest(Map<String, Object> data, Map<String, Object> vars, long timeStamp) {
        if (!WearableFunctionBridge.shouldSendHit()) {
            return;
        }
        HashMap<String, Object> mutableData = new HashMap<String, Object>();
        mutableData.putAll(StaticMethods.getDefaultData());
        long t = StaticMethods.getTimeSinceLaunch();
        if (t > 0L) {
            mutableData.put("a.TimeSinceLaunch", String.valueOf(t));
        }
        if (data != null) {
            mutableData.putAll(data);
        }
        if (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_UNKNOWN) {
            mutableData.put(PRIVACY_MODE_KEY, "unknown");
        }
        HashMap<String, Object> mutableVars = vars != null ? new HashMap<String, Object>(vars) : new HashMap();
        String aid = StaticMethods.getAID();
        if (aid != null) {
            mutableVars.put("aid", StaticMethods.getAID());
        }
        if (StaticMethods.getVisitorID() != null) {
            mutableVars.put("vid", StaticMethods.getVisitorID());
        }
        mutableVars.put("ce", MobileConfig.getInstance().getCharacterSet());
        if (MobileConfig.getInstance().getOfflineTrackingEnabled()) {
            mutableVars.put("ts", Long.toString(timeStamp));
        }
        mutableVars.put("t", StaticMethods.getTimestampString());
        mutableVars.put(CUSTOMER_PERSPECTIVE_VAR, Lifecycle.applicationIsInBackground() ? APP_STATE_BACKGROUND : APP_STATE_FOREGROUND);
        Iterator it = mutableData.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry kvPair = it.next();
            String key = (String)kvPair.getKey();
            if (key == null) {
                it.remove();
                continue;
            }
            if (!key.startsWith(VAR_ESCAPE_PREFIX)) continue;
            mutableVars.put(key.substring(VAR_ESCAPE_PREFIX.length()), kvPair.getValue());
            it.remove();
        }
        if (MobileConfig.getInstance().getVisitorIdServiceEnabled()) {
            mutableVars.putAll(VisitorIDService.sharedInstance().getAnalyticsIdVisitorParameters());
        }
        Messages.checkForInAppMessage(new HashMap<String, Object>(mutableVars), new HashMap<String, Object>(mutableData), new HashMap<String, Object>(Lifecycle.getContextDataLowercase()));
        Messages.checkFor3rdPartyCallbacks(new HashMap<String, Object>(mutableVars), new HashMap<String, Object>(mutableData));
        mutableVars.put("c", StaticMethods.translateContextData(mutableData));
        if (MobileConfig.getInstance().getMarketingCloudCoopUnsafe() && MobileConfig.getInstance().getAamAnalyticsForwardingEnabled()) {
            ContextData coopContextData = new ContextData();
            ContextData value = new ContextData();
            value.value = 1;
            coopContextData.put("coop_unsafe", value);
            mutableVars.put("d", coopContextData);
        }
        StringBuilder requestString = new StringBuilder(2048);
        requestString.append("ndh=1");
        if (MobileConfig.getInstance().getVisitorIdServiceEnabled()) {
            requestString.append(VisitorIDService.sharedInstance().getAnalyticsIdString());
        }
        StaticMethods.serializeToQueryString(mutableVars, requestString);
        StaticMethods.logDebugFormat("Analytics - Request Queued (%s)", requestString);
        AnalyticsWorker.sharedInstance().queue(requestString.toString(), timeStamp);
    }
}

