/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import com.adobe.mobile.AnalyticsWorker;
import com.adobe.mobile.Config;
import com.adobe.mobile.Lifecycle;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.StaticMethods;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

final class ReferrerHandler {
    static final String CONTEXT_DATA_KEY = "contextData";
    static final String ADOBE_DATA_KEY = "adobeData";
    static final String DEEP_LINK_KEY = "link_deferred";
    static final String ACQUISITION_V3_TOKEN = "adb_acq_v3";
    static final String GOOGLE_REFERRER_DATA_KEY = "googleReferrerData";
    static final String OTHER_REFERRER_DATA_KEY = "otherReferrerData";
    static final String ACQUISITION_REFERRER_DATA_NAMESPACE = "a.acquisition.custom.";
    static final String ACQUISITION_GOOGLE_REFERRER_NAMESPACE = "a.referrer.campaign.";
    static final String ACQUISITION_ADOBE_DATA_PREFIX = "adb";
    private static boolean _referrerProcessed = true;
    static final HashSet<String> ADOBE_DATA_BLACKLISTED_NAMESPACED_KEYS_SET = new HashSet<String>(){
        {
            this.add("a.acquisition.custom.unique_id");
            this.add("a.acquisition.custom.deeplinkid");
            this.add("a.acquisition.custom.link_deferred");
        }
    };

    ReferrerHandler() {
    }

    protected static void setReferrerProcessed(boolean processed) {
        _referrerProcessed = processed;
    }

    protected static boolean getReferrerProcessed() {
        return _referrerProcessed;
    }

    public static void processIntent(Intent intent) {
        String referrerURL = ReferrerHandler.getReferrerURLFromIntent(intent);
        ReferrerHandler.processReferrerUrl(referrerURL);
    }

    protected static boolean isBlackListed(String namespacedKey) {
        return ADOBE_DATA_BLACKLISTED_NAMESPACED_KEYS_SET.contains(namespacedKey);
    }

    protected static String getReferrerURLFromIntent(Intent intent) {
        if (intent == null) {
            StaticMethods.logWarningFormat("Analytics - Unable to process referrer due to an invalid intent parameter", new Object[0]);
            return null;
        }
        if (!intent.getAction().equals("com.android.vending.INSTALL_REFERRER")) {
            StaticMethods.logDebugFormat("Analytics - Ignoring referrer due to the intent's action not being handled by analytics", new Object[0]);
            return null;
        }
        try {
            Bundle extras = intent.getExtras();
            if (extras != null) {
                extras.containsKey(null);
            }
        }
        catch (Exception e) {
            return null;
        }
        String referrerURL = intent.getStringExtra("referrer");
        try {
            return referrerURL != null ? URLDecoder.decode(referrerURL, "UTF-8") : null;
        }
        catch (Exception e) {
            return referrerURL;
        }
    }

    protected static HashMap<String, Object> parseReferrerURLToMap(String referrerURL) {
        HashMap<String, Object> referrerFields = new HashMap<String, Object>();
        for (String item : referrerURL.split("&")) {
            String[] tokens = item.split("=");
            if (tokens.length != 2) continue;
            referrerFields.put(tokens[0], tokens[1]);
        }
        return referrerFields;
    }

    protected static void handleGooglePlayAcquisition(HashMap<String, Object> referrerFields) {
        if (ReferrerHandler.referrerInfoExists()) {
            return;
        }
        final HashMap<String, Object> referrerLifecycleContextData = ReferrerHandler.appendNamespaceToGoogleReferrerFields(referrerFields);
        if (Lifecycle.lifecycleHasRun && referrerLifecycleContextData.containsKey("a.referrer.campaign.source") && referrerLifecycleContextData.containsKey("a.referrer.campaign.name")) {
            StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Lifecycle.updateContextData(referrerLifecycleContextData);
                }
            });
            MobileConfig.getInstance().invokeAdobeDataCallback(Config.MobileDataEvent.MOBILE_EVENT_ACQUISITION_INSTALL, referrerLifecycleContextData);
            AnalyticsWorker.sharedInstance().kickWithReferrerData(referrerLifecycleContextData);
        }
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            JSONObject googleReferrerObject = new JSONObject();
            googleReferrerObject.put(GOOGLE_REFERRER_DATA_KEY, (Object)new JSONObject(referrerLifecycleContextData));
            editor.putString("ADMS_Referrer_ContextData_Json_String", googleReferrerObject.toString());
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Analytics - Error persisting referrer data (%s)", e.getMessage());
        }
        catch (JSONException e) {
            StaticMethods.logErrorFormat("Analytics - Error persisting referrer data (%s)", e.getMessage());
        }
        _referrerProcessed = true;
    }

    protected static HashMap<String, Object> appendNamespaceToGoogleReferrerFields(HashMap<String, Object> referrerFields) {
        HashMap<String, Object> processedFields = new HashMap<String, Object>();
        if (referrerFields == null || referrerFields.size() == 0) {
            return processedFields;
        }
        HashMap<String, Object> referrerFieldsCopy = new HashMap<String, Object>(referrerFields);
        if (referrerFieldsCopy.containsKey("utm_campaign")) {
            processedFields.put("a.referrer.campaign.name", referrerFieldsCopy.remove("utm_campaign"));
        }
        if (referrerFieldsCopy.containsKey("utm_source")) {
            processedFields.put("a.referrer.campaign.source", referrerFieldsCopy.remove("utm_source"));
        }
        if (referrerFieldsCopy.containsKey("utm_medium")) {
            processedFields.put("a.referrer.campaign.medium", referrerFieldsCopy.remove("utm_medium"));
        }
        if (referrerFieldsCopy.containsKey("utm_term")) {
            processedFields.put("a.referrer.campaign.term", referrerFieldsCopy.remove("utm_term"));
        }
        if (referrerFieldsCopy.containsKey("utm_content")) {
            processedFields.put("a.referrer.campaign.content", referrerFieldsCopy.remove("utm_content"));
        }
        if (referrerFieldsCopy.containsKey("trackingcode")) {
            processedFields.put("a.referrer.campaign.trackingcode", referrerFieldsCopy.remove("trackingcode"));
        }
        Set<Map.Entry<String, Object>> entrySet = referrerFieldsCopy.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            if (!key.startsWith(ACQUISITION_REFERRER_DATA_NAMESPACE) && !key.startsWith(ACQUISITION_GOOGLE_REFERRER_NAMESPACE)) {
                key = ACQUISITION_REFERRER_DATA_NAMESPACE + key;
            }
            processedFields.put(key, entry.getValue());
        }
        return processedFields;
    }

    protected static HashMap<String, Object> parseGoogleReferrerFields(String json) {
        HashMap<String, Object> referrerData = new HashMap<String, Object>();
        if (json == null) {
            return referrerData;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            referrerData.putAll(ReferrerHandler.getDataFromJSON(jsonObject, GOOGLE_REFERRER_DATA_KEY));
        }
        catch (JSONException e) {
            StaticMethods.logDebugFormat("Could not retrieve Google referrer data (%s)", e.getMessage());
            referrerData.clear();
        }
        return referrerData;
    }

    protected static void saveReferrerDataFromOtherSource(Map<String, Object> referrerFields) {
        if (referrerFields == null || referrerFields.size() == 0) {
            return;
        }
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            JSONObject googleReferrerObject = new JSONObject();
            googleReferrerObject.put(OTHER_REFERRER_DATA_KEY, (Object)new JSONObject(referrerFields));
            editor.putString("ADMS_Referrer_ContextData_Json_String", googleReferrerObject.toString());
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Analytics - Error persisting referrer data (%s)", e.getMessage());
        }
        catch (JSONException e) {
            StaticMethods.logErrorFormat("Analytics - Error persisting referrer data (%s)", e.getMessage());
        }
    }

    protected static HashMap<String, Object> parseOtherReferrerFields(String json) {
        HashMap<String, Object> referrerData = new HashMap<String, Object>();
        if (json == null) {
            return referrerData;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            referrerData.putAll(ReferrerHandler.getDataFromJSON(jsonObject, OTHER_REFERRER_DATA_KEY));
        }
        catch (JSONException e) {
            StaticMethods.logDebugFormat("Could not retrieve referrer data (%s)", e.getMessage());
            referrerData.clear();
        }
        return referrerData;
    }

    protected static String processReferrerDataFromV3Server(String jsonResponse) {
        if (jsonResponse == null) {
            return null;
        }
        String processedJson = jsonResponse;
        try {
            JSONObject jsonObject = new JSONObject(jsonResponse);
            HashMap<String, Object> adobeData = ReferrerHandler.getDataFromJSON(jsonObject, ADOBE_DATA_KEY);
            HashMap<String, Object> processedAdobeData = new HashMap<String, Object>();
            if (adobeData != null && adobeData.size() > 0) {
                Set<Map.Entry<String, Object>> entrySet = adobeData.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    String key = entry.getKey();
                    if (!key.startsWith(ACQUISITION_REFERRER_DATA_NAMESPACE)) {
                        key = ACQUISITION_REFERRER_DATA_NAMESPACE + key;
                    }
                    processedAdobeData.put(key, entry.getValue());
                }
                jsonObject.remove(ADOBE_DATA_KEY);
                jsonObject.put(ADOBE_DATA_KEY, (Object)new JSONObject(processedAdobeData));
                processedJson = jsonObject.toString();
            }
        }
        catch (JSONException e) {
            StaticMethods.logDebugFormat("Could not parse adobeData from the response (%s)", e.getMessage());
        }
        return processedJson;
    }

    protected static HashMap<String, Object> processV3ResponseAndReturnAdobeData(String jsonResponse) {
        HashMap<String, Object> adobeData = new HashMap<String, Object>();
        try {
            JSONObject adobeDataObject = new JSONObject(jsonResponse);
            HashMap<String, Object> unfilteredAdobeData = ReferrerHandler.getDataFromJSON(adobeDataObject, ADOBE_DATA_KEY);
            if (unfilteredAdobeData != null && unfilteredAdobeData.size() > 0) {
                adobeData.putAll(ReferrerHandler.filterForBlacklistedKeys(unfilteredAdobeData));
            }
        }
        catch (JSONException e) {
            StaticMethods.logDebugFormat("Could not parse adobeData from the response (%s)", e.getMessage());
        }
        return adobeData;
    }

    protected static HashMap<String, Object> filterForBlacklistedKeys(HashMap<String, Object> adobeData) {
        if (adobeData == null || adobeData.size() == 0) {
            return null;
        }
        HashMap<String, Object> filteredAdobeData = new HashMap<String, Object>(adobeData);
        Set<Map.Entry<String, Object>> entrySet = filteredAdobeData.entrySet();
        Iterator<Map.Entry<String, Object>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (!ReferrerHandler.isBlackListed(entry.getKey())) continue;
            iterator.remove();
        }
        return filteredAdobeData;
    }

    protected static void handleV3Acquisition(HashMap<String, Object> referrerFields) {
        String ugid = (String)referrerFields.get("utm_content");
        String jsonResponse = ReferrerHandler.getReferrerDataFromV3Server(ugid, StaticMethods.getAdvertisingIdentifier());
        String processedJsonResponse = ReferrerHandler.processReferrerDataFromV3Server(jsonResponse);
        if (Lifecycle.lifecycleHasRun) {
            if (_referrerProcessed) {
                StaticMethods.logDebugFormat("Analytics - Acquisition referrer timed out", new Object[0]);
                return;
            }
            final HashMap<String, Object> referrerData = new HashMap<String, Object>();
            JSONObject responseJSON = ReferrerHandler.translateV3StringResponseToJSONObject(processedJsonResponse);
            ReferrerHandler.triggerDeepLink(ReferrerHandler.getDeepLinkFromJSON(responseJSON));
            HashMap<String, Object> contextData = ReferrerHandler.getDataFromJSON(responseJSON, CONTEXT_DATA_KEY);
            referrerData.putAll(contextData);
            if (contextData != null && contextData.size() > 0) {
                HashMap<String, Object> adobeData = ReferrerHandler.processV3ResponseAndReturnAdobeData(processedJsonResponse);
                referrerData.putAll(adobeData);
            }
            MobileConfig.getInstance().invokeAdobeDataCallback(Config.MobileDataEvent.MOBILE_EVENT_ACQUISITION_INSTALL, referrerData);
            StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Lifecycle.updateContextData(referrerData);
                }
            });
            AnalyticsWorker.sharedInstance().kickWithReferrerData(referrerData);
        }
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            editor.putString("ADMS_Referrer_ContextData_Json_String", processedJsonResponse);
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Analytics - Error persisting referrer data (%s)", e.getMessage());
        }
        _referrerProcessed = true;
    }

    protected static boolean isV3Response(HashMap<String, Object> referrerFields) {
        return ACQUISITION_V3_TOKEN.equals(referrerFields.get("utm_source")) && ACQUISITION_V3_TOKEN.equals(referrerFields.get("utm_campaign"));
    }

    protected static HashMap<String, Object> processV3ResponseAndReturnContextData(String response) {
        JSONObject responseJSON = ReferrerHandler.translateV3StringResponseToJSONObject(response);
        HashMap<String, Object> contextData = ReferrerHandler.getDataFromJSON(responseJSON, CONTEXT_DATA_KEY);
        return contextData;
    }

    protected static void triggerDeepLink(String deepLink) {
        if (deepLink == null) {
            return;
        }
        try {
            Activity currentActivity = StaticMethods.getCurrentActivity();
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)deepLink));
            currentActivity.startActivity(intent);
        }
        catch (StaticMethods.NullActivityException ex) {
            StaticMethods.logWarningFormat(ex.getMessage(), new Object[0]);
        }
        catch (Exception ex) {
            StaticMethods.logWarningFormat("Acquisition - Could not load deep link intent for Acquisition (%s)", ex.toString());
        }
    }

    protected static HashMap<String, Object> parseV3ContextDataFromResponse(String response) {
        JSONObject responseJSON = ReferrerHandler.translateV3StringResponseToJSONObject(response);
        return ReferrerHandler.getDataFromJSON(responseJSON, CONTEXT_DATA_KEY);
    }

    protected static JSONObject translateV3StringResponseToJSONObject(String response) {
        JSONObject contextData;
        JSONObject responseObject;
        if (response == null || response.length() == 0) {
            return null;
        }
        try {
            responseObject = new JSONObject(response);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Analytics - Unable to parse response(%s)", ex.getLocalizedMessage());
            return null;
        }
        try {
            contextData = responseObject.getJSONObject(CONTEXT_DATA_KEY);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Analytics - Unable to parse acquisition service response (no contextData parameter in response)", new Object[0]);
            return null;
        }
        if (contextData == null) {
            StaticMethods.logDebugFormat("Analytics - Unable to parse acquisition service response (no contextData parameter in response)", new Object[0]);
            return null;
        }
        if (!contextData.has("a.referrer.campaign.name")) {
            StaticMethods.logDebugFormat("Analytics - Acquisition referrer data was not complete (no a.referrer.campaign.name in context data), ignoring", new Object[0]);
            return null;
        }
        StaticMethods.logDebugFormat("Analytics - Received Referrer Data(%s)", response);
        return responseObject;
    }

    protected static HashMap<String, Object> getDataFromJSON(JSONObject responseObject, String jsonKey) {
        JSONObject contextData;
        HashMap<String, Object> contextDataMap = new HashMap<String, Object>();
        if (responseObject == null) {
            return contextDataMap;
        }
        try {
            contextData = responseObject.getJSONObject(jsonKey);
        }
        catch (JSONException ex) {
            return contextDataMap;
        }
        if (contextData == null) {
            return contextDataMap;
        }
        Iterator keys = contextData.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            try {
                contextDataMap.put(key, contextData.getString(key));
            }
            catch (JSONException ex) {
                StaticMethods.logDebugFormat("Analytics - Unable to parse acquisition service response (the value for %s is not a string)", key);
            }
        }
        return contextDataMap;
    }

    protected static String getDeepLinkFromJSON(JSONObject responseObject) {
        String deepLink;
        JSONObject adobeData;
        if (responseObject == null) {
            return null;
        }
        try {
            adobeData = responseObject.getJSONObject(ADOBE_DATA_KEY);
        }
        catch (JSONException ex) {
            return null;
        }
        if (adobeData == null) {
            return null;
        }
        try {
            deepLink = adobeData.getString("a.acquisition.custom.link_deferred");
        }
        catch (JSONException ex) {
            return null;
        }
        return deepLink;
    }

    protected static String getReferrerDataFromV3Server(String ugid, String adid) {
        String responseString;
        if (!MobileConfig.getInstance().mobileReferrerConfigured()) {
            return null;
        }
        String url = ReferrerHandler.generateURLForV3(ugid, adid);
        StaticMethods.logDebugFormat("Analytics - Trying to fetch referrer data from (%s)", url);
        byte[] responseByteArray = RequestHandler.retrieveData(url, null, MobileConfig.getInstance().getReferrerTimeout(), "Analytics");
        if (responseByteArray == null) {
            return null;
        }
        try {
            responseString = new String(responseByteArray, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            StaticMethods.logErrorFormat("Analytics - Unable to decode response(%s)", ex.getLocalizedMessage());
            return null;
        }
        return responseString;
    }

    protected static String generateURLForV3(String ugid, String adid) {
        StringBuilder urlSb = new StringBuilder(64);
        MobileConfig mobileConfig = MobileConfig.getInstance();
        urlSb.append(String.format("https://%s/v3/%s/end", mobileConfig.getAcquisitionServer(), mobileConfig.getAcquisitionAppId()));
        StringBuilder querySb = new StringBuilder(64);
        if (ugid != null && ugid.length() > 0) {
            querySb.append(String.format("?a_ugid=%s", StaticMethods.URLEncode(ugid)));
        }
        if (adid != null && adid.length() > 0) {
            querySb.append(querySb.length() > 0 ? "&" : "?");
            querySb.append(String.format("a_cid=%s", StaticMethods.URLEncode(adid)));
        }
        return urlSb.append((CharSequence)querySb).toString();
    }

    static void processPlayInstallReferrerUrl(String referrerUrl) {
        if (ReferrerHandler.referrerInfoExists()) {
            return;
        }
        ReferrerHandler.processReferrerUrl(referrerUrl);
    }

    private static void processReferrerUrl(String referrerUrl) {
        if (StaticMethods.isNullOrEmpty(referrerUrl)) {
            StaticMethods.logDebugFormat("Analytics - Ignoring referrer due to the referrer Url being empty", new Object[0]);
            return;
        }
        StaticMethods.logDebugFormat("Analytics - Received referrer information (%s)", referrerUrl);
        HashMap<String, Object> referrerFields = ReferrerHandler.parseReferrerURLToMap(referrerUrl);
        if (ReferrerHandler.isV3Response(referrerFields)) {
            ReferrerHandler.handleV3Acquisition(referrerFields);
        } else {
            ReferrerHandler.handleGooglePlayAcquisition(referrerFields);
        }
    }

    private static boolean referrerInfoExists() {
        boolean referrerInfoExists = false;
        try {
            referrerInfoExists = StaticMethods.getSharedPreferences().contains("ADMS_Referrer_ContextData_Json_String");
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logDebugFormat("Analytics - Error reading referrer info from preferences (%s)", new Object[0]);
        }
        return referrerInfoExists;
    }
}

