/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.adobe.mobile.AnalyticsWorker;
import com.adobe.mobile.Config;
import com.adobe.mobile.Message;
import com.adobe.mobile.MessageFullScreen;
import com.adobe.mobile.MessageOpenURL;
import com.adobe.mobile.MessageTargetExperienceUIFullScreen;
import com.adobe.mobile.MessageTemplateCallback;
import com.adobe.mobile.MessageTemplatePii;
import com.adobe.mobile.Messages;
import com.adobe.mobile.MobileIdentities;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.PiiQueue;
import com.adobe.mobile.RemoteDownload;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.TargetPreviewManager;
import com.adobe.mobile.ThirdPartyQueue;
import com.adobe.mobile.WearableFunctionBridge;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class MobileConfig {
    private static final String JSON_CONFIG_ANALYTICS_KEY = "analytics";
    private static final String JSON_CONFIG_REMOTES_KEY = "remotes";
    private static final String JSON_CONFIG_REPORT_SUITES_KEY = "rsids";
    private static final String JSON_CONFIG_SERVER_KEY = "server";
    private static final String JSON_CONFIG_CHAR_SET_KEY = "charset";
    private static final String JSON_CONFIG_SSL_KEY = "ssl";
    private static final String JSON_CONFIG_OFFLINE_TRACKING_KEY = "offlineEnabled";
    private static final String JSON_CONFIG_BACKDATE_SESSION_INFO_KEY = "backdateSessionInfo";
    private static final String JSON_CONFIG_LIFECYCLE_TIMEOUT_KEY = "lifecycleTimeout";
    private static final String JSON_CONFIG_REFERRER_TIMEOUT_KEY = "referrerTimeout";
    private static final String JSON_CONFIG_BATCH_LIMIT_KEY = "batchLimit";
    private static final String JSON_CONFIG_PRIVACY_DEFAULT_KEY = "privacyDefault";
    private static final String JSON_CONFIG_POINTS_OF_INTEREST_KEY = "poi";
    private static final String JSON_CONFIG_POI_REMOTES_KEY = "analytics.poi";
    private static final String JSON_CONFIG_TARGET_KEY = "target";
    private static final String JSON_CONFIG_CLIENT_CODE_KEY = "clientCode";
    private static final String JSON_CONFIG_ENVIRONMENTID_KEY = "environmentId";
    private static final String JSON_CONFIG_SESSION_TIMEOUT_KEY = "sessionTimeout";
    private static final String JSON_CONFIG_TIMEOUT_KEY = "timeout";
    private static final String JSON_CONFIG_AAM_KEY = "audienceManager";
    private static final String JSON_CONFIG_MESSAGES_URL_KEY = "messages";
    private static final String JSON_CONFIG_MESSAGES_KEY = "messages";
    private static final String JSON_CONFIG_MARKETINGCLOUD_KEY = "marketingCloud";
    private static final String JSON_CONFIG_ORGID_KEY = "org";
    private static final String JSON_CONFIG_COOP_UNSAFE_KEY = "coopUnsafe";
    private static final String JSON_CONFIG_ACQUISITION_KEY = "acquisition";
    private static final String JSON_CONFIG_APP_IDENTIFIER_KEY = "appid";
    private static final String JSON_CONFIG_AAM_ANALYTICS_FORWARD_KEY = "analyticsForwardingEnabled";
    private static final String JSON_CONFIG_REACHABILITY_CHECKS_ENABLED_KEY = "reachabilityChecksEnabled";
    private static final String CONFIG_PRIVACY_OPTED_IN = "optedin";
    private static final String CONFIG_PRIVACY_OPTED_OUT = "optedout";
    private static final String CONFIG_PRIVACY_UNKNOWN = "optunknown";
    private static final String CONFIG_FILE_NAME = "ADBMobileConfig.json";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final boolean DEFAULT_SSL = true;
    private static final boolean DEFAULT_OFFLINE_TRACKING = false;
    private static final boolean DEFAULT_BACKDATE_SESSION_INFO = true;
    private static final int DEFAULT_LIFECYCLE_TIMEOUT = 300;
    private static final int DEFAULT_REFERRER_TIMEOUT = 0;
    private static final int DEFAULT_BATCH_LIMIT = 0;
    private static final MobilePrivacyStatus DEFAULT_PRIVACY_STATUS = MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN;
    private static final int DEFAULT_LOCATION_TIMEOUT = 2;
    private static final int DEFAULT_TARGET_SESSION_TIMEOUT_SECONDS = 1800;
    private static final int DEFAULT_AAM_TIMEOUT = 2;
    private static final boolean DEFAULT_AAM_ANALYTICS_FORWARD_ENABLED = false;
    private static final boolean DEFAULT_JSON_CONFIG_COOP_UNSAFE = false;
    private static final boolean DEFAULT_REACHABILITY_CHECKS_ENABLED = true;
    private boolean _networkConnectivity = false;
    private Config.AdobeDataCallback _adobeDataCallback = null;
    private boolean _reachabilityChecksEnabled = true;
    private String _reportSuiteIds = null;
    private String _trackingServer = null;
    private String _characterSet = "UTF-8";
    private boolean _ssl = true;
    private boolean _offlineTrackingEnabled = false;
    private boolean _backdateSessionInfoEnabled = true;
    private int _lifecycleTimeout = 300;
    private int _referrerTimeout = 0;
    private int _batchLimit = 0;
    private MobilePrivacyStatus _privacyStatus = DEFAULT_PRIVACY_STATUS;
    private List<List<Object>> _pointsOfInterest = null;
    private String _pointsOfInterestURL = null;
    private String _clientCode = null;
    private int _defaultLocationTimeout = 2;
    private long _environmentId = 0L;
    private int _targetSessionTimeout = 1800;
    private String _aamServer = null;
    private boolean _aamAnalyticsForwardingEnabled = false;
    private int _aamTimeout = 2;
    private String _acquisitionServer = null;
    private String _acquisitionAppIdentifier = null;
    private String _messagesURL = null;
    private ArrayList<Message> _inAppMessages = null;
    private ArrayList<Message> _callbackTemplates = null;
    private ArrayList<Message> _piiRequests = null;
    private String _marketingCloudOrganizationId = null;
    private String _marketingCloudServer = null;
    private boolean _marketingCloudCoopUnsafe = false;
    private static MobileConfig _instance = null;
    private static final Object _instanceMutex = new Object();
    private Boolean _usingAnalytics = null;
    private static final Object _usingAnalyticsMutex = new Object();
    private Boolean _usingGooglePlayServices = null;
    private static final Object _usingGooglePlayServicesMutex = new Object();
    private Boolean _usingAudienceManager = null;
    private static final Object _usingAudienceManagerMutex = new Object();
    private Boolean _usingTarget = null;
    private static final Object _usingTargetMutex = new Object();
    private static InputStream _userDefinedInputStream = null;
    private static final Object _userDefinedInputStreamMutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MobileConfig getInstance() {
        Object object = _instanceMutex;
        synchronized (object) {
            if (_instance == null) {
                _instance = new MobileConfig();
            }
            return _instance;
        }
    }

    private MobileConfig() {
        JSONObject configSettings = this.loadBundleConfig();
        if (configSettings == null) {
            return;
        }
        this._reachabilityChecksEnabled = configSettings.optBoolean(JSON_CONFIG_REACHABILITY_CHECKS_ENABLED_KEY, true);
        if (this._reachabilityChecksEnabled) {
            this.startNotifier();
        }
        JSONObject analyticsSettings = null;
        try {
            analyticsSettings = configSettings.getJSONObject(JSON_CONFIG_ANALYTICS_KEY);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Analytics - Not configured.", new Object[0]);
        }
        if (analyticsSettings != null) {
            block74: {
                try {
                    this._trackingServer = analyticsSettings.getString(JSON_CONFIG_SERVER_KEY);
                    this._reportSuiteIds = analyticsSettings.getString(JSON_CONFIG_REPORT_SUITES_KEY);
                }
                catch (JSONException e) {
                    this._trackingServer = null;
                    this._reportSuiteIds = null;
                    StaticMethods.logDebugFormat("Analytics - Not Configured.", new Object[0]);
                }
                try {
                    this._characterSet = analyticsSettings.getString(JSON_CONFIG_CHAR_SET_KEY);
                }
                catch (JSONException e) {
                    this._characterSet = DEFAULT_CHARSET;
                }
                try {
                    this._ssl = analyticsSettings.getBoolean(JSON_CONFIG_SSL_KEY);
                }
                catch (JSONException e) {
                    this._ssl = true;
                }
                try {
                    this._offlineTrackingEnabled = analyticsSettings.getBoolean(JSON_CONFIG_OFFLINE_TRACKING_KEY);
                }
                catch (JSONException e) {
                    this._offlineTrackingEnabled = false;
                }
                try {
                    this._backdateSessionInfoEnabled = analyticsSettings.getBoolean(JSON_CONFIG_BACKDATE_SESSION_INFO_KEY);
                }
                catch (JSONException e) {
                    this._backdateSessionInfoEnabled = true;
                }
                try {
                    this._lifecycleTimeout = analyticsSettings.getInt(JSON_CONFIG_LIFECYCLE_TIMEOUT_KEY);
                }
                catch (JSONException e) {
                    this._lifecycleTimeout = 300;
                }
                try {
                    this._referrerTimeout = analyticsSettings.getInt(JSON_CONFIG_REFERRER_TIMEOUT_KEY);
                }
                catch (JSONException e) {
                    this._referrerTimeout = 0;
                }
                try {
                    this._batchLimit = analyticsSettings.getInt(JSON_CONFIG_BATCH_LIMIT_KEY);
                }
                catch (JSONException e) {
                    this._batchLimit = 0;
                }
                try {
                    String privacyString;
                    if (StaticMethods.getSharedPreferences().contains("PrivacyStatus")) {
                        this._privacyStatus = MobilePrivacyStatus.values()[StaticMethods.getSharedPreferences().getInt("PrivacyStatus", 0)];
                        break block74;
                    }
                    try {
                        privacyString = analyticsSettings.getString(JSON_CONFIG_PRIVACY_DEFAULT_KEY);
                    }
                    catch (JSONException e) {
                        privacyString = null;
                    }
                    this._privacyStatus = privacyString != null ? this.privacyStatusFromString(privacyString) : DEFAULT_PRIVACY_STATUS;
                }
                catch (StaticMethods.NullContextException e) {
                    StaticMethods.logErrorFormat("Config - Error pulling privacy from shared preferences. (%s)", e.getMessage());
                    return;
                }
            }
            try {
                JSONArray poiArray = analyticsSettings.getJSONArray(JSON_CONFIG_POINTS_OF_INTEREST_KEY);
                this.loadPoiFromJsonArray(poiArray);
            }
            catch (JSONException e) {
                StaticMethods.logErrorFormat("Analytics - Malformed POI List(%s)", e.getLocalizedMessage());
            }
        }
        JSONObject targetSettings = null;
        try {
            targetSettings = configSettings.getJSONObject(JSON_CONFIG_TARGET_KEY);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Target - Not Configured.", new Object[0]);
        }
        if (targetSettings != null) {
            try {
                this._clientCode = targetSettings.getString(JSON_CONFIG_CLIENT_CODE_KEY);
            }
            catch (JSONException e) {
                this._clientCode = null;
                StaticMethods.logDebugFormat("Target - Not Configured.", new Object[0]);
            }
            try {
                this._defaultLocationTimeout = targetSettings.getInt(JSON_CONFIG_TIMEOUT_KEY);
            }
            catch (JSONException e) {
                this._defaultLocationTimeout = 2;
            }
            try {
                this._environmentId = targetSettings.getLong(JSON_CONFIG_ENVIRONMENTID_KEY);
            }
            catch (JSONException e) {
                this._environmentId = 0L;
            }
            try {
                this._targetSessionTimeout = targetSettings.getInt(JSON_CONFIG_SESSION_TIMEOUT_KEY);
                if (this._targetSessionTimeout < 0) {
                    this._targetSessionTimeout = 1800;
                }
            }
            catch (JSONException e) {
                this._targetSessionTimeout = 1800;
            }
        }
        JSONObject aamSettings = null;
        try {
            aamSettings = configSettings.getJSONObject(JSON_CONFIG_AAM_KEY);
        }
        catch (JSONException e) {
            StaticMethods.logDebugFormat("Audience Manager - Not Configured.", new Object[0]);
        }
        if (aamSettings != null) {
            try {
                this._aamServer = aamSettings.getString(JSON_CONFIG_SERVER_KEY);
            }
            catch (JSONException ex) {
                this._aamServer = null;
                StaticMethods.logDebugFormat("Audience Manager - Not Configured.", new Object[0]);
            }
            try {
                this._aamAnalyticsForwardingEnabled = aamSettings.getBoolean(JSON_CONFIG_AAM_ANALYTICS_FORWARD_KEY);
            }
            catch (JSONException ex) {
                this._aamAnalyticsForwardingEnabled = false;
            }
            if (this._aamAnalyticsForwardingEnabled) {
                StaticMethods.logDebugFormat("Audience Manager - Analytics Server-Side Forwarding Is Enabled.", new Object[0]);
            }
            try {
                this._aamTimeout = aamSettings.getInt(JSON_CONFIG_TIMEOUT_KEY);
            }
            catch (JSONException e) {
                this._aamTimeout = 2;
            }
        }
        JSONObject acquisitionSettings = null;
        try {
            acquisitionSettings = configSettings.getJSONObject(JSON_CONFIG_ACQUISITION_KEY);
        }
        catch (JSONException e) {
            StaticMethods.logDebugFormat("Acquisition - Not Configured.", new Object[0]);
        }
        if (acquisitionSettings != null) {
            try {
                this._acquisitionAppIdentifier = acquisitionSettings.getString(JSON_CONFIG_APP_IDENTIFIER_KEY);
                this._acquisitionServer = acquisitionSettings.getString(JSON_CONFIG_SERVER_KEY);
            }
            catch (JSONException ex) {
                this._acquisitionAppIdentifier = null;
                this._acquisitionServer = null;
                StaticMethods.logDebugFormat("Acquisition - Not configured correctly (missing server or app identifier).", new Object[0]);
            }
        }
        JSONObject remoteURLs = null;
        try {
            remoteURLs = configSettings.getJSONObject(JSON_CONFIG_REMOTES_KEY);
        }
        catch (JSONException e) {
            StaticMethods.logDebugFormat("Remotes - Not Configured.", new Object[0]);
        }
        if (remoteURLs != null) {
            try {
                this._messagesURL = remoteURLs.getString("messages");
            }
            catch (JSONException e) {
                StaticMethods.logDebugFormat("Config - No in-app messages remote url loaded (%s)", e.getLocalizedMessage());
            }
            try {
                this._pointsOfInterestURL = remoteURLs.getString(JSON_CONFIG_POI_REMOTES_KEY);
            }
            catch (JSONException e) {
                StaticMethods.logDebugFormat("Config - No points of interest remote url loaded (%s)", e.getLocalizedMessage());
            }
        }
        JSONArray jsonMessages = null;
        try {
            jsonMessages = configSettings.getJSONArray("messages");
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Not configured locally.", new Object[0]);
        }
        if (jsonMessages != null && jsonMessages.length() > 0) {
            this.loadMessagesFromJsonArray(jsonMessages);
        }
        JSONObject marketingCloudSettings = null;
        try {
            marketingCloudSettings = configSettings.getJSONObject(JSON_CONFIG_MARKETINGCLOUD_KEY);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Marketing Cloud - Not configured locally.", new Object[0]);
        }
        if (marketingCloudSettings != null) {
            try {
                this._marketingCloudOrganizationId = marketingCloudSettings.getString(JSON_CONFIG_ORGID_KEY);
            }
            catch (JSONException ex) {
                this._marketingCloudOrganizationId = null;
                StaticMethods.logDebugFormat("Visitor - ID Service Not Configured.", new Object[0]);
            }
            try {
                this._marketingCloudServer = marketingCloudSettings.getString(JSON_CONFIG_SERVER_KEY);
            }
            catch (JSONException ex) {
                this._marketingCloudServer = null;
                StaticMethods.logDebugFormat("Visitor ID Service - Custom endpoint not found in configuration, using default endpoint.", new Object[0]);
            }
            try {
                this._marketingCloudCoopUnsafe = marketingCloudSettings.getBoolean(JSON_CONFIG_COOP_UNSAFE_KEY);
            }
            catch (JSONException ex) {
                StaticMethods.logDebugFormat("Visitor - Coop Unsafe Not Configured.", new Object[0]);
            }
        }
        this.loadCachedRemotes();
        this.updateBlacklist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean mobileUsingAnalytics() {
        Object object = _usingAnalyticsMutex;
        synchronized (object) {
            if (this._usingAnalytics == null) {
                this._usingAnalytics = this.getReportSuiteIds() != null && this.getReportSuiteIds().length() > 0 && this.getTrackingServer() != null && this.getTrackingServer().length() > 0;
                if (!this._usingAnalytics.booleanValue()) {
                    StaticMethods.logDebugFormat("Analytics - Your config file is not set up to use Analytics(missing report suite id(s) or tracking server information)", new Object[0]);
                }
            }
            return this._usingAnalytics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean mobileUsingGooglePlayServices() {
        Object object = _usingGooglePlayServicesMutex;
        synchronized (object) {
            if (this._usingGooglePlayServices == null) {
                this._usingGooglePlayServices = WearableFunctionBridge.isGooglePlayServicesEnabled();
            }
            return this._usingGooglePlayServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean mobileUsingAudienceManager() {
        if (StaticMethods.isWearableApp()) {
            return false;
        }
        Object object = _usingAudienceManagerMutex;
        synchronized (object) {
            if (this._usingAudienceManager == null) {
                this._usingAudienceManager = this.getAamServer() != null && this.getAamServer().length() > 0;
                if (!this._usingAudienceManager.booleanValue()) {
                    StaticMethods.logDebugFormat("Audience Manager - Your config file is not set up to use Audience Manager(missing audience manager server information)", new Object[0]);
                }
            }
            return this._usingAudienceManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean mobileUsingTarget() {
        if (StaticMethods.isWearableApp()) {
            return false;
        }
        Object object = _usingTargetMutex;
        synchronized (object) {
            if (this._usingTarget == null) {
                this._usingTarget = this.getClientCode() != null && this.getClientCode().length() > 0;
                if (!this._usingTarget.booleanValue()) {
                    StaticMethods.logDebugFormat("Target Worker - Your config file is not set up to use Target(missing client code information)", new Object[0]);
                }
            }
            return this._usingTarget;
        }
    }

    protected boolean reachabilityChecksEnabled() {
        return this._reachabilityChecksEnabled;
    }

    protected boolean mobileReferrerConfigured() {
        return this._acquisitionServer != null && this._acquisitionAppIdentifier != null && this._acquisitionServer.length() > 0 && this._acquisitionAppIdentifier.length() > 0;
    }

    protected void setAdobeDataCallback(Config.AdobeDataCallback callback) {
        this._adobeDataCallback = callback;
    }

    protected void invokeAdobeDataCallback(Config.MobileDataEvent event, Map<String, Object> data) {
        if (this._adobeDataCallback == null) {
            StaticMethods.logDebugFormat("Config - A callback has not been registered for Adobe events.", new Object[0]);
            return;
        }
        if (data != null) {
            this._adobeDataCallback.call(event, new HashMap<String, Object>(data));
        } else {
            this._adobeDataCallback.call(event, null);
        }
    }

    protected String getReportSuiteIds() {
        return this._reportSuiteIds;
    }

    protected String getTrackingServer() {
        return this._trackingServer;
    }

    protected String getCharacterSet() {
        return this._characterSet;
    }

    protected boolean getSSL() {
        return this._ssl;
    }

    protected boolean getOfflineTrackingEnabled() {
        return this._offlineTrackingEnabled;
    }

    protected boolean getBackdateSessionInfoEnabled() {
        return this._backdateSessionInfoEnabled;
    }

    protected int getLifecycleTimeout() {
        return this._lifecycleTimeout;
    }

    protected int getBatchLimit() {
        return this._batchLimit;
    }

    protected void setPrivacyStatus(MobilePrivacyStatus status) {
        if (status == null) {
            return;
        }
        if (status == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_UNKNOWN && !this._offlineTrackingEnabled) {
            StaticMethods.logWarningFormat("Analytics - Cannot set privacy status to unknown when offline tracking is disabled", new Object[0]);
            return;
        }
        if (status == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
            StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    StaticMethods.logDebugFormat("Analytics - Privacy status set to opt in, attempting to send Analytics hits and postbacks in queue.", new Object[0]);
                    AnalyticsWorker.sharedInstance().kick(false);
                }
            });
            StaticMethods.getThirdPartyCallbacksExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    StaticMethods.logDebugFormat("Data Callback - Privacy status set to opt in, attempting to send all requests in queue", new Object[0]);
                    ThirdPartyQueue.sharedInstance().kick(false);
                }
            });
            StaticMethods.getPIIExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    StaticMethods.logDebugFormat("Pii Callback - Privacy status set to opt in, attempting to send all requests in queue", new Object[0]);
                    PiiQueue.sharedInstance().kick(false);
                }
            });
        }
        if (status == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
            StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    StaticMethods.logDebugFormat("Analytics - Privacy status set to opt out, purging database of Analytics requests and postbacks.", new Object[0]);
                    AnalyticsWorker.sharedInstance().clearTrackingQueue();
                }
            });
            StaticMethods.getThirdPartyCallbacksExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    StaticMethods.logDebugFormat("Data Callback - Privacy status set to opt out, attempting to clear queue of all requests", new Object[0]);
                    ThirdPartyQueue.sharedInstance().clearTrackingQueue();
                }
            });
            StaticMethods.getPIIExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    StaticMethods.logDebugFormat("PII - Privacy status set to opt out, attempting to clear queue of all requests.", new Object[0]);
                    PiiQueue.sharedInstance().clearTrackingQueue();
                }
            });
            MobileIdentities.resetAllIdentifiers();
        }
        this._privacyStatus = status;
        WearableFunctionBridge.syncPrivacyStatusToWearable(status.getValue());
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            editor.putInt("PrivacyStatus", status.getValue());
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Config - Error persisting privacy status (%s).", e.getMessage());
        }
    }

    protected MobilePrivacyStatus getPrivacyStatus() {
        return this._privacyStatus;
    }

    protected List<List<Object>> getPointsOfInterest() {
        return this._pointsOfInterest;
    }

    protected int getReferrerTimeout() {
        return this._referrerTimeout * 1000;
    }

    protected int getAnalyticsResponseType() {
        return this._aamAnalyticsForwardingEnabled ? 10 : 0;
    }

    protected String getClientCode() {
        return this._clientCode;
    }

    protected int getDefaultLocationTimeout() {
        return this._defaultLocationTimeout;
    }

    protected long getEnvironmentID() {
        return this._environmentId;
    }

    protected int getTargetSessionTimeout() {
        return this._targetSessionTimeout;
    }

    protected String getAamServer() {
        return this._aamServer;
    }

    protected boolean getAamAnalyticsForwardingEnabled() {
        return this._aamAnalyticsForwardingEnabled;
    }

    protected int getAamTimeout() {
        return this._aamTimeout;
    }

    protected String getAcquisitionAppId() {
        return this._acquisitionAppIdentifier;
    }

    protected String getAcquisitionServer() {
        return this._acquisitionServer;
    }

    protected void downloadRemoteConfigs() {
        StaticMethods.getMessagesExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (MobileConfig.this._messagesURL == null || MobileConfig.this._messagesURL.length() <= 0) {
                    MobileConfig.this.loadMessageImages();
                    return;
                }
                RemoteDownload.remoteDownloadSync(MobileConfig.this._messagesURL, new RemoteDownload.RemoteDownloadBlock(){

                    @Override
                    public void call(boolean modified, File file) {
                        MobileConfig.this.updateMessagesData(file);
                        MobileConfig.this.loadMessageImages();
                        MobileConfig.this.updateBlacklist();
                    }
                });
            }
        });
        StaticMethods.getThirdPartyCallbacksExecutor().execute(new Runnable(){

            @Override
            public void run() {
                FutureTask<Void> f = new FutureTask<Void>(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        return null;
                    }
                });
                StaticMethods.getMessagesExecutor().execute(f);
                try {
                    f.get();
                }
                catch (Exception e) {
                    StaticMethods.logErrorFormat("Data Callback - Error waiting for callbacks being loaded (%s)", e.getMessage());
                }
            }
        });
        StaticMethods.getPIIExecutor().execute(new Runnable(){

            @Override
            public void run() {
                FutureTask<Void> f = new FutureTask<Void>(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        return null;
                    }
                });
                StaticMethods.getMessagesExecutor().execute(f);
                try {
                    f.get();
                }
                catch (Exception e) {
                    StaticMethods.logErrorFormat("Pii Callback - Error waiting for callbacks being loaded (%s)", e.getMessage());
                }
            }
        });
        if (this._pointsOfInterestURL != null && this._pointsOfInterestURL.length() > 0) {
            RemoteDownload.remoteDownloadAsync(this._pointsOfInterestURL, new RemoteDownload.RemoteDownloadBlock(){

                @Override
                public void call(boolean modified, final File file) {
                    StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (file != null) {
                                StaticMethods.logDebugFormat("Config - Using remote definition for points of interest", new Object[0]);
                                MobileConfig.this.updatePOIData(file);
                            }
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void updateMessagesData(File file) {
        block23: {
            FileInputStream fis;
            block22: {
                fis = null;
                if (file != null) break block22;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    StaticMethods.logErrorFormat("Messages - Unable to close file stream (%s)", e.getLocalizedMessage());
                }
                return;
            }
            fis = new FileInputStream(file);
            JSONObject jsonData = this.loadConfigFromStream(fis);
            this.loadMessagesDataFromRemote(jsonData);
            try {
                if (fis != null) {
                    fis.close();
                }
                break block23;
            }
            catch (IOException e) {
                StaticMethods.logErrorFormat("Messages - Unable to close file stream (%s)", e.getLocalizedMessage());
            }
            break block23;
            catch (JSONException e) {
                StaticMethods.logErrorFormat("Messages - Unable to read messages remote config file, falling back to bundled messages (%s)", e.getLocalizedMessage());
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    break block23;
                }
                catch (IOException e2) {
                    StaticMethods.logErrorFormat("Messages - Unable to close file stream (%s)", e2.getLocalizedMessage());
                }
                break block23;
            }
            catch (IOException e2) {
                StaticMethods.logWarningFormat("Messages - Unable to open messages config file, falling back to bundled messages (%s)", e2.getLocalizedMessage());
                {
                    catch (Throwable throwable) {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException e3) {
                            StaticMethods.logErrorFormat("Messages - Unable to close file stream (%s)", e3.getLocalizedMessage());
                        }
                        throw throwable;
                    }
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e4) {
                    StaticMethods.logErrorFormat("Messages - Unable to close file stream (%s)", e4.getLocalizedMessage());
                }
            }
        }
    }

    protected void enableTargetPreviewMessage() {
        if (this._inAppMessages == null) {
            this._inAppMessages = new ArrayList();
        }
        MessageTargetExperienceUIFullScreen targetPreviewMessage = TargetPreviewManager.getInstance().getMessageTargetExperienceUIFullscreen();
        MessageFullScreen messageFullScreen = Messages.getFullScreenMessageById(targetPreviewMessage.messageId);
        if (messageFullScreen == null) {
            this._inAppMessages.add(targetPreviewMessage);
        }
    }

    protected void disableTargetPreviewMessage() {
        if (this._inAppMessages == null) {
            return;
        }
        MessageTargetExperienceUIFullScreen targetPreviewMessage = TargetPreviewManager.getInstance().getMessageTargetExperienceUIFullscreen();
        Iterator<Message> messageIterator = this._inAppMessages.iterator();
        while (messageIterator.hasNext()) {
            Message message = messageIterator.next();
            if (!message.messageId.equalsIgnoreCase(targetPreviewMessage.messageId)) continue;
            messageIterator.remove();
            break;
        }
    }

    protected String getPointsOfInterestURL() {
        return this._pointsOfInterestURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void updatePOIData(File file) {
        block24: {
            FileInputStream fis;
            block23: {
                block22: {
                    fis = null;
                    if (file != null) break block22;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        StaticMethods.logErrorFormat("Config - Unable to close file stream (%s)", e.getLocalizedMessage());
                    }
                    return;
                }
                fis = new FileInputStream(file);
                JSONObject jsonData = this.loadConfigFromStream(fis);
                if (jsonData == null) break block23;
                JSONObject analytics = jsonData.getJSONObject(JSON_CONFIG_ANALYTICS_KEY);
                JSONArray poiArray = analytics.getJSONArray(JSON_CONFIG_POINTS_OF_INTEREST_KEY);
                this.loadPoiFromJsonArray(poiArray);
            }
            try {
                if (fis != null) {
                    fis.close();
                }
                break block24;
            }
            catch (IOException e) {
                StaticMethods.logErrorFormat("Config - Unable to close file stream (%s)", e.getLocalizedMessage());
            }
            break block24;
            catch (JSONException ex) {
                StaticMethods.logErrorFormat("Config - Unable to read points of interest remote config file, falling back to bundled poi (%s)", ex.getLocalizedMessage());
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    break block24;
                }
                catch (IOException e) {
                    StaticMethods.logErrorFormat("Config - Unable to close file stream (%s)", e.getLocalizedMessage());
                }
                break block24;
            }
            catch (IOException ex2) {
                StaticMethods.logWarningFormat("Config - Unable to open points of interest config file, falling back to bundled poi (%s)", ex2.getLocalizedMessage());
                {
                    catch (Throwable throwable) {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException e) {
                            StaticMethods.logErrorFormat("Config - Unable to close file stream (%s)", e.getLocalizedMessage());
                        }
                        throw throwable;
                    }
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    StaticMethods.logErrorFormat("Config - Unable to close file stream (%s)", e.getLocalizedMessage());
                }
            }
        }
    }

    protected ArrayList<Message> getInAppMessages() {
        return this._inAppMessages;
    }

    protected String getInAppMessageURL() {
        return this._messagesURL;
    }

    protected ArrayList<Message> getCallbackTemplates() {
        return this._callbackTemplates;
    }

    protected ArrayList<Message> getPiiRequests() {
        return this._piiRequests;
    }

    protected String getMarketingCloudOrganizationId() {
        return this._marketingCloudOrganizationId;
    }

    protected String getMarketingCloudCustomServer() {
        return this._marketingCloudServer;
    }

    protected boolean getMarketingCloudCoopUnsafe() {
        return this._marketingCloudCoopUnsafe;
    }

    protected boolean getVisitorIdServiceEnabled() {
        return this._marketingCloudOrganizationId != null && this._marketingCloudOrganizationId.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject loadBundleConfig() {
        InputStream userPath;
        JSONObject jsonData = null;
        Object object = _userDefinedInputStreamMutex;
        synchronized (object) {
            userPath = _userDefinedInputStream;
        }
        try {
            if (userPath != null) {
                StaticMethods.logDebugFormat("Config - Attempting to load config file from override stream", new Object[0]);
                jsonData = this.loadConfigFromStream(userPath);
            }
        }
        catch (IOException e) {
            StaticMethods.logDebugFormat("Config - Error loading user defined config (%s)", e.getMessage());
        }
        catch (JSONException e) {
            StaticMethods.logDebugFormat("Config - Error parsing user defined config (%s)", e.getMessage());
        }
        if (jsonData == null) {
            if (userPath != null) {
                StaticMethods.logDebugFormat("Config - Failed attempting to load custom config, will fall back to standard config location.", new Object[0]);
            }
            StaticMethods.logDebugFormat("Config - Attempting to load config file from default location", new Object[0]);
            jsonData = this.loadConfigFile(CONFIG_FILE_NAME);
            if (jsonData == null) {
                StaticMethods.logDebugFormat("Config - Could not find config file at expected location.  Attempting to load from www folder", new Object[0]);
                jsonData = this.loadConfigFile("www" + File.separator + CONFIG_FILE_NAME);
            }
        }
        return jsonData;
    }

    private JSONObject loadConfigFile(String configFilePath) {
        JSONObject jsonData = null;
        try {
            Resources resources = StaticMethods.getSharedContext().getResources();
            if (resources == null) {
                return null;
            }
            AssetManager assets = resources.getAssets();
            if (assets == null) {
                return null;
            }
            jsonData = this.loadConfigFromStream(assets.open(configFilePath));
        }
        catch (IOException e) {
            StaticMethods.logErrorFormat("Config - Exception loading config file (%s)", e.getMessage());
        }
        catch (JSONException e) {
            StaticMethods.logErrorFormat("Config - Exception parsing config file (%s)", e.getMessage());
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Config - Null context when attempting to read config file (%s)", e.getMessage());
        }
        return jsonData;
    }

    protected void loadCachedRemotes() {
        if (this._messagesURL != null && this._messagesURL.length() > 0) {
            this.updateMessagesData(RemoteDownload.getFileForCachedURL(this._messagesURL));
        }
        if (this._pointsOfInterestURL != null && this._pointsOfInterestURL.length() > 0) {
            this.updatePOIData(RemoteDownload.getFileForCachedURL(this._pointsOfInterestURL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private JSONObject loadConfigFromStream(InputStream stream) throws JSONException, IOException {
        if (stream == null) {
            return null;
        }
        byte[] data = new byte[stream.available()];
        stream.read(data);
        String jsonString = new String(data, DEFAULT_CHARSET);
        JSONObject jSONObject = new JSONObject(jsonString);
        try {
            stream.close();
        }
        catch (IOException e) {
            StaticMethods.logErrorFormat("Config - Unable to close stream (%s)", e.getMessage());
        }
        return jSONObject;
        catch (IOException e) {
            StaticMethods.logErrorFormat("Config - Exception when reading config (%s)", e.getMessage());
            try {
                stream.close();
            }
            catch (IOException e2) {
                StaticMethods.logErrorFormat("Config - Unable to close stream (%s)", e2.getMessage());
            }
        }
        catch (NullPointerException e2) {
            StaticMethods.logErrorFormat("Config - Stream closed when attempting to load config (%s)", e2.getMessage());
            {
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException e3) {
                        StaticMethods.logErrorFormat("Config - Unable to close stream (%s)", e3.getMessage());
                    }
                    throw throwable;
                }
            }
            try {
                stream.close();
            }
            catch (IOException e4) {
                StaticMethods.logErrorFormat("Config - Unable to close stream (%s)", e4.getMessage());
            }
        }
        return new JSONObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserDefinedConfigPath(InputStream stream) {
        Object object = _userDefinedInputStreamMutex;
        synchronized (object) {
            if (_userDefinedInputStream == null) {
                _userDefinedInputStream = stream;
            }
        }
    }

    private MobilePrivacyStatus privacyStatusFromString(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase(CONFIG_PRIVACY_OPTED_IN)) {
                return MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN;
            }
            if (string.equalsIgnoreCase(CONFIG_PRIVACY_OPTED_OUT)) {
                return MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT;
            }
            if (string.equalsIgnoreCase(CONFIG_PRIVACY_UNKNOWN)) {
                return MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_UNKNOWN;
            }
        }
        return DEFAULT_PRIVACY_STATUS;
    }

    private void loadPoiFromJsonArray(JSONArray poiArray) {
        if (poiArray == null) {
            return;
        }
        try {
            this._pointsOfInterest = new ArrayList<List<Object>>();
            int count = poiArray.length();
            for (int i = 0; i < count; ++i) {
                JSONArray singlePOI = poiArray.getJSONArray(i);
                ArrayList<Object> singlePoint = new ArrayList<Object>(4);
                singlePoint.add(singlePOI.getString(0));
                singlePoint.add(singlePOI.getDouble(1));
                singlePoint.add(singlePOI.getDouble(2));
                singlePoint.add(singlePOI.getDouble(3));
                this._pointsOfInterest.add(singlePoint);
            }
        }
        catch (JSONException ex) {
            StaticMethods.logErrorFormat("Messages - Unable to parse remote points of interest JSON (%s)", ex.getMessage());
        }
    }

    private void loadMessagesDataFromRemote(JSONObject jsonData) {
        if (jsonData == null) {
            StaticMethods.logDebugFormat("Messages - Remote messages config was null, falling back to bundled messages", new Object[0]);
            RemoteDownload.deleteFilesInDirectory("messageImages");
            return;
        }
        JSONArray jsonMessages = null;
        try {
            jsonMessages = jsonData.getJSONArray("messages");
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Remote messages not configured, falling back to bundled messages", new Object[0]);
        }
        StaticMethods.logDebugFormat("Messages - Using remote definition for messages", new Object[0]);
        if (jsonMessages == null || jsonMessages.length() <= 0) {
            RemoteDownload.deleteFilesInDirectory("messageImages");
            this._inAppMessages = null;
            this._callbackTemplates = null;
            this._piiRequests = null;
            return;
        }
        this.loadMessagesFromJsonArray(jsonMessages);
    }

    private void loadMessagesFromJsonArray(JSONArray messages) {
        try {
            ArrayList<Message> tempInAppMessages = new ArrayList<Message>();
            ArrayList<Message> tempCallbackTemplates = new ArrayList<Message>();
            ArrayList<Message> tempPiiRequests = new ArrayList<Message>();
            int messageCount = messages.length();
            for (int i = 0; i < messageCount; ++i) {
                JSONObject messageJson = messages.getJSONObject(i);
                Message message = Message.messageWithJsonObject(messageJson);
                if (message == null) continue;
                StaticMethods.logDebugFormat("Messages - loaded message - %s", message.description());
                if (message.getClass() == MessageTemplatePii.class) {
                    tempPiiRequests.add(message);
                    continue;
                }
                if (message.getClass() == MessageTemplateCallback.class || message.getClass() == MessageOpenURL.class) {
                    tempCallbackTemplates.add(message);
                    continue;
                }
                tempInAppMessages.add(message);
            }
            this._inAppMessages = tempInAppMessages;
            this._callbackTemplates = tempCallbackTemplates;
            this._piiRequests = tempPiiRequests;
        }
        catch (JSONException e) {
            StaticMethods.logErrorFormat("Messages - Unable to parse messages JSON (%s)", e.getMessage());
        }
    }

    private void updateBlacklist() {
        HashMap<String, Integer> blackList;
        if (this._inAppMessages != null) {
            for (Message message : this._inAppMessages) {
                blackList = message.loadBlacklist();
                if (!message.isBlacklisted() || message.showRule.getValue() == blackList.get(message.messageId).intValue()) continue;
                message.removeFromBlacklist();
            }
        }
        if (this._callbackTemplates != null) {
            for (Message message : this._callbackTemplates) {
                blackList = message.loadBlacklist();
                if (!message.isBlacklisted() || message.showRule.getValue() == blackList.get(message.messageId).intValue()) continue;
                message.removeFromBlacklist();
            }
        }
    }

    private void loadMessageImages() {
        StaticMethods.getMessageImageCachingExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (MobileConfig.this._inAppMessages == null || MobileConfig.this._inAppMessages.size() <= 0) {
                    RemoteDownload.deleteFilesInDirectory("messageImages");
                    return;
                }
                ArrayList<String> assetUrls = new ArrayList<String>();
                for (Message message : MobileConfig.this._inAppMessages) {
                    if (message.assets == null || message.assets.size() <= 0) continue;
                    for (ArrayList<String> currentAssetArray : message.assets) {
                        if (currentAssetArray.size() <= 0) continue;
                        for (String currentAsset : currentAssetArray) {
                            assetUrls.add(currentAsset);
                            RemoteDownload.remoteDownloadSync(currentAsset, 10000, 10000, null, "messageImages");
                        }
                    }
                }
                if (assetUrls.size() > 0) {
                    RemoteDownload.deleteFilesForDirectoryNotInList("messageImages", assetUrls);
                } else {
                    RemoteDownload.deleteFilesInDirectory("messageImages");
                }
            }
        });
    }

    protected boolean networkConnectivity() {
        return StaticMethods.isWearableApp() || this._networkConnectivity;
    }

    protected void startNotifier() {
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        Context appCtx = null;
        try {
            appCtx = StaticMethods.getSharedContext().getApplicationContext();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Analytics - Error registering network receiver (%s)", e.getMessage());
        }
        if (appCtx == null) {
            return;
        }
        appCtx.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                MobileConfig.this._networkConnectivity = MobileConfig.this.getNetworkConnectivity(context);
                if (MobileConfig.this._networkConnectivity) {
                    StaticMethods.getAnalyticsExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            StaticMethods.logDebugFormat("Analytics - Network status changed (reachable)", new Object[0]);
                            AnalyticsWorker.sharedInstance().kick(false);
                        }
                    });
                } else {
                    StaticMethods.logDebugFormat("Analytics - Network status changed (unreachable)", new Object[0]);
                }
            }
        }, filter);
    }

    protected boolean getNetworkConnectivity(Context context) {
        boolean tempNetworkConnectivity = true;
        try {
            if (context != null) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager != null) {
                    NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                    if (activeNetworkInfo != null) {
                        tempNetworkConnectivity = activeNetworkInfo.isAvailable() && activeNetworkInfo.isConnected();
                    } else {
                        tempNetworkConnectivity = false;
                        StaticMethods.logWarningFormat("Analytics - Unable to determine connectivity status due to there being no default network currently active", new Object[0]);
                    }
                } else {
                    StaticMethods.logWarningFormat("Analytics - Unable to determine connectivity status due to the system service requested being unrecognized", new Object[0]);
                }
            }
        }
        catch (NullPointerException e) {
            StaticMethods.logWarningFormat("Analytics - Unable to determine connectivity status due to an unexpected error (%s)", e.getLocalizedMessage());
        }
        catch (SecurityException e) {
            StaticMethods.logErrorFormat("Analytics - Unable to access connectivity status due to a security error (%s)", e.getLocalizedMessage());
        }
        catch (Exception e) {
            StaticMethods.logWarningFormat("Analytics - Unable to access connectivity status due to an unexpected error (%s)", e.getLocalizedMessage());
        }
        return tempNetworkConnectivity;
    }
}

