/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.adobe.mobile.Message;
import com.adobe.mobile.MessageNotificationHandler;
import com.adobe.mobile.Messages;
import com.adobe.mobile.StaticMethods;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

final class MessageLocalNotification
extends Message {
    protected String content;
    protected String deeplink;
    protected String userInfo;
    protected Integer localNotificationDelay;
    private static final String JSON_CONFIG_CONTENT = "content";
    private static final String JSON_CONFIG_WAIT = "wait";

    MessageLocalNotification() {
    }

    @Override
    protected boolean initWithPayloadObject(JSONObject dictionary) {
        JSONObject jsonPayload;
        if (dictionary == null || dictionary.length() <= 0) {
            return false;
        }
        if (!super.initWithPayloadObject(dictionary)) {
            return false;
        }
        StaticMethods.logDebugFormat("Messages -  Building Local Notification message.", new Object[0]);
        try {
            jsonPayload = dictionary.getJSONObject("payload");
            if (jsonPayload.length() <= 0) {
                StaticMethods.logDebugFormat("Messages - Unable to create local notification message \"%s\", payload is empty", this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Unable to create local notification message \"%s\", payload is required", this.messageId);
            return false;
        }
        try {
            this.content = jsonPayload.getString(JSON_CONFIG_CONTENT);
            if (this.content.length() <= 0) {
                StaticMethods.logDebugFormat("Messages - Unable to create local notification message \"%s\", content is empty", this.messageId);
                return false;
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Unable to create local notification message \"%s\", content is required", this.messageId);
            return false;
        }
        try {
            this.localNotificationDelay = jsonPayload.getInt(JSON_CONFIG_WAIT);
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Unable to create local notification message \"%s\", localNotificationDelay is required", this.messageId);
            return false;
        }
        try {
            this.deeplink = jsonPayload.getString("adb_deeplink");
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Tried to read deeplink for local notification message but found none.  This is not a required field", new Object[0]);
        }
        try {
            this.userInfo = jsonPayload.getJSONObject("userData").toString();
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Messages - Tried to read userData for local notification message but found none.  This is not a required field", new Object[0]);
        }
        catch (NullPointerException ex) {
            StaticMethods.logDebugFormat("Messages - Tried to read userData for local notification message but found none.  This is not a required field", new Object[0]);
        }
        StaticMethods.logDebugFormat("Message created with: \n MessageID: \"%s\" \n Content: \"%s\" \n Delay: \"%d\" \n Deeplink: \"%s\" \n User Data: \"%s\"", this.messageId, this.content, this.localNotificationDelay, this.deeplink, this.userInfo);
        return true;
    }

    @Override
    protected void show() {
        Activity currentActivity;
        super.show();
        this.messageTriggered();
        try {
            currentActivity = StaticMethods.getCurrentActivity();
        }
        catch (StaticMethods.NullActivityException ex) {
            StaticMethods.logErrorFormat(ex.getMessage(), new Object[0]);
            return;
        }
        int requestCode = new SecureRandom().nextInt();
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, this.localNotificationDelay);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setClass((Context)currentActivity, MessageNotificationHandler.class);
        intent.putExtra("adbMessageCode", (Serializable)Messages.MESSAGE_LOCAL_IDENTIFIER);
        intent.putExtra("adb_m_l_id", this.messageId);
        intent.putExtra("requestCode", requestCode);
        intent.putExtra("userData", this.userInfo);
        intent.putExtra("adb_deeplink", this.deeplink);
        intent.putExtra("alarm_message", this.content);
        try {
            PendingIntent sender = PendingIntent.getBroadcast((Context)StaticMethods.getSharedContext(), (int)requestCode, (Intent)intent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)StaticMethods.getSharedContext().getSystemService("alarm");
            alarmManager.set(0, calendar.getTimeInMillis(), sender);
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Messaging - Error scheduling local notification (%s)", e.getMessage());
        }
    }
}

