/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.adobe.mobile.AdobeMarketingActivity;
import com.adobe.mobile.MessageFullScreen;
import com.adobe.mobile.Messages;
import com.adobe.mobile.StaticMethods;

public class MessageFullScreenActivity
extends AdobeMarketingActivity {
    protected MessageFullScreen message;
    protected static final String MESSAGE_STATE_MESSAGE_ID = "MessageFullScreenActivity.messageId";
    protected static final String MESSAGE_STATE_REPLACED_HTML = "MessageFullScreenActivity.replacedHtml";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.message = this.restoreFromSavedState(savedInstanceState);
            Messages.setCurrentMessageFullscreen(this.message);
        } else {
            this.message = Messages.getCurrentFullscreenMessage();
        }
        if (!this.messageIsValid()) {
            return;
        }
        this.message.messageFullScreenActivity = this;
        this.requestWindowFeature(1);
        RelativeLayout relativeLayout = new RelativeLayout((Context)this);
        this.setContentView((View)relativeLayout);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (!this.messageIsValid()) {
            return;
        }
        try {
            final ViewGroup rootViewGroup = (ViewGroup)this.findViewById(0x1020002);
            if (rootViewGroup == null) {
                StaticMethods.logErrorFormat("Messages - unable to get root view group from os", new Object[0]);
                this.finish();
                this.overridePendingTransition(0, 0);
            } else {
                rootViewGroup.post(new Runnable(){

                    @Override
                    public void run() {
                        MessageFullScreenActivity.this.message.rootViewGroup = rootViewGroup;
                        MessageFullScreenActivity.this.message.showInRootViewGroup();
                    }
                });
            }
        }
        catch (NullPointerException ex) {
            StaticMethods.logWarningFormat("Messages - content view is in undefined state (%s)", ex.getMessage());
            this.finish();
            this.overridePendingTransition(0, 0);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putString(MESSAGE_STATE_MESSAGE_ID, this.message.messageId);
        outState.putString(MESSAGE_STATE_REPLACED_HTML, this.message.replacedHtml);
        super.onSaveInstanceState(outState);
    }

    public void onBackPressed() {
        if (this.message != null) {
            this.message.isVisible = false;
            this.message.viewed();
        }
        this.finish();
        this.overridePendingTransition(0, 0);
    }

    private boolean messageIsValid() {
        if (this.message == null) {
            StaticMethods.logWarningFormat("Messages - unable to display fullscreen message, message is undefined", new Object[0]);
            Messages.setCurrentMessage(null);
            this.finish();
            this.overridePendingTransition(0, 0);
            return false;
        }
        return true;
    }

    private MessageFullScreen restoreFromSavedState(Bundle savedInstanceState) {
        String messageId = savedInstanceState.getString(MESSAGE_STATE_MESSAGE_ID);
        MessageFullScreen message = Messages.getFullScreenMessageById(messageId);
        if (message != null) {
            message.replacedHtml = savedInstanceState.getString(MESSAGE_STATE_REPLACED_HTML);
        }
        return message;
    }
}

