/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.Context;
import android.content.SharedPreferences;
import com.adobe.mobile.Config;
import com.adobe.mobile.GoogleApiClientWrapper;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.RemoteDownload;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.VisitorIDService;
import com.adobe.mobile.WearableDataConnection;
import com.adobe.mobile.WearableDataRequest;
import com.adobe.mobile.WearableDataResponse;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataMapRequest;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.Wearable;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class ConfigSynchronizer {
    private static final Object _handheldInstallDateMutex = new Object();
    private static final Object _aidMutex = new Object();
    private static final Object _visitorIDMutex = new Object();
    private static final Object _pushEnabledMutex = new Object();
    private static final Object _adiDMutex = new Object();
    private static final Object _visServiceMutex = new Object();
    private static final Object _privacyStatusMutex = new Object();

    ConfigSynchronizer() {
    }

    protected static void syncVisitorID(String vid) {
        if (StaticMethods.isWearableApp()) {
            return;
        }
        DataMap dataMap = new DataMap();
        dataMap.putString("APP_MEASUREMENT_VISITOR_ID", vid);
        ConfigSynchronizer.syncData("/abdmobile/data/config/visitorId", dataMap);
    }

    protected static void syncAdvertisingIdentifier(String adid) {
        if (StaticMethods.isWearableApp()) {
            return;
        }
        DataMap dataMap = new DataMap();
        dataMap.putString("ADOBEMOBILE_STOREDDEFAULTS_ADVERTISING_IDENTIFIER", adid);
        ConfigSynchronizer.syncData("/abdmobile/data/config/adId", dataMap);
    }

    protected static void syncPushEnabled(boolean enabled) {
        if (StaticMethods.isWearableApp()) {
            return;
        }
        DataMap dataMap = new DataMap();
        dataMap.putBoolean("ADBMOBILE_KEY_PUSH_ENABLED", enabled);
        ConfigSynchronizer.syncData("/abdmobile/data/config/pushEnabled", dataMap);
    }

    protected static void syncVidService(String mid, String hint, String blob, long ssl, long lastSync, String customerIDs) {
        if (StaticMethods.isWearableApp()) {
            return;
        }
        DataMap dataMap = new DataMap();
        dataMap.putString("ADBMOBILE_PERSISTED_MID", mid);
        dataMap.putString("ADBMOBILE_PERSISTED_MID_BLOB", blob);
        dataMap.putString("ADBMOBILE_PERSISTED_MID_HINT", hint);
        dataMap.putLong("ADBMOBILE_VISITORID_TTL", ssl);
        dataMap.putLong("ADBMOBILE_VISITORID_SYNC", lastSync);
        dataMap.putString("ADBMOBILE_VISITORID_IDS", customerIDs);
        ConfigSynchronizer.syncData("/abdmobile/data/config/vidService", dataMap);
    }

    protected static void syncPrivacyStatus(int privacyStatus) {
        if (StaticMethods.isWearableApp()) {
            return;
        }
        DataMap dataMap = new DataMap();
        dataMap.putInt("PrivacyStatus", privacyStatus);
        ConfigSynchronizer.syncData("/abdmobile/data/config/privacyStatus", dataMap);
    }

    protected static void syncData(String path, DataMap dataMap) {
        GoogleApiClient mGoogleApiClient;
        if (path == null || path.isEmpty() || !path.startsWith("/") || path.startsWith("/", 1)) {
            StaticMethods.logWarningFormat("Wearable - syncData: path is invalid (should not be null/empty and should start with single /), actual %s", path);
            return;
        }
        try {
            mGoogleApiClient = new GoogleApiClient.Builder(StaticMethods.getSharedContext()).addApi(Wearable.API).build();
        }
        catch (StaticMethods.NullContextException e) {
            return;
        }
        GoogleApiClientWrapper.connect(mGoogleApiClient);
        ConnectionResult connectionResult = GoogleApiClientWrapper.blockingConnect(mGoogleApiClient, 15000L, TimeUnit.MILLISECONDS);
        if (connectionResult == null || !connectionResult.isSuccess()) {
            StaticMethods.logWarningFormat("Wearable - Failed to setup connection", new Object[0]);
            return;
        }
        PutDataMapRequest dataMapRequest = PutDataMapRequest.create((String)path);
        dataMapRequest.getDataMap().putAll(dataMap);
        PutDataRequest request = dataMapRequest.asPutDataRequest();
        Wearable.DataApi.putDataItem(mGoogleApiClient, request);
    }

    protected static DataMap getSharedConfig() {
        DataMap dataMap = new DataMap();
        try {
            dataMap.putLong("ADMS_InstallDate", StaticMethods.getSharedPreferences().getLong("ADMS_InstallDate", 0L));
            dataMap.putBoolean("ADOBEMOBILE_STOREDDEFAULTS_IGNORE_AID", StaticMethods.getSharedPreferences().getBoolean("ADOBEMOBILE_STOREDDEFAULTS_IGNORE_AID", false));
            dataMap.putString("ADOBEMOBILE_STOREDDEFAULTS_AID", StaticMethods.getSharedPreferences().getString("ADOBEMOBILE_STOREDDEFAULTS_AID", null));
            dataMap.putBoolean("ADOBEMOBILE_STOREDDEFAULTS_AID_SYNCED", StaticMethods.getSharedPreferences().getBoolean("ADOBEMOBILE_STOREDDEFAULTS_AID_SYNCED", false));
            dataMap.putString("APP_MEASUREMENT_VISITOR_ID", StaticMethods.getSharedPreferences().getString("APP_MEASUREMENT_VISITOR_ID", null));
            dataMap.putString("ADOBEMOBILE_STOREDDEFAULTS_ADVERTISING_IDENTIFIER", StaticMethods.getSharedPreferences().getString("ADOBEMOBILE_STOREDDEFAULTS_ADVERTISING_IDENTIFIER", null));
            dataMap.putBoolean("ADBMOBILE_KEY_PUSH_ENABLED", StaticMethods.getSharedPreferences().getBoolean("ADBMOBILE_KEY_PUSH_ENABLED", false));
            dataMap.putString("ADBMOBILE_PERSISTED_MID", StaticMethods.getSharedPreferences().getString("ADBMOBILE_PERSISTED_MID", null));
            dataMap.putString("ADBMOBILE_PERSISTED_MID_HINT", StaticMethods.getSharedPreferences().getString("ADBMOBILE_PERSISTED_MID_HINT", null));
            dataMap.putString("ADBMOBILE_PERSISTED_MID_BLOB", StaticMethods.getSharedPreferences().getString("ADBMOBILE_PERSISTED_MID_BLOB", null));
            dataMap.putLong("ADBMOBILE_VISITORID_TTL", StaticMethods.getSharedPreferences().getLong("ADBMOBILE_VISITORID_TTL", 0L));
            dataMap.putLong("ADBMOBILE_VISITORID_SYNC", StaticMethods.getSharedPreferences().getLong("ADBMOBILE_VISITORID_SYNC", 0L));
            dataMap.putString("ADBMOBILE_VISITORID_IDS", StaticMethods.getSharedPreferences().getString("ADBMOBILE_VISITORID_IDS", null));
            if (StaticMethods.getSharedPreferences().contains("PrivacyStatus")) {
                dataMap.putInt("PrivacyStatus", StaticMethods.getSharedPreferences().getInt("PrivacyStatus", 0));
            }
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Wearable - Error getting shared preferences", new Object[0]);
        }
        return dataMap;
    }

    protected static void restoreSharedConfig(DataMap dataMap) {
        ConfigSynchronizer.restoreHandheldInstallDate(dataMap);
        ConfigSynchronizer.restorePrivacyStatus(dataMap);
        ConfigSynchronizer.restoreVisitorID(dataMap);
        ConfigSynchronizer.restoreVidService(dataMap);
        ConfigSynchronizer.restoreAid(dataMap);
        ConfigSynchronizer.restoreAdid(dataMap);
        ConfigSynchronizer.restorePushEnabled(dataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreHandheldInstallDate(DataMap dataMap) {
        Object object = _handheldInstallDateMutex;
        synchronized (object) {
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                if (dataMap.containsKey("ADMS_InstallDate")) {
                    editor.putLong("ADMS_Handheld_App_InstallDate", dataMap.getLong("ADMS_InstallDate", 0L));
                }
                editor.commit();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Wearable - Error saving Handheld App install date to shared preferences", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreAid(DataMap dataMap) {
        Object object = _aidMutex;
        synchronized (object) {
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.putBoolean("ADOBEMOBILE_STOREDDEFAULTS_IGNORE_AID", dataMap.getBoolean("ADOBEMOBILE_STOREDDEFAULTS_IGNORE_AID"));
                editor.putString("ADOBEMOBILE_STOREDDEFAULTS_AID", dataMap.getString("ADOBEMOBILE_STOREDDEFAULTS_AID"));
                editor.putBoolean("ADOBEMOBILE_STOREDDEFAULTS_AID_SYNCED", dataMap.getBoolean("ADOBEMOBILE_STOREDDEFAULTS_AID_SYNCED"));
                editor.commit();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Wearable - Error saving Aid data to shared preferences", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreVisitorID(DataMap dataMap) {
        Object object = _visitorIDMutex;
        synchronized (object) {
            Config.setUserIdentifier(dataMap.getString("APP_MEASUREMENT_VISITOR_ID"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restorePushEnabled(DataMap dataMap) {
        Object object = _pushEnabledMutex;
        synchronized (object) {
            StaticMethods.setPushEnabled(dataMap.getBoolean("ADBMOBILE_KEY_PUSH_ENABLED"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreAdid(final DataMap dataMap) {
        Object object = _adiDMutex;
        synchronized (object) {
            Callable<String> task = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return dataMap.getString("ADOBEMOBILE_STOREDDEFAULTS_ADVERTISING_IDENTIFIER");
                }
            };
            Config.submitAdvertisingIdentifierTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreVidService(DataMap dataMap) {
        Object object = _visServiceMutex;
        synchronized (object) {
            try {
                SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
                editor.putString("ADBMOBILE_PERSISTED_MID", dataMap.getString("ADBMOBILE_PERSISTED_MID"));
                editor.putString("ADBMOBILE_PERSISTED_MID_HINT", dataMap.getString("ADBMOBILE_PERSISTED_MID_HINT"));
                editor.putString("ADBMOBILE_PERSISTED_MID_BLOB", dataMap.getString("ADBMOBILE_PERSISTED_MID_BLOB"));
                editor.putLong("ADBMOBILE_VISITORID_TTL", dataMap.getLong("ADBMOBILE_VISITORID_TTL"));
                editor.putLong("ADBMOBILE_VISITORID_SYNC", dataMap.getLong("ADBMOBILE_VISITORID_SYNC"));
                editor.putString("ADBMOBILE_VISITORID_IDS", dataMap.getString("ADBMOBILE_VISITORID_IDS"));
                editor.commit();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Wearable - Error saving Visitor Id Service data to shared preferences", new Object[0]);
            }
            VisitorIDService.sharedInstance().resetVariablesFromSharedPreferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restorePrivacyStatus(DataMap dataMap) {
        Object object = _privacyStatusMutex;
        synchronized (object) {
            if (dataMap.getInt("PrivacyStatus") >= MobilePrivacyStatus.values().length) {
                StaticMethods.logWarningFormat("Wearable - Invalid PrivacyStatus value (%d)", dataMap.getInt("PrivacyStatus"));
                return;
            }
            if (dataMap.containsKey("PrivacyStatus")) {
                Config.setPrivacyStatus(MobilePrivacyStatus.values()[dataMap.getInt("PrivacyStatus")]);
            }
        }
    }

    protected static void restoreConfig(DataItem item) {
        if (item == null || item.getUri() == null || item.getUri().getPath() == null) {
            return;
        }
        DataMap dataMap = DataMapItem.fromDataItem((DataItem)item).getDataMap();
        if (dataMap == null) {
            return;
        }
        String path = item.getUri().getPath();
        if (path.compareTo("/abdmobile/data/config/visitorId") == 0) {
            ConfigSynchronizer.restoreVisitorID(dataMap);
        } else if (path.compareTo("/abdmobile/data/config/vidService") == 0) {
            ConfigSynchronizer.restoreVidService(dataMap);
        } else if (path.compareTo("/abdmobile/data/config/privacyStatus") == 0) {
            ConfigSynchronizer.restorePrivacyStatus(dataMap);
        } else if (path.compareTo("/abdmobile/data/config/adId") == 0) {
            ConfigSynchronizer.restoreAdid(dataMap);
        } else if (path.compareTo("/abdmobile/data/config/pushEnabled") == 0) {
            ConfigSynchronizer.restorePushEnabled(dataMap);
        }
    }

    protected static void syncConfigFromHandheld() {
        if (StaticMethods.isWearableApp()) {
            try {
                Context appCtx = StaticMethods.getSharedContext().getApplicationContext();
                WearableDataResponse.ShareConfigResponse response = (WearableDataResponse.ShareConfigResponse)new WearableDataConnection(appCtx).send(WearableDataRequest.createShareConfigRequest(15000));
                if (response != null && response.getResult() != null) {
                    ConfigSynchronizer.restoreSharedConfig(response.getResult());
                }
                String pointsOfInterestURL = MobileConfig.getInstance().getPointsOfInterestURL();
                String inAppMessagesURL = MobileConfig.getInstance().getInAppMessageURL();
                if (pointsOfInterestURL == null && inAppMessagesURL == null) {
                    return;
                }
                String poiFileName = null;
                File poiFile = RemoteDownload.getFileForCachedURL(pointsOfInterestURL);
                if (poiFile != null) {
                    poiFileName = poiFile.getName();
                }
                String iamFileName = null;
                File iamFile = RemoteDownload.getFileForCachedURL(inAppMessagesURL);
                if (iamFile != null) {
                    iamFileName = iamFile.getName();
                }
                new WearableDataConnection(appCtx).send(WearableDataRequest.createFileRequest(pointsOfInterestURL, poiFileName, 15000));
                new WearableDataConnection(appCtx).send(WearableDataRequest.createFileRequest(inAppMessagesURL, iamFileName, 15000));
                MobileConfig.getInstance().loadCachedRemotes();
            }
            catch (StaticMethods.NullContextException e) {
                StaticMethods.logErrorFormat("Analytics - Error syncing Points of Interest and In-app Messages from handheld app to wearable app (%s)", e.getLocalizedMessage());
            }
        }
    }
}

