/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.content.SharedPreferences;
import com.adobe.mobile.AudienceManager;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.RequestHandler;
import com.adobe.mobile.StaticMethods;
import com.adobe.mobile.VisitorIDService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class AudienceManagerWorker {
    private static final String AUDIENCE_MANAGER_DATA_PROVIDER_ID_KEY = "d_dpid";
    private static final String AUDIENCE_MANAGER_DATA_PROVIDER_USER_ID_KEY = "d_dpuuid";
    private static final String AUDIENCE_MANAGER_USER_ID_KEY = "d_uuid";
    private static final String AUDIENCE_MANAGER_CUSTOMER_DATA_PREFIX = "c_";
    private static final String AUDIENCE_MANAGER_URL_SUFFIX = "&d_ptfm=android&d_dst=1&d_rtbd=json";
    private static final String AUDIENCE_MANAGER_COOP_UNSAFE = "&d_coop_unsafe=1";
    private static final String AUDIENCE_MANAGER_OPT_OUT_URL_BASE = "https://%s/demoptout.jpg?";
    private static final String AUDIENCE_MANAGER_OPT_OUT_URL_AAM = "d_uuid=%s";
    private static final String AUDIENCE_MANAGER_OPT_OUT_URL_VISID_SERVICE = "d_mid=%s&d_orgid=%s";
    private static final String AUDIENCE_MANAGER_SHARED_PREFS_PROFILE_KEY = "AAMUserProfile";
    private static final String AUDIENCE_MANAGER_JSON_DESTS_KEY = "dests";
    private static final String AUDIENCE_MANAGER_JSON_URL_KEY = "c";
    private static final String AUDIENCE_MANAGER_JSON_STUFF_KEY = "stuff";
    private static final String AUDIENCE_MANAGER_JSON_USER_ID_KEY = "uuid";
    private static final String AUDIENCE_MANAGER_JSON_COOKIE_NAME_KEY = "cn";
    private static final String AUDIENCE_MANAGER_JSON_COOKIE_VALUE_KEY = "cv";
    private static final int CONNECTION_TIMEOUT_MSEC = 5000;
    private static final int TO_MILLI = 1000;
    private static String _dpid = null;
    private static String _dpuuid = null;
    private static HashMap<String, Object> _visitorProfile = null;
    private static volatile boolean VisitorProfile_pred = true;
    private static String _urlPrefix = null;
    private static volatile boolean UrlPrefix_pred = true;

    AudienceManagerWorker() {
    }

    public static HashMap<String, Object> GetVisitorProfile() {
        FutureTask<HashMap<String, Object>> f = new FutureTask<HashMap<String, Object>>(new Callable<HashMap<String, Object>>(){

            @Override
            public HashMap<String, Object> call() throws Exception {
                block5: {
                    if (VisitorProfile_pred) {
                        try {
                            String profile = StaticMethods.getSharedPreferences().getString(AudienceManagerWorker.AUDIENCE_MANAGER_SHARED_PREFS_PROFILE_KEY, null);
                            if (profile == null || profile.length() <= 0) break block5;
                            try {
                                JSONObject profileData = new JSONObject(profile);
                                _visitorProfile = StaticMethods.mapFromJson(profileData);
                            }
                            catch (JSONException ex) {
                                StaticMethods.logWarningFormat("Audience Manager - Problem accessing profile data (%s)", ex.getLocalizedMessage());
                            }
                            VisitorProfile_pred = false;
                        }
                        catch (StaticMethods.NullContextException e) {
                            StaticMethods.logErrorFormat("Audience Manager - Problem accessing profile data (%s)", e.getMessage());
                        }
                    }
                }
                return _visitorProfile;
            }
        });
        StaticMethods.getAudienceExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Audience Manager - Unable to retrieve Visitor Profile", e.getMessage());
            return null;
        }
    }

    public static String GetDpuuid() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return _dpuuid;
            }
        });
        StaticMethods.getAudienceExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Audience Manager - Unable to get Dpid (%s)", e.getMessage());
            return null;
        }
    }

    public static String GetDpid() {
        FutureTask<String> f = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return _dpid;
            }
        });
        StaticMethods.getAudienceExecutor().execute(f);
        try {
            return f.get();
        }
        catch (Exception e) {
            StaticMethods.logErrorFormat("Audience Manager - Unable to get Dpid (%s)", e.getMessage());
            return null;
        }
    }

    public static void SetDpidAndDpuuid(final String newDpid, final String newDpuuid) {
        StaticMethods.getAudienceExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
                    return;
                }
                _dpid = newDpid;
                _dpuuid = newDpuuid;
            }
        });
    }

    static void handleOptOut() {
        StaticMethods.getAudienceExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String optOutUrl;
                String aamServer = MobileConfig.getInstance().getAamServer();
                String uuid = AudienceManagerWorker.GetUUID();
                String mid = VisitorIDService.sharedInstance().getMarketingCloudID();
                String mcOrgId = MobileConfig.getInstance().getMarketingCloudOrganizationId();
                if (!StaticMethods.isNullOrEmpty(uuid) && !StaticMethods.isNullOrEmpty(aamServer)) {
                    optOutUrl = String.format("https://%s/demoptout.jpg?d_uuid=%s", aamServer, uuid);
                } else if (!StaticMethods.isNullOrEmpty(mid) && !StaticMethods.isNullOrEmpty(mcOrgId)) {
                    optOutUrl = String.format("https://%s/demoptout.jpg?d_mid=%s&d_orgid=%s", VisitorIDService.sharedInstance().getMarketingCloudServer(), mid, mcOrgId);
                } else {
                    return;
                }
                StaticMethods.logDebugFormat("Audience Manager - Opting user out of server-side segments.", new Object[0]);
                RequestHandler.sendGenericRequest(optOutUrl, null, 5000, "Audience Manager");
            }
        });
    }

    static void purgeDpidAndDpuuid() {
        StaticMethods.getAudienceExecutor().execute(new Runnable(){

            @Override
            public void run() {
                _dpid = null;
                _dpuuid = null;
            }
        });
    }

    public static void SubmitSignal(Map<String, Object> data, AudienceManager.AudienceManagerCallback<Map<String, Object>> callback) {
        if (MobileConfig.getInstance().getPrivacyStatus() != MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
            StaticMethods.logDebugFormat("Audience Manager - Ignoring signal due to privacy status not being opt in", new Object[0]);
            if (callback != null) {
                callback.call(null);
            }
            return;
        }
        StaticMethods.getAudienceExecutor().execute(new SubmitSignalTask(data, callback));
    }

    public static void Reset() {
        StaticMethods.getAudienceExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AudienceManagerWorker.SetUUID(null);
                AudienceManagerWorker.SetVisitorProfile(null);
            }
        });
    }

    protected static HashMap<String, Object> processJsonResponse(JSONObject response) {
        AudienceManagerWorker.ProcessDestsArray(response);
        try {
            AudienceManagerWorker.SetUUID(response.getString(AUDIENCE_MANAGER_JSON_USER_ID_KEY));
        }
        catch (JSONException e) {
            StaticMethods.logWarningFormat("Audience Manager - Unable to parse JSON data (%s)", e.getLocalizedMessage());
        }
        HashMap<String, Object> returnedMap = AudienceManagerWorker.ProcessStuffArray(response);
        if (returnedMap.size() > 0) {
            StaticMethods.logDebugFormat("Audience Manager - response (%s)", returnedMap);
        } else {
            StaticMethods.logWarningFormat("Audience Manager - response was empty", new Object[0]);
        }
        AudienceManagerWorker.SetVisitorProfile(returnedMap);
        return returnedMap;
    }

    private static String BuildSchemaRequest(Map<String, Object> data) {
        if (AudienceManagerWorker.GetUrlPrefix() == null) {
            return null;
        }
        String urlString = AudienceManagerWorker.GetUrlPrefix() + AudienceManagerWorker.GetCustomUrlVariables(data) + AudienceManagerWorker.GetDataProviderUrlVariables() + AUDIENCE_MANAGER_URL_SUFFIX + (MobileConfig.getInstance().getMarketingCloudCoopUnsafe() ? AUDIENCE_MANAGER_COOP_UNSAFE : "");
        return urlString.replace("?&", "?");
    }

    private static String GetCustomUrlVariables(Map<String, Object> data) {
        if (data == null || data.size() <= 0) {
            return "";
        }
        StringBuilder urlVars = new StringBuilder(1024);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || key.length() <= 0 || value == null || value.toString().length() <= 0 || entry.getValue().getClass() != String.class) continue;
            urlVars.append("&").append(AUDIENCE_MANAGER_CUSTOMER_DATA_PREFIX).append(StaticMethods.URLEncode(AudienceManagerWorker.SanitizeUrlVariableName(key))).append("=").append(StaticMethods.URLEncode(value.toString()));
        }
        return urlVars.toString();
    }

    private static String SanitizeUrlVariableName(String name) {
        return name.replace(".", "_");
    }

    private static String GetDataProviderUrlVariables() {
        String uuid;
        StringBuilder urlVars = new StringBuilder();
        if (MobileConfig.getInstance().getVisitorIdServiceEnabled()) {
            urlVars.append(VisitorIDService.sharedInstance().getAAMParameterString());
        }
        if ((uuid = AudienceManagerWorker.GetUUID()) != null) {
            urlVars.append("&").append(AUDIENCE_MANAGER_USER_ID_KEY).append("=").append(uuid);
        }
        if (_dpid != null && _dpid.length() > 0 && _dpuuid != null && _dpuuid.length() > 0) {
            String encodedDpuuid = _dpuuid;
            try {
                String replacedPlusSigns = _dpuuid.replace("+", "%2B");
                String decodedDpuuid = URLDecoder.decode(replacedPlusSigns, "UTF-8");
                encodedDpuuid = StaticMethods.URLEncode(decodedDpuuid);
            }
            catch (UnsupportedEncodingException ex) {
                StaticMethods.logDebugFormat("Audience Manager", "Unable to properly encode dpuuid (%s).  Sending original value.", ex);
            }
            urlVars.append("&").append(AUDIENCE_MANAGER_DATA_PROVIDER_ID_KEY).append("=").append(_dpid).append("&").append(AUDIENCE_MANAGER_DATA_PROVIDER_USER_ID_KEY).append("=").append(encodedDpuuid);
        }
        return urlVars.toString();
    }

    private static void SetUUID(String newUuid) {
        if (newUuid != null && !newUuid.isEmpty() && MobileConfig.getInstance().getPrivacyStatus() == MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_OUT) {
            return;
        }
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            if (newUuid == null) {
                editor.remove("AAMUserId");
            } else {
                editor.putString("AAMUserId", newUuid);
            }
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Audience Manager - Error updating uuid in shared preferences (%s)", e.getMessage());
        }
    }

    static String GetUUID() {
        try {
            return StaticMethods.getSharedPreferences().getString("AAMUserId", null);
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Audience Manager - Error getting uuid from shared preferences (%s).", e.getMessage());
            return null;
        }
    }

    private static void SetVisitorProfile(Map<String, Object> profile) {
        VisitorProfile_pred = false;
        try {
            SharedPreferences.Editor editor = StaticMethods.getSharedPreferencesEditor();
            if (profile != null && profile.size() > 0) {
                JSONObject profileJSON = new JSONObject(profile);
                editor.putString(AUDIENCE_MANAGER_SHARED_PREFS_PROFILE_KEY, profileJSON.toString());
                _visitorProfile = new HashMap<String, Object>(profile);
            } else {
                editor.remove(AUDIENCE_MANAGER_SHARED_PREFS_PROFILE_KEY);
                _visitorProfile = null;
            }
            editor.commit();
        }
        catch (StaticMethods.NullContextException e) {
            StaticMethods.logErrorFormat("Audience Manager - Error updating visitor profile (%s)", e.getMessage());
        }
    }

    private static void ProcessDestsArray(JSONObject jsonResponse) {
        try {
            JSONArray dests = jsonResponse.getJSONArray(AUDIENCE_MANAGER_JSON_DESTS_KEY);
            for (int i = 0; i < dests.length(); ++i) {
                JSONObject dest = dests.getJSONObject(i);
                String url = dest.getString(AUDIENCE_MANAGER_JSON_URL_KEY);
                if (url == null || url.length() <= 0) continue;
                RequestHandler.sendGenericRequest(url, null, 5000, "Audience Manager");
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Audience Manager - No destination in response (%s)", ex.getLocalizedMessage());
        }
    }

    private static HashMap<String, Object> ProcessStuffArray(JSONObject jsonResponse) {
        HashMap<String, Object> returnedMap = new HashMap<String, Object>();
        try {
            JSONArray stuffArray = jsonResponse.getJSONArray(AUDIENCE_MANAGER_JSON_STUFF_KEY);
            for (int i = 0; i < stuffArray.length(); ++i) {
                JSONObject stuff = stuffArray.getJSONObject(i);
                if (stuff == null) continue;
                returnedMap.put(stuff.getString(AUDIENCE_MANAGER_JSON_COOKIE_NAME_KEY), stuff.getString(AUDIENCE_MANAGER_JSON_COOKIE_VALUE_KEY));
            }
        }
        catch (JSONException ex) {
            StaticMethods.logDebugFormat("Audience Manager - No 'stuff' array in response (%s)", ex.getLocalizedMessage());
        }
        return returnedMap;
    }

    private static String GetUrlPrefix() {
        if (UrlPrefix_pred && MobileConfig.getInstance().mobileUsingAudienceManager()) {
            UrlPrefix_pred = false;
            _urlPrefix = String.format("%s://%s/event?", MobileConfig.getInstance().getSSL() ? "https" : "http", MobileConfig.getInstance().getAamServer());
        }
        return _urlPrefix;
    }

    static /* synthetic */ String access$400(Map x0) {
        return AudienceManagerWorker.BuildSchemaRequest(x0);
    }

    public static class SubmitSignalTask
    implements Runnable {
        public final Map<String, Object> data;
        public final AudienceManager.AudienceManagerCallback<Map<String, Object>> callback;

        public SubmitSignalTask(Map<String, Object> initData, AudienceManager.AudienceManagerCallback<Map<String, Object>> initCallback) {
            this.data = initData;
            this.callback = initCallback;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

