/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.mobile;

import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.adobe.mobile.AbstractDatabaseBacking;
import com.adobe.mobile.MobileConfig;
import com.adobe.mobile.MobilePrivacyStatus;
import com.adobe.mobile.ReferrerHandler;
import com.adobe.mobile.StaticMethods;
import java.util.Timer;
import java.util.TimerTask;

abstract class AbstractHitDatabase
extends AbstractDatabaseBacking {
    protected long numberOfUnsentHits;
    protected long lastHitTimestamp;
    protected String dbCreateStatement;
    protected boolean bgThreadActive = false;
    protected final Object backgroundMutex = new Object();
    private final Object referrerTimerMutex = new Object();
    private Timer referrerTimer;
    private TimerTask referrerTask;

    AbstractHitDatabase() {
    }

    protected Hit selectOldestHit() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getFirstHitInQueue must be overwritten");
    }

    protected Runnable workerThread() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("workerThread must be overwritten");
    }

    @Override
    protected void initializeDatabase() {
        try {
            this.database.execSQL(this.dbCreateStatement);
        }
        catch (NullPointerException x) {
            StaticMethods.logErrorFormat("%s - Unable to create database due to an invalid path (%s)", this.logPrefix, x.getLocalizedMessage());
        }
        catch (SQLException x) {
            StaticMethods.logErrorFormat("%s - Unable to create database due to a sql error (%s)", this.logPrefix, x.getLocalizedMessage());
        }
        catch (Exception x) {
            StaticMethods.logErrorFormat("%s - Unable to create database due to an unexpected error (%s)", this.logPrefix, x.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteHit(String identifier) throws AbstractDatabaseBacking.CorruptedDatabaseException {
        if (identifier == null || identifier.trim().length() == 0) {
            StaticMethods.logDebugFormat("%s - Unable to delete hit due to an invalid parameter", this.logPrefix);
            return;
        }
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                this.database.delete("HITS", "ID = ?", new String[]{identifier});
                --this.numberOfUnsentHits;
            }
            catch (NullPointerException x) {
                StaticMethods.logErrorFormat("%s - Unable to delete hit due to an unopened database (%s)", this.logPrefix, x.getLocalizedMessage());
            }
            catch (SQLException x) {
                StaticMethods.logErrorFormat("%s - Unable to delete hit due to a sql error (%s)", this.logPrefix, x.getLocalizedMessage());
                throw new AbstractDatabaseBacking.CorruptedDatabaseException("Unable to delete, database probably corrupted (" + x.getLocalizedMessage() + ")");
            }
            catch (Exception x) {
                StaticMethods.logErrorFormat("%s - Unable to delete hit due to an unexpected error (%s)", this.logPrefix, x.getLocalizedMessage());
                throw new AbstractDatabaseBacking.CorruptedDatabaseException("Unexpected exception, database probably corrupted (" + x.getLocalizedMessage() + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTrackingQueue() {
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                this.database.delete("HITS", null, null);
                this.numberOfUnsentHits = 0L;
            }
            catch (NullPointerException x) {
                StaticMethods.logErrorFormat("%s - Unable to clear tracking queue due to an unopened database (%s)", this.logPrefix, x.getLocalizedMessage());
            }
            catch (SQLException x) {
                StaticMethods.logErrorFormat("%s - Unable to clear tracking queue due to a sql error (%s)", this.logPrefix, x.getLocalizedMessage());
            }
            catch (Exception x) {
                StaticMethods.logErrorFormat("%s - Unable to clear tracking queue due to an unexpected error (%s)", this.logPrefix, x.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bringOnline() {
        if (!this.bgThreadActive) {
            this.bgThreadActive = true;
            Object object = this.backgroundMutex;
            synchronized (object) {
                new Thread(this.workerThread(), "ADBMobileBackgroundThread").start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void kick(boolean ignoreBatchLimit) {
        boolean overBatchLimit;
        MobileConfig cfg = MobileConfig.getInstance();
        if (!ReferrerHandler.getReferrerProcessed() && cfg.getReferrerTimeout() > 0) {
            Object object = this.referrerTimerMutex;
            synchronized (object) {
                if (this.referrerTask == null) {
                    try {
                        this.referrerTask = new ReferrerTimeoutTask(ignoreBatchLimit);
                        this.referrerTimer = new Timer();
                        this.referrerTimer.schedule(this.referrerTask, MobileConfig.getInstance().getReferrerTimeout());
                    }
                    catch (Exception e) {
                        StaticMethods.logErrorFormat("%s - Error creating referrer timer (%s)", this.logPrefix, e.getMessage());
                    }
                }
            }
            return;
        }
        if (this.referrerTimer != null) {
            Object object = this.referrerTimerMutex;
            synchronized (object) {
                try {
                    this.referrerTimer.cancel();
                }
                catch (Exception e) {
                    StaticMethods.logErrorFormat("%s - Error cancelling referrer timer (%s)", this.logPrefix, e.getMessage());
                }
                this.referrerTask = null;
            }
        }
        if (cfg.getPrivacyStatus() != MobilePrivacyStatus.MOBILE_PRIVACY_STATUS_OPT_IN) {
            return;
        }
        boolean bl = overBatchLimit = !cfg.getOfflineTrackingEnabled() || this.numberOfUnsentHits > (long)cfg.getBatchLimit();
        if (overBatchLimit || ignoreBatchLimit) {
            this.bringOnline();
        }
    }

    protected void forceKick() {
        this.kick(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getTrackingQueueSize() {
        long numRows = 0L;
        Object object = this.dbMutex;
        synchronized (object) {
            try {
                numRows = DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)"HITS");
            }
            catch (NullPointerException x) {
                StaticMethods.logErrorFormat("%s - Unable to get tracking queue size due to an unopened database (%s)", this.logPrefix, x.getLocalizedMessage());
            }
            catch (SQLException x) {
                StaticMethods.logErrorFormat("%s - Unable to get tracking queue size due to a sql error (%s)", this.logPrefix, x.getLocalizedMessage());
            }
            catch (Exception x) {
                StaticMethods.logErrorFormat("%s - Unable to get tracking queue size due to an unexpected error (%s)", this.logPrefix, x.getLocalizedMessage());
            }
        }
        return numRows;
    }

    @Override
    protected void postReset() {
        this.numberOfUnsentHits = 0L;
    }

    protected class ReferrerTimeoutTask
    extends TimerTask {
        private boolean kickFlag = false;

        ReferrerTimeoutTask(boolean flag) {
            this.kickFlag = flag;
        }

        @Override
        public void run() {
            ReferrerHandler.setReferrerProcessed(true);
            StaticMethods.logDebugFormat("%s - Referrer timeout has expired without referrer data", AbstractHitDatabase.this.logPrefix);
            AbstractHitDatabase.this.kick(this.kickFlag);
        }
    }

    protected static class Hit {
        String urlFragment;
        String identifier;
        long timestamp;
        String postBody;
        String postType;
        int timeout;

        protected Hit() {
        }
    }
}

