/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source.chunk;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.source.chunk.Chunk;
import com.akamai.amp.exoplayer2.upstream.DataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Arrays;

public abstract class DataChunk
extends Chunk {
    private static final int READ_GRANULARITY = 16384;
    private byte[] data;
    private volatile boolean loadCanceled;

    public DataChunk(DataSource dataSource, DataSpec dataSpec, int type, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, @Nullable byte[] data) {
        super(dataSource, dataSpec, type, trackFormat, trackSelectionReason, trackSelectionData, -9223372036854775807L, -9223372036854775807L);
        this.data = data == null ? Util.EMPTY_BYTE_ARRAY : data;
    }

    public byte[] getDataHolder() {
        return this.data;
    }

    @Override
    public final void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public final void load() throws IOException {
        try {
            this.dataSource.open(this.dataSpec);
            int limit = 0;
            int bytesRead = 0;
            while (bytesRead != -1 && !this.loadCanceled) {
                this.maybeExpandData(limit);
                bytesRead = this.dataSource.read(this.data, limit, 16384);
                if (bytesRead == -1) continue;
                limit += bytesRead;
            }
            if (!this.loadCanceled) {
                this.consume(this.data, limit);
            }
        }
        finally {
            Util.closeQuietly(this.dataSource);
        }
    }

    protected abstract void consume(byte[] var1, int var2) throws IOException;

    private void maybeExpandData(int limit) {
        if (this.data.length < limit + 16384) {
            this.data = Arrays.copyOf(this.data, this.data.length + 16384);
        }
    }
}

