/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.FormatHolder;
import com.akamai.amp.exoplayer2.Renderer;
import com.akamai.amp.exoplayer2.RendererCapabilities;
import com.akamai.amp.exoplayer2.RendererConfiguration;
import com.akamai.amp.exoplayer2.decoder.DecoderInputBuffer;
import com.akamai.amp.exoplayer2.source.SampleStream;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.MediaClock;
import java.io.IOException;

public abstract class BaseRenderer
implements Renderer,
RendererCapabilities {
    private final int trackType;
    private final FormatHolder formatHolder;
    @Nullable
    private RendererConfiguration configuration;
    private int index;
    private int state;
    @Nullable
    private SampleStream stream;
    @Nullable
    private Format[] streamFormats;
    private long streamOffsetUs;
    private long lastResetPositionUs;
    private long readingPositionUs;
    private boolean streamIsFinal;
    private boolean throwRendererExceptionIsExecuting;

    public BaseRenderer(int trackType) {
        this.trackType = trackType;
        this.formatHolder = new FormatHolder();
        this.readingPositionUs = Long.MIN_VALUE;
    }

    @Override
    public final int getTrackType() {
        return this.trackType;
    }

    @Override
    public final RendererCapabilities getCapabilities() {
        return this;
    }

    @Override
    public final void setIndex(int index) {
        this.index = index;
    }

    @Override
    @Nullable
    public MediaClock getMediaClock() {
        return null;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final void enable(RendererConfiguration configuration, Format[] formats, SampleStream stream, long positionUs, boolean joining, boolean mayRenderStartOfStream, long startPositionUs, long offsetUs) throws ExoPlaybackException {
        Assertions.checkState(this.state == 0);
        this.configuration = configuration;
        this.state = 1;
        this.lastResetPositionUs = positionUs;
        this.onEnabled(joining, mayRenderStartOfStream);
        this.replaceStream(formats, stream, startPositionUs, offsetUs);
        this.onPositionReset(positionUs, joining);
    }

    @Override
    public final void start() throws ExoPlaybackException {
        Assertions.checkState(this.state == 1);
        this.state = 2;
        this.onStarted();
    }

    @Override
    public final void replaceStream(Format[] formats, SampleStream stream, long startPositionUs, long offsetUs) throws ExoPlaybackException {
        Assertions.checkState(!this.streamIsFinal);
        this.stream = stream;
        this.readingPositionUs = offsetUs;
        this.streamFormats = formats;
        this.streamOffsetUs = offsetUs;
        this.onStreamChanged(formats, startPositionUs, offsetUs);
    }

    @Override
    @Nullable
    public final SampleStream getStream() {
        return this.stream;
    }

    @Override
    public final boolean hasReadStreamToEnd() {
        return this.readingPositionUs == Long.MIN_VALUE;
    }

    @Override
    public final long getReadingPositionUs() {
        return this.readingPositionUs;
    }

    @Override
    public final void setCurrentStreamFinal() {
        this.streamIsFinal = true;
    }

    @Override
    public final boolean isCurrentStreamFinal() {
        return this.streamIsFinal;
    }

    @Override
    public final void maybeThrowStreamError() throws IOException {
        Assertions.checkNotNull(this.stream).maybeThrowError();
    }

    @Override
    public final void resetPosition(long positionUs) throws ExoPlaybackException {
        this.streamIsFinal = false;
        this.lastResetPositionUs = positionUs;
        this.readingPositionUs = positionUs;
        this.onPositionReset(positionUs, false);
    }

    @Override
    public final void stop() {
        Assertions.checkState(this.state == 2);
        this.state = 1;
        this.onStopped();
    }

    @Override
    public final void disable() {
        Assertions.checkState(this.state == 1);
        this.formatHolder.clear();
        this.state = 0;
        this.stream = null;
        this.streamFormats = null;
        this.streamIsFinal = false;
        this.onDisabled();
    }

    @Override
    public final void reset() {
        Assertions.checkState(this.state == 0);
        this.formatHolder.clear();
        this.onReset();
    }

    @Override
    public int supportsMixedMimeTypeAdaptation() throws ExoPlaybackException {
        return 0;
    }

    @Override
    public void handleMessage(int what, @Nullable Object object) throws ExoPlaybackException {
    }

    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
    }

    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) throws ExoPlaybackException {
    }

    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
    }

    protected void onStarted() throws ExoPlaybackException {
    }

    protected void onStopped() {
    }

    protected void onDisabled() {
    }

    protected void onReset() {
    }

    protected final long getLastResetPositionUs() {
        return this.lastResetPositionUs;
    }

    protected final FormatHolder getFormatHolder() {
        this.formatHolder.clear();
        return this.formatHolder;
    }

    protected final Format[] getStreamFormats() {
        return Assertions.checkNotNull(this.streamFormats);
    }

    protected final RendererConfiguration getConfiguration() {
        return Assertions.checkNotNull(this.configuration);
    }

    protected final int getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ExoPlaybackException createRendererException(Exception cause, @Nullable Format format) {
        int formatSupport = 4;
        if (format != null && !this.throwRendererExceptionIsExecuting) {
            this.throwRendererExceptionIsExecuting = true;
            try {
                formatSupport = RendererCapabilities.getFormatSupport(this.supportsFormat(format));
            }
            catch (ExoPlaybackException exoPlaybackException) {
            }
            finally {
                this.throwRendererExceptionIsExecuting = false;
            }
        }
        return ExoPlaybackException.createForRenderer(cause, this.getName(), this.getIndex(), format, formatSupport);
    }

    protected final int readSource(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired) {
        int result = Assertions.checkNotNull(this.stream).readData(formatHolder, buffer, formatRequired);
        if (result == -4) {
            if (buffer.isEndOfStream()) {
                this.readingPositionUs = Long.MIN_VALUE;
                return this.streamIsFinal ? -4 : -3;
            }
            buffer.timeUs += this.streamOffsetUs;
            this.readingPositionUs = Math.max(this.readingPositionUs, buffer.timeUs);
        } else if (result == -5) {
            Format format = Assertions.checkNotNull(formatHolder.format);
            if (format.subsampleOffsetUs != Long.MAX_VALUE) {
                formatHolder.format = format = format.buildUpon().setSubsampleOffsetUs(format.subsampleOffsetUs + this.streamOffsetUs).build();
            }
        }
        return result;
    }

    protected int skipSource(long positionUs) {
        return Assertions.checkNotNull(this.stream).skipData(positionUs - this.streamOffsetUs);
    }

    protected final boolean isSourceReady() {
        return this.hasReadStreamToEnd() ? this.streamIsFinal : Assertions.checkNotNull(this.stream).isReady();
    }
}

