/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.license.decryption;

import com.akamai.amp.license.decryption.InvalidDataException;
import com.akamai.amp.license.decryption.Validate;

class AES256v2HeaderData {
    private static final int SIZE_WITH_PASSWORD = 34;
    private static final int SIZE_WITHOUT_PASSWORD = 18;
    private final byte version;
    private final byte options;
    private final byte[] encryptionSalt;
    private final byte[] hmacSalt;
    private final byte[] iv;
    private final boolean isPasswordBased;

    AES256v2HeaderData(byte[] data) throws InvalidDataException {
        int minimumLength;
        Validate.notNull(data, "Data cannot be null.", new Object[0]);
        if (data.length < 2) {
            throw new InvalidDataException("Not enough data to read header.");
        }
        int index = 0;
        this.version = data[index++];
        if (this.version != 3) {
            throw new InvalidDataException(String.format("Expected version %d but found %d.", 3, this.version));
        }
        this.options = data[index++];
        if (this.options != 0 && this.options != 1) {
            throw new InvalidDataException("Unrecognised bit in the options byte.");
        }
        this.isPasswordBased = (this.options & 1) == 1;
        int n = minimumLength = this.isPasswordBased ? 34 : 18;
        if (data.length < minimumLength) {
            throw new InvalidDataException(String.format("Data must be a minimum length of %d bytes, but found %d bytes.", minimumLength, data.length));
        }
        if (this.isPasswordBased) {
            this.encryptionSalt = new byte[8];
            System.arraycopy(data, index, this.encryptionSalt, 0, this.encryptionSalt.length);
            this.hmacSalt = new byte[8];
            System.arraycopy(data, index += this.encryptionSalt.length, this.hmacSalt, 0, this.hmacSalt.length);
            index += this.hmacSalt.length;
        } else {
            this.encryptionSalt = null;
            this.hmacSalt = null;
        }
        this.iv = new byte[16];
        System.arraycopy(data, index, this.iv, 0, this.iv.length);
        index += this.iv.length;
    }

    static int getSizeWithPassword() {
        return 34;
    }

    static int getSizeWithoutPassword() {
        return 18;
    }

    byte getVersion() {
        return this.version;
    }

    byte getOptions() {
        return this.options;
    }

    byte[] getEncryptionSalt() {
        return this.encryptionSalt;
    }

    byte[] getHmacSalt() {
        return this.hmacSalt;
    }

    byte[] getIv() {
        return this.iv;
    }

    boolean isPasswordBased() {
        return this.isPasswordBased;
    }
}

