/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.config;

import android.os.AsyncTask;
import com.akamai.amp.config.Config;
import com.akamai.amp.media.hls.httpdownloaders.StringHttpDownloader;

public class AMPConfigLoader
extends AsyncTask<String, Void, Boolean> {
    private ConfigLoaderListener mListener;

    public AMPConfigLoader(ConfigLoaderListener listener) {
        this.mListener = listener;
    }

    public void loadConfig(String sConfigUrl, boolean isRemoteConfig) {
        if (isRemoteConfig) {
            this.execute(new String[]{sConfigUrl});
        } else {
            Config.getConfig().parseJsonConfig(sConfigUrl);
            Config.getConfig().configLoaded = true;
            if (this.mListener != null) {
                this.mListener.configLoaded();
            }
        }
    }

    protected Boolean doInBackground(String ... params) {
        StringHttpDownloader downloader = new StringHttpDownloader();
        String url = params[0];
        String fileData = (String)downloader.loadFile(url, null, false);
        if (fileData != null) {
            Config.getConfig().init(url);
            if (Config.getConfig().isJsonFormat) {
                String jsonContent = (String)downloader.loadFile(Config.getConfig().configURL, null, false);
                Config.getConfig().parseJsonConfig(jsonContent);
            } else {
                Config.getConfig().parseXMLConfig(url, fileData);
            }
            Config.getConfig().configLoaded = true;
        }
        return true;
    }

    protected void onPostExecute(Boolean result) {
        if (this.mListener != null) {
            this.mListener.configLoaded();
        }
        super.onPostExecute((Object)result);
    }

    public static interface ConfigLoaderListener {
        public void configLoaded();
    }
}

