/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.cast.utils;

import android.content.Context;
import android.net.Uri;
import android.view.Menu;
import android.view.MenuItem;
import androidx.mediarouter.app.MediaRouteButton;
import com.akamai.amp.cast.utils.CastSettings;
import com.akamai.amp.utils.LogManager;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastButtonFactory;
import com.google.android.gms.common.images.WebImage;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class AmpCastUtils {
    public static final String TAG = "AmpCastUtils";

    public static MenuItem initCastButton(Context context, Menu menu, int menuItemId) {
        return CastButtonFactory.setUpMediaRouteButton((Context)context, (Menu)menu, (int)menuItemId);
    }

    public static void initCastButton(Context context, MediaRouteButton mediaRouteButton) {
        CastButtonFactory.setUpMediaRouteButton((Context)context, (MediaRouteButton)mediaRouteButton);
    }

    public static MediaTrack buildTrack(long id, String type, String subType, String contentId, String contentType, String name, String language) {
        int trackType = 0;
        if ("text".equals(type)) {
            trackType = 1;
        } else if ("video".equals(type)) {
            trackType = 3;
        } else if ("audio".equals(type)) {
            trackType = 2;
        }
        int trackSubType = 0;
        if (subType != null) {
            if ("captions".equals(type)) {
                trackSubType = 2;
            } else if ("subtitle".equals(type)) {
                trackSubType = 1;
            }
        }
        return new MediaTrack.Builder(id, trackType).setName(name).setSubtype(trackSubType).setContentId(contentId).setContentType(contentType == null ? "" : contentType).setLanguage(language).build();
    }

    public static MediaMetadata buildMovieMetadata(String title, String studio, String imgUrl, String bigImageUrl) {
        MediaMetadata movieMetadata = new MediaMetadata(1);
        movieMetadata.putString("com.google.android.gms.cast.metadata.SUBTITLE", studio);
        movieMetadata.putString("com.google.android.gms.cast.metadata.TITLE", title);
        if (imgUrl != null) {
            movieMetadata.addImage(new WebImage(Uri.parse((String)imgUrl)));
        }
        if (bigImageUrl != null) {
            movieMetadata.addImage(new WebImage(Uri.parse((String)bigImageUrl)));
        }
        return movieMetadata;
    }

    public static MediaMetadata modifyMovieMetadata(MediaMetadata movieMetadata, String title, String studio, String imgUrl, String bigImageUrl) {
        if (movieMetadata != null) {
            movieMetadata.putString("com.google.android.gms.cast.metadata.SUBTITLE", studio);
            movieMetadata.putString("com.google.android.gms.cast.metadata.TITLE", title);
            if (imgUrl != null) {
                movieMetadata.addImage(new WebImage(Uri.parse((String)imgUrl)));
            }
            if (bigImageUrl != null) {
                movieMetadata.addImage(new WebImage(Uri.parse((String)bigImageUrl)));
            }
        }
        return movieMetadata;
    }

    public static JSONObject buildCustomData(String subTitle, String descriptionKey) {
        JSONObject jsonObj = null;
        try {
            jsonObj = new JSONObject();
            jsonObj.put(descriptionKey, (Object)subTitle);
        }
        catch (JSONException e) {
            LogManager.error((String)TAG, (String)("Failed to add description to the json object ->" + (Object)((Object)e)));
        }
        return jsonObj;
    }

    @Deprecated
    public static MediaInfo buildMediaInfo(String title, String studio, String subTitle, String descriptionKey, int duration, String url, String mimeType, String imgUrl, String bigImageUrl, List<MediaTrack> tracks) {
        return new MediaInfo.Builder(url).setStreamType(1).setContentType(mimeType).setMetadata(AmpCastUtils.buildMovieMetadata(title, studio, imgUrl, bigImageUrl)).setMediaTracks(tracks).setStreamDuration((long)(duration * 1000)).setCustomData(AmpCastUtils.buildCustomData(subTitle, descriptionKey)).build();
    }

    @Deprecated
    public static MediaInfo buildMediaInfo(String title, String studio, String subTitle, String descriptionKey, int duration, String url, String mimeType, String imgUrl, String bigImageUrl, List<MediaTrack> tracks, MediaMetadata movieMetadata) {
        return new MediaInfo.Builder(url).setStreamType(1).setContentType(mimeType).setMetadata(AmpCastUtils.modifyMovieMetadata(movieMetadata, title, studio, imgUrl, bigImageUrl)).setMediaTracks(tracks).setStreamDuration((long)(duration * 1000)).setCustomData(AmpCastUtils.buildCustomData(subTitle, descriptionKey)).build();
    }

    public static MediaQueueItem createMediaQueueItem(MediaInfo mediaInfo) {
        return new MediaQueueItem.Builder(mediaInfo).setAutoplay(true).setPreloadTime((double)CastSettings.get().getPreloadTimeS()).build();
    }

    public static MediaQueueItem createMediaQueueItem(MediaInfo mediaInfo, MediaMetadata extraData) {
        return new MediaQueueItem.Builder(AmpCastUtils.updateMediaInfo(mediaInfo, extraData)).setAutoplay(true).setPreloadTime((double)CastSettings.get().getPreloadTimeS()).build();
    }

    public static MediaInfo updateMediaInfo(MediaInfo originalMediaInfo, MediaMetadata extraData) {
        if (originalMediaInfo != null) {
            return new MediaInfo.Builder(originalMediaInfo.getContentId()).setStreamType(originalMediaInfo.getStreamType()).setContentType(originalMediaInfo.getContentType()).setMetadata(AmpCastUtils.attachExtraMetadata(originalMediaInfo.getMetadata(), extraData)).setMediaTracks(originalMediaInfo.getMediaTracks()).setStreamDuration(originalMediaInfo.getStreamDuration()).setCustomData(originalMediaInfo.getCustomData()).build();
        }
        return null;
    }

    private static MediaMetadata attachExtraMetadata(MediaMetadata originalMetadata, MediaMetadata extraData) {
        if (extraData == null) {
            return originalMetadata;
        }
        if (originalMetadata == null) {
            originalMetadata = new MediaMetadata(1);
        }
        String demographicId = extraData.getString("kGCKMetadataNlsKeyDeviceID");
        String optOutStatus = extraData.getString("kGCKMetadataNlsKeyOptout");
        if (demographicId != null) {
            originalMetadata.putString("kGCKMetadataNlsKeyDeviceID", demographicId);
        }
        if (optOutStatus != null) {
            originalMetadata.putString("kGCKMetadataNlsKeyOptout", optOutStatus);
        }
        return originalMetadata;
    }
}

