/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.source;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ExoPlayerLibraryInfo;
import com.akamai.amp.exoplayer2.MediaItem;
import com.akamai.amp.exoplayer2.drm.DefaultDrmSessionManager;
import com.akamai.amp.exoplayer2.drm.DrmSessionManager;
import com.akamai.amp.exoplayer2.drm.FrameworkMediaDrm;
import com.akamai.amp.exoplayer2.drm.HttpMediaDrmCallback;
import com.akamai.amp.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.akamai.amp.exoplayer2.upstream.HttpDataSource;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import com.google.common.primitives.Ints;
import java.util.Map;

public final class MediaSourceDrmHelper {
    @Nullable
    private HttpDataSource.Factory drmHttpDataSourceFactory;
    @Nullable
    private String userAgent;

    public void setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
        this.drmHttpDataSourceFactory = drmHttpDataSourceFactory;
    }

    public void setDrmUserAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
    }

    public DrmSessionManager create(MediaItem mediaItem) {
        Assertions.checkNotNull(mediaItem.playbackProperties);
        MediaItem.DrmConfiguration drmConfiguration = mediaItem.playbackProperties.drmConfiguration;
        if (drmConfiguration == null || Util.SDK_INT < 18) {
            return DrmSessionManager.getDummyDrmSessionManager();
        }
        HttpDataSource.Factory dataSourceFactory = this.drmHttpDataSourceFactory != null ? this.drmHttpDataSourceFactory : new DefaultHttpDataSourceFactory(this.userAgent != null ? this.userAgent : ExoPlayerLibraryInfo.DEFAULT_USER_AGENT);
        HttpMediaDrmCallback httpDrmCallback = new HttpMediaDrmCallback(drmConfiguration.licenseUri == null ? null : drmConfiguration.licenseUri.toString(), drmConfiguration.forceDefaultLicenseUri, dataSourceFactory);
        for (Map.Entry<String, String> entry : drmConfiguration.requestHeaders.entrySet()) {
            httpDrmCallback.setKeyRequestProperty(entry.getKey(), entry.getValue());
        }
        DefaultDrmSessionManager drmSessionManager = new DefaultDrmSessionManager.Builder().setUuidAndExoMediaDrmProvider(drmConfiguration.uuid, FrameworkMediaDrm.DEFAULT_PROVIDER).setMultiSession(drmConfiguration.multiSession).setPlayClearSamplesWithoutKeys(drmConfiguration.playClearContentWithoutKey).setUseDrmSessionsForClearContent(Ints.toArray(drmConfiguration.sessionForClearTypes)).build(httpDrmCallback);
        drmSessionManager.setMode(0, drmConfiguration.getKeySetId());
        return drmSessionManager;
    }
}

