/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.extractor;

import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.ParserException;
import com.akamai.amp.exoplayer2.extractor.ExtractorInput;
import com.akamai.amp.exoplayer2.extractor.FlacStreamMetadata;
import com.akamai.amp.exoplayer2.extractor.Id3Peeker;
import com.akamai.amp.exoplayer2.extractor.VorbisUtil;
import com.akamai.amp.exoplayer2.metadata.Metadata;
import com.akamai.amp.exoplayer2.metadata.flac.PictureFrame;
import com.akamai.amp.exoplayer2.metadata.id3.Id3Decoder;
import com.akamai.amp.exoplayer2.util.ParsableBitArray;
import com.akamai.amp.exoplayer2.util.ParsableByteArray;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FlacMetadataReader {
    private static final int STREAM_MARKER = 1716281667;
    private static final int SYNC_CODE = 16382;
    private static final int SEEK_POINT_SIZE = 18;

    @Nullable
    public static Metadata peekId3Metadata(ExtractorInput input, boolean parseData) throws IOException {
        Id3Decoder.FramePredicate id3FramePredicate = parseData ? null : Id3Decoder.NO_FRAMES_PREDICATE;
        Metadata id3Metadata = new Id3Peeker().peekId3Data(input, id3FramePredicate);
        return id3Metadata == null || id3Metadata.length() == 0 ? null : id3Metadata;
    }

    public static boolean checkAndPeekStreamMarker(ExtractorInput input) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(4);
        input.peekFully(scratch.getData(), 0, 4);
        return scratch.readUnsignedInt() == 1716281667L;
    }

    @Nullable
    public static Metadata readId3Metadata(ExtractorInput input, boolean parseData) throws IOException {
        input.resetPeekPosition();
        long startingPeekPosition = input.getPeekPosition();
        Metadata id3Metadata = FlacMetadataReader.peekId3Metadata(input, parseData);
        int peekedId3Bytes = (int)(input.getPeekPosition() - startingPeekPosition);
        input.skipFully(peekedId3Bytes);
        return id3Metadata;
    }

    public static void readStreamMarker(ExtractorInput input) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(4);
        input.readFully(scratch.getData(), 0, 4);
        if (scratch.readUnsignedInt() != 1716281667L) {
            throw new ParserException("Failed to read FLAC stream marker.");
        }
    }

    public static boolean readMetadataBlock(ExtractorInput input, FlacStreamMetadataHolder metadataHolder) throws IOException {
        input.resetPeekPosition();
        ParsableBitArray scratch = new ParsableBitArray(new byte[4]);
        input.peekFully(scratch.data, 0, 4);
        boolean isLastMetadataBlock = scratch.readBit();
        int type = scratch.readBits(7);
        int length = 4 + scratch.readBits(24);
        if (type == 0) {
            metadataHolder.flacStreamMetadata = FlacMetadataReader.readStreamInfoBlock(input);
        } else {
            FlacStreamMetadata flacStreamMetadata = metadataHolder.flacStreamMetadata;
            if (flacStreamMetadata == null) {
                throw new IllegalArgumentException();
            }
            if (type == 3) {
                FlacStreamMetadata.SeekTable seekTable = FlacMetadataReader.readSeekTableMetadataBlock(input, length);
                metadataHolder.flacStreamMetadata = flacStreamMetadata.copyWithSeekTable(seekTable);
            } else if (type == 4) {
                List<String> vorbisComments = FlacMetadataReader.readVorbisCommentMetadataBlock(input, length);
                metadataHolder.flacStreamMetadata = flacStreamMetadata.copyWithVorbisComments(vorbisComments);
            } else if (type == 6) {
                PictureFrame pictureFrame = FlacMetadataReader.readPictureMetadataBlock(input, length);
                metadataHolder.flacStreamMetadata = flacStreamMetadata.copyWithPictureFrames(Collections.singletonList(pictureFrame));
            } else {
                input.skipFully(length);
            }
        }
        return isLastMetadataBlock;
    }

    public static FlacStreamMetadata.SeekTable readSeekTableMetadataBlock(ParsableByteArray data) {
        data.skipBytes(1);
        int length = data.readUnsignedInt24();
        long seekTableEndPosition = (long)data.getPosition() + (long)length;
        int seekPointCount = length / 18;
        long[] pointSampleNumbers = new long[seekPointCount];
        long[] pointOffsets = new long[seekPointCount];
        for (int i = 0; i < seekPointCount; ++i) {
            long sampleNumber = data.readLong();
            if (sampleNumber == -1L) {
                pointSampleNumbers = Arrays.copyOf(pointSampleNumbers, i);
                pointOffsets = Arrays.copyOf(pointOffsets, i);
                break;
            }
            pointSampleNumbers[i] = sampleNumber;
            pointOffsets[i] = data.readLong();
            data.skipBytes(2);
        }
        data.skipBytes((int)(seekTableEndPosition - (long)data.getPosition()));
        return new FlacStreamMetadata.SeekTable(pointSampleNumbers, pointOffsets);
    }

    public static int getFrameStartMarker(ExtractorInput input) throws IOException {
        input.resetPeekPosition();
        ParsableByteArray scratch = new ParsableByteArray(2);
        input.peekFully(scratch.getData(), 0, 2);
        int frameStartMarker = scratch.readUnsignedShort();
        int syncCode = frameStartMarker >> 2;
        if (syncCode != 16382) {
            input.resetPeekPosition();
            throw new ParserException("First frame does not start with sync code.");
        }
        input.resetPeekPosition();
        return frameStartMarker;
    }

    private static FlacStreamMetadata readStreamInfoBlock(ExtractorInput input) throws IOException {
        byte[] scratchData = new byte[38];
        input.readFully(scratchData, 0, 38);
        return new FlacStreamMetadata(scratchData, 4);
    }

    private static FlacStreamMetadata.SeekTable readSeekTableMetadataBlock(ExtractorInput input, int length) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(length);
        input.readFully(scratch.getData(), 0, length);
        return FlacMetadataReader.readSeekTableMetadataBlock(scratch);
    }

    private static List<String> readVorbisCommentMetadataBlock(ExtractorInput input, int length) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(length);
        input.readFully(scratch.getData(), 0, length);
        scratch.skipBytes(4);
        VorbisUtil.CommentHeader commentHeader = VorbisUtil.readVorbisCommentHeader(scratch, false, false);
        return Arrays.asList(commentHeader.comments);
    }

    private static PictureFrame readPictureMetadataBlock(ExtractorInput input, int length) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(length);
        input.readFully(scratch.getData(), 0, length);
        scratch.skipBytes(4);
        int pictureType = scratch.readInt();
        int mimeTypeLength = scratch.readInt();
        String mimeType = scratch.readString(mimeTypeLength, Charsets.US_ASCII);
        int descriptionLength = scratch.readInt();
        String description = scratch.readString(descriptionLength);
        int width = scratch.readInt();
        int height = scratch.readInt();
        int depth = scratch.readInt();
        int colors = scratch.readInt();
        int pictureDataLength = scratch.readInt();
        byte[] pictureData = new byte[pictureDataLength];
        scratch.readBytes(pictureData, 0, pictureDataLength);
        return new PictureFrame(pictureType, mimeType, description, width, height, depth, colors, pictureData);
    }

    private FlacMetadataReader() {
    }

    public static final class FlacStreamMetadataHolder {
        @Nullable
        public FlacStreamMetadata flacStreamMetadata;

        public FlacStreamMetadataHolder(@Nullable FlacStreamMetadata flacStreamMetadata) {
            this.flacStreamMetadata = flacStreamMetadata;
        }
    }
}

