/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.audio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class OpusUtil {
    public static final int SAMPLE_RATE = 48000;
    private static final int DEFAULT_SEEK_PRE_ROLL_SAMPLES = 3840;
    private static final int FULL_CODEC_INITIALIZATION_DATA_BUFFER_COUNT = 3;

    private OpusUtil() {
    }

    public static int getChannelCount(byte[] header) {
        return header[9] & 0xFF;
    }

    public static List<byte[]> buildInitializationData(byte[] header) {
        int preSkipSamples = OpusUtil.getPreSkipSamples(header);
        long preSkipNanos = OpusUtil.sampleCountToNanoseconds(preSkipSamples);
        long seekPreRollNanos = OpusUtil.sampleCountToNanoseconds(3840L);
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>(3);
        initializationData.add(header);
        initializationData.add(OpusUtil.buildNativeOrderByteArray(preSkipNanos));
        initializationData.add(OpusUtil.buildNativeOrderByteArray(seekPreRollNanos));
        return initializationData;
    }

    public static int getPreSkipSamples(List<byte[]> initializationData) {
        if (initializationData.size() == 3) {
            long codecDelayNs = ByteBuffer.wrap(initializationData.get(1)).order(ByteOrder.nativeOrder()).getLong();
            return (int)OpusUtil.nanosecondsToSampleCount(codecDelayNs);
        }
        return OpusUtil.getPreSkipSamples(initializationData.get(0));
    }

    public static int getSeekPreRollSamples(List<byte[]> initializationData) {
        if (initializationData.size() == 3) {
            long seekPreRollNs = ByteBuffer.wrap(initializationData.get(2)).order(ByteOrder.nativeOrder()).getLong();
            return (int)OpusUtil.nanosecondsToSampleCount(seekPreRollNs);
        }
        return 3840;
    }

    private static int getPreSkipSamples(byte[] header) {
        return (header[11] & 0xFF) << 8 | header[10] & 0xFF;
    }

    private static byte[] buildNativeOrderByteArray(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(value).array();
    }

    private static long sampleCountToNanoseconds(long sampleCount) {
        return sampleCount * 1000000000L / 48000L;
    }

    private static long nanosecondsToSampleCount(long nanoseconds) {
        return nanoseconds * 48000L / 1000000000L;
    }
}

