/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.yospace.exo;

import android.app.Activity;
import android.util.Log;
import com.akamai.amp.media.IPlayerEventsListener;
import com.akamai.amp.media.VideoPlayerView;
import com.akamai.amp.utils.PlayerDataPool;
import com.yospace.android.hls.analytic.Session;
import com.yospace.hls.player.PlaybackState;
import com.yospace.hls.player.PlayerState;
import com.yospace.util.event.EventSourceImpl;
import java.util.Timer;
import java.util.TimerTask;

public class ExoAdapter
implements IPlayerEventsListener {
    private static final String TAG = "ExoAdapter";
    public VideoPlayerView mVideoPlayerView;
    private final Activity mActivity;
    private boolean isBuffering = false;
    private EventSourceImpl<PlayerState> mPlayerStateSource = new EventSourceImpl();
    private Timer mPlayheadTimer;
    private PlayerDataPool playerDataPool;

    public ExoAdapter(Activity activity) {
        this.mActivity = activity;
    }

    private void addPlayheadObserver() {
        this.removePlayheadObserver();
        Log.i((String)TAG, (String)"ExoAdapter.addPlayheadObserver - called");
        this.mPlayheadTimer = new Timer();
        this.playerDataPool = new PlayerDataPool(this.mVideoPlayerView);
        this.mPlayheadTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ExoAdapter.this.mPlayerStateSource.notify((Object)new PlayerState(PlaybackState.PLAYHEAD_UPDATE, Integer.valueOf((int)((ExoAdapter)ExoAdapter.this).playerDataPool.currentStreamPositionMS), false));
            }
        }, 0L, 250L);
    }

    public void setVideoPlayerView(VideoPlayerView videoPlayerView) {
        this.mVideoPlayerView = videoPlayerView;
        this.mVideoPlayerView.addEventsListener((IPlayerEventsListener)this);
    }

    public void stopPlayerUpdate() {
        if (this.playerDataPool != null) {
            this.playerDataPool.stopPlayerUpdate();
        }
    }

    private void removePlayheadObserver() {
        if (this.mPlayheadTimer != null) {
            Log.i((String)TAG, (String)"ExoAdapter.removePlayheadObserver - called");
            this.mPlayheadTimer.cancel();
            this.mPlayheadTimer = null;
        }
        this.stopPlayerUpdate();
    }

    public void setSession(Session session) {
        session.setPlayerStateSource(this.mPlayerStateSource);
    }

    public boolean onPlayerEvent(int iInEventType) {
        int playbackState = iInEventType;
        int playheadPosition = (int)this.mVideoPlayerView.getCurrentStreamPositionMS();
        if (playbackState == 5 && !this.isBuffering) {
            this.mPlayerStateSource.notify((Object)new PlayerState(PlaybackState.BUFFERING_START, Integer.valueOf(playheadPosition), false));
            this.isBuffering = true;
        } else if (playbackState == 6) {
            this.mPlayerStateSource.notify((Object)new PlayerState(PlaybackState.BUFFERING_END, Integer.valueOf(playheadPosition), false));
            this.isBuffering = false;
        }
        if (playbackState == 3) {
            PlaybackState state = iInEventType == 3 ? PlaybackState.PLAYING : PlaybackState.PAUSED;
            this.mPlayerStateSource.notify((Object)new PlayerState(state, Integer.valueOf(playheadPosition), false));
            if (state == PlaybackState.PLAYING) {
                this.addPlayheadObserver();
            } else {
                this.removePlayheadObserver();
            }
        }
        if (playbackState == 17) {
            this.mPlayerStateSource.notify((Object)new PlayerState(PlaybackState.PAUSED, Integer.valueOf(playheadPosition), false));
        } else if (playbackState == 18) {
            this.mPlayerStateSource.notify((Object)new PlayerState(PlaybackState.PLAYING, Integer.valueOf(playheadPosition), false));
        }
        return true;
    }

    public boolean onPlayerExtendedEvent(int iInEventType, int arg1, int arg2) {
        return true;
    }
}

