/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.id3tags;

import android.util.Log;
import com.akamai.amp.id3tags.ID3TagData;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@Deprecated
public class Serialization {
    private static final String TAG = "ID3TagExtractor";

    public static ID3TagData Deserialize(byte[] data, int offset, String segmentUrl) {
        int LEN_TEXT_ID3_FRAME = 512;
        int currentPosition = offset;
        byte[] id3TagText = Serialization.ReadBytes(data, currentPosition, currentPosition + 512);
        if (null == id3TagText) {
            throw new IllegalArgumentException("Cannot deserialize text value");
        }
        currentPosition += 512;
        String normalizedText = Serialization.NormalizeBytes(id3TagText);
        String text = null;
        if (0 != normalizedText.length()) {
            text = normalizedText;
            Log.i((String)TAG, (String)("Deserialization result: " + normalizedText));
        }
        int SIZE_TIME = 8;
        byte[] time = Serialization.ReadBytes(data, currentPosition, currentPosition + 8);
        if (null == time) {
            throw new IllegalArgumentException("Cannot deserialize time value");
        }
        long startTime = ByteBuffer.wrap(time).order(ByteOrder.LITTLE_ENDIAN).getLong();
        Log.i((String)TAG, (String)("Deserialization time: " + startTime));
        return new ID3TagData(text, startTime, segmentUrl, data);
    }

    public static byte[] ReadBytes(byte[] inData, int startPos, int endPos) {
        if (null == inData) {
            return null;
        }
        if (startPos < 0 || endPos < 0 || startPos > endPos) {
            return null;
        }
        byte[] outData = new byte[endPos - startPos];
        int j = 0;
        for (int i = startPos; i < endPos; ++i) {
            outData[j] = inData[i];
            ++j;
        }
        return outData;
    }

    public static String NormalizeBytes(byte[] data) {
        String res = "";
        int point = 0;
        for (int i = data.length - 1; i >= 0; --i) {
            if (data[i] == 0) continue;
            point = i;
            break;
        }
        if (point != 0) {
            try {
                res = new String(data, 0, point + 1, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return res;
    }
}

