/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.exowrapper2;

import android.text.TextUtils;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.util.MimeTypes;
import java.util.Locale;

final class TrackNameBuilder {
    public static String buildTrackName(Format format) {
        String trackName = MimeTypes.isVideo(format.sampleMimeType) ? TrackNameBuilder.joinWithSeparator(TrackNameBuilder.joinWithSeparator(TrackNameBuilder.joinWithSeparator(TrackNameBuilder.buildResolutionString(format), TrackNameBuilder.buildBitrateString(format)), TrackNameBuilder.buildTrackIdString(format)), TrackNameBuilder.buildSampleMimeTypeString(format)) : (MimeTypes.isAudio(format.sampleMimeType) ? TrackNameBuilder.joinWithSeparator(TrackNameBuilder.joinWithSeparator(TrackNameBuilder.joinWithSeparator(TrackNameBuilder.joinWithSeparator(TrackNameBuilder.buildLanguageString(format), TrackNameBuilder.buildAudioPropertyString(format)), TrackNameBuilder.buildBitrateString(format)), TrackNameBuilder.buildTrackIdString(format)), TrackNameBuilder.buildSampleMimeTypeString(format)) : TrackNameBuilder.joinWithSeparator(TrackNameBuilder.joinWithSeparator(TrackNameBuilder.joinWithSeparator(TrackNameBuilder.buildLanguageString(format), TrackNameBuilder.buildBitrateString(format)), TrackNameBuilder.buildTrackIdString(format)), TrackNameBuilder.buildSampleMimeTypeString(format)));
        return trackName.length() == 0 ? "unknown" : trackName;
    }

    private static String buildResolutionString(Format format) {
        return format.width == -1 || format.height == -1 ? "" : format.width + "x" + format.height;
    }

    private static String buildAudioPropertyString(Format format) {
        return format.channelCount == -1 || format.sampleRate == -1 ? "" : format.channelCount + "ch, " + format.sampleRate + "Hz";
    }

    private static String buildLanguageString(Format format) {
        return TextUtils.isEmpty((CharSequence)format.language) || "und".equals(format.language) ? "" : format.language;
    }

    private static String buildBitrateString(Format format) {
        return format.bitrate == -1 ? "" : String.format(Locale.US, "%.2fMbit", Float.valueOf((float)format.bitrate / 1000000.0f));
    }

    private static String joinWithSeparator(String first, String second) {
        return first.length() == 0 ? second : (second.length() == 0 ? first : first + ", " + second);
    }

    private static String buildTrackIdString(Format format) {
        return format.id == null ? "" : "id:" + format.id;
    }

    private static String buildSampleMimeTypeString(Format format) {
        return format.sampleMimeType == null ? "" : format.sampleMimeType;
    }

    private TrackNameBuilder() {
    }
}

