/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.upstream;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.upstream.BaseDataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Assertions;
import java.io.IOException;

public final class ByteArrayDataSource
extends BaseDataSource {
    private final byte[] data;
    @Nullable
    private Uri uri;
    private int readPosition;
    private int bytesRemaining;
    private boolean opened;

    public ByteArrayDataSource(byte[] data) {
        super(false);
        Assertions.checkNotNull(data);
        Assertions.checkArgument(data.length > 0);
        this.data = data;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.uri = dataSpec.uri;
        this.transferInitializing(dataSpec);
        this.readPosition = (int)dataSpec.position;
        this.bytesRemaining = (int)(dataSpec.length == -1L ? (long)this.data.length - dataSpec.position : dataSpec.length);
        if (this.bytesRemaining <= 0 || this.readPosition + this.bytesRemaining > this.data.length) {
            throw new IOException("Unsatisfiable range: [" + this.readPosition + ", " + dataSpec.length + "], length: " + this.data.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) {
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        readLength = Math.min(readLength, this.bytesRemaining);
        System.arraycopy(this.data, this.readPosition, buffer, offset, readLength);
        this.readPosition += readLength;
        this.bytesRemaining -= readLength;
        this.bytesTransferred(readLength);
        return readLength;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() {
        if (this.opened) {
            this.opened = false;
            this.transferEnded();
        }
        this.uri = null;
    }
}

