/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.parser.feed;

import com.akamai.amp.media.elements.MediaResource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeedParser {
    public void loadFeedFromString(String data, MediaResource mediaResource) {
        this.parseJson(data, mediaResource);
    }

    private void parseJson(String content, MediaResource mediaResource) {
        try {
            JSONObject jObject = new JSONObject(content);
            JSONObject channel = jObject.getJSONObject("channel");
            JSONObject item = channel.getJSONObject("item");
            JSONObject mediaGroup = item.getJSONObject("media-group");
            JSONArray mediaContent = mediaGroup.getJSONArray("media-content");
            mediaResource.setGuid(item.optString("guid"));
            mediaResource.setDescription(item.optString("description"));
            mediaResource.setCategory(item.optString("category"));
            mediaResource.setMetadata(item);
            String mp4Url = null;
            for (int i = 0; i < mediaContent.length(); ++i) {
                JSONObject contentItem = mediaContent.getJSONObject(i);
                JSONObject attributes = contentItem.getJSONObject("@attributes");
                String type = attributes.getString("type");
                if (type.equals("application/x-mpegURL")) {
                    mediaResource.setUrl(attributes.getString("url"));
                    break;
                }
                if (!type.equals("video/mp4") || mp4Url != null) continue;
                mp4Url = attributes.getString("url");
            }
            if ((mediaResource.getUrl() == null || mediaResource.getUrl().length() == 0) && mp4Url != null && mp4Url.length() > 0) {
                mediaResource.setUrl(mp4Url);
            }
            mediaResource.setTitle(mediaGroup.optString("media-title"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getStringPropertyByPath(String path, MediaResource mediaResource) {
        String res = null;
        if (mediaResource.getMetadata() != null) {
            String[] properties = path.split("\\.");
            JSONObject lastObj = mediaResource.getMetadata();
            for (int i = 0; i < properties.length; ++i) {
                if (i == 0 && properties[i].equals("media") || i == 1 && properties[i].equals("metadata")) continue;
                if (i == properties.length - 1) {
                    if (lastObj == null || (res = lastObj.optString(properties[i])) != null && res.length() != 0) continue;
                    res = "-";
                    continue;
                }
                if (lastObj != null) {
                    lastObj = lastObj.optJSONObject(properties[i]);
                    continue;
                }
                res = "-";
                break;
            }
        }
        return res;
    }
}

