/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.muxstats;

import com.mux.stats.sdk.core.Core;
import com.mux.stats.sdk.core.CorePlayer;
import com.mux.stats.sdk.core.MuxSDKViewOrientation;
import com.mux.stats.sdk.core.events.BaseEventListener;
import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.InternalErrorEvent;
import com.mux.stats.sdk.core.events.data.DataEvent;
import com.mux.stats.sdk.core.events.playback.AdBreakEndEvent;
import com.mux.stats.sdk.core.events.playback.AdBreakStartEvent;
import com.mux.stats.sdk.core.events.playback.AdEndedEvent;
import com.mux.stats.sdk.core.events.playback.AdErrorEvent;
import com.mux.stats.sdk.core.events.playback.AdFirstQuartileEvent;
import com.mux.stats.sdk.core.events.playback.AdMidpointEvent;
import com.mux.stats.sdk.core.events.playback.AdPauseEvent;
import com.mux.stats.sdk.core.events.playback.AdPlayEvent;
import com.mux.stats.sdk.core.events.playback.AdPlayingEvent;
import com.mux.stats.sdk.core.events.playback.AdRequestEvent;
import com.mux.stats.sdk.core.events.playback.AdResponseEvent;
import com.mux.stats.sdk.core.events.playback.AdThirdQuartileEvent;
import com.mux.stats.sdk.core.events.playback.EndedEvent;
import com.mux.stats.sdk.core.events.playback.ErrorEvent;
import com.mux.stats.sdk.core.events.playback.PauseEvent;
import com.mux.stats.sdk.core.events.playback.PlayEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.events.playback.PlayerReadyEvent;
import com.mux.stats.sdk.core.events.playback.PlayingEvent;
import com.mux.stats.sdk.core.events.playback.RenditionChangeEvent;
import com.mux.stats.sdk.core.events.playback.RequestBandwidthEvent;
import com.mux.stats.sdk.core.events.playback.SeekedEvent;
import com.mux.stats.sdk.core.events.playback.SeekingEvent;
import com.mux.stats.sdk.core.events.playback.TimeUpdateEvent;
import com.mux.stats.sdk.core.events.playback.ViewEndEvent;
import com.mux.stats.sdk.core.events.playback.ViewInitEvent;
import com.mux.stats.sdk.core.model.CustomerPlayerData;
import com.mux.stats.sdk.core.model.CustomerVideoData;
import com.mux.stats.sdk.core.model.CustomerViewData;
import com.mux.stats.sdk.core.model.EnvironmentData;
import com.mux.stats.sdk.core.model.PlayerData;
import com.mux.stats.sdk.core.model.VideoData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.model.ViewerData;
import com.mux.stats.sdk.core.util.MuxExceptionTracker;
import com.mux.stats.sdk.core.util.MuxLogger;
import com.mux.stats.sdk.muxstats.IDevice;
import com.mux.stats.sdk.muxstats.INetworkRequest;
import com.mux.stats.sdk.muxstats.IPlayerListener;
import com.mux.stats.sdk.muxstats.MuxErrorException;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class MuxStats
extends BaseEventListener {
    private static final String TAG = "MuxStats";
    private static final long TIME_UPDATE_INTERVAL_MS = 100L;
    private static final long MAX_SECONDS_SEEK_PLAYHEAD_SHIFT = 500L;
    private static final long SEEK_PLAYHEAD_DRIFT_MS = 200L;
    private Timer timer;
    private String playerName;
    private CustomerPlayerData customerPlayerData;
    private CustomerVideoData customerVideoData;
    private CustomerViewData customerViewData;
    private Integer playerWidth;
    private Integer playerHeight;
    private Integer screenWidth;
    private Integer screenHeight;
    private VideoData videoData = new VideoData();
    private long lastPlaybackPosition;
    private long lastPlaybackTimeUpdated;
    private boolean started;
    private String errorMessage;
    private int errorCode;
    private boolean playerSizeControlledManually;
    private String muxViewerId;
    private String packageName;
    private String packageVersion;
    private boolean automaticErrors;
    private boolean sentryEnabled;
    private CorePlayer player;
    private IPlayerListener listener;
    private static IDevice hostDevice = null;
    private static INetworkRequest hostNetworkApi = null;

    public MuxStats(IPlayerListener listener, String playerName, CustomerPlayerData customerPlayerData, CustomerVideoData customerVideoData) {
        this(listener, playerName, customerPlayerData, customerVideoData, null, true);
    }

    public MuxStats(IPlayerListener listener, String playerName, CustomerPlayerData customerPlayerData, CustomerVideoData customerVideoData, CustomerViewData customerViewData) {
        this(listener, playerName, customerPlayerData, customerVideoData, customerViewData, true);
    }

    public MuxStats(IPlayerListener listener, String playerName, CustomerPlayerData customerPlayerData, CustomerVideoData customerVideoData, CustomerViewData customerViewData, boolean sentryEnabled) {
        this.playerName = playerName;
        this.customerViewData = customerViewData;
        this.customerPlayerData = customerPlayerData;
        this.customerVideoData = customerVideoData;
        this.automaticErrors = true;
        this.playerSizeControlledManually = false;
        this.sentryEnabled = sentryEnabled;
        this.enforceNonNull();
        this.init(listener);
    }

    public CustomerVideoData getCustomerVideoData() {
        return this.customerVideoData;
    }

    public CustomerViewData getCustomerViewData() {
        return this.customerViewData;
    }

    public CustomerPlayerData getCustomerPlayerData() {
        return this.customerPlayerData;
    }

    public void updateCustomerData(CustomerPlayerData customerPlayerData, CustomerVideoData customerVideoData) {
        this.updateCustomerData(customerPlayerData, customerVideoData, null);
    }

    public void updateCustomerData(CustomerPlayerData customerPlayerData, CustomerVideoData customerVideoData, CustomerViewData customerViewData) {
        if (customerVideoData != null || customerPlayerData != null || customerViewData != null) {
            DataEvent dataEvent = new DataEvent();
            if (customerVideoData != null) {
                this.customerVideoData = customerVideoData;
                dataEvent.setCustomerVideoData(customerVideoData);
            }
            if (customerPlayerData != null) {
                this.customerPlayerData = customerPlayerData;
                dataEvent.setCustomerPlayerData(customerPlayerData);
            }
            if (customerViewData != null) {
                this.customerViewData = customerViewData;
                dataEvent.setCustomerViewData(customerViewData);
            }
            this.dispatch(dataEvent);
        }
    }

    public static void setHostDevice(IDevice device) {
        hostDevice = device;
    }

    public static IDevice getHostDevice() {
        return hostDevice;
    }

    public static void setHostNetworkApi(INetworkRequest network) {
        hostNetworkApi = network;
    }

    public static INetworkRequest getHostNetworkApi() {
        return hostNetworkApi;
    }

    public void allowLogcatOutput(boolean allow, boolean verbose) {
        Core.allowLogcatOutputForPlayer(this.playerName, allow, verbose);
    }

    public void orientationChange(MuxSDKViewOrientation orientation) {
        Core.orientationChangeForPlayer(this.playerName, orientation);
    }

    private void enforceNonNull() {
        if (this.playerName == null) {
            throw new IllegalArgumentException("playerName cannot be null");
        }
        if (this.customerPlayerData == null) {
            throw new IllegalArgumentException("customerPlayerData cannot be null");
        }
    }

    public void videoChange(CustomerVideoData customerVideoData) {
        this.dispatch(new ViewEndEvent(this.getPlayerData()));
        this.dispatch(new ViewInitEvent(this.getPlayerData()));
        this.customerVideoData = customerVideoData;
        DataEvent dataEvent = new DataEvent();
        if (customerVideoData != null) {
            dataEvent.setCustomerVideoData(customerVideoData);
        }
        this.videoData = new VideoData();
        dataEvent.setVideoData(this.videoData);
        this.dispatch(dataEvent);
    }

    private PlaybackEvent setProgramChangeToEvent(PlaybackEvent event) {
        if (event.getViewData() == null) {
            ViewData vd = new ViewData();
            vd.setViewProgramChanged(true);
            event.setViewData(vd);
        } else {
            event.getViewData().setViewProgramChanged(true);
        }
        return event;
    }

    public void programChange(CustomerVideoData customerVideoData) {
        this.videoChange(customerVideoData);
        this.dispatch(this.setProgramChangeToEvent(new PlayEvent(this.getPlayerData())));
        this.dispatch(this.setProgramChangeToEvent(new PlayingEvent(this.getPlayerData())));
    }

    public void setPlayerSize(int width, int height) {
        this.playerSizeControlledManually = true;
        this.playerWidth = width;
        this.playerHeight = height;
    }

    public void setScreenSize(int width, int height) {
        this.screenWidth = width;
        this.screenHeight = height;
    }

    public void error(MuxErrorException e) {
        this.errorMessage = e.getMessage();
        this.errorCode = e.getCode();
        MuxLogger.d(TAG, "external error (" + Integer.toString(this.errorCode) + "): " + this.errorMessage);
        this.checkVideoData();
        this.dispatch(new ErrorEvent(this.getPlayerData()));
    }

    public void setAutomaticErrorTracking(boolean enabled) {
        this.automaticErrors = enabled;
    }

    public void release() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
        if (this.playerName != null) {
            Core.destroyPlayer(this.playerName);
        }
        this.listener = null;
        this.player = null;
    }

    private void dispatch(IEvent event) {
        block2: {
            try {
                Core.dispatchEventForPlayer(this.playerName, event);
            }
            catch (Throwable t) {
                if (!this.sentryEnabled) break block2;
                MuxExceptionTracker.sendException(t, this.customerPlayerData.getEnvironmentKey());
            }
        }
    }

    private void init(IPlayerListener listener) {
        this.player = Core.createPlayer(this.playerName, this.sentryEnabled);
        this.listener = listener;
        this.prepareEnvironment();
        PlayerData playerData = this.getPlayerData();
        this.dispatch(new ViewInitEvent(playerData));
        this.timer = new Timer();
        MuxStats delegate = this;
        this.timer.scheduleAtFixedRate((TimerTask)new TimeUpdateTask(delegate, this.timer), 0L, 100L);
        this.videoData = new VideoData();
        DataEvent dataEvent = new DataEvent();
        if (this.customerPlayerData != null) {
            dataEvent.setCustomerPlayerData(this.customerPlayerData);
        }
        if (this.customerVideoData != null) {
            dataEvent.setCustomerVideoData(this.customerVideoData);
        }
        if (this.customerViewData != null) {
            dataEvent.setCustomerViewData(this.customerViewData);
        }
        if (this.customerPlayerData != null || this.customerVideoData != null || this.customerViewData != null) {
            this.dispatch(dataEvent);
        }
        this.dispatch(new PlayerReadyEvent(playerData));
    }

    private void prepareEnvironment() {
        block7: {
            try {
                EnvironmentData environmentData = new EnvironmentData();
                if (hostDevice != null) {
                    this.muxViewerId = hostDevice.getDeviceId();
                    this.packageName = hostDevice.getAppName();
                    this.packageVersion = hostDevice.getAppVersion();
                }
                if (this.muxViewerId != null) {
                    environmentData.setMuxViewerId(this.muxViewerId);
                }
                ViewerData viewerData = new ViewerData();
                if (hostDevice != null) {
                    viewerData.setViewerOsFamily(hostDevice.getOSFamily());
                    viewerData.setViewerOsArchitecture(hostDevice.getHardwareArchitecture());
                    viewerData.setViewerOsVersion(hostDevice.getOSVersion());
                    viewerData.setViewerDeviceManufacturer(hostDevice.getManufacturer());
                    viewerData.setViewerDeviceName(hostDevice.getModelName());
                    viewerData.setViewerConnectionType(hostDevice.getNetworkConnectionType());
                }
                if (this.packageName != null) {
                    viewerData.setViewerApplicationName(this.packageName);
                }
                if (this.packageVersion != null) {
                    viewerData.setViewerApplicationVersion(this.packageVersion);
                }
                DataEvent dataEvent = new DataEvent();
                dataEvent.setEnvironmentData(environmentData);
                dataEvent.setViewerData(viewerData);
                Core.dispatchDataEvent(dataEvent);
            }
            catch (Throwable t) {
                if (!this.sentryEnabled) break block7;
                MuxExceptionTracker.sendException(t, this.customerPlayerData.getEnvironmentKey());
            }
        }
    }

    private PlayerData getPlayerData() {
        PlayerData playerData = new PlayerData();
        IDevice device = MuxStats.getHostDevice();
        if (device != null) {
            playerData.setPlayerMuxPluginName(device.getPluginName());
            playerData.setPlayerMuxPluginVersion(device.getPluginVersion());
            playerData.setPlayerSoftwareName(device.getPlayerSoftware());
        }
        if (hostDevice != null) {
            playerData.setPlayerSoftwareVersion(hostDevice.getPlayerVersion());
        }
        if (this.listener == null) {
            return playerData;
        }
        playerData.setPlayerIsPaused(this.listener.isPaused());
        playerData.setPlayerPlayheadTime(this.listener.getCurrentPosition());
        if (this.errorMessage != null) {
            playerData.setPlayerErrorMessage(this.errorMessage);
            playerData.setPlayerErrorCode(Integer.toString(this.errorCode));
        }
        if (!this.playerSizeControlledManually) {
            this.playerWidth = this.listener.getPlayerViewWidth();
            this.playerHeight = this.listener.getPlayerViewHeight();
        }
        if (this.playerHeight != null && this.playerWidth != null) {
            playerData.setPlayerHeight(this.playerHeight);
            playerData.setPlayerWidth(this.playerWidth);
            if (this.screenHeight != null && this.screenWidth != null) {
                if (this.screenHeight.equals(this.playerHeight) && this.screenWidth.equals(this.playerWidth) || this.screenWidth.equals(this.playerHeight) && this.screenHeight.equals(this.playerWidth)) {
                    playerData.setPlayerIsFullscreen("true");
                } else {
                    playerData.setPlayerIsFullscreen("false");
                }
            }
        }
        return playerData;
    }

    private void checkVideoData() {
        boolean videoDataUpdated = false;
        if (this.listener == null) {
            return;
        }
        if (this.listener.getSourceWidth() != null && this.videoData.getVideoSourceWidth() != this.listener.getSourceWidth()) {
            this.videoData.setVideoSourceWidth(this.listener.getSourceWidth());
            videoDataUpdated = true;
        }
        if (this.listener.getSourceHeight() != null && this.videoData.getVideoSourceHeight() != this.listener.getSourceHeight()) {
            this.videoData.setVideoSourceHeight(this.listener.getSourceHeight());
            videoDataUpdated = true;
        }
        if (this.listener.getMimeType() != null && this.videoData.getVideoSourceMimeType() != this.listener.getMimeType()) {
            this.videoData.setVideoSourceMimeType(this.listener.getMimeType());
            videoDataUpdated = true;
        }
        if (this.listener.getSourceDuration() != null && this.videoData.getVideoSourceDuration() != this.listener.getSourceDuration()) {
            this.videoData.setVideoSourceDuration(this.listener.getSourceDuration());
            videoDataUpdated = true;
        }
        if (this.listener.getSourceAdvertisedBitrate() != null && this.videoData.getVideoSourceAdvertisedBitrate() != this.listener.getSourceAdvertisedBitrate()) {
            this.videoData.setVideoSourceAdvertisedBitrate(this.listener.getSourceAdvertisedBitrate());
            videoDataUpdated = true;
        }
        if (this.listener.getSourceAdvertisedFramerate() != null && this.videoData.getVideoSourceAdvertisedFramerate() != this.listener.getSourceAdvertisedFramerate()) {
            this.videoData.setVideoSourceAdvertisedFramerate(this.listener.getSourceAdvertisedFramerate());
            videoDataUpdated = true;
        }
        if (videoDataUpdated) {
            DataEvent dataEvent = new DataEvent();
            dataEvent.setVideoData(this.videoData);
            this.dispatch(dataEvent);
        }
    }

    private void dispatchTimeUpdateFromTimer() {
        this.handle(new TimeUpdateEvent(null));
    }

    private void updatePlaybackPosition() {
        if (this.listener != null) {
            this.lastPlaybackTimeUpdated = new Date().getTime();
            this.lastPlaybackPosition = this.listener.getCurrentPosition();
        }
    }

    @Override
    public synchronized void handle(IEvent event) {
        if (!event.isPlayback() && !event.isError()) {
            MuxLogger.d(TAG, "unexpected internal event");
            return;
        }
        if (event.isError() && !this.automaticErrors) {
            MuxLogger.d(TAG, "error detected, but automatic error reporting is disabled");
            return;
        }
        switch (event.getType()) {
            case "timeupdate": {
                this.checkVideoData();
                this.dispatch(new TimeUpdateEvent(this.getPlayerData()));
                break;
            }
            case "play": {
                this.checkVideoData();
                this.started = true;
                this.dispatch(new PlayEvent(this.getPlayerData()));
                break;
            }
            case "playing": {
                this.checkVideoData();
                PlayerData playerData = this.getPlayerData();
                this.dispatch(new PlayingEvent(playerData));
                break;
            }
            case "seeking": {
                this.checkVideoData();
                this.dispatch(new SeekingEvent(this.getPlayerData()));
                break;
            }
            case "seeked": {
                this.checkVideoData();
                this.dispatch(new SeekedEvent(this.getPlayerData()));
                break;
            }
            case "pause": {
                this.checkVideoData();
                this.dispatch(new PauseEvent(this.getPlayerData()));
                break;
            }
            case "ended": {
                this.checkVideoData();
                this.dispatch(new EndedEvent(this.getPlayerData()));
                break;
            }
            case "internalerror": {
                InternalErrorEvent errorEvent = (InternalErrorEvent)event;
                this.errorMessage = errorEvent.getErrorMessage();
                this.errorCode = errorEvent.getErrorCode();
                MuxLogger.d(TAG, "internal error: " + this.errorMessage);
                this.checkVideoData();
                this.dispatch(new ErrorEvent(this.getPlayerData()));
                break;
            }
            case "bandwidth": {
                this.checkVideoData();
                RequestBandwidthEvent playbackEvent = new RequestBandwidthEvent(this.getPlayerData());
                playbackEvent.setBandwidthMetricData(((PlaybackEvent)event).getBandwidthMetricData());
                this.dispatch(playbackEvent);
                break;
            }
            case "renditionchange": {
                this.checkVideoData();
                RenditionChangeEvent renditionEvent = new RenditionChangeEvent(this.getPlayerData());
                this.dispatch(renditionEvent);
                break;
            }
            case "adbreakstart": 
            case "adbreakend": 
            case "adended": 
            case "aderror": 
            case "adfirstquartile": 
            case "admidpoint": 
            case "adpause": 
            case "adplay": 
            case "adplaying": 
            case "adrequest": 
            case "adresponse": 
            case "adthirdquartile": {
                this.handleAdsEvents(event);
            }
        }
        this.updatePlaybackPosition();
    }

    private void handleAdsEvents(IEvent event) {
        PlaybackEvent playbackEvent;
        this.checkVideoData();
        switch (event.getType()) {
            case "adbreakstart": {
                playbackEvent = new AdBreakStartEvent(this.getPlayerData());
                break;
            }
            case "adbreakend": {
                playbackEvent = new AdBreakEndEvent(this.getPlayerData());
                break;
            }
            case "adended": {
                playbackEvent = new AdEndedEvent(this.getPlayerData());
                break;
            }
            case "aderror": {
                playbackEvent = new AdErrorEvent(this.getPlayerData());
                break;
            }
            case "adfirstquartile": {
                playbackEvent = new AdFirstQuartileEvent(this.getPlayerData());
                break;
            }
            case "admidpoint": {
                playbackEvent = new AdMidpointEvent(this.getPlayerData());
                break;
            }
            case "adpause": {
                playbackEvent = new AdPauseEvent(this.getPlayerData());
                break;
            }
            case "adplay": {
                playbackEvent = new AdPlayEvent(this.getPlayerData());
                break;
            }
            case "adplaying": {
                playbackEvent = new AdPlayingEvent(this.getPlayerData());
                break;
            }
            case "adrequest": {
                playbackEvent = new AdRequestEvent(this.getPlayerData());
                break;
            }
            case "adresponse": {
                playbackEvent = new AdResponseEvent(this.getPlayerData());
                break;
            }
            case "adthirdquartile": {
                playbackEvent = new AdThirdQuartileEvent(this.getPlayerData());
                break;
            }
            default: {
                return;
            }
        }
        playbackEvent.setViewData(((PlaybackEvent)event).getViewData());
        this.dispatch(playbackEvent);
    }

    protected CorePlayer getCorePlayer() {
        return this.player;
    }

    private static class TimeUpdateTask
    extends TimerTask {
        private final WeakReference<MuxStats> muxStatsReference;
        private final WeakReference<Timer> timerReference;

        public TimeUpdateTask(MuxStats delegate, Timer timer) {
            this.muxStatsReference = new WeakReference<MuxStats>(delegate);
            this.timerReference = new WeakReference<Timer>(timer);
        }

        @Override
        public void run() {
            MuxStats delegate = (MuxStats)this.muxStatsReference.get();
            if (delegate != null) {
                try {
                    if (!delegate.listener.isPaused()) {
                        delegate.dispatchTimeUpdateFromTimer();
                    }
                }
                catch (Throwable t) {
                    if (delegate.sentryEnabled) {
                        MuxExceptionTracker.sendException(t, delegate.customerPlayerData.getEnvironmentKey());
                    }
                    MuxLogger.d(MuxStats.TAG, "uncaught exception in timer task, cleaning up and exiting");
                    delegate.release();
                }
            } else {
                Timer timer = (Timer)this.timerReference.get();
                if (timer != null) {
                    timer.cancel();
                    timer.purge();
                }
            }
        }
    }
}

