/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.util;

import com.mux.stats.sdk.core.util.MuxLogger;
import com.mux.stats.sdk.core.util.UUID;
import com.mux.stats.sdk.muxstats.IDevice;
import com.mux.stats.sdk.muxstats.MuxStats;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MuxExceptionTracker {
    private static final String TAG = "MuxExceptionTracker";
    private static final String SENTRY_URI = "https://sentry.io/api/228922/store/";
    private static final String PUBLIC_KEY = "0f9d3da735df4b64b9660599f941f315";
    private static final String PRIVATE_KEY = "d342734b3d574eb3be25c186e861e4e4";

    private static JSONObject buildSentryDetails(Throwable t, String envKey) {
        JSONObject json = new JSONObject();
        try {
            IDevice device = MuxStats.getHostDevice();
            json.put("event_id", (Object)UUID.generateUUID().replace("-", ""));
            if (device != null) {
                json.put("logger", (Object)device.getPluginName());
            }
            json.put("platform", (Object)"java");
            json.put("level", (Object)"error");
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            df.setTimeZone(tz);
            json.put("timestamp", (Object)df.format(new Date()));
            JSONObject sdk = new JSONObject();
            if (device != null) {
                sdk.put("name", (Object)device.getPluginName());
                sdk.put("version", (Object)device.getPluginVersion());
            }
            json.put("sdk", (Object)sdk);
            JSONObject value = new JSONObject();
            value.put("type", (Object)t.getClass().toString());
            value.put("value", (Object)t.getMessage());
            value.put("stacktrace", (Object)MuxExceptionTracker.convertStackTrace(t.getStackTrace()));
            JSONArray values = new JSONArray();
            values.put((Object)value);
            JSONObject exception = new JSONObject();
            exception.put("values", (Object)values);
            json.put("exception", (Object)exception);
            if (device != null) {
                JSONObject tags = new JSONObject();
                tags.put("os_family", (Object)device.getOSFamily());
                tags.put("os_architecture", (Object)device.getHardwareArchitecture());
                tags.put("os_version", (Object)device.getOSVersion());
                tags.put("device_manufacturer", (Object)device.getManufacturer());
                tags.put("device_name", (Object)device.getModelName());
                tags.put("exoplayer_version", (Object)device.getPlayerVersion());
                tags.put("property_key", (Object)envKey);
                json.put("tags", (Object)tags);
            }
        }
        catch (Exception e) {
            MuxLogger.d(TAG, e.getMessage());
            json = null;
        }
        return json;
    }

    private static JSONObject convertStackTrace(StackTraceElement[] stackTraceElements) throws JSONException {
        JSONArray frames = new JSONArray();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            JSONObject frame = new JSONObject();
            frame.put("filename", (Object)stackTraceElement.getFileName());
            frame.put("function", (Object)stackTraceElement.getMethodName());
            frame.put("module", (Object)stackTraceElement.getClassName());
            frame.put("lineno", stackTraceElement.getLineNumber());
            frames.put((Object)frame);
        }
        JSONObject stacktrace = new JSONObject();
        stacktrace.put("frames", (Object)frames);
        return stacktrace;
    }

    public static void sendException(Throwable t, String envKey) {
        try {
            Hashtable<String, String> headers = new Hashtable<String, String>();
            IDevice device = MuxStats.getHostDevice();
            if (device != null) {
                headers.put("X-Sentry-Auth", "Sentry sentry_version=7,sentry_client=" + device.getPluginName() + "/" + device.getPlayerVersion() + ",sentry_timestamp=" + new Date().getTime() + ",sentry_key=" + PUBLIC_KEY + ",sentry_secret=" + PRIVATE_KEY);
            } else {
                headers.put("X-Sentry-Auth", "Sentry sentry_version=7,sentry_timestamp=" + new Date().getTime() + ",sentry_key=" + PUBLIC_KEY + ",sentry_secret=" + PRIVATE_KEY);
            }
            headers.put("Content-Encoding", "gzip");
            JSONObject body = MuxExceptionTracker.buildSentryDetails(t, envKey);
            if (body != null && MuxStats.getHostNetworkApi() != null) {
                MuxStats.getHostNetworkApi().post(new URL(SENTRY_URI), body, headers);
            }
        }
        catch (Exception e) {
            MuxLogger.d(TAG, e.getMessage());
        }
    }
}

