/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.ViewMetricEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseTracker;

public class WatchTimeTracker
extends BaseTracker {
    private long lastEventTime = 0L;
    private long watchTime = 0L;

    public WatchTimeTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
        ViewData viewData = new ViewData();
        viewData.setViewWatchTime(0L);
        this.dispatch(new ViewMetricEvent(viewData));
    }

    private void countWatchTime(long now) {
        if (this.lastEventTime > 0L) {
            this.watchTime += now - this.lastEventTime;
            ViewData viewData = new ViewData();
            viewData.setViewWatchTime(this.watchTime);
            this.dispatch(new ViewMetricEvent(viewData));
        }
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        String eventType = event.getType();
        if (eventType == "internalheartbeat") {
            long currentTime = event.getViewData().getViewerTime();
            this.countWatchTime(currentTime);
            this.lastEventTime = currentTime;
        } else if (eventType == "internalheartbeatend") {
            this.countWatchTime(event.getViewData().getViewerTime());
            this.lastEventTime = 0L;
        }
    }
}

