/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.ViewMetricEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseTracker;
import com.mux.stats.sdk.core.trackers.ITimeTracker;
import com.mux.stats.sdk.core.util.CurrentTime;
import java.util.HashSet;

public class ViewerTimeTracker
extends BaseTracker
implements ITimeTracker {
    private HashSet<String> derivativeEvents = new HashSet();
    private CurrentTime currentTime;

    public ViewerTimeTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
        this.derivativeEvents.add("internalheartbeat");
        this.derivativeEvents.add("internalheartbeatend");
        this.setCurrentTime(new CurrentTime());
    }

    public void setCurrentTime(CurrentTime currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public long now() {
        long time = this.currentTime.now();
        return time;
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        if (!this.derivativeEvents.contains(event.getType())) {
            ViewData viewData = new ViewData();
            viewData.setViewerTime(this.now());
            this.dispatch(new ViewMetricEvent(viewData));
        }
    }
}

