/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.ViewMetricEvent;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.events.playback.SeekingEvent;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseTracker;

public class SeekingTracker
extends BaseTracker {
    private long lastEventTime = 0L;
    private boolean isSeeking = false;
    private int viewSeekCount = 0;
    private long viewSeekDuration = 0L;
    private long viewMaxSeekTime = 0L;

    public SeekingTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
    }

    private void startSeeking(Long now, PlaybackEvent event) {
        if (!this.isSeeking) {
            this.isSeeking = true;
            SeekingEvent externalSeeking = new SeekingEvent(event.getPlayerData());
            externalSeeking.setIsSuppressed(false);
            externalSeeking.setViewData(event.getViewData());
            this.dispatch(externalSeeking);
        }
        this.lastEventTime = now;
    }

    private void completeSeek(Long now) {
        if (this.lastEventTime > 0L) {
            ++this.viewSeekCount;
            long seekDuration = now - this.lastEventTime;
            this.viewSeekDuration += seekDuration;
            if (seekDuration > this.viewMaxSeekTime) {
                this.viewMaxSeekTime = seekDuration;
            }
            ViewData viewData = new ViewData();
            viewData.setViewSeekCount(this.viewSeekCount);
            viewData.setViewSeekDuration(this.viewSeekDuration);
            viewData.setViewMaxSeekTime(this.viewMaxSeekTime);
            this.dispatch(new ViewMetricEvent(viewData));
        }
        this.isSeeking = false;
        this.lastEventTime = 0L;
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        String eventType = event.getType();
        if (eventType == "seeking") {
            this.startSeeking(event.getViewData().getViewerTime(), event);
        } else if (eventType == "seeked") {
            this.completeSeek(event.getViewData().getViewerTime());
        } else if (eventType == "viewend") {
            this.isSeeking = false;
        }
    }
}

