/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.BaseEventListener;
import com.mux.stats.sdk.core.events.EventRateExceedTrackableEvent;
import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.TrackableEvent;
import com.mux.stats.sdk.core.model.BaseQueryData;
import com.mux.stats.sdk.core.util.MuxExceptionTracker;
import com.mux.stats.sdk.core.util.MuxLogger;
import com.mux.stats.sdk.muxstats.INetworkRequest;
import com.mux.stats.sdk.muxstats.MuxStats;
import com.mux.stats.sdk.os.MuxArray;
import com.mux.stats.sdk.os.MuxDictionary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BeaconBatchTracker
extends BaseEventListener
implements INetworkRequest.IMuxNetworkRequestsCompletion {
    private static final String TAG = "MuxStatsEventQueue";
    private static final int MAX_BEACON_SIZE = 300;
    private static final int MAX_QUEUE_LENGTH = 3600;
    private static final int BEACON_INTERVAL = 5000;
    private static final long DATA_INACTIVITY_TIMEOUT = 600000L;
    protected long lastBeaconSentTime = 0L;
    protected int failureCount = 0;
    private boolean lastBeaconCompleted = true;
    private boolean verboseMode = false;
    protected ArrayList<TrackableEvent> eventQueue = new ArrayList();
    protected ArrayList<TrackableEvent> pendingEventsQueue = new ArrayList();
    protected INetworkRequest dispatcher = MuxStats.getHostNetworkApi();
    private String envKey = null;
    private final Set<String> flushEvents = new HashSet<String>(Arrays.asList("viewstart", "error", "ended", "viewend"));
    private boolean rateLimited = false;
    private boolean sentryEnabled;
    private long lastEventTime = 0L;
    private BaseQueryData previousBeaconData = null;
    private final Set<String> dataToAlwaysSend = new HashSet<String>(Arrays.asList("ake", "xid", "xsqno", "psqno", "pphti", "pinid", "uti", "mapve", "vid"));

    public BeaconBatchTracker(boolean sentryEnabled) {
        this.sentryEnabled = sentryEnabled;
    }

    public void setVerboseMode(boolean verbose) {
        this.verboseMode = verbose;
    }

    @Override
    public void handle(IEvent event) {
        TrackableEvent trackableEvent = (TrackableEvent)event;
        if (!this.rateLimited) {
            this.deduplicateBeaconData(trackableEvent);
            this.lastEventTime = System.currentTimeMillis();
            this.rateLimited = !this.queueEvent(trackableEvent);
            String eventType = trackableEvent.getEventType();
            if (this.flushEvents.contains(eventType) || this.rateLimited) {
                if (this.rateLimited) {
                    EventRateExceedTrackableEvent rateExceedEvent = new EventRateExceedTrackableEvent(trackableEvent);
                    this.eventQueue.add(rateExceedEvent);
                }
                this.flush();
            }
        }
    }

    protected long getNextBeaconTimeInterval() {
        if (this.failureCount == 0) {
            return 5000L;
        }
        double factor = Math.pow(2.0, this.failureCount - 1);
        return (long)((1.0 + (factor *= Math.random())) * 5000.0);
    }

    private boolean queueEvent(TrackableEvent event) {
        if (this.eventQueue.size() < 3600) {
            this.eventQueue.add(event);
            if (System.currentTimeMillis() - this.lastBeaconSentTime > this.getNextBeaconTimeInterval()) {
                this.sendBeaconQueue(false);
                this.lastBeaconSentTime = System.currentTimeMillis();
            }
            return this.eventQueue.size() <= 3600;
        }
        return false;
    }

    @Override
    public void flush() {
        this.sendBeaconQueue(true);
    }

    private void sendBeaconQueue(boolean flush) {
        int eventsCount = 0;
        if (flush) {
            eventsCount = this.eventQueue.size();
        } else {
            int n = eventsCount = this.eventQueue.size() > 300 ? 300 : this.eventQueue.size();
        }
        if (eventsCount == 0) {
            return;
        }
        MuxLogger.d(TAG, "attempt to send " + eventsCount + " events, total queue size " + this.eventQueue.size());
        if ((this.lastBeaconCompleted || flush) && this.dispatcher != null) {
            try {
                MuxDictionary batchJson = new MuxDictionary();
                MuxArray events = new MuxArray();
                StringBuilder eventNames = new StringBuilder();
                for (int i = 0; i < eventsCount; ++i) {
                    TrackableEvent event = this.eventQueue.remove(0);
                    this.pendingEventsQueue.add(event);
                    String eventType = event.getEventType();
                    eventNames.append(eventType + ", ");
                    MuxDictionary query = event.getQuery().getMuxDictionary();
                    query.putString("e", eventType);
                    MuxArray keys = query.keys();
                    if (this.verboseMode) {
                        MuxLogger.d(TAG, "    sending " + eventType + "\n" + event.getDebugString());
                    } else {
                        MuxLogger.d(TAG, "    sending " + eventType + " with " + keys.size() + " dims");
                    }
                    for (int ii = 0; ii < keys.size(); ++ii) {
                        String key = (String)keys.get(ii);
                        if (!key.equals("ake") || this.envKey != null) continue;
                        this.envKey = query.getString(key);
                    }
                    events.append(query);
                }
                batchJson.putArray("events", events);
                if (flush) {
                    MuxLogger.d(TAG, "flush " + eventsCount + " events to batch handler");
                } else {
                    MuxLogger.d(TAG, "submit " + eventsCount + " events to batch handler");
                }
                MuxLogger.d(TAG, "    [" + eventNames.toString() + "]");
                this.lastBeaconCompleted = false;
                this.dispatcher.postWithCompletion(this.envKey, batchJson.getJSONString(), null, this);
            }
            catch (Throwable t) {
                if (this.sentryEnabled) {
                    MuxExceptionTracker.sendException(t, this.envKey);
                }
                this.lastBeaconCompleted = true;
            }
        }
    }

    @Override
    public void onComplete(boolean result) {
        MuxLogger.d(TAG, "last batch handler result " + result);
        this.lastBeaconCompleted = true;
        if (!result) {
            if (this.eventQueue.size() + this.pendingEventsQueue.size() < 3600) {
                this.eventQueue.addAll(0, this.pendingEventsQueue);
                ++this.failureCount;
            } else {
                MuxLogger.d(TAG, "event queue too large, dropping events failed to send !!!");
            }
        } else {
            this.failureCount = 0;
        }
        this.pendingEventsQueue.clear();
    }

    private void deduplicateBeaconData(TrackableEvent event) {
        BaseQueryData beaconData = event.getQuery();
        String eventType = event.getEventType();
        if (eventType.equals("viewstart") || eventType.equals("viewend") || this.previousBeaconData == null || System.currentTimeMillis() - this.lastEventTime >= 600000L) {
            this.previousBeaconData = new BaseQueryData();
            this.previousBeaconData.update(beaconData);
            if (eventType.equals("viewend")) {
                this.previousBeaconData = null;
            }
        } else {
            BaseQueryData beaconDataCompact = new BaseQueryData();
            MuxArray keys = beaconData.keys();
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                String val = beaconData.get(key);
                if (this.previousBeaconData.get(key) != null && val.equals(this.previousBeaconData.get(key)) && !this.dataToAlwaysSend.contains(key)) continue;
                beaconDataCompact.put(key, val);
                this.previousBeaconData.put(key, val);
            }
            beaconData.clear();
            beaconData.update(beaconDataCompact);
        }
    }
}

