/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core.trackers;

import com.mux.stats.sdk.core.events.IEventDispatcher;
import com.mux.stats.sdk.core.events.playback.PlaybackEvent;
import com.mux.stats.sdk.core.model.PlayerData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.BaseAdTracker;
import com.mux.stats.sdk.core.util.CurrentTime;
import java.util.ArrayList;

public class AdTracker
extends BaseAdTracker {
    private boolean prerollRequested = false;
    private boolean prerollPlayed = false;
    private int adBreakCount = 0;
    private int adCompleteCount = 0;
    private int adViewCount = 0;
    private int adErrorCount = 0;
    private int adViewPlayCount = 0;
    private long prerollStartupRequestStartTime = 0L;
    private long prerollRequestStartTime = 0L;
    private long prerollRequestLoadTime = 0L;
    private CurrentTime currentTime = new CurrentTime();
    private long adWatchedTime = 0L;
    private long lastAdStartTime = 0L;
    private long viewAdRequestCount = 0L;
    private long viewPrerollRequestCount = 0L;
    private boolean paused = false;
    private ArrayList<Long> adRequestTimes = new ArrayList();
    private boolean wouldBeNewAdPlay = true;
    private boolean adHavePlayed = false;

    public AdTracker(IEventDispatcher dispatcher) {
        super(dispatcher);
        this.prerollStartupRequestStartTime = this.currentTime.now();
    }

    @Override
    protected void handlePlaybackEvent(PlaybackEvent event) {
        ViewData viewData = event.getViewData();
        PlayerData playerData = event.getPlayerData();
        switch (event.getType()) {
            case "adbreakstart": {
                ++this.adBreakCount;
                break;
            }
            case "adbreakend": {
                break;
            }
            case "adended": {
                this.adWatchedTime += this.currentTime.now() - this.lastAdStartTime;
                ++this.adCompleteCount;
                this.wouldBeNewAdPlay = true;
                break;
            }
            case "aderror": {
                ++this.adErrorCount;
                this.wouldBeNewAdPlay = true;
                break;
            }
            case "adfirstquartile": {
                break;
            }
            case "admidpoint": {
                break;
            }
            case "adpause": {
                this.paused = true;
                break;
            }
            case "adplay": {
                if (this.paused) {
                    this.paused = false;
                    break;
                }
                this.adHavePlayed = true;
                if (this.isPrerollPosition(viewData) && !this.prerollPlayed) {
                    this.prerollPlayed = true;
                    this.prerollRequestLoadTime = this.currentTime.now();
                    viewData.setViewPrerollRequestTime(this.prerollRequestLoadTime - this.prerollRequestStartTime);
                    viewData.setViewStartupPrerollRequestTime(this.prerollRequestLoadTime - this.prerollStartupRequestStartTime);
                }
                ++this.adViewCount;
                this.lastAdStartTime = this.currentTime.now();
                if (!this.wouldBeNewAdPlay) break;
                this.wouldBeNewAdPlay = false;
                ++this.adViewPlayCount;
                break;
            }
            case "adplaying": {
                if (!this.isPrerollPosition(viewData) || this.prerollRequestLoadTime <= 0L) break;
                long loadDelta = this.currentTime.now() - this.prerollRequestLoadTime;
                viewData.setViewPrerollLoadTime(loadDelta);
                viewData.setViewStartupPrerollLoadTime(loadDelta);
                break;
            }
            case "adrequest": {
                if (this.prerollRequestStartTime == 0L) {
                    this.prerollRequestStartTime = this.currentTime.now();
                }
                if (this.isPrerollPosition(viewData)) {
                    this.prerollRequested = true;
                    if (!this.adHavePlayed) {
                        ++this.viewPrerollRequestCount;
                    }
                }
                ++this.viewAdRequestCount;
                viewData.setViewAdRequestCount(this.viewAdRequestCount);
                this.adRequestTimes.add(this.currentTime.now());
                break;
            }
            case "adresponse": {
                if (this.adRequestTimes.size() <= 0) break;
                long viewAdRequestTime = this.currentTime.now() - this.adRequestTimes.remove(0);
                viewData.setViewAdRequestTime(viewAdRequestTime);
                break;
            }
            case "adthirdquartile": {
                break;
            }
            default: {
                return;
            }
        }
        viewData.setViewAdBreakCount(this.adBreakCount);
        viewData.setViewAdCompleteCount(this.adCompleteCount);
        viewData.setViewAdViewCount(this.adViewCount);
        viewData.setViewAdErrorCount(this.adErrorCount);
        if (this.prerollRequested) {
            viewData.setViewPrerollRequested(this.prerollRequested);
        }
        if (this.prerollPlayed) {
            viewData.setViewPrerollPlayed(this.prerollPlayed);
        }
        viewData.setViewAdWatchTime(this.adWatchedTime);
        viewData.setViewPrerollRequestCount(this.viewPrerollRequestCount);
        viewData.setViewAdPlayCount(this.adViewPlayCount);
    }

    private boolean isPrerollPosition(ViewData viewData) {
        Long contentPlaybackTime = viewData.getViewContentPlaybackTime();
        return contentPlaybackTime == null || contentPlaybackTime < 1000L;
    }
}

