/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core;

import com.mux.stats.sdk.core.events.EventBus;
import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.TrackableEvent;
import com.mux.stats.sdk.core.events.ViewMetricEvent;
import com.mux.stats.sdk.core.events.data.DataEvent;
import com.mux.stats.sdk.core.events.playback.IPlaybackEvent;
import com.mux.stats.sdk.core.model.BandwidthMetricData;
import com.mux.stats.sdk.core.model.CustomerVideoData;
import com.mux.stats.sdk.core.model.VideoData;
import com.mux.stats.sdk.core.model.ViewData;
import com.mux.stats.sdk.core.trackers.AdTracker;
import com.mux.stats.sdk.core.trackers.ExternalEventTracker;
import com.mux.stats.sdk.core.trackers.ExternalHeartbeatTracker;
import com.mux.stats.sdk.core.trackers.InternalHeartbeatTracker;
import com.mux.stats.sdk.core.trackers.PlaybackTimeTracker;
import com.mux.stats.sdk.core.trackers.RebufferTracker;
import com.mux.stats.sdk.core.trackers.RequestMetricsTracker;
import com.mux.stats.sdk.core.trackers.ScalingTracker;
import com.mux.stats.sdk.core.trackers.SeekingTracker;
import com.mux.stats.sdk.core.trackers.TimeToFirstFrameTracker;
import com.mux.stats.sdk.core.trackers.ViewStateTracker;
import com.mux.stats.sdk.core.trackers.ViewerTimeTracker;
import com.mux.stats.sdk.core.trackers.WatchTimeTracker;
import com.mux.stats.sdk.core.util.UUID;

public class CoreView
extends EventBus {
    private ViewData viewData;
    private VideoData videoData;
    private CustomerVideoData customerVideoData;
    private int viewSequenceNumber;
    private BandwidthMetricData bandwidthMetricData;

    private void viewInit() {
        this.viewData = new ViewData();
        this.viewData.setViewId(UUID.generateUUID());
        this.videoData = new VideoData();
        this.customerVideoData = new CustomerVideoData();
        this.bandwidthMetricData = new BandwidthMetricData();
        this.viewSequenceNumber = 0;
        this.addListener(new ViewerTimeTracker(this));
        this.addListener(new ScalingTracker(this));
        this.addListener(new SeekingTracker(this));
        this.addListener(new InternalHeartbeatTracker(this));
        this.addListener(new PlaybackTimeTracker(this));
        this.addListener(new WatchTimeTracker(this));
        this.addListener(new TimeToFirstFrameTracker(this));
        this.addListener(new RebufferTracker(this));
        this.addListener(new ViewStateTracker(this));
        this.addListener(new RequestMetricsTracker(this));
        this.addListener(new AdTracker(this));
        this.addListener(new ExternalEventTracker(this));
        this.addListener(new ExternalHeartbeatTracker(this));
    }

    private void handlePlaybackEvent(IPlaybackEvent event) {
        if (event.getType() == "viewinit") {
            this.viewInit();
        }
        if (event.getViewData() != null) {
            this.viewData.update(event.getViewData());
        }
        event.setViewData(this.viewData);
        event.setVideoData(this.videoData);
        if (this.bandwidthMetricData != null) {
            this.bandwidthMetricData.update(event.getBandwidthMetricData());
        }
    }

    private void handleTrackableEvent(TrackableEvent trackableEvent) {
        this.viewData.update(trackableEvent.getViewData());
        this.viewData.setViewSequenceNumber(++this.viewSequenceNumber);
        trackableEvent.setViewData(this.viewData);
        trackableEvent.setVideoData(this.videoData);
        trackableEvent.setCustomerVideoData(this.customerVideoData);
        trackableEvent.setBandwidthMetricData(this.bandwidthMetricData);
    }

    private void handleDataEvent(DataEvent dataEvent) {
        if (this.videoData == null || this.customerVideoData == null) {
            return;
        }
        this.videoData.update(dataEvent.getVideoData());
        this.customerVideoData.update(dataEvent.getCustomerVideoData());
    }

    @Override
    public void dispatch(IEvent event) {
        if (event.isTrackable()) {
            this.handleTrackableEvent((TrackableEvent)event);
        } else if (event.isPlayback()) {
            this.handlePlaybackEvent((IPlaybackEvent)event);
        }
        if (event.isViewMetric()) {
            this.viewData.update(((ViewMetricEvent)event).getViewData());
        } else if (event.isData()) {
            this.handleDataEvent((DataEvent)event);
        } else {
            super.dispatch(event);
        }
    }
}

