/*
 * Decompiled with CFR 0.152.
 */
package com.mux.stats.sdk.core;

import com.mux.stats.sdk.core.CorePlayer;
import com.mux.stats.sdk.core.MuxSDKViewOrientation;
import com.mux.stats.sdk.core.Session;
import com.mux.stats.sdk.core.events.BaseEventListener;
import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.IEventListener;
import com.mux.stats.sdk.core.events.TrackableEvent;
import com.mux.stats.sdk.core.events.data.DataEvent;
import com.mux.stats.sdk.core.model.EnvironmentData;
import com.mux.stats.sdk.core.model.ViewerData;
import java.util.concurrent.ConcurrentHashMap;

public class Core {
    private static final String MUX_API_VERSION = "2.1";
    private static final String MUX_EMBED_VERSION = "5.0.0";
    private static final String DEBUG_EVENT_ID = "DEBUG";
    private static ConcurrentHashMap<String, CorePlayer> players = new ConcurrentHashMap();
    private static IEventListener clientEventListener;
    private static EnvironmentData environmentData;
    private static ViewerData viewerData;
    private static Session session;
    private static boolean environmentDataReady;

    private static void initEnvironmentData() {
        if (environmentDataReady) {
            return;
        }
        session.startSession();
        environmentData.setMuxApiVersion(MUX_API_VERSION);
        environmentData.setMuxEmbedVersion(MUX_EMBED_VERSION);
        environmentDataReady = true;
    }

    public static CorePlayer createPlayer(String playerId, boolean sentryEnabled) {
        Core.initEnvironmentData();
        CorePlayer player = new CorePlayer(sentryEnabled);
        player.addListener(new EventListener(playerId));
        players.put(playerId, player);
        return player;
    }

    public static void setClientEventListener(IEventListener eventListener) {
        clientEventListener = eventListener;
    }

    public static void destroyPlayer(String playerId) {
        CorePlayer player = players.remove(playerId);
        if (player != null) {
            player.flush();
        }
    }

    public static void dispatchEventForPlayer(String playerId, IEvent event) {
        CorePlayer player = players.get(playerId);
        if (player != null) {
            session.updateEnvironmentData(environmentData);
            player.dispatch(event);
        }
    }

    public static void orientationChangeForPlayer(String playerId, MuxSDKViewOrientation orientation) {
        CorePlayer player = players.get(playerId);
        if (player != null) {
            player.dispatchOrientationChange(orientation);
        }
    }

    public static void dispatchDataEvent(DataEvent dataEvent) {
        environmentData.update(dataEvent.getEnvironmentData());
        viewerData.update(dataEvent.getViewerData());
    }

    public static void allowLogcatOutputForPlayer(String playerId, boolean allow, boolean verbose) {
        CorePlayer player = players.get(playerId);
        if (player != null) {
            player.allowLogcatOutput(allow, verbose);
        }
    }

    static {
        environmentData = new EnvironmentData();
        viewerData = new ViewerData();
        session = new Session();
        environmentDataReady = false;
    }

    static class EventListener
    extends BaseEventListener {
        private String playerId;

        public EventListener(String playerId) {
            this.playerId = playerId;
        }

        @Override
        public void handle(IEvent event) {
            if (event.isTrackable()) {
                TrackableEvent e = (TrackableEvent)event;
                e.setEnvironmentData(environmentData);
                e.setViewerData(viewerData);
                if (clientEventListener != null) {
                    clientEventListener.handle(event);
                } else {
                    CorePlayer player = (CorePlayer)players.get(this.playerId);
                    if (player != null) {
                        player.handle(event);
                    }
                }
            }
        }

        @Override
        public void flush() {
            CorePlayer player = (CorePlayer)players.get(this.playerId);
            if (player != null) {
                player.flush();
            }
        }
    }
}

