/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.yospace;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import com.yospace.android.hls.analytic.advert.AdBreak;
import java.util.List;

public class TimelineView
extends View {
    private ShapeDrawable mTimeline;
    private ShapeDrawable mPlayhead;
    List<AdBreak> mAdbreakList;
    private long mTotalTime;
    private int mBarWidth;
    private static int mXPadding = 20;
    private static int mYOffset = 0;
    private static int mPlayheadWidth = 10;
    private static int mBarHeight = 20;

    private void init(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        this.mBarWidth = size.x - 2 * mXPadding;
        this.mTimeline = new ShapeDrawable((Shape)new RectShape());
        this.mTimeline.getPaint().setColor(-1);
        this.mTimeline.setBounds(mXPadding, mYOffset, this.mBarWidth, mYOffset + mBarHeight);
        this.mPlayhead = new ShapeDrawable((Shape)new RectShape());
        this.mPlayhead.getPaint().setColor(-65536);
        this.mPlayhead.setBounds(mXPadding, mYOffset, mXPadding + mPlayheadWidth, mYOffset + mBarHeight);
    }

    protected void onDraw(Canvas canvas) {
        this.mTimeline.draw(canvas);
        if (this.mAdbreakList != null && !this.mAdbreakList.isEmpty()) {
            for (AdBreak adbreak : this.mAdbreakList) {
                ShapeDrawable ab = new ShapeDrawable((Shape)new RectShape());
                int start = this.timeToX(adbreak.getStartMillis());
                int end = this.timeToX(adbreak.getStartMillis() + (long)adbreak.getDuration());
                ab.setBounds(mXPadding + start, mYOffset, mXPadding + end, mYOffset + mBarHeight);
                if (adbreak.isActive()) {
                    ab.getPaint().setColor(-16776961);
                } else {
                    ab.getPaint().setColor(-12303292);
                }
                ab.draw(canvas);
            }
        }
        this.mPlayhead.draw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        long time = this.xToTime(x);
        return super.onTouchEvent(event);
    }

    public void setPlayhead(long playhead) {
        int position = this.timeToX(playhead);
        this.mPlayhead.setBounds(mXPadding + position, mYOffset, mXPadding + mPlayheadWidth + position, mYOffset + mBarHeight);
        this.invalidate();
    }

    public void setTotalTime(long totalTime) {
        this.mTotalTime = totalTime;
    }

    public TimelineView(Context context) {
        super(context);
        this.init(context);
    }

    public TimelineView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public TimelineView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private int timeToX(long time) {
        return (int)Math.round((double)time / (double)this.mTotalTime * (double)this.mBarWidth);
    }

    public void UpdateTimeline(List<AdBreak> adbreakList, int total) {
        this.mAdbreakList = adbreakList;
        this.mTotalTime = total;
        this.invalidate();
    }

    private long xToTime(float val) {
        return Math.round((double)val * (double)this.mTotalTime / (double)this.mBarWidth);
    }
}

