/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.media.elements;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class MediaFormat
implements Parcelable {
    public static final int NO_VALUE = -1;
    public static final long OFFSET_SAMPLE_RELATIVE = Long.MAX_VALUE;
    public final String trackId;
    public final String mimeType;
    public final int bitrate;
    public final int maxInputSize;
    public final long durationUs;
    public final List<byte[]> initializationData;
    public final boolean adaptive;
    public final int width;
    public final int height;
    public final int maxWidth;
    public final int maxHeight;
    public final int rotationDegrees;
    public final float pixelWidthHeightRatio;
    public final int channelCount;
    public final int sampleRate;
    public final int pcmEncoding;
    public final int encoderDelay;
    public final int encoderPadding;
    public final String language;
    public final long subsampleOffsetUs;
    private int hashCode;
    private android.media.MediaFormat frameworkMediaFormat;
    public static final Parcelable.Creator<MediaFormat> CREATOR = new Parcelable.Creator<MediaFormat>(){

        public MediaFormat createFromParcel(Parcel in) {
            return new MediaFormat(in);
        }

        public MediaFormat[] newArray(int size) {
            return new MediaFormat[size];
        }
    };

    public static MediaFormat createVideoFormat(String trackId, String mimeType, int bitrate, int maxInputSize, long durationUs, int width, int height, List<byte[]> initializationData) {
        return MediaFormat.createVideoFormat(trackId, mimeType, bitrate, maxInputSize, durationUs, width, height, initializationData, -1, -1.0f);
    }

    public static MediaFormat createVideoFormat(String trackId, String mimeType, int bitrate, int maxInputSize, long durationUs, int width, int height, List<byte[]> initializationData, int rotationDegrees, float pixelWidthHeightRatio) {
        return new MediaFormat(trackId, mimeType, bitrate, maxInputSize, durationUs, width, height, rotationDegrees, pixelWidthHeightRatio, -1, -1, null, Long.MAX_VALUE, initializationData, false, -1, -1, -1, -1, -1);
    }

    public static MediaFormat createAudioFormat(String trackId, String mimeType, int bitrate, int maxInputSize, long durationUs, int channelCount, int sampleRate, List<byte[]> initializationData, String language) {
        return MediaFormat.createAudioFormat(trackId, mimeType, bitrate, maxInputSize, durationUs, channelCount, sampleRate, initializationData, language, -1);
    }

    public static MediaFormat createAudioFormat(String trackId, String mimeType, int bitrate, int maxInputSize, long durationUs, int channelCount, int sampleRate, List<byte[]> initializationData, String language, int pcmEncoding) {
        return new MediaFormat(trackId, mimeType, bitrate, maxInputSize, durationUs, -1, -1, -1, -1.0f, channelCount, sampleRate, language, Long.MAX_VALUE, initializationData, false, -1, -1, pcmEncoding, -1, -1);
    }

    public static MediaFormat createTextFormat(String trackId, String mimeType, int bitrate, long durationUs, String language) {
        return MediaFormat.createTextFormat(trackId, mimeType, bitrate, durationUs, language, Long.MAX_VALUE);
    }

    public static MediaFormat createTextFormat(String trackId, String mimeType, int bitrate, long durationUs, String language, long subsampleOffsetUs) {
        return new MediaFormat(trackId, mimeType, bitrate, -1, durationUs, -1, -1, -1, -1.0f, -1, -1, language, subsampleOffsetUs, null, false, -1, -1, -1, -1, -1);
    }

    public static MediaFormat createImageFormat(String trackId, String mimeType, int bitrate, long durationUs, List<byte[]> initializationData, String language) {
        return new MediaFormat(trackId, mimeType, bitrate, -1, durationUs, -1, -1, -1, -1.0f, -1, -1, language, Long.MAX_VALUE, initializationData, false, -1, -1, -1, -1, -1);
    }

    public static MediaFormat createFormatForMimeType(String trackId, String mimeType, int bitrate, long durationUs) {
        return new MediaFormat(trackId, mimeType, bitrate, -1, durationUs, -1, -1, -1, -1.0f, -1, -1, null, Long.MAX_VALUE, null, false, -1, -1, -1, -1, -1);
    }

    public static MediaFormat createId3Format() {
        return MediaFormat.createFormatForMimeType(null, "application/id3", -1, -9223372036854775807L);
    }

    MediaFormat(Parcel in) {
        this.trackId = in.readString();
        this.mimeType = in.readString();
        this.bitrate = in.readInt();
        this.maxInputSize = in.readInt();
        this.durationUs = in.readLong();
        this.width = in.readInt();
        this.height = in.readInt();
        this.rotationDegrees = in.readInt();
        this.pixelWidthHeightRatio = in.readFloat();
        this.channelCount = in.readInt();
        this.sampleRate = in.readInt();
        this.language = in.readString();
        this.subsampleOffsetUs = in.readLong();
        this.initializationData = new ArrayList<byte[]>();
        in.readList(this.initializationData, null);
        this.adaptive = in.readInt() == 1;
        this.maxWidth = in.readInt();
        this.maxHeight = in.readInt();
        this.pcmEncoding = in.readInt();
        this.encoderDelay = in.readInt();
        this.encoderPadding = in.readInt();
    }

    MediaFormat(String trackId, String mimeType, int bitrate, int maxInputSize, long durationUs, int width, int height, int rotationDegrees, float pixelWidthHeightRatio, int channelCount, int sampleRate, String language, long subsampleOffsetUs, List<byte[]> initializationData, boolean adaptive, int maxWidth, int maxHeight, int pcmEncoding, int encoderDelay, int encoderPadding) {
        this.trackId = trackId;
        this.mimeType = Assertions.checkNotEmpty(mimeType);
        this.bitrate = bitrate;
        this.maxInputSize = maxInputSize;
        this.durationUs = durationUs;
        this.width = width;
        this.height = height;
        this.rotationDegrees = rotationDegrees;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
        this.language = language;
        this.subsampleOffsetUs = subsampleOffsetUs;
        this.initializationData = initializationData == null ? Collections.emptyList() : initializationData;
        this.adaptive = adaptive;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.pcmEncoding = pcmEncoding;
        this.encoderDelay = encoderDelay;
        this.encoderPadding = encoderPadding;
    }

    public MediaFormat copyWithMaxInputSize(int maxInputSize) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, this.subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.pcmEncoding, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithMaxVideoDimensions(int maxWidth, int maxHeight) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, this.subsampleOffsetUs, this.initializationData, this.adaptive, maxWidth, maxHeight, this.pcmEncoding, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithSubsampleOffsetUs(long subsampleOffsetUs) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.pcmEncoding, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithDurationUs(long durationUs) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, this.subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.pcmEncoding, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithLanguage(String language) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, language, this.subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.pcmEncoding, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyWithFixedTrackInfo(String trackId, int bitrate, int width, int height, String language) {
        return new MediaFormat(trackId, this.mimeType, bitrate, this.maxInputSize, this.durationUs, width, height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, language, this.subsampleOffsetUs, this.initializationData, this.adaptive, -1, -1, this.pcmEncoding, this.encoderDelay, this.encoderPadding);
    }

    public MediaFormat copyAsAdaptive(String trackId) {
        return new MediaFormat(trackId, this.mimeType, -1, -1, this.durationUs, -1, -1, -1, -1.0f, -1, -1, null, Long.MAX_VALUE, null, true, this.maxWidth, this.maxHeight, -1, -1, -1);
    }

    public MediaFormat copyWithGaplessInfo(int encoderDelay, int encoderPadding) {
        return new MediaFormat(this.trackId, this.mimeType, this.bitrate, this.maxInputSize, this.durationUs, this.width, this.height, this.rotationDegrees, this.pixelWidthHeightRatio, this.channelCount, this.sampleRate, this.language, this.subsampleOffsetUs, this.initializationData, this.adaptive, this.maxWidth, this.maxHeight, this.pcmEncoding, encoderDelay, encoderPadding);
    }

    @SuppressLint(value={"InlinedApi"})
    @TargetApi(value=16)
    public final android.media.MediaFormat getFrameworkMediaFormatV16() {
        if (this.frameworkMediaFormat == null) {
            android.media.MediaFormat format = new android.media.MediaFormat();
            format.setString("mime", this.mimeType);
            MediaFormat.maybeSetStringV16(format, "language", this.language);
            MediaFormat.maybeSetIntegerV16(format, "max-input-size", this.maxInputSize);
            MediaFormat.maybeSetIntegerV16(format, "width", this.width);
            MediaFormat.maybeSetIntegerV16(format, "height", this.height);
            MediaFormat.maybeSetIntegerV16(format, "rotation-degrees", this.rotationDegrees);
            MediaFormat.maybeSetIntegerV16(format, "max-width", this.maxWidth);
            MediaFormat.maybeSetIntegerV16(format, "max-height", this.maxHeight);
            MediaFormat.maybeSetIntegerV16(format, "channel-count", this.channelCount);
            MediaFormat.maybeSetIntegerV16(format, "sample-rate", this.sampleRate);
            MediaFormat.maybeSetIntegerV16(format, "encoder-delay", this.encoderDelay);
            MediaFormat.maybeSetIntegerV16(format, "encoder-padding", this.encoderPadding);
            for (int i = 0; i < this.initializationData.size(); ++i) {
                format.setByteBuffer("csd-" + i, ByteBuffer.wrap(this.initializationData.get(i)));
            }
            if (this.durationUs != -9223372036854775807L) {
                format.setLong("durationUs", this.durationUs);
            }
            this.frameworkMediaFormat = format;
        }
        return this.frameworkMediaFormat;
    }

    @Deprecated
    @TargetApi(value=16)
    final void setFrameworkFormatV16(android.media.MediaFormat format) {
        this.frameworkMediaFormat = format;
    }

    public String toString() {
        return "MediaFormat(" + this.trackId + ", " + this.mimeType + ", " + this.bitrate + ", " + this.maxInputSize + ", " + this.width + ", " + this.height + ", " + this.rotationDegrees + ", " + this.pixelWidthHeightRatio + ", " + this.channelCount + ", " + this.sampleRate + ", " + this.language + ", " + this.durationUs + ", " + this.adaptive + ", " + this.maxWidth + ", " + this.maxHeight + ", " + this.pcmEncoding + ", " + this.encoderDelay + ", " + this.encoderPadding + ")";
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 31 * result + (this.trackId == null ? 0 : this.trackId.hashCode());
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + this.bitrate;
            result = 31 * result + this.maxInputSize;
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.rotationDegrees;
            result = 31 * result + Float.floatToRawIntBits(this.pixelWidthHeightRatio);
            result = 31 * result + (int)this.durationUs;
            result = 31 * result + (this.adaptive ? 1231 : 1237);
            result = 31 * result + this.maxWidth;
            result = 31 * result + this.maxHeight;
            result = 31 * result + this.channelCount;
            result = 31 * result + this.sampleRate;
            result = 31 * result + this.pcmEncoding;
            result = 31 * result + this.encoderDelay;
            result = 31 * result + this.encoderPadding;
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (int)this.subsampleOffsetUs;
            for (int i = 0; i < this.initializationData.size(); ++i) {
                result = 31 * result + Arrays.hashCode(this.initializationData.get(i));
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaFormat other = (MediaFormat)obj;
        if (!(this.adaptive == other.adaptive && this.bitrate == other.bitrate && this.maxInputSize == other.maxInputSize && this.durationUs == other.durationUs && this.width == other.width && this.height == other.height && this.rotationDegrees == other.rotationDegrees && this.pixelWidthHeightRatio == other.pixelWidthHeightRatio && this.maxWidth == other.maxWidth && this.maxHeight == other.maxHeight && this.channelCount == other.channelCount && this.sampleRate == other.sampleRate && this.pcmEncoding == other.pcmEncoding && this.encoderDelay == other.encoderDelay && this.encoderPadding == other.encoderPadding && this.subsampleOffsetUs == other.subsampleOffsetUs && Util.areEqual(this.trackId, other.trackId) && Util.areEqual(this.language, other.language) && Util.areEqual(this.mimeType, other.mimeType) && this.initializationData.size() == other.initializationData.size())) {
            return false;
        }
        for (int i = 0; i < this.initializationData.size(); ++i) {
            if (Arrays.equals(this.initializationData.get(i), other.initializationData.get(i))) continue;
            return false;
        }
        return true;
    }

    @TargetApi(value=16)
    private static final void maybeSetStringV16(android.media.MediaFormat format, String key, String value) {
        if (value != null) {
            format.setString(key, value);
        }
    }

    @TargetApi(value=16)
    private static final void maybeSetIntegerV16(android.media.MediaFormat format, String key, int value) {
        if (value != -1) {
            format.setInteger(key, value);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.trackId);
        dest.writeString(this.mimeType);
        dest.writeInt(this.bitrate);
        dest.writeInt(this.maxInputSize);
        dest.writeLong(this.durationUs);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.rotationDegrees);
        dest.writeFloat(this.pixelWidthHeightRatio);
        dest.writeInt(this.channelCount);
        dest.writeInt(this.sampleRate);
        dest.writeString(this.language);
        dest.writeLong(this.subsampleOffsetUs);
        dest.writeList(this.initializationData);
        dest.writeInt(this.adaptive ? 1 : 0);
        dest.writeInt(this.maxWidth);
        dest.writeInt(this.maxHeight);
        dest.writeInt(this.pcmEncoding);
        dest.writeInt(this.encoderDelay);
        dest.writeInt(this.encoderPadding);
    }
}

