/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.upstream;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.upstream.BaseDataSource;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class RawResourceDataSource
extends BaseDataSource {
    public static final String RAW_RESOURCE_SCHEME = "rawresource";
    private final Resources resources;
    private final String packageName;
    @Nullable
    private Uri uri;
    @Nullable
    private AssetFileDescriptor assetFileDescriptor;
    @Nullable
    private InputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public static Uri buildRawResourceUri(int rawResourceId) {
        return Uri.parse((String)("rawresource:///" + rawResourceId));
    }

    public RawResourceDataSource(Context context) {
        super(false);
        this.resources = context.getResources();
        this.packageName = context.getPackageName();
    }

    @Override
    public long open(DataSpec dataSpec) throws RawResourceDataSourceException {
        long assetFileDescriptorLength;
        AssetFileDescriptor assetFileDescriptor;
        int resourceId;
        Uri uri;
        this.uri = uri = dataSpec.uri;
        if (TextUtils.equals((CharSequence)RAW_RESOURCE_SCHEME, (CharSequence)uri.getScheme()) || TextUtils.equals((CharSequence)"android.resource", (CharSequence)uri.getScheme()) && uri.getPathSegments().size() == 1 && Assertions.checkNotNull(uri.getLastPathSegment()).matches("\\d+")) {
            try {
                resourceId = Integer.parseInt(Assertions.checkNotNull(uri.getLastPathSegment()));
            }
            catch (NumberFormatException e) {
                throw new RawResourceDataSourceException("Resource identifier must be an integer.");
            }
        } else if (TextUtils.equals((CharSequence)"android.resource", (CharSequence)uri.getScheme())) {
            String host;
            String resourceName;
            String path = Assertions.checkNotNull(uri.getPath());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((resourceId = this.resources.getIdentifier(resourceName = (TextUtils.isEmpty((CharSequence)(host = uri.getHost())) ? "" : host + ":") + path, "raw", this.packageName)) == 0) {
                throw new RawResourceDataSourceException("Resource not found.");
            }
        } else {
            throw new RawResourceDataSourceException("URI must either use scheme rawresource or android.resource");
        }
        this.transferInitializing(dataSpec);
        this.assetFileDescriptor = assetFileDescriptor = this.resources.openRawResourceFd(resourceId);
        if (assetFileDescriptor == null) {
            throw new RawResourceDataSourceException("Resource is compressed: " + uri);
        }
        FileInputStream inputStream = new FileInputStream(assetFileDescriptor.getFileDescriptor());
        this.inputStream = inputStream;
        try {
            inputStream.skip(assetFileDescriptor.getStartOffset());
            long skipped = inputStream.skip(dataSpec.position);
            if (skipped < dataSpec.position) {
                throw new EOFException();
            }
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        this.bytesRemaining = dataSpec.length != -1L ? dataSpec.length : ((assetFileDescriptorLength = assetFileDescriptor.getLength()) == -1L ? -1L : assetFileDescriptorLength - dataSpec.position);
        this.opened = true;
        this.transferStarted(dataSpec);
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws RawResourceDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? readLength : (int)Math.min(this.bytesRemaining, (long)readLength);
            bytesRead = Util.castNonNull(this.inputStream).read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        if (bytesRead == -1) {
            if (this.bytesRemaining != -1L) {
                throw new RawResourceDataSourceException(new EOFException());
            }
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws RawResourceDataSourceException {
        this.uri = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(e);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new RawResourceDataSourceException(e);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    this.transferEnded();
                }
            }
        }
    }

    public static class RawResourceDataSourceException
    extends IOException {
        public RawResourceDataSourceException(String message) {
            super(message);
        }

        public RawResourceDataSourceException(IOException e) {
            super(e);
        }
    }
}

