/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.scheduler;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PersistableBundle;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import com.akamai.amp.exoplayer2.scheduler.Requirements;
import com.akamai.amp.exoplayer2.scheduler.Scheduler;
import com.akamai.amp.exoplayer2.util.Assertions;
import com.akamai.amp.exoplayer2.util.Log;
import com.akamai.amp.exoplayer2.util.Util;

@RequiresApi(value=21)
public final class PlatformScheduler
implements Scheduler {
    private static final String TAG = "PlatformScheduler";
    private static final String KEY_SERVICE_ACTION = "service_action";
    private static final String KEY_SERVICE_PACKAGE = "service_package";
    private static final String KEY_REQUIREMENTS = "requirements";
    private static final int SUPPORTED_REQUIREMENTS = 0xF | (Util.SDK_INT >= 26 ? 16 : 0);
    private final int jobId;
    private final ComponentName jobServiceComponentName;
    private final JobScheduler jobScheduler;

    @RequiresPermission(value="android.permission.RECEIVE_BOOT_COMPLETED")
    public PlatformScheduler(Context context, int jobId) {
        context = context.getApplicationContext();
        this.jobId = jobId;
        this.jobServiceComponentName = new ComponentName(context, PlatformSchedulerService.class);
        this.jobScheduler = Assertions.checkNotNull((JobScheduler)context.getSystemService("jobscheduler"));
    }

    @Override
    public boolean schedule(Requirements requirements, String servicePackage, String serviceAction) {
        JobInfo jobInfo = PlatformScheduler.buildJobInfo(this.jobId, this.jobServiceComponentName, requirements, serviceAction, servicePackage);
        int result = this.jobScheduler.schedule(jobInfo);
        return result == 1;
    }

    @Override
    public boolean cancel() {
        this.jobScheduler.cancel(this.jobId);
        return true;
    }

    @Override
    public Requirements getSupportedRequirements(Requirements requirements) {
        return requirements.filterRequirements(SUPPORTED_REQUIREMENTS);
    }

    private static JobInfo buildJobInfo(int jobId, ComponentName jobServiceComponentName, Requirements requirements, String serviceAction, String servicePackage) {
        Requirements filteredRequirements = requirements.filterRequirements(SUPPORTED_REQUIREMENTS);
        if (!filteredRequirements.equals(requirements)) {
            Log.w(TAG, "Ignoring unsupported requirements: " + (filteredRequirements.getRequirements() ^ requirements.getRequirements()));
        }
        JobInfo.Builder builder = new JobInfo.Builder(jobId, jobServiceComponentName);
        if (requirements.isUnmeteredNetworkRequired()) {
            builder.setRequiredNetworkType(2);
        } else if (requirements.isNetworkRequired()) {
            builder.setRequiredNetworkType(1);
        }
        builder.setRequiresDeviceIdle(requirements.isIdleRequired());
        builder.setRequiresCharging(requirements.isChargingRequired());
        if (Util.SDK_INT >= 26 && requirements.isStorageNotLowRequired()) {
            builder.setRequiresStorageNotLow(true);
        }
        builder.setPersisted(true);
        PersistableBundle extras = new PersistableBundle();
        extras.putString(KEY_SERVICE_ACTION, serviceAction);
        extras.putString(KEY_SERVICE_PACKAGE, servicePackage);
        extras.putInt(KEY_REQUIREMENTS, requirements.getRequirements());
        builder.setExtras(extras);
        return builder.build();
    }

    public static final class PlatformSchedulerService
    extends JobService {
        public boolean onStartJob(JobParameters params) {
            PersistableBundle extras = params.getExtras();
            Requirements requirements = new Requirements(extras.getInt(PlatformScheduler.KEY_REQUIREMENTS));
            int notMetRequirements = requirements.getNotMetRequirements((Context)this);
            if (notMetRequirements == 0) {
                String serviceAction = Assertions.checkNotNull(extras.getString(PlatformScheduler.KEY_SERVICE_ACTION));
                String servicePackage = Assertions.checkNotNull(extras.getString(PlatformScheduler.KEY_SERVICE_PACKAGE));
                Intent intent = new Intent(serviceAction).setPackage(servicePackage);
                Util.startForegroundService((Context)this, intent);
            } else {
                Log.w(PlatformScheduler.TAG, "Requirements not met: " + notMetRequirements);
                this.jobFinished(params, true);
            }
            return false;
        }

        public boolean onStopJob(JobParameters params) {
            return false;
        }
    }
}

