/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.exoplayer2.metadata.id3;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.akamai.amp.exoplayer2.metadata.id3.Id3Frame;
import com.akamai.amp.exoplayer2.util.Util;

public final class CommentFrame
extends Id3Frame {
    public static final String ID = "COMM";
    public final String language;
    public final String description;
    public final String text;
    public static final Parcelable.Creator<CommentFrame> CREATOR = new Parcelable.Creator<CommentFrame>(){

        public CommentFrame createFromParcel(Parcel in) {
            return new CommentFrame(in);
        }

        public CommentFrame[] newArray(int size) {
            return new CommentFrame[size];
        }
    };

    public CommentFrame(String language, String description, String text) {
        super(ID);
        this.language = language;
        this.description = description;
        this.text = text;
    }

    CommentFrame(Parcel in) {
        super(ID);
        this.language = Util.castNonNull(in.readString());
        this.description = Util.castNonNull(in.readString());
        this.text = Util.castNonNull(in.readString());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CommentFrame other = (CommentFrame)obj;
        return Util.areEqual(this.description, other.description) && Util.areEqual(this.language, other.language) && Util.areEqual(this.text, other.text);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.id + ": language=" + this.language + ", description=" + this.description;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.language);
        dest.writeString(this.text);
    }

    @Override
    public String getValue() {
        return this.text;
    }
}

