/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.mux.bandwidth;

import android.annotation.SuppressLint;
import com.akamai.amp.analytics.mux.MuxEventBus;
import com.akamai.amp.analytics.mux.bandwidth.BandwidthMetric;
import com.akamai.amp.analytics.mux.bandwidth.BandwidthMetricDash;
import com.akamai.amp.analytics.mux.bandwidth.BandwidthMetricHls;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.source.TrackGroup;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.upstream.DataSpec;
import com.mux.stats.sdk.core.events.IEvent;
import com.mux.stats.sdk.core.events.playback.RequestBandwidthEvent;
import com.mux.stats.sdk.core.model.BandwidthMetricData;
import java.io.IOException;
import java.util.ArrayList;

public class BandwidthMetricDispatcher {
    private MuxEventBus ampEventBus;
    private BandwidthMetric bandwidthMetricHls;
    private BandwidthMetric bandwidthMetricDash;

    public BandwidthMetricDispatcher(MuxEventBus ampEventBus) {
        this.ampEventBus = ampEventBus;
        this.bandwidthMetricHls = new BandwidthMetricHls(ampEventBus);
        this.bandwidthMetricDash = new BandwidthMetricDash(ampEventBus);
    }

    @SuppressLint(value={"SwitchIntDef"})
    private BandwidthMetric currentBandwidthMetric() {
        switch (this.ampEventBus.getStreamType()) {
            case 2: {
                return this.bandwidthMetricHls;
            }
            case 0: {
                return this.bandwidthMetricDash;
            }
        }
        return null;
    }

    public void onLoadError(DataSpec dataSpec, int dataType, IOException e) {
        BandwidthMetric bandwidthMetric = this.currentBandwidthMetric();
        if (bandwidthMetric == null) {
            return;
        }
        BandwidthMetricData loadData = bandwidthMetric.onLoadError(dataSpec, dataType, e);
        this.dispatch(loadData);
    }

    public void onLoadCanceled(DataSpec dataSpec) {
        BandwidthMetric bandwidthMetric = this.currentBandwidthMetric();
        if (bandwidthMetric == null) {
            return;
        }
        BandwidthMetricData loadData = bandwidthMetric.onLoadCanceled(dataSpec);
        this.dispatch(loadData);
    }

    public void onLoadStarted(DataSpec dataSpec, int dataType, Format trackFormat, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs) {
        BandwidthMetric bandwidthMetric = this.currentBandwidthMetric();
        if (bandwidthMetric == null) {
            return;
        }
        bandwidthMetric.onLoadStarted(dataSpec, dataType, trackFormat, mediaStartTimeMs, mediaEndTimeMs, elapsedRealtimeMs);
    }

    public void onLoadCompleted(DataSpec dataSpec, int dataType, Format trackFormat, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
        BandwidthMetric bandwidthMetric = this.currentBandwidthMetric();
        if (bandwidthMetric == null) {
            return;
        }
        BandwidthMetricData loadData = bandwidthMetric.onLoadCompleted(dataSpec, dataType, trackFormat, mediaStartTimeMs, mediaEndTimeMs, elapsedRealtimeMs, loadDurationMs, bytesLoaded);
        this.dispatch(loadData);
    }

    public void onTracksChanged(TrackGroupArray trackGroups) {
        BandwidthMetric bandwidthMetric = this.currentBandwidthMetric();
        if (bandwidthMetric == null) {
            return;
        }
        if (trackGroups.length > 0) {
            for (int groupIndex = 0; groupIndex < trackGroups.length; ++groupIndex) {
                TrackGroup trackGroup = trackGroups.get(groupIndex);
                if (0 >= trackGroup.length) continue;
                Format trackFormat = trackGroup.getFormat(0);
                if (trackFormat.containerMimeType == null || !trackFormat.containerMimeType.contains("video")) continue;
                ArrayList<BandwidthMetricData.Rendition> renditions = new ArrayList<BandwidthMetricData.Rendition>();
                for (int i = 0; i < trackGroup.length; ++i) {
                    trackFormat = trackGroup.getFormat(i);
                    BandwidthMetricData.Rendition rendition = new BandwidthMetricData.Rendition();
                    rendition.bitrate = trackFormat.bitrate;
                    rendition.width = trackFormat.width;
                    rendition.height = trackFormat.height;
                    renditions.add(rendition);
                }
                this.ampEventBus.renditionList = renditions;
            }
        }
    }

    private void dispatch(BandwidthMetricData data) {
        if (data != null) {
            RequestBandwidthEvent playback = new RequestBandwidthEvent(null);
            playback.setBandwidthMetricData(data);
            this.ampEventBus.dispatch((IEvent)playback);
        }
    }
}

