/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.analytics.mux;

import com.akamai.amp.analytics.mux.MuxEventBus;
import com.akamai.amp.analytics.mux.bandwidth.BandwidthMetricDispatcher;
import com.akamai.amp.exoplayer2.ExoPlaybackException;
import com.akamai.amp.exoplayer2.Format;
import com.akamai.amp.exoplayer2.Player;
import com.akamai.amp.exoplayer2.analytics.AnalyticsListener;
import com.akamai.amp.exoplayer2.source.LoadEventInfo;
import com.akamai.amp.exoplayer2.source.MediaLoadData;
import com.akamai.amp.exoplayer2.source.TrackGroupArray;
import com.akamai.amp.exoplayer2.trackselection.TrackSelectionArray;
import com.akamai.amp.exoplayer2.util.NonNullApi;
import com.mux.stats.sdk.muxstats.MuxErrorException;
import java.io.IOException;

@NonNullApi
class MuxExoListener
implements AnalyticsListener,
Player.EventListener {
    private final MuxEventBus muxEventBus;
    private final BandwidthMetricDispatcher bandwidthDispatcher;

    MuxExoListener(MuxEventBus muxEventBus, BandwidthMetricDispatcher bandwidthDispatcher) {
        this.muxEventBus = muxEventBus;
        this.bandwidthDispatcher = bandwidthDispatcher;
    }

    public void onPlayerError(AnalyticsListener.EventTime eventTime, ExoPlaybackException error) {
        this.muxEventBus.dispatchPlayerError(error);
    }

    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        this.bandwidthDispatcher.onTracksChanged(trackGroups);
    }

    public void onLoadStarted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        this.bandwidthDispatcher.onLoadStarted(loadEventInfo.dataSpec, mediaLoadData.dataType, mediaLoadData.trackFormat, mediaLoadData.mediaStartTimeMs, mediaLoadData.mediaEndTimeMs, loadEventInfo.elapsedRealtimeMs);
    }

    public void onLoadCompleted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        this.bandwidthDispatcher.onLoadCompleted(loadEventInfo.dataSpec, mediaLoadData.dataType, mediaLoadData.trackFormat, mediaLoadData.mediaStartTimeMs, mediaLoadData.mediaEndTimeMs, loadEventInfo.elapsedRealtimeMs, loadEventInfo.loadDurationMs, loadEventInfo.bytesLoaded);
    }

    public void onLoadCanceled(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
        this.bandwidthDispatcher.onLoadCanceled(loadEventInfo.dataSpec);
    }

    public void onLoadError(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException e, boolean wasCanceled) {
        this.bandwidthDispatcher.onLoadError(loadEventInfo.dataSpec, mediaLoadData.dataType, e);
    }

    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        if (mediaLoadData.trackFormat != null) {
            String mimeType = mediaLoadData.trackFormat.containerMimeType + " (" + mediaLoadData.trackFormat.sampleMimeType + ")";
            this.muxEventBus.setMimeType(mimeType);
        }
    }

    public void onDecoderInputFormatChanged(AnalyticsListener.EventTime eventTime, int trackType, Format format) {
        if (trackType == 2 || trackType == 0) {
            this.muxEventBus.dispatchRenditionChange(format);
        }
    }

    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception e) {
        this.muxEventBus.dispatchInternalError((Exception)new MuxErrorException(-2, "DrmSessionManagerError - " + e.getMessage()));
    }
}

