/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.ads.yospace;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import com.yospace.android.hls.analytic.advert.Advert;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class YospaceUi
extends RelativeLayout
implements View.OnClickListener {
    private static final String LOG_TAG = "YospaceUi";
    private Activity activity;
    private Button moreInfoButton;
    private Advert mCurrentAdvert;
    private String mCurrentNonLinearId;
    private Context context;
    private RelativeLayout container;

    public YospaceUi(Context context, Activity activity) {
        super(context);
        this.context = context;
        this.activity = activity;
        this.initialization();
    }

    private void initialization() {
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{-15527149, 0xE8E8E8});
        gradientDrawable.setCornerRadius(0.0f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        this.container = new RelativeLayout(this.context);
        this.container.setBackgroundDrawable((Drawable)gradientDrawable);
        this.addView((View)this.container, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(10);
        params.addRule(11);
        this.moreInfoButton = new Button(this.context);
        this.moreInfoButton.setTextColor(-1);
        this.moreInfoButton.setBackgroundColor(0);
        this.container.addView((View)this.moreInfoButton, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(10);
        this.moreInfoButton.setOnClickListener((View.OnClickListener)this);
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void setAdvert(Advert advert) {
        this.mCurrentAdvert = advert;
        Log.e((String)LOG_TAG, (String)(this.mCurrentAdvert.getDuration() + " duration"));
        Log.e((String)LOG_TAG, (String)(this.mCurrentAdvert.getAdTitle() + " title"));
        Log.e((String)LOG_TAG, (String)(this.mCurrentAdvert.getDescription() + " description"));
        Log.e((String)LOG_TAG, (String)(this.mCurrentAdvert.getAdvertiser() + " Advertiser"));
        Log.e((String)LOG_TAG, (String)(this.mCurrentAdvert.getId() + " id"));
        Log.e((String)LOG_TAG, (String)(this.mCurrentAdvert.getSurveyUrl() + " surveyurl"));
        if (advert.isFiller()) {
            this.moreInfoButton.setText((CharSequence)"Filler");
            this.moreInfoButton.setEnabled(false);
        } else {
            String str = advert.getLinearCreative().getVideoClicks().getClickThroughUrl();
            if (str != null && !str.isEmpty()) {
                this.moreInfoButton.setText((CharSequence)"More Info");
                this.moreInfoButton.setEnabled(true);
            } else {
                this.moreInfoButton.setText((CharSequence)"Advert");
                this.moreInfoButton.setEnabled(false);
            }
        }
        this.moreInfoButton.setVisibility(0);
    }

    public void onClick(View view) {
        Log.e((String)LOG_TAG, (String)"more info button pressed");
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.mCurrentAdvert.getLinearCreative().getVideoClicks().getClickThroughUrl()));
        this.activity.startActivity(browserIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap bytesToBitmap(byte[] bytes) {
        ByteArrayInputStream imageStream = null;
        try {
            imageStream = new ByteArrayInputStream(bytes);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)imageStream);
            return bitmap;
        }
        catch (Exception ex) {
            Log.i((String)LOG_TAG, (String)("Unable to generate a bitmap: " + ex.getMessage()));
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            if (imageStream != null) {
                try {
                    imageStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

