/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.amp.config;

import com.akamai.amp.config.data.FreewheelData;
import com.akamai.amp.config.data.GoogleAnalyticsData;
import com.akamai.amp.config.data.IMAData;
import com.akamai.amp.config.data.MediaAnalyticsData;
import com.akamai.amp.config.data.NielsenData;
import com.akamai.amp.config.data.heartbeat.HeartbeatConfigurationData;
import com.akamai.amp.config.data.streamsense.StreamsenseData;
import com.akamai.amp.config.js.JsEvaluator;
import com.akamai.amp.media.elements.Media;
import com.akamai.amp.parser.config.RootConfigParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Config {
    public boolean configLoaded = false;
    public String configURL;
    public boolean isJsonFormat = false;
    public boolean isLocalJson = false;
    public boolean isRemoteConfig = true;
    public boolean autoplay = true;
    public boolean fullScreen = true;
    public boolean captionsEnabled = true;
    public String controlsMode;
    public String controlsAdMode;
    public NielsenData nielsenData;
    public HeartbeatConfigurationData heartbeatConfigurationData;
    public StreamsenseData streamsenseData;
    public MediaAnalyticsData mediaAnalyticsData = new MediaAnalyticsData();
    public GoogleAnalyticsData googleAnalyticsData;
    public Media media;
    public String feedData;
    public String feedURL;
    public String configJsonData;
    public IMAData imaData;
    public FreewheelData freewheelData;
    private String adId;
    private RootConfigParser rootConfigParser = new RootConfigParser();
    private static Config instance;
    public JsEvaluator jsEvaluator = new JsEvaluator();
    @Deprecated
    private String _comscoreC2 = null;
    @Deprecated
    private String _comscorePublisherSecret = null;
    @Deprecated
    public Boolean _autoHideControlBar = false;
    @Deprecated
    public int _controlBarShowTime = 5000;

    public static Config getConfig() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static void setConfig(Config config) {
        if (instance == null) {
            instance = config;
        }
    }

    public static Config getInstance() {
        return instance;
    }

    public static void setInstance(Config instance) {
        Config.instance = instance;
    }

    public void init(String url) {
        this.configURL = url;
        this.isJsonFormat = url.contains(".json");
    }

    public void setIMAData() {
        this.imaData = this.rootConfigParser.buildIMAData();
        this.adId = this.rootConfigParser.getAdsId(false);
    }

    public void setNielsenData() {
        this.nielsenData = this.rootConfigParser.buildNielsenData();
    }

    public void setHeartbeatData() {
        this.heartbeatConfigurationData = this.rootConfigParser.buildHeartbeatData();
    }

    public void setStreamsenseData() {
        this.streamsenseData = this.rootConfigParser.buildStreamsenseData();
    }

    public void setMediaAnalyticsData() {
        this.mediaAnalyticsData = this.rootConfigParser.buildMediaAnalyticsData();
    }

    public void setGoogleAnalyticsData() {
        this.googleAnalyticsData = this.rootConfigParser.buildGoogleAnalyticsData();
    }

    public void setFreeWheelData() {
        this.freewheelData = this.rootConfigParser.buildFreeWheelData();
        this.adId = this.rootConfigParser.getAdsId(true);
    }

    public void parseJsonConfig(String jsonContent) {
        this.rootConfigParser.parseJson(jsonContent);
    }

    public String validateJSExpression(String value) {
        String evaluatedExpression;
        if (value != null && JsEvaluator.containsJSExpression(value)) {
            this.jsEvaluator.startEval();
            evaluatedExpression = this.jsEvaluator.evaluate(value);
            this.jsEvaluator.finishEval();
        } else {
            evaluatedExpression = value;
        }
        return evaluatedExpression;
    }

    public void parseXMLConfig(String url, String xml) {
        if (this.isJsonFormat) {
            return;
        }
        this.imaData = new IMAData();
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput((Reader)new StringReader(xml));
            int eventType = xpp.getEventType();
            boolean configuringFeed = false;
            boolean configuringView = false;
            boolean configuringBranding = false;
            boolean configuringIma = false;
            boolean configuringImaPreroll = false;
            boolean configuringMediaAnalytics = false;
            boolean configuringMediaAnalyticsDimensions = false;
            boolean configuringComscore = false;
            boolean configuringNielsen = false;
            this.mediaAnalyticsData.getMediaAnalyticsDimensions().clear();
            while (eventType != 1) {
                block76: {
                    if (eventType != 0) {
                        if (eventType == 2) {
                            tagName = xpp.getName();
                            if (configuringMediaAnalyticsDimensions) {
                                String maKey = tagName;
                                String maValue = xpp.nextText();
                                this.mediaAnalyticsData.getMediaAnalyticsDimensions().put(maKey, maValue);
                            }
                            if (tagName.equalsIgnoreCase("feed")) {
                                configuringFeed = true;
                            } else if (tagName.equalsIgnoreCase("core_ads_enabled")) {
                                value = xpp.nextText();
                                boolean adsEnabled = value.equalsIgnoreCase("true");
                                if (this.imaData != null) {
                                    this.imaData.setAdsEnabled(adsEnabled);
                                }
                            } else if (tagName.equalsIgnoreCase("view")) {
                                configuringView = true;
                            } else if (tagName.equalsIgnoreCase("element")) {
                                if (configuringView && (value = xpp.getAttributeValue(null, "id")).equalsIgnoreCase("controls")) {
                                    value = xpp.getAttributeValue(null, "autoHide");
                                    try {
                                        this._controlBarShowTime = Integer.parseInt(value);
                                        if (this._controlBarShowTime > 0) {
                                            this._autoHideControlBar = true;
                                            break block76;
                                        }
                                        this._autoHideControlBar = false;
                                    }
                                    catch (NumberFormatException e) {
                                        this._autoHideControlBar = false;
                                    }
                                }
                            } else if (tagName.equalsIgnoreCase("branding")) {
                                configuringBranding = true;
                            } else if (!tagName.equalsIgnoreCase("title")) {
                                if (tagName.equalsIgnoreCase("player")) {
                                    value = xpp.getAttributeValue(null, "show_feature_bar");
                                } else if (tagName.equalsIgnoreCase("ima")) {
                                    configuringIma = true;
                                } else if (tagName.equalsIgnoreCase("enabled")) {
                                    if (configuringIma) {
                                        value = xpp.nextText();
                                        boolean isFalse = value.equals("false");
                                        if (this.imaData != null) {
                                            this.imaData.setAdsEnabled(!isFalse);
                                        }
                                    }
                                } else if (tagName.equalsIgnoreCase("preroll")) {
                                    if (configuringIma) {
                                        configuringImaPreroll = true;
                                    }
                                } else if (tagName.equalsIgnoreCase("adTagUrl")) {
                                    if (configuringImaPreroll || configuringIma) {
                                        String adTagUrl = xpp.nextText();
                                        if (this.imaData != null) {
                                            this.imaData.setAdTagUrl(adTagUrl);
                                        }
                                    }
                                } else if (tagName.equalsIgnoreCase("mediaanalytics")) {
                                    configuringMediaAnalytics = true;
                                } else if (tagName.equalsIgnoreCase("dimensions") && configuringMediaAnalytics) {
                                    configuringMediaAnalyticsDimensions = true;
                                } else if (tagName.equalsIgnoreCase("nielsen")) {
                                    configuringNielsen = true;
                                } else if (tagName.equalsIgnoreCase("config")) {
                                    if (configuringMediaAnalytics) {
                                        this.mediaAnalyticsData.setMediaAnalyticsBeacon(xpp.nextText());
                                    }
                                } else if (tagName.equalsIgnoreCase("comscore")) {
                                    configuringComscore = true;
                                } else if (tagName.equalsIgnoreCase("customersecret")) {
                                    if (configuringComscore) {
                                        this._comscorePublisherSecret = xpp.nextText();
                                    }
                                } else if (tagName.equalsIgnoreCase("c2") && configuringComscore) {
                                    this._comscoreC2 = xpp.nextText();
                                }
                            }
                        } else if (eventType == 3) {
                            tagName = xpp.getName();
                            if (tagName.equalsIgnoreCase("feed")) {
                                configuringFeed = false;
                            } else if (tagName.equalsIgnoreCase("view")) {
                                configuringView = false;
                            } else if (tagName.equalsIgnoreCase("branding")) {
                                configuringBranding = false;
                            } else if (tagName.equalsIgnoreCase("ima")) {
                                configuringIma = false;
                            } else if (tagName.equalsIgnoreCase("preroll")) {
                                if (configuringIma) {
                                    configuringImaPreroll = false;
                                }
                            } else if (tagName.equalsIgnoreCase("mediaanalytics")) {
                                configuringMediaAnalytics = false;
                            } else if (tagName.equalsIgnoreCase("dimensions") && configuringMediaAnalyticsDimensions) {
                                configuringMediaAnalyticsDimensions = false;
                            } else if (tagName.equalsIgnoreCase("nielsen")) {
                                configuringNielsen = false;
                            } else if (tagName.equalsIgnoreCase("comscore")) {
                                configuringComscore = false;
                            }
                        } else if (eventType == 4) {
                            // empty if block
                        }
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (XmlPullParserException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clearConfig() {
        instance = null;
    }
}

